/*FIXME: in future make one universal dialog*/
#include <stdio.h>
#include <stdlib.h>
#include "..\..\plugin.hpp"
#include "..\..\farkeys.hpp"
#include "umplugin.h"
#include "memory.h"

static long WINAPI EditAdvancedAccessDialogProc(HANDLE hDlg,int Msg,int Param1,long Param2)
{
  int *DlgParams=(int *)Info.SendDlgMessage(hDlg,DM_GETDLGDATA,0,0);
  switch(Msg)
  {
    case DN_KEY:
      if((Param2==KEY_SHIFTADD)||(Param2==KEY_SHIFTSUBTRACT))
      {
        int state=(Param2==KEY_SHIFTADD);
        FarDialogItem DialogItem;
        for(int i=0;i<DlgParams[1];i++)
        {
          Info.SendDlgMessage(hDlg,DM_GETDLGITEM,DlgParams[0]+i,(long)&DialogItem);
          DialogItem.Selected=state;
          Info.SendDlgMessage(hDlg,DM_SETDLGITEM,DlgParams[0]+i,(long)&DialogItem);
        }
      }
      break;
  }
  return Info.DefDlgProc(hDlg,Msg,Param1,Param2);
}

static bool EditAdvancedAccess(UserManager *panel,int size,int *messages,unsigned int *access,int delimiter)
{
  bool res=false;
  PanelInfo PInfo;
  Info.Control((HANDLE)panel,FCTL_GETPANELINFO,&PInfo);
  if((PInfo.ItemsNumber>0)&&(!(PInfo.PanelItems[PInfo.CurrentItem].FindData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)))
  {
    if(PInfo.PanelItems[PInfo.CurrentItem].Flags&PPIF_USERDATA)
    {
      unsigned long mask=GetLevelFromUserData(PInfo.PanelItems[PInfo.CurrentItem].UserData);
      //Show dialog
      /*
        0000000000111111111122222222223333333333444444444455555555556666666666777777
        0123456789012345678901234567890123456789012345678901234567890123456789012345
      00                                                                            00
      01   ͻ   01
      02    [ ] Read data/List directory                                          02
      03    [ ] Write data/Add file                                               03
      04    [ ] Append data/Add subdirectory                                      04
      05    [ ] Read extended attributes/Read properties                          05
      06    [ ] Write extended attributes/Write properties                        06
      07    [ ] Execute/Traverce???                                               07
      08    [ ] Delete Child                                                      08
      09    [ ] Read attributes                                                   09
      10    [ ] Write attributes                                                  10
      11   Ķ   11
      12    [ ] Delete                                                            12
      13    [ ] Read owner, group, dacl                                           13
      14    [ ] Change Permissions                                                14
      15    [ ] Take Ownership                                                    15
      16    [ ] Synchronize                                                       16
      17   Ķ   17
      18                    [ OK ]                [ Cancel ]                      18
      19   ͼ   19
      20                                                                            20
        0000000000111111111122222222223333333333444444444455555555556666666666777777
        0123456789012345678901234567890123456789012345678901234567890123456789012345
      */
      int ItemCount=4+size+((delimiter>=0)?1:0);
      FarDialogItem *DialogItems=(FarDialogItem *)malloc(sizeof(FarDialogItem)*ItemCount);
      if(DialogItems)
      {
        int button_index=ItemCount-2,check_index=button_index-size;
        DialogItems[0].Type=DI_DOUBLEBOX; DialogItems[0].X1=3; DialogItems[0].Y1=1; DialogItems[0].X2=72; DialogItems[0].Y2=ItemCount;
        DialogItems[1].Type=DI_TEXT; DialogItems[1].X1=-1; DialogItems[1].Y1=ItemCount-2; DialogItems[1].Flags=DIF_SEPARATOR;
        if(delimiter>=0)
          DialogItems[2].Type=DI_TEXT; DialogItems[2].X1=-1; DialogItems[2].Y1=3+delimiter; DialogItems[2].Flags=DIF_SEPARATOR;

        DialogItems[button_index].Type=DI_BUTTON; DialogItems[button_index].Y1=ItemCount-1; DialogItems[button_index].Flags=DIF_CENTERGROUP; DialogItems[button_index].DefaultButton=TRUE; strcpy(DialogItems[button_index].Data,GetMsg(mPropButtonOk));
        button_index++;
        DialogItems[button_index].Type=DI_BUTTON; DialogItems[button_index].Y1=ItemCount-1; DialogItems[button_index].Flags=DIF_CENTERGROUP; strcpy(DialogItems[button_index].Data,GetMsg(mPropButtonCancel));
        button_index--;
        for(int i=0;i<size;i++)
        {
          DialogItems[check_index+i].Type=DI_CHECKBOX;
          DialogItems[check_index+i].X1=5;
          DialogItems[check_index+i].Y1=2+i+((i>delimiter&&delimiter>=0)?1:0);
          if(!i) DialogItems[check_index+i].Focus=TRUE;
          strcpy(DialogItems[check_index+i].Data,GetMsg(messages[i]));
          if(mask&access[i]) DialogItems[check_index+i].Selected=TRUE;
        }
        int params[2]={check_index,size};
        int DlgCode=Info.DialogEx(Info.ModuleNumber,-1,-1,76,ItemCount+2,"EditAdvancedAccess",DialogItems,ItemCount,0,0,EditAdvancedAccessDialogProc,(long)params);
        if(DlgCode==button_index)
        {
          mask=0;
          for(int i=0;i<size;i++)
          {
            if(DialogItems[check_index+i].Selected)
              mask|=access[i];
          }
          if(UpdateAcl(panel,panel->level,GetSidFromUserData(PInfo.PanelItems[PInfo.CurrentItem].UserData),GetItemTypeFromUserData(PInfo.PanelItems[PInfo.CurrentItem].UserData),mask,actionUpdate))
            res=true;
        }
        free(DialogItems);
      }
    }
  }
  return res;
}

bool EditFileAdvancedAccess(UserManager *panel)
{
  const int size=14;
  int messages[size];
  int MsgIdx=mPropFileReadData;
  if(panel->flags&FLAG_FOLDER) MsgIdx=mPropDirReadData;
  for(int i=0;i<size;i++) messages[i]=MsgIdx+i;
  unsigned int access[]=
  {
    FILE_READ_DATA,FILE_WRITE_DATA,FILE_APPEND_DATA,FILE_READ_EA,FILE_WRITE_EA,FILE_EXECUTE,
    FILE_DELETE_CHILD,FILE_READ_ATTRIBUTES,FILE_WRITE_ATTRIBUTES,DELETE,READ_CONTROL,
    WRITE_DAC,WRITE_OWNER,SYNCHRONIZE,
  };
  return EditAdvancedAccess(panel,size,messages,access,8);
}

bool EditRegAdvancedAccess(UserManager *panel)
{
  const int size=10;
  int messages[]=
  {
    mPropRegQueryValue,mPropRegSetValue,mPropRegCreateSubkey,mPropRegEnumerateSubkeys,mPropRegNotify,mPropRegCreateLink,
    mPropRegDelete,mPropRegReadControl,mPropRegChangePermissions,mPropRegTakeOwnership,
  };
  unsigned int access[]=
  {
    KEY_QUERY_VALUE,KEY_SET_VALUE,KEY_CREATE_SUB_KEY,KEY_ENUMERATE_SUB_KEYS,
    KEY_NOTIFY,KEY_CREATE_LINK,
    DELETE,READ_CONTROL,WRITE_DAC,WRITE_OWNER,
  };
  return EditAdvancedAccess(panel,size,messages,access,-1);
}

bool EditPrinterAdvancedAccess(UserManager *panel)
{
  const int size=6;
  int messages[]=
  {
    mPropPrintUse,mPropPrintAdminister,mPropRegDelete,mPropRegReadControl,mPropRegChangePermissions,mPropRegTakeOwnership,
  };
  unsigned int access[]=
  {
    PRINTER_ACCESS_USE,PRINTER_ACCESS_ADMINISTER,
    DELETE,READ_CONTROL,WRITE_DAC,WRITE_OWNER,
  };
  return EditAdvancedAccess(panel,size,messages,access,-1);
}

bool EditJobAdvancedAccess(UserManager *panel)
{
  const int size=5;
  int messages[]=
  {
    mPropJobAdminister,mPropRegDelete,mPropRegReadControl,mPropRegChangePermissions,mPropRegTakeOwnership,
  };
  unsigned int access[]=
  {
    JOB_ACCESS_ADMINISTER,
    DELETE,READ_CONTROL,WRITE_DAC,WRITE_OWNER,
  };
  return EditAdvancedAccess(panel,size,messages,access,-1);
}
