#include <stdio.h>
#include <stdlib.h>
#include "..\..\plugin.hpp"
#include "umplugin.h"
#include "memory.h"

long WINAPI EditCommonAccessDialogProc(HANDLE hDlg,int Msg,int Param1,long Param2)
{
  FarDialogItem DialogItem;
  switch(Msg)
  {
    case DN_INITDIALOG:
    case DN_BTNCLICK:
      Info.SendDlgMessage(hDlg,DM_GETDLGITEM,2,(long)&DialogItem);
      if(DialogItem.Selected)
      {
        for(int i=4;i<10;i++)
        {
          Info.SendDlgMessage(hDlg,DM_GETDLGITEM,i,(long)&DialogItem);
          DialogItem.Selected=FALSE;
          DialogItem.Flags|=DIF_DISABLE;
          Info.SendDlgMessage(hDlg,DM_SETDLGITEM,i,(long)&DialogItem);
        }
      }
      else
      {
        for(int i=4;i<10;i++)
        {
          Info.SendDlgMessage(hDlg,DM_GETDLGITEM,i,(long)&DialogItem);
          DialogItem.Flags&=~DIF_DISABLE;
          Info.SendDlgMessage(hDlg,DM_SETDLGITEM,i,(long)&DialogItem);
        }
      }
      break;
  }
  return Info.DefDlgProc(hDlg,Msg,Param1,Param2);
}

bool EditCommonAccess(UserManager *panel)
{
  bool res=false;
  PanelInfo PInfo;
  Info.Control((HANDLE)panel,FCTL_GETPANELINFO,&PInfo);
  if((PInfo.ItemsNumber>0)&&(!(PInfo.PanelItems[PInfo.CurrentItem].FindData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)))
  {
    if(PInfo.PanelItems[PInfo.CurrentItem].Flags&PPIF_USERDATA)
    {
      unsigned long mask=GetLevelFromUserData(PInfo.PanelItems[PInfo.CurrentItem].UserData);
      //Show dialog
      /*
        0000000000111111111122222222223333333333444444444455555555556666666666777777
        0123456789012345678901234567890123456789012345678901234567890123456789012345
      00                                                                            00
      01   ͻ   01
      02    (*) Full                                                              02
      03    ( ) Special                                                           03
      04    Ŀ    04
      05     [ ] Read                                                           05
      06     [ ] Write                                                          06
      07     [ ] Execute                                                        07
      08     [ ] Delete                                                         08
      09     [ ] Change Permissions                                             09
      10     [ ] Take Ownership                                                 10
      11        11
      12                    [ OK ]                [ Cancel ]                      12
      13   ͼ   13
      14                                                                            14
        0000000000111111111122222222223333333333444444444455555555556666666666777777
        0123456789012345678901234567890123456789012345678901234567890123456789012345
      */
      static struct InitDialogItem InitItems[]={
      /* 0*/  {DI_DOUBLEBOX,3,1,72,13,0,0,0,0,""},
      /* 1*/  {DI_SINGLEBOX,5,4,70,11,0,0,DIF_LEFTTEXT,0,""},
      /* 2*/  {DI_RADIOBUTTON,5,2,0,0,1,0,DIF_GROUP,0,(char *)mPropSimpleFull},
      /* 3*/  {DI_RADIOBUTTON,5,3,0,0,0,0,0,0,(char *)mPropSimpleSpecial},
      /* 4*/  {DI_CHECKBOX,7, 5,0,0,0,0,0,0,(char *)mPropSimpleRead},
      /* 5*/  {DI_CHECKBOX,7, 6,0,0,0,0,0,0,(char *)mPropSimpleWrite},
      /* 6*/  {DI_CHECKBOX,7, 7,0,0,0,0,0,0,(char *)mPropSimpleExecute},
      /* 7*/  {DI_CHECKBOX,7, 8,0,0,0,0,0,0,(char *)mPropSimpleDelete},
      /* 8*/  {DI_CHECKBOX,7, 9,0,0,0,0,0,0,(char *)mPropSimpleChangePermissions},
      /* 9*/  {DI_CHECKBOX,7,10,0,0,0,0,0,0,(char *)mPropSimpleTakeOwnership},
      /*10*/  {DI_BUTTON,0,12,0,0,0,0,DIF_CENTERGROUP,1,(char *)mPropButtonOk},
      /*11*/  {DI_BUTTON,0,12,0,0,0,0,DIF_CENTERGROUP,0,(char *)mPropButtonCancel}
      };
      struct FarDialogItem DialogItems[sizeof(InitItems)/sizeof(InitItems[0])];
      InitDialogItems(InitItems,DialogItems,sizeof(InitItems)/sizeof(InitItems[0]));
      if((mask&common_full_access[panel->level])==common_full_access[panel->level])
        DialogItems[2].Selected=TRUE;
      else
      {
        DialogItems[3].Selected=TRUE;
        for(int i=4;i<10;i++)
          if((mask&common_rights[panel->level][i-4])==common_rights[panel->level][i-4])
            DialogItems[i].Selected=TRUE;
      }
      int DlgCode=Info.DialogEx(Info.ModuleNumber,-1,-1,76,15,"EditCommonAccess",DialogItems,(sizeof(DialogItems)/sizeof(DialogItems[0])),0,0,EditCommonAccessDialogProc,0);
      if(DlgCode==10)
      {
        mask=0;
        if(DialogItems[2].Selected)
          mask=common_full_access[panel->level];
        else
        {
          for(int i=4;i<10;i++)
            if(DialogItems[i].Selected)
              mask|=common_rights[panel->level][i-4];
        }
        if(UpdateAcl(panel,panel->level,GetSidFromUserData(PInfo.PanelItems[PInfo.CurrentItem].UserData),GetItemTypeFromUserData(PInfo.PanelItems[PInfo.CurrentItem].UserData),mask,actionUpdate))
          res=true;
      }
    }
  }
  return res;
}
