#include <windows.h>
#include "memory.h"

static PSID user=NULL;

void init_current_user(void)
{
  HANDLE token; PTOKEN_USER token_user=NULL;
  if(OpenProcessToken(GetCurrentProcess(),TOKEN_QUERY,&token))
  {
    unsigned long size;
    GetTokenInformation(token,TokenUser,0,0,&size);
    token_user=(PTOKEN_USER)malloc(size);
    if(token_user)
    {
      if(GetTokenInformation(token,TokenUser,token_user,size,&size))
      {
        if((token_user->User.Sid)&&(IsValidSid(token_user->User.Sid)))
        {
          user=(PSID)malloc(GetLengthSid(token_user->User.Sid));
          if(user) CopySid(GetLengthSid(token_user->User.Sid),user,token_user->User.Sid);
        }
      }
      free(token_user);
    }
    CloseHandle(token);
  }
}

bool is_current_user(PSID sid)
{
  if(sid&&IsValidSid(sid)&&user&&IsValidSid(user)&&EqualSid(user,sid)) return true;
  return false;
}

PSID current_user(void)
{
  return user;
}

void free_current_user(void)
{
  free(user);
  user=NULL;
}
