#ifndef _NTDLL_
#define _NTDLL_
#if __GNUC__ >=3
#pragma GCC system_header
#endif

#include <ntdef.h>
#include "ntstatus.h"

#ifdef __cplusplus
extern "C"{
#endif

#ifndef IN
#define IN
#endif

#ifndef OUT
#define OUT
#endif

#ifndef OPTIONAL
#define OPTIONAL
#endif

#ifndef NOTHING
#define NOTHING
#endif

#ifndef CRITICAL
#define CRITICAL
#endif

#ifndef NTAPI
#ifndef NTAPI
#define NTAPI __stdcall
#endif
#endif

#ifndef NTSYSAPI
#define NTSYSAPI
#endif

#ifndef POINTER_64
#define POINTER_64
#endif

//flags that control various aspects of the behavior of the kernel.
#ifndef FLG_STOP_ON_EXCEPTION
#define FLG_STOP_ON_EXCEPTION           0x00000001
#endif
#ifndef FLG_SHOW_LDR_SNAPS
#define FLG_SHOW_LDR_SNAPS              0x00000002
#endif
#ifndef FLG_DEBUG_INITIAL_COMMAND
#define FLG_DEBUG_INITIAL_COMMAND       0x00000004
#endif
#ifndef FLG_STOP_ON_HUNG_GUI
#define FLG_STOP_ON_HUNG_GUI            0x00000008
#endif
#ifndef FLG_HEAP_ENABLE_TAIL_CHECK
#define FLG_HEAP_ENABLE_TAIL_CHECK      0x00000010
#endif
#ifndef FLG_HEAP_ENABLE_FREE_CHECK
#define FLG_HEAP_ENABLE_FREE_CHECK      0x00000020
#endif
#ifndef FLG_HEAP_VALIDATE_PARAMETERS
#define FLG_HEAP_VALIDATE_PARAMETERS    0x00000040
#endif
#ifndef FLG_HEAP_VALIDATE_ALL
#define FLG_HEAP_VALIDATE_ALL           0x00000080
#endif
#ifndef FLG_POOL_ENABLE_TAIL_CHECK
#define FLG_POOL_ENABLE_TAIL_CHECK      0x00000100
#endif
#ifndef FLG_POOL_ENABLE_FREE_CHECK
#define FLG_POOL_ENABLE_FREE_CHECK      0x00000200
#endif
#ifndef FLG_POOL_ENABLE_TAGGING
#define FLG_POOL_ENABLE_TAGGING         0x00000400
#endif
#ifndef FLG_HEAP_ENABLE_TAGGING
#define FLG_HEAP_ENABLE_TAGGING         0x00000800
#endif
#ifndef FLG_USER_STACK_TRACE_DB
#define FLG_USER_STACK_TRACE_DB         0x00001000
#endif
#ifndef FLG_KERNEL_STACK_TRACE_DB
#define FLG_KERNEL_STACK_TRACE_DB       0x00002000
#endif
#ifndef FLG_MAINTAIN_OBJECT_TYPELIST
#define FLG_MAINTAIN_OBJECT_TYPELIST    0x00004000
#endif
#ifndef FLG_HEAP_ENABLE_TAG_BY_DLL
#define FLG_HEAP_ENABLE_TAG_BY_DLL      0x00008000
#endif
#ifndef FLG_IGNORE_DEBUG_PRIV
#define FLG_IGNORE_DEBUG_PRIV           0x00010000
#endif
#ifndef FLG_ENABLE_CSRDEBUG
#define FLG_ENABLE_CSRDEBUG             0x00020000
#endif
#ifndef FLG_ENABLE_KDEBUG_SYMBOL_LOAD
#define FLG_ENABLE_KDEBUG_SYMBOL_LOAD   0x00040000
#endif
#ifndef FLG_DISABLE_PAGE_KERNEL_STACKS
#define FLG_DISABLE_PAGE_KERNEL_STACKS  0x00080000
#endif
#ifndef FLG_HEAP_ENABLE_CALL_TRACING
#define FLG_HEAP_ENABLE_CALL_TRACING    0x00100000
#endif
#ifndef FLG_HEAP_DISABLE_COALESCING
#define FLG_HEAP_DISABLE_COALESCING     0x00200000
#endif
#ifndef FLG_ENABLE_CLOSE_EXCEPTIONS
#define FLG_ENABLE_CLOSE_EXCEPTIONS     0x00400000
#endif
#ifndef FLG_ENABLE_EXCEPTION_LOGGING
#define FLG_ENABLE_EXCEPTION_LOGGING    0x00800000
#endif
#ifndef FLG_ENABLE_DBGPRINT_BUFFERING
#define FLG_ENABLE_DBGPRINT_BUFFERING   0x08000000
#endif

// flags that specify properties of the object
#ifndef SINGLE_HANDLE_ENTRY
#define SINGLE_HANDLE_ENTRY             0x40
#endif
#ifndef DEFAULT_SECURITY_QUOTA
#define DEFAULT_SECURITY_QUOTA          0x20
#endif
#ifndef PERMANENT
#define PERMANENT                       0x10
#endif
#ifndef EXCLUSIVE
#define EXCLUSIVE                       0x08
#endif
#ifndef CREATOR_INFO
#define CREATOR_INFO                    0x04
#endif
#ifndef KERNEL_MODE
#define KERNEL_MODE                     0x02
#endif

// Define the I/O status information return values for NtCreateFile/NtOpenFile
#ifndef FILE_SUPERSEDED
#define FILE_SUPERSEDED                 0x00000000
#endif
#ifndef FILE_OPENED
#define FILE_OPENED                     0x00000001
#endif
#ifndef FILE_CREATED
#define FILE_CREATED                    0x00000002
#endif
#ifndef FILE_OVERWRITTEN
#define FILE_OVERWRITTEN                0x00000003
#endif
#ifndef FILE_EXISTS
#define FILE_EXISTS                     0x00000004
#endif
#ifndef FILE_DOES_NOT_EXIST
#define FILE_DOES_NOT_EXIST             0x00000005
#endif

// Define the create disposition values
#ifndef FILE_SUPERSEDE
#define FILE_SUPERSEDE                  0x00000000
#endif
#ifndef FILE_OPEN
#define FILE_OPEN                       0x00000001
#endif
#ifndef FILE_CREATE
#define FILE_CREATE                     0x00000002
#endif
#ifndef FILE_OPEN_IF
#define FILE_OPEN_IF                    0x00000003
#endif
#ifndef FILE_OVERWRITE
#define FILE_OVERWRITE                  0x00000004
#endif
#ifndef FILE_OVERWRITE_IF
#define FILE_OVERWRITE_IF               0x00000005
#endif
#ifndef FILE_MAXIMUM_DISPOSITION
#define FILE_MAXIMUM_DISPOSITION        0x00000005
#endif

// Define the create/open option flags
#ifndef FILE_DIRECTORY_FILE
#define FILE_DIRECTORY_FILE                     0x00000001
#endif
#ifndef FILE_WRITE_THROUGH
#define FILE_WRITE_THROUGH                      0x00000002
#endif
#ifndef FILE_SEQUENTIAL_ONLY
#define FILE_SEQUENTIAL_ONLY                    0x00000004
#endif
#ifndef FILE_NO_INTERMEDIATE_BUFFERING
#define FILE_NO_INTERMEDIATE_BUFFERING          0x00000008
#endif
#ifndef FILE_SYNCHRONOUS_IO_ALERT
#define FILE_SYNCHRONOUS_IO_ALERT               0x00000010
#endif
#ifndef FILE_SYNCHRONOUS_IO_NONALERT
#define FILE_SYNCHRONOUS_IO_NONALERT            0x00000020
#endif
#ifndef FILE_NON_DIRECTORY_FILE
#define FILE_NON_DIRECTORY_FILE                 0x00000040
#endif
#ifndef FILE_CREATE_TREE_CONNECTION
#define FILE_CREATE_TREE_CONNECTION             0x00000080
#endif
#ifndef FILE_COMPLETE_IF_OPLOCKED
#define FILE_COMPLETE_IF_OPLOCKED               0x00000100
#endif
#ifndef FILE_NO_EA_KNOWLEDGE
#define FILE_NO_EA_KNOWLEDGE                    0x00000200
#endif
#ifndef FILE_OPEN_FOR_RECOVERY
#define FILE_OPEN_FOR_RECOVERY                  0x00000400
#endif
#ifndef FILE_RANDOM_ACCESS
#define FILE_RANDOM_ACCESS                      0x00000800
#endif
#ifndef FILE_DELETE_ON_CLOSE
#define FILE_DELETE_ON_CLOSE                    0x00001000
#endif
#ifndef FILE_OPEN_BY_FILE_ID
#define FILE_OPEN_BY_FILE_ID                    0x00002000
#endif
#ifndef FILE_OPEN_FOR_BACKUP_INTENT
#define FILE_OPEN_FOR_BACKUP_INTENT             0x00004000
#endif
#ifndef FILE_NO_COMPRESSION
#define FILE_NO_COMPRESSION                     0x00008000
#endif
#ifndef FILE_RESERVE_OPFILTER
#define FILE_RESERVE_OPFILTER                   0x00100000
#endif
#ifndef FILE_OPEN_REPARSE_POINT
#define FILE_OPEN_REPARSE_POINT                 0x00200000
#endif
#ifndef FILE_OPEN_NO_RECALL
#define FILE_OPEN_NO_RECALL                     0x00400000
#endif
#ifndef FILE_OPEN_FOR_FREE_SPACE_QUERY
#define FILE_OPEN_FOR_FREE_SPACE_QUERY          0x00800000
#endif
#ifndef FILE_COPY_STRUCTURED_STORAGE
#define FILE_COPY_STRUCTURED_STORAGE            0x00000041
#endif
#ifndef FILE_STRUCTURED_STORAGE
#define FILE_STRUCTURED_STORAGE                 0x00000441
#endif
#ifndef FILE_VALID_OPTION_FLAGS
#define FILE_VALID_OPTION_FLAGS                 0x00ffffff
#endif
#ifndef FILE_VALID_PIPE_OPTION_FLAGS
#define FILE_VALID_PIPE_OPTION_FLAGS            0x00000032
#endif
#ifndef FILE_VALID_MAILSLOT_OPTION_FLAGS
#define FILE_VALID_MAILSLOT_OPTION_FLAGS        0x00000032
#endif
#ifndef FILE_VALID_SET_FLAGS
#define FILE_VALID_SET_FLAGS                    0x00000036
#endif

#ifndef DEVICE_TYPE
#define DEVICE_TYPE ULONG
#endif

#ifndef FILE_DEVICE_BEEP
#define FILE_DEVICE_BEEP                0x00000001
#endif
#ifndef FILE_DEVICE_CD_ROM
#define FILE_DEVICE_CD_ROM              0x00000002
#endif
#ifndef FILE_DEVICE_CD_ROM_FILE_SYSTEM
#define FILE_DEVICE_CD_ROM_FILE_SYSTEM  0x00000003
#endif
#ifndef FILE_DEVICE_CONTROLLER
#define FILE_DEVICE_CONTROLLER          0x00000004
#endif
#ifndef FILE_DEVICE_DATALINK
#define FILE_DEVICE_DATALINK            0x00000005
#endif
#ifndef FILE_DEVICE_DFS
#define FILE_DEVICE_DFS                 0x00000006
#endif
#ifndef FILE_DEVICE_DISK
#define FILE_DEVICE_DISK                0x00000007
#endif
#ifndef FILE_DEVICE_DISK_FILE_SYSTEM
#define FILE_DEVICE_DISK_FILE_SYSTEM    0x00000008
#endif
#ifndef FILE_DEVICE_FILE_SYSTEM
#define FILE_DEVICE_FILE_SYSTEM         0x00000009
#endif
#ifndef FILE_DEVICE_INPORT_PORT
#define FILE_DEVICE_INPORT_PORT         0x0000000a
#endif
#ifndef FILE_DEVICE_KEYBOARD
#define FILE_DEVICE_KEYBOARD            0x0000000b
#endif
#ifndef FILE_DEVICE_MAILSLOT
#define FILE_DEVICE_MAILSLOT            0x0000000c
#endif
#ifndef FILE_DEVICE_MIDI_IN
#define FILE_DEVICE_MIDI_IN             0x0000000d
#endif
#ifndef FILE_DEVICE_MIDI_OUT
#define FILE_DEVICE_MIDI_OUT            0x0000000e
#endif
#ifndef FILE_DEVICE_MOUSE
#define FILE_DEVICE_MOUSE               0x0000000f
#endif
#ifndef FILE_DEVICE_MULTI_UNC_PROVIDER
#define FILE_DEVICE_MULTI_UNC_PROVIDER  0x00000010
#endif
#ifndef FILE_DEVICE_NAMED_PIPE
#define FILE_DEVICE_NAMED_PIPE          0x00000011
#endif
#ifndef FILE_DEVICE_NETWORK
#define FILE_DEVICE_NETWORK             0x00000012
#endif
#ifndef FILE_DEVICE_NETWORK_BROWSER
#define FILE_DEVICE_NETWORK_BROWSER     0x00000013
#endif
#ifndef FILE_DEVICE_NETWORK_FILE_SYSTEM
#define FILE_DEVICE_NETWORK_FILE_SYSTEM 0x00000014
#endif
#ifndef FILE_DEVICE_NULL
#define FILE_DEVICE_NULL                0x00000015
#endif
#ifndef FILE_DEVICE_PARALLEL_PORT
#define FILE_DEVICE_PARALLEL_PORT       0x00000016
#endif
#ifndef FILE_DEVICE_PHYSICAL_NETCARD
#define FILE_DEVICE_PHYSICAL_NETCARD    0x00000017
#endif
#ifndef FILE_DEVICE_PRINTER
#define FILE_DEVICE_PRINTER             0x00000018
#endif
#ifndef FILE_DEVICE_SCANNER
#define FILE_DEVICE_SCANNER             0x00000019
#endif
#ifndef FILE_DEVICE_SERIAL_MOUSE_PORT
#define FILE_DEVICE_SERIAL_MOUSE_PORT   0x0000001a
#endif
#ifndef FILE_DEVICE_SERIAL_PORT
#define FILE_DEVICE_SERIAL_PORT         0x0000001b
#endif
#ifndef FILE_DEVICE_SCREEN
#define FILE_DEVICE_SCREEN              0x0000001c
#endif
#ifndef FILE_DEVICE_SOUND
#define FILE_DEVICE_SOUND               0x0000001d
#endif
#ifndef FILE_DEVICE_STREAMS
#define FILE_DEVICE_STREAMS             0x0000001e
#endif
#ifndef FILE_DEVICE_TAPE
#define FILE_DEVICE_TAPE                0x0000001f
#endif
#ifndef FILE_DEVICE_TAPE_FILE_SYSTEM
#define FILE_DEVICE_TAPE_FILE_SYSTEM    0x00000020
#endif
#ifndef FILE_DEVICE_TRANSPORT
#define FILE_DEVICE_TRANSPORT           0x00000021
#endif
#ifndef FILE_DEVICE_UNKNOWN
#define FILE_DEVICE_UNKNOWN             0x00000022
#endif
#ifndef FILE_DEVICE_VIDEO
#define FILE_DEVICE_VIDEO               0x00000023
#endif
#ifndef FILE_DEVICE_VIRTUAL_DISK
#define FILE_DEVICE_VIRTUAL_DISK        0x00000024
#endif
#ifndef FILE_DEVICE_WAVE_IN
#define FILE_DEVICE_WAVE_IN             0x00000025
#endif
#ifndef FILE_DEVICE_WAVE_OUT
#define FILE_DEVICE_WAVE_OUT            0x00000026
#endif
#ifndef FILE_DEVICE_8042_PORT
#define FILE_DEVICE_8042_PORT           0x00000027
#endif
#ifndef FILE_DEVICE_NETWORK_REDIRECTOR
#define FILE_DEVICE_NETWORK_REDIRECTOR  0x00000028
#endif
#ifndef FILE_DEVICE_BATTERY
#define FILE_DEVICE_BATTERY             0x00000029
#endif
#ifndef FILE_DEVICE_BUS_EXTENDER
#define FILE_DEVICE_BUS_EXTENDER        0x0000002a
#endif
#ifndef FILE_DEVICE_MODEM
#define FILE_DEVICE_MODEM               0x0000002b
#endif
#ifndef FILE_DEVICE_VDM
#define FILE_DEVICE_VDM                 0x0000002c
#endif
#ifndef FILE_DEVICE_MASS_STORAGE
#define FILE_DEVICE_MASS_STORAGE        0x0000002d
#endif
#ifndef FILE_DEVICE_SMB
#define FILE_DEVICE_SMB                 0x0000002e
#endif
#ifndef FILE_DEVICE_KS
#define FILE_DEVICE_KS                  0x0000002f
#endif
#ifndef FILE_DEVICE_CHANGER
#define FILE_DEVICE_CHANGER             0x00000030
#endif
#ifndef FILE_DEVICE_SMARTCARD
#define FILE_DEVICE_SMARTCARD           0x00000031
#endif
#ifndef FILE_DEVICE_ACPI
#define FILE_DEVICE_ACPI                0x00000032
#endif
#ifndef FILE_DEVICE_DVD
#define FILE_DEVICE_DVD                 0x00000033
#endif
#ifndef FILE_DEVICE_FULLSCREEN_VIDEO
#define FILE_DEVICE_FULLSCREEN_VIDEO    0x00000034
#endif
#ifndef FILE_DEVICE_DFS_FILE_SYSTEM
#define FILE_DEVICE_DFS_FILE_SYSTEM     0x00000035
#endif
#ifndef FILE_DEVICE_DFS_VOLUME
#define FILE_DEVICE_DFS_VOLUME          0x00000036
#endif
#ifndef FILE_DEVICE_SERENUM
#define FILE_DEVICE_SERENUM             0x00000037
#endif
#ifndef FILE_DEVICE_TERMSRV
#define FILE_DEVICE_TERMSRV             0x00000038
#endif
#ifndef FILE_DEVICE_KSEC
#define FILE_DEVICE_KSEC                0x00000039
#endif

#ifndef FILE_REMOVABLE_MEDIA
#define FILE_REMOVABLE_MEDIA            0x00000001
#endif
#ifndef FILE_READ_ONLY_DEVICE
#define FILE_READ_ONLY_DEVICE           0x00000002
#endif
#ifndef FILE_FLOPPY_DISKETTE
#define FILE_FLOPPY_DISKETTE            0x00000004
#endif
#ifndef FILE_WRITE_ONCE_MEDIA
#define FILE_WRITE_ONCE_MEDIA           0x00000008
#endif
#ifndef FILE_REMOTE_DEVICE
#define FILE_REMOTE_DEVICE              0x00000010
#endif
#ifndef FILE_DEVICE_IS_MOUNTED
#define FILE_DEVICE_IS_MOUNTED          0x00000020
#endif
#ifndef FILE_VIRTUAL_VOLUME
#define FILE_VIRTUAL_VOLUME             0x00000040
#endif
#ifndef FILE_AUTOGENERATED_DEVICE_NAME
#define FILE_AUTOGENERATED_DEVICE_NAME  0x00000080
#endif
#ifndef FILE_DEVICE_SECURE_OPEN
#define FILE_DEVICE_SECURE_OPEN         0x00000100
#endif

#ifndef FILE_BYTE_ALIGNMENT
#define FILE_BYTE_ALIGNMENT             0x00000000
#endif
#ifndef FILE_WORD_ALIGNMENT
#define FILE_WORD_ALIGNMENT             0x00000001
#endif
#ifndef FILE_LONG_ALIGNMENT
#define FILE_LONG_ALIGNMENT             0x00000003
#endif
#ifndef FILE_QUAD_ALIGNMENT
#define FILE_QUAD_ALIGNMENT             0x00000007
#endif
#ifndef FILE_OCTA_ALIGNMENT
#define FILE_OCTA_ALIGNMENT             0x0000000f
#endif
#ifndef FILE_32_BYTE_ALIGNMENT
#define FILE_32_BYTE_ALIGNMENT          0x0000001f
#endif
#ifndef FILE_64_BYTE_ALIGNMENT
#define FILE_64_BYTE_ALIGNMENT          0x0000003f
#endif
#ifndef FILE_128_BYTE_ALIGNMENT
#define FILE_128_BYTE_ALIGNMENT         0x0000007f
#endif
#ifndef FILE_256_BYTE_ALIGNMENT
#define FILE_256_BYTE_ALIGNMENT         0x000000ff
#endif
#ifndef FILE_512_BYTE_ALIGNMENT
#define FILE_512_BYTE_ALIGNMENT         0x000001ff
#endif

#ifndef DBGKD_INTERNAL_BP_FLAG_COUNTONLY
#define DBGKD_INTERNAL_BP_FLAG_COUNTONLY  0x01 // don't count instructions
#endif
#ifndef DBGKD_INTERNAL_BP_FLAG_INVALID
#define DBGKD_INTERNAL_BP_FLAG_INVALID    0x02 // disabled BP
#endif
#ifndef DBGKD_INTERNAL_BP_FLAG_SUSPENDED
#define DBGKD_INTERNAL_BP_FLAG_SUSPENDED  0x04 // temporarily suspended
#endif
#ifndef DBGKD_INTERNAL_BP_FLAG_DYING
#define DBGKD_INTERNAL_BP_FLAG_DYING      0x08 // kill on exit
#endif

#ifndef DUPLICATE_SAME_ATTRIBUTES
#define DUPLICATE_SAME_ATTRIBUTES       0x00000004
#endif

#ifndef OBJECT_TYPE_CREATE
#define OBJECT_TYPE_CREATE              (0x0001)
#endif
#ifndef OBJECT_TYPE_ALL_ACCESS
#define OBJECT_TYPE_ALL_ACCESS          (STANDARD_RIGHTS_REQUIRED | 0x1)
#endif

#ifndef DIRECTORY_QUERY
#define DIRECTORY_QUERY                 (0x0001)
#endif
#ifndef DIRECTORY_TRAVERSE
#define DIRECTORY_TRAVERSE              (0x0002)
#endif
#ifndef DIRECTORY_CREATE_OBJECT
#define DIRECTORY_CREATE_OBJECT         (0x0004)
#endif
#ifndef DIRECTORY_CREATE_SUBDIRECTORY
#define DIRECTORY_CREATE_SUBDIRECTORY   (0x0008)
#endif
#ifndef DIRECTORY_ALL_ACCESS
#define DIRECTORY_ALL_ACCESS            (STANDARD_RIGHTS_REQUIRED | 0xF)
#endif

#ifndef SYMBOLIC_LINK_QUERY
#define SYMBOLIC_LINK_QUERY             (0x0001)
#endif
#ifndef SYMBOLIC_LINK_ALL_ACCESS
#define SYMBOLIC_LINK_ALL_ACCESS        (STANDARD_RIGHTS_REQUIRED | 0x1)
#endif

#ifndef PAGE_NOACCESS
#ifndef PAGE_NOACCESS
#define PAGE_NOACCESS          0x01
#endif
#endif
#ifndef PAGE_READONLY
#ifndef PAGE_READONLY
#define PAGE_READONLY          0x02
#endif
#endif
#ifndef PAGE_READWRITE
#ifndef PAGE_READWRITE
#define PAGE_READWRITE         0x04
#endif
#endif
#ifndef PAGE_WRITECOPY
#ifndef PAGE_WRITECOPY
#define PAGE_WRITECOPY         0x08
#endif
#endif
#ifndef PAGE_EXECUTE
#ifndef PAGE_EXECUTE
#define PAGE_EXECUTE           0x10
#endif
#endif
#ifndef PAGE_EXECUTE_READ
#ifndef PAGE_EXECUTE_READ
#define PAGE_EXECUTE_READ      0x20
#endif
#endif
#ifndef PAGE_EXECUTE_READWRITE
#ifndef PAGE_EXECUTE_READWRITE
#define PAGE_EXECUTE_READWRITE 0x40
#endif
#endif
#ifndef PAGE_EXECUTE_WRITECOPY
#ifndef PAGE_EXECUTE_WRITECOPY
#define PAGE_EXECUTE_WRITECOPY 0x80
#endif
#endif
#ifndef PAGE_GUARD
#ifndef PAGE_GUARD
#define PAGE_GUARD            0x100
#endif
#endif
#ifndef PAGE_NOCACHE
#ifndef PAGE_NOCACHE
#define PAGE_NOCACHE          0x200
#endif
#endif
#ifndef PAGE_WRITECOMBINE
#ifndef PAGE_WRITECOMBINE
#define PAGE_WRITECOMBINE     0x400
#endif
#endif

#ifndef MEM_COMMIT
#ifndef MEM_COMMIT
#define MEM_COMMIT           0x1000
#endif
#endif
#ifndef MEM_RESERVE
#ifndef MEM_RESERVE
#define MEM_RESERVE          0x2000
#endif
#endif
#ifndef MEM_DECOMMIT
#ifndef MEM_DECOMMIT
#define MEM_DECOMMIT         0x4000
#endif
#endif
#ifndef MEM_RELEASE
#ifndef MEM_RELEASE
#define MEM_RELEASE          0x8000
#endif
#endif
#ifndef MEM_FREE
#ifndef MEM_FREE
#define MEM_FREE            0x10000
#endif
#endif
#ifndef MEM_PRIVATE
#ifndef MEM_PRIVATE
#define MEM_PRIVATE         0x20000
#endif
#endif
#ifndef MEM_MAPPED
#ifndef MEM_MAPPED
#define MEM_MAPPED          0x40000
#endif
#endif
#ifndef MEM_RESET
#ifndef MEM_RESET
#define MEM_RESET           0x80000
#endif
#endif
#ifndef MEM_TOP_DOWN
#ifndef MEM_TOP_DOWN
#define MEM_TOP_DOWN       0x100000
#endif
#endif
#ifndef MEM_LARGE_PAGES
#ifndef MEM_LARGE_PAGES
#define MEM_LARGE_PAGES  0x20000000
#endif
#endif
#ifndef MEM_4MB_PAGES
#ifndef MEM_4MB_PAGES
#define MEM_4MB_PAGES    0x80000000
#endif
#endif

#ifndef WSLE_PAGE_READONLY
#define WSLE_PAGE_READONLY          0x001 // Page is read only
#endif
#ifndef WSLE_PAGE_EXECUTE
#define WSLE_PAGE_EXECUTE           0x002 // Page is executable
#endif
#ifndef WSLE_PAGE_READWRITE
#define WSLE_PAGE_READWRITE         0x004 // Page is writeable
#endif
#ifndef WSLE_PAGE_EXECUTE_READ
#define WSLE_PAGE_EXECUTE_READ      0x003
#endif
#ifndef WSLE_PAGE_WRITECOPY
#define WSLE_PAGE_WRITECOPY         0x005 // Page should be copied on write
#endif
#ifndef WSLE_PAGE_EXECUTE_READWRITE
#define WSLE_PAGE_EXECUTE_READWRITE 0x006
#endif
#ifndef WSLE_PAGE_EXECUTE_WRITECOPY
#define WSLE_PAGE_EXECUTE_WRITECOPY 0x007 // Page should be copied on write
#endif
#ifndef WSLE_PAGE_SHARE_COUNT_MASK
#define WSLE_PAGE_SHARE_COUNT_MASK  0x0E0
#endif
#ifndef WSLE_PAGE_SHAREABLE
#define WSLE_PAGE_SHAREABLE         0x100 // Page is shareable
#endif

#ifndef LOCK_VM_IN_WSL
#define LOCK_VM_IN_WSL 0x01 // Lock page in working set list
#endif
#ifndef LOCK_VM_IN_RAM
#define LOCK_VM_IN_RAM 0x02 // Lock page in physical memory
#endif

#ifndef SECTION_QUERY
#ifndef SECTION_QUERY
#define SECTION_QUERY       0x0001
#endif
#endif
#ifndef SECTION_MAP_WRITE
#ifndef SECTION_MAP_WRITE
#define SECTION_MAP_WRITE   0x0002
#endif
#endif
#ifndef SECTION_MAP_READ
#ifndef SECTION_MAP_READ
#define SECTION_MAP_READ    0x0004
#endif
#endif
#ifndef SECTION_MAP_EXECUTE
#ifndef SECTION_MAP_EXECUTE
#define SECTION_MAP_EXECUTE 0x0008
#endif
#endif
#ifndef SECTION_EXTEND_SIZE
#ifndef SECTION_EXTEND_SIZE
#define SECTION_EXTEND_SIZE 0x0010
#endif
#endif
#ifndef SECTION_ALL_ACCESS
#ifndef SECTION_ALL_ACCESS
#define SECTION_ALL_ACCESS (STANDARD_RIGHTS_REQUIRED|SECTION_QUERY|SECTION_MAP_WRITE|SECTION_MAP_READ|SECTION_MAP_EXECUTE|SECTION_EXTEND_SIZE)
#endif
#endif

#ifndef SEC_BASED
#ifndef SEC_BASED
#define SEC_BASED     0x00200000 // Section should be mapped at same address in each process
#endif
#endif
#ifndef SEC_NO_CHANGE
#ifndef SEC_NO_CHANGE
#define SEC_NO_CHANGE 0x00400000 // Changes to protection of section pages are disabled
#endif
#endif
#ifndef SEC_FILE
#ifndef SEC_FILE
#define SEC_FILE      0x00800000 // Section is backed by a file
#endif
#endif
#ifndef SEC_IMAGE
#ifndef SEC_IMAGE
#define SEC_IMAGE     0x01000000 // Section is mapped as an image
#endif
#endif
#ifndef SEC_VLM
#ifndef SEC_VLM
#define SEC_VLM       0x02000000 // Section maps VLM
#endif
#endif
#ifndef SEC_RESERVE
#ifndef SEC_RESERVE
#define SEC_RESERVE   0x04000000 // Section pages are reserved
#endif
#endif
#ifndef SEC_COMMIT
#ifndef SEC_COMMIT
#define SEC_COMMIT    0x08000000 // Section pages are committed
#endif
#endif
#ifndef SEC_NOCACHE
#ifndef SEC_NOCACHE
#define SEC_NOCACHE   0x10000000 // Section pages are non-cacheable
#endif
#endif

#ifndef AT_EXTENDABLE_FILE
#define AT_EXTENDABLE_FILE 0x00002000 // Allow view to exceed section size
#endif
#ifndef AT_RESERVED
#define AT_RESERVED 0x20000000        // Valid but ignored
#endif
#ifndef AT_ROUND_TO_PAGE
#define AT_ROUND_TO_PAGE 0x40000000   // Adjust address and size if necessary
#endif

#ifndef THREAD_ALERT
#define THREAD_ALERT 4 //Alert thread
#endif

#ifndef PROCESS_TERMINATE
#ifndef PROCESS_TERMINATE
#define PROCESS_TERMINATE         (0x0001)
#endif
#endif
#ifndef PROCESS_CREATE_THREAD
#ifndef PROCESS_CREATE_THREAD
#define PROCESS_CREATE_THREAD     (0x0002)
#endif
#endif
#ifndef PROCESS_SET_SESSIONID
#ifndef PROCESS_SET_SESSIONID
#define PROCESS_SET_SESSIONID     (0x0004)
#endif
#endif
#ifndef PROCESS_VM_OPERATION
#ifndef PROCESS_VM_OPERATION
#define PROCESS_VM_OPERATION      (0x0008)
#endif
#endif
#ifndef PROCESS_VM_READ
#ifndef PROCESS_VM_READ
#define PROCESS_VM_READ           (0x0010)
#endif
#endif
#ifndef PROCESS_VM_WRITE
#ifndef PROCESS_VM_WRITE
#define PROCESS_VM_WRITE          (0x0020)
#endif
#endif
#ifndef PROCESS_DUP_HANDLE
#ifndef PROCESS_DUP_HANDLE
#define PROCESS_DUP_HANDLE        (0x0040)
#endif
#endif
#ifndef PROCESS_CREATE_PROCESS
#ifndef PROCESS_CREATE_PROCESS
#define PROCESS_CREATE_PROCESS    (0x0080)
#endif
#endif
#ifndef PROCESS_SET_QUOTA
#ifndef PROCESS_SET_QUOTA
#define PROCESS_SET_QUOTA         (0x0100)
#endif
#endif
#ifndef PROCESS_SET_INFORMATION
#ifndef PROCESS_SET_INFORMATION
#define PROCESS_SET_INFORMATION   (0x0200)
#endif
#endif
#ifndef PROCESS_QUERY_INFORMATION
#ifndef PROCESS_QUERY_INFORMATION
#define PROCESS_QUERY_INFORMATION (0x0400)
#endif
#endif
#ifndef PROCESS_SET_PORT
#ifndef PROCESS_SET_PORT
#define PROCESS_SET_PORT          (0x0800)
#endif
#endif
#ifndef PROCESS_ALL_ACCESS
#ifndef PROCESS_ALL_ACCESS
#define PROCESS_ALL_ACCESS        (STANDARD_RIGHTS_REQUIRED|SYNCHRONIZE|0xFFF)
#endif
#endif

#ifndef OBJ_HANDLE_TAGBITS
#ifndef OBJ_HANDLE_TAGBITS
#define OBJ_HANDLE_TAGBITS  0x00000003L
#endif
#endif

#ifndef PC_IDLE
#define PC_IDLE         1
#endif
#ifndef PC_NORMAL
#define PC_NORMAL       2
#endif
#ifndef PC_HIGH
#define PC_HIGH         3
#endif
#ifndef PC_REALTIME
#define PC_REALTIME     4
#endif
#ifndef PC_BELOW_NORMAL
#define PC_BELOW_NORMAL 5
#endif
#ifndef PC_ABOVE_NORMAL
#define PC_ABOVE_NORMAL 6
#endif

#ifndef PDI_MODULES
#define PDI_MODULES     0x01 // The loaded modules of the process
#endif
#ifndef PDI_BACKTRACE
#define PDI_BACKTRACE   0x02 // The heap stack back traces
#endif
#ifndef PDI_HEAPS
#define PDI_HEAPS       0x04 // The heaps of the process
#endif
#ifndef PDI_HEAP_TAGS
#define PDI_HEAP_TAGS   0x08 // The heap tags
#endif
#ifndef PDI_HEAP_BLOCKS
#define PDI_HEAP_BLOCKS 0x10 // The heap blocks
#endif
#ifndef PDI_LOCKS
#define PDI_LOCKS       0x20 // The locks created by the process
#endif

#ifndef LDRP_STATIC_LINK
#define LDRP_STATIC_LINK             0x00000002
#endif
#ifndef LDRP_IMAGE_DLL
#define LDRP_IMAGE_DLL               0x00000004
#endif
#ifndef LDRP_LOAD_IN_PROGRESS
#define LDRP_LOAD_IN_PROGRESS        0x00001000
#endif
#ifndef LDRP_UNLOAD_IN_PROGRESS
#define LDRP_UNLOAD_IN_PROGRESS      0x00002000
#endif
#ifndef LDRP_ENTRY_PROCESSED
#define LDRP_ENTRY_PROCESSED         0x00004000
#endif
#ifndef LDRP_ENTRY_INSERTED
#define LDRP_ENTRY_INSERTED          0x00008000
#endif
#ifndef LDRP_CURRENT_LOAD
#define LDRP_CURRENT_LOAD            0x00010000
#endif
#ifndef LDRP_FAILED_BUILTIN_LOAD
#define LDRP_FAILED_BUILTIN_LOAD     0x00020000
#endif
#ifndef LDRP_DONT_CALL_FOR_THREADS
#define LDRP_DONT_CALL_FOR_THREADS   0x00040000
#endif
#ifndef LDRP_PROCESS_ATTACH_CALLED
#define LDRP_PROCESS_ATTACH_CALLED   0x00080000
#endif
#ifndef LDRP_DEBUG_SYMBOLS_LOADED
#define LDRP_DEBUG_SYMBOLS_LOADED    0x00100000
#endif
#ifndef LDRP_IMAGE_NOT_AT_BASE
#define LDRP_IMAGE_NOT_AT_BASE       0x00200000
#endif
#ifndef LDRP_WX86_IGNORE_MACHINETYPE
#define LDRP_WX86_IGNORE_MACHINETYPE 0x00400000
#endif

#ifndef JOB_OBJECT_ASSIGN_PROCESS
#ifndef JOB_OBJECT_ASSIGN_PROCESS
#define JOB_OBJECT_ASSIGN_PROCESS           (0x0001)
#endif
#endif
#ifndef JOB_OBJECT_SET_ATTRIBUTES
#ifndef JOB_OBJECT_SET_ATTRIBUTES
#define JOB_OBJECT_SET_ATTRIBUTES           (0x0002)
#endif
#endif
#ifndef JOB_OBJECT_QUERY
#ifndef JOB_OBJECT_QUERY
#define JOB_OBJECT_QUERY                    (0x0004)
#endif
#endif
#ifndef JOB_OBJECT_TERMINATE
#ifndef JOB_OBJECT_TERMINATE
#define JOB_OBJECT_TERMINATE                (0x0008)
#endif
#endif
#ifndef JOB_OBJECT_SET_SECURITY_ATTRIBUTES
#ifndef JOB_OBJECT_SET_SECURITY_ATTRIBUTES
#define JOB_OBJECT_SET_SECURITY_ATTRIBUTES  (0x0010)
#endif
#endif
#ifndef JOB_OBJECT_ALL_ACCESS
#ifndef JOB_OBJECT_ALL_ACCESS
#define JOB_OBJECT_ALL_ACCESS               (STANDARD_RIGHTS_REQUIRED|SYNCHRONIZE|0x1F)
#endif
#endif

#ifndef JOB_OBJECT_LIMIT_WORKINGSET
#define JOB_OBJECT_LIMIT_WORKINGSET                 0x0001
#endif
#ifndef JOB_OBJECT_LIMIT_PROCESS_TIME
#define JOB_OBJECT_LIMIT_PROCESS_TIME               0x0002
#endif
#ifndef JOB_OBJECT_LIMIT_JOB_TIME
#define JOB_OBJECT_LIMIT_JOB_TIME                   0x0004
#endif
#ifndef JOB_OBJECT_LIMIT_ACTIVE_PROCESS
#define JOB_OBJECT_LIMIT_ACTIVE_PROCESS             0x0008
#endif
#ifndef JOB_OBJECT_LIMIT_AFFINITY
#define JOB_OBJECT_LIMIT_AFFINITY                   0x0010
#endif
#ifndef JOB_OBJECT_LIMIT_PRIORITY_CLASS
#define JOB_OBJECT_LIMIT_PRIORITY_CLASS             0x0020
#endif
#ifndef JOB_OBJECT_LIMIT_PRESERVE_JOB_TIME
#define JOB_OBJECT_LIMIT_PRESERVE_JOB_TIME          0x0040
#endif
#ifndef JOB_OBJECT_LIMIT_SCHEDULING_CLASS
#define JOB_OBJECT_LIMIT_SCHEDULING_CLASS           0x0080
#endif
#ifndef JOB_OBJECT_LIMIT_PROCESS_MEMORY
#define JOB_OBJECT_LIMIT_PROCESS_MEMORY             0x0100
#endif
#ifndef JOB_OBJECT_LIMIT_JOB_MEMORY
#define JOB_OBJECT_LIMIT_JOB_MEMORY                 0x0200
#endif
#ifndef JOB_OBJECT_LIMIT_DIE_ON_UNHANDLED_EXCEPTION
#define JOB_OBJECT_LIMIT_DIE_ON_UNHANDLED_EXCEPTION 0x0400
#endif
#ifndef JOB_OBJECT_BREAKAWAY_OK
#define JOB_OBJECT_BREAKAWAY_OK                     0x0800
#endif
#ifndef JOB_OBJECT_SILENT_BREAKAWAY
#define JOB_OBJECT_SILENT_BREAKAWAY                 0x1000
#endif

#ifndef JOB_OBJECT_UILIMIT_HANDLES
#define JOB_OBJECT_UILIMIT_HANDLES                  0x0001
#endif
#ifndef JOB_OBJECT_UILIMIT_READCLIPBOARD
#define JOB_OBJECT_UILIMIT_READCLIPBOARD            0x0002
#endif
#ifndef JOB_OBJECT_UILIMIT_WRITECLIPBOARD
#define JOB_OBJECT_UILIMIT_WRITECLIPBOARD           0x0004
#endif
#ifndef JOB_OBJECT_UILIMIT_SYSTEMPARAMETERS
#define JOB_OBJECT_UILIMIT_SYSTEMPARAMETERS         0x0008
#endif
#ifndef JOB_OBJECT_UILIMIT_DISPLAYSETTINGS
#define JOB_OBJECT_UILIMIT_DISPLAYSETTINGS          0x0010
#endif
#ifndef JOB_OBJECT_UILIMIT_GLOBALATOMS
#define JOB_OBJECT_UILIMIT_GLOBALATOMS              0x0020
#endif
#ifndef JOB_OBJECT_UILIMIT_DESKTOP
#define JOB_OBJECT_UILIMIT_DESKTOP                  0x0040
#endif
#ifndef JOB_OBJECT_UILIMIT_EXITWINDOWS
#define JOB_OBJECT_UILIMIT_EXITWINDOWS              0x0080
#endif

#ifndef JOB_OBJECT_SECURITY_NO_ADMIN
#define JOB_OBJECT_SECURITY_NO_ADMIN                0x0001
#endif
#ifndef JOB_OBJECT_SECURITY_RESTRICTED_TOKEN
#define JOB_OBJECT_SECURITY_RESTRICTED_TOKEN        0x0002
#endif
#ifndef JOB_OBJECT_SECURITY_ONLY_TOKEN
#define JOB_OBJECT_SECURITY_ONLY_TOKEN              0x0004
#endif
#ifndef JOB_OBJECT_SECURITY_FILTER_TOKENS
#define JOB_OBJECT_SECURITY_FILTER_TOKENS           0x0008
#endif

#ifndef JOB_OBJECT_TERMINATE_AT_END_OF_JOB
#define JOB_OBJECT_TERMINATE_AT_END_OF_JOB 0
#endif
#ifndef JOB_OBJECT_POST_AT_END_OF_JOB
#define JOB_OBJECT_POST_AT_END_OF_JOB      1
#endif

#ifndef JOB_OBJECT_MSG_END_OF_JOB_TIME
#define JOB_OBJECT_MSG_END_OF_JOB_TIME        1
#endif
#ifndef JOB_OBJECT_MSG_END_OF_PROCESS_TIME
#define JOB_OBJECT_MSG_END_OF_PROCESS_TIME    2
#endif
#ifndef JOB_OBJECT_MSG_ACTIVE_PROCESS_LIMIT
#define JOB_OBJECT_MSG_ACTIVE_PROCESS_LIMIT   3
#endif
#ifndef JOB_OBJECT_MSG_ACTIVE_PROCESS_ZERO
#define JOB_OBJECT_MSG_ACTIVE_PROCESS_ZERO    4
#endif
#ifndef JOB_OBJECT_MSG_NEW_PROCESS
#define JOB_OBJECT_MSG_NEW_PROCESS            6
#endif
#ifndef JOB_OBJECT_MSG_EXIT_PROCESS
#define JOB_OBJECT_MSG_EXIT_PROCESS           7
#endif
#ifndef JOB_OBJECT_MSG_ABNORMAL_EXIT_PROCESS
#define JOB_OBJECT_MSG_ABNORMAL_EXIT_PROCESS  8
#endif
#ifndef JOB_OBJECT_MSG_PROCESS_MEMORY_LIMIT
#define JOB_OBJECT_MSG_PROCESS_MEMORY_LIMIT   9
#endif
#ifndef JOB_OBJECT_MSG_JOB_MEMORY_LIMIT
#define JOB_OBJECT_MSG_JOB_MEMORY_LIMIT      10
#endif

#ifndef DELETE_MAX_PRIVILEGES
#define DELETE_MAX_PRIVILEGES 1
#endif

#ifndef TIMER_QUERY_STATE
#ifndef TIMER_QUERY_STATE
#define TIMER_QUERY_STATE       0x0001
#endif
#endif
#ifndef TIMER_MODIFY_STATE
#ifndef TIMER_MODIFY_STATE
#define TIMER_MODIFY_STATE      0x0002
#endif
#endif
#ifndef TIMER_ALL_ACCESS
#ifndef TIMER_ALL_ACCESS
#define TIMER_ALL_ACCESS (STANDARD_RIGHTS_REQUIRED|SYNCHRONIZE|TIMER_QUERY_STATE|TIMER_MODIFY_STATE)
#endif
#endif

#ifndef EVENT_QUERY_STATE
#ifndef EVENT_QUERY_STATE
#define EVENT_QUERY_STATE       0x0001
#endif
#endif
#ifndef EVENT_MODIFY_STATE
#ifndef EVENT_MODIFY_STATE
#define EVENT_MODIFY_STATE      0x0002
#endif
#endif
#ifndef EVENT_ALL_ACCESS
#ifndef EVENT_ALL_ACCESS
#define EVENT_ALL_ACCESS (STANDARD_RIGHTS_REQUIRED|SYNCHRONIZE|0x3)
#endif
#endif

#ifndef SEMAPHORE_QUERY_STATE
#define SEMAPHORE_QUERY_STATE       0x0001
#endif
#ifndef SEMAPHORE_MODIFY_STATE
#define SEMAPHORE_MODIFY_STATE      0x0002
#endif
#ifndef SEMAPHORE_ALL_ACCESS
#define SEMAPHORE_ALL_ACCESS (STANDARD_RIGHTS_REQUIRED|SYNCHRONIZE|0x3)
#endif

#ifndef MUTANT_QUERY_STATE
#define MUTANT_QUERY_STATE      0x0001
#endif
#ifndef MUTANT_ALL_ACCESS
#define MUTANT_ALL_ACCESS (STANDARD_RIGHTS_REQUIRED|SYNCHRONIZE|MUTANT_QUERY_STATE)
#endif

#ifndef IO_COMPLETION_QUERY_STATE
#define IO_COMPLETION_QUERY_STATE       0x0001
#endif
#ifndef IO_COMPLETION_MODIFY_STATE
#define IO_COMPLETION_MODIFY_STATE      0x0002
#endif
#ifndef IO_COMPLETION_ALL_ACCESS
#define IO_COMPLETION_ALL_ACCESS        (STANDARD_RIGHTS_REQUIRED|SYNCHRONIZE|0x3)
#endif

#define REG_MONITOR_SINGLE_KEY 0x00
#define REG_MONITOR_SECOND_KEY 0x01

#ifndef REG_QWORD
#define REG_QWORD                   11
#endif
#ifndef REG_QWORD_LITTLE_ENDIAN
#define REG_QWORD_LITTLE_ENDIAN     11
#endif

#define AUDIT_ALLOW_NO_PRIVILEGE 0x1

#define ACCESS_OBJECT_GUID       0
#define ACCESS_PROPERTY_SET_GUID 1
#define ACCESS_PROPERTY_GUID     2
#define ACCESS_MAX_LEVEL         4

#define ES_SYSTEM_REQUIRED  ((DWORD)0x00000001)
#define ES_DISPLAY_REQUIRED ((DWORD)0x00000002)
#define ES_USER_PRESENT     ((DWORD)0x00000004)
#define ES_CONTINUOUS       ((DWORD)0x80000000)

#define POWER_ACTION_QUERY_ALLOWED 0
#define POWER_ACTION_UI_ALLOWED    1
#define POWER_ACTION_OVERRIDE_APPS 2
#define POWER_ACTION_LOCK_CONSOLE  3
#define POWER_ACTION_DISABLE_WAKES 4
#define POWER_ACTION_CRITICAL      5
/**/

typedef CONST char *PCSZ;
#if __W32API_MAJOR_VERSION == 1
typedef STRING ANSI_STRING;
typedef PSTRING PANSI_STRING;
typedef STRING OEM_STRING;
typedef PSTRING POEM_STRING;
typedef void * POINTER_64 PVOID64;
#endif
typedef const UNICODE_STRING *PCUNICODE_STRING;
typedef ULONG KAFFINITY;
typedef KAFFINITY *PKAFFINITY;
typedef LONG KPRIORITY;
typedef ULONG EXECUTION_STATE;
typedef EXECUTION_STATE *PEXECUTION_STATE;

typedef struct _PEB *PPEB;

typedef struct _IO_STATUS_BLOCK {
  NTSTATUS Status;
  ULONG Information;
} IO_STATUS_BLOCK, *PIO_STATUS_BLOCK;

typedef
VOID
(NTAPI *PIO_APC_ROUTINE)(
  IN PVOID ApcContext,
  IN PIO_STATUS_BLOCK IoStatusBlock,
  IN ULONG Reserved
);

typedef
VOID
(NTAPI *PTIMER_APC_ROUTINE)(
  IN PVOID TimerContext,
  IN ULONG TimerLowValue,
  IN ULONG TimerHighValue
);

typedef struct _VM_COUNTERS {
  ULONG PeakVirtualSize;
  ULONG VirtualSize;
  ULONG PageFaultCount;
  ULONG PeakWorkingSetSize;
  ULONG WorkingSetSize;
  ULONG QuotaPeakPagedPoolUsage;
  ULONG QuotaPagedPoolUsage;
  ULONG QuotaPeakNonPagedPoolUsage;
  ULONG QuotaNonPagedPoolUsage;
  ULONG PagefileUsage;
  ULONG PeakPagefileUsage;
} VM_COUNTERS, *PVM_COUNTERS;

typedef struct _CLIENT_ID {
  HANDLE UniqueProcess;
  HANDLE UniqueThread;
} CLIENT_ID;

typedef CLIENT_ID *PCLIENT_ID;

typedef enum {
  StateInitialized,
  StateReady,
  StateRunning,
  StateStandby,
  StateTerminated,
  StateWait,
  StateTransition,
  StateUnknown
} THREAD_STATE;

typedef enum _KWAIT_REASON {
  Executive,
  FreePage,
  PageIn,
  PoolAllocation,
  DelayExecution,
  Suspended,
  UserRequest,
  WrExecutive,
  WrFreePage,
  WrPageIn,
  WrPoolAllocation,
  WrDelayExecution,
  WrSuspended,
  WrUserRequest,
  WrEventPair,
  WrQueue,
  WrLpcReceive,
  WrLpcReply,
  WrVirtualMemory,
  WrPageOut,
  WrRendezvous,
  Spare2,
  Spare3,
  Spare4,
  Spare5,
  Spare6,
  WrKernel
} KWAIT_REASON;

typedef enum _POOL_TYPE {
  NonPagedPool,
  PagedPool,
  NonPagedPoolMustSucceed,
  DontUseThisType,
  NonPagedPoolCacheAligned,
  PagedPoolCacheAligned,
  NonPagedPoolCacheAlignedMustS,
  MaxPoolType,
  NonPagedPoolSession = 32,
  PagedPoolSession = NonPagedPoolSession + 1,
  NonPagedPoolMustSucceedSession = PagedPoolSession + 1,
  DontUseThisTypeSession = NonPagedPoolMustSucceedSession + 1,
  NonPagedPoolCacheAlignedSession = DontUseThisTypeSession + 1,
  PagedPoolCacheAlignedSession = NonPagedPoolCacheAlignedSession + 1,
  NonPagedPoolCacheAlignedMustSSession = PagedPoolCacheAlignedSession + 1,
} POOL_TYPE;
/**/
#if __W32API_MAJOR_VERSION == 1
typedef union _FILE_SEGMENT_ELEMENT {
  PVOID64 Buffer;
  ULONGLONG Alignment;
} FILE_SEGMENT_ELEMENT, *PFILE_SEGMENT_ELEMENT;
#endif

typedef struct _FILE_FULL_EA_INFORMATION {
  ULONG NextEntryOffset;
  UCHAR Flags;
  UCHAR EaNameLength;
  USHORT EaValueLength;
  CHAR EaName[1];
} FILE_FULL_EA_INFORMATION, *PFILE_FULL_EA_INFORMATION;

typedef struct _FILE_GET_EA_INFORMATION {
  ULONG NextEntryOffset;
  UCHAR EaNameLength;
  CHAR EaName[1];
} FILE_GET_EA_INFORMATION, *PFILE_GET_EA_INFORMATION;

typedef enum _FSINFOCLASS {
  FileFsVolumeInformation       = 1,
  FileFsLabelInformation,      // 2
  FileFsSizeInformation,       // 3
  FileFsDeviceInformation,     // 4
  FileFsAttributeInformation,  // 5
  FileFsControlInformation,    // 6
  FileFsFullSizeInformation,   // 7
  FileFsObjectIdInformation,   // 8
  FileFsMaximumInformation
} FS_INFORMATION_CLASS, *PFS_INFORMATION_CLASS;

typedef struct _FILE_FS_VOLUME_INFORMATION {
  LARGE_INTEGER VolumeCreationTime;
  ULONG VolumeSerialNumber;
  ULONG VolumeLabelLength;
  UCHAR Unknown;
  WCHAR VolumeLabel[1];
} FILE_FS_VOLUME_INFORMATION, *PFILE_FS_VOLUME_INFORMATION;

typedef struct _FILE_FS_LABEL_INFORMATION {
  ULONG VolumeLabelLength;
  WCHAR VolumeLabel;
} FILE_FS_LABEL_INFORMATION, *PFILE_FS_LABEL_INFORMATION;

typedef struct _FILE_FS_SIZE_INFORMATION {
  LARGE_INTEGER TotalAllocationUnits;
  LARGE_INTEGER AvailableAllocationUnits;
  ULONG SectorsPerAllocationUnit;
  ULONG BytesPerSector;
} FILE_FS_SIZE_INFORMATION, *PFILE_FS_SIZE_INFORMATION;

typedef struct _FILE_FS_DEVICE_INFORMATION {
  DEVICE_TYPE DeviceType;
  ULONG Characteristics;
} FILE_FS_DEVICE_INFORMATION, *PFILE_FS_DEVICE_INFORMATION;

typedef struct _FILE_FS_ATTRIBUTE_INFORMATION {
  ULONG FileSystemFlags;
  ULONG MaximumComponentNameLength;
  ULONG FileSystemNameLength;
  WCHAR FileSystemName[1];
} FILE_FS_ATTRIBUTE_INFORMATION, *PFILE_FS_ATTRIBUTE_INFORMATION;

typedef struct _FILE_FS_CONTROL_INFORMATION {
  LARGE_INTEGER Reserved[3];
  LARGE_INTEGER DefaultQuotaThreshold;
  LARGE_INTEGER DefaultQuotaLimit;
  ULONG QuotaFlags;
} FILE_FS_CONTROL_INFORMATION, *PFILE_FS_CONTROL_INFORMATION;

typedef struct _FILE_FS_FULL_SIZE_INFORMATION {
  LARGE_INTEGER TotalQuotaAllocationUnits;
  LARGE_INTEGER AvailableQuotaAllocationUnits;
  LARGE_INTEGER AvailableAllocationUnits;
  ULONG SectorsPerAllocationUnit;
  ULONG BytesPerSector;
} FILE_FS_FULL_SIZE_INFORMATION, *PFILE_FS_FULL_SIZE_INFORMATION;

typedef struct _FILE_FS_OBJECT_ID_INFORMATION {
  UUID VolumeObjectId;
  ULONG VolumeObjectIdExtendedInfo[12];
} FILE_FS_OBJECT_ID_INFORMATION, *PFILE_FS_OBJECT_ID_INFORMATION;

typedef struct _FILE_USER_QUOTA_INFORMATION {
  ULONG NextEntryOffset;
  ULONG SidLength;
  LARGE_INTEGER ChangeTime;
  LARGE_INTEGER QuotaUsed;
  LARGE_INTEGER QuotaThreshold;
  LARGE_INTEGER QuotaLimit;
  SID Sid[1];
} FILE_USER_QUOTA_INFORMATION, *PFILE_USER_QUOTA_INFORMATION;

typedef struct _FILE_QUOTA_LIST_INFORMATION {
  ULONG NextEntryOffset;
  ULONG SidLength;
  SID Sid[1];
} FILE_QUOTA_LIST_INFORMATION, *PFILE_QUOTA_LIST_INFORMATION;

typedef enum _FILE_INFORMATION_CLASS {
  FileDirectoryInformation       = 1,
  FileFullDirectoryInformation, // 2
  FileBothDirectoryInformation, // 3
  FileBasicInformation,         // 4
  FileStandardInformation,      // 5
  FileInternalInformation,      // 6
  FileEaInformation,            // 7
  FileAccessInformation,        // 8
  FileNameInformation,          // 9
  FileRenameInformation,        // 10
  FileLinkInformation,          // 11
  FileNamesInformation,         // 12
  FileDispositionInformation,   // 13
  FilePositionInformation,      // 14
  FileFullEaInformation,        // 15
  FileModeInformation,          // 16
  FileAlignmentInformation,     // 17
  FileAllInformation,           // 18
  FileAllocationInformation,    // 19
  FileEndOfFileInformation,     // 20
  FileAlternateNameInformation, // 21
  FileStreamInformation,        // 22
  FilePipeInformation,          // 23
  FilePipeLocalInformation,     // 24
  FilePipeRemoteInformation,    // 25
  FileMailslotQueryInformation, // 26
  FileMailslotSetInformation,   // 27
  FileCompressionInformation,   // 28
  FileObjectIdInformation,      // 29
  FileCompletionInformation,    // 30
  FileMoveClusterInformation,   // 31
  FileQuotaInformation,         // 32
  FileReparsePointInformation,  // 33
  FileNetworkOpenInformation,   // 34
  FileAttributeTagInformation,  // 35
  FileTrackingInformation,      // 36
  FileMaximumInformation
} FILE_INFORMATION_CLASS, *PFILE_INFORMATION_CLASS;

typedef struct _FILE_DIRECTORY_INFORMATION { // Information Class 1
  ULONG NextEntryOffset;
  ULONG Unknown;
  LARGE_INTEGER CreationTime;
  LARGE_INTEGER LastAccessTime;
  LARGE_INTEGER LastWriteTime;
  LARGE_INTEGER ChangeTime;
  LARGE_INTEGER EndOfFile;
  LARGE_INTEGER AllocationSize;
  ULONG FileAttributes;
  ULONG FileNameLength;
  WCHAR FileName[1];
} FILE_DIRECTORY_INFORMATION, *PFILE_DIRECTORY_INFORMATION;

typedef struct _FILE_FULL_DIRECTORY_INFORMATION { // Information Class 2
  ULONG NextEntryOffset;
  ULONG Unknown;
  LARGE_INTEGER CreationTime;
  LARGE_INTEGER LastAccessTime;
  LARGE_INTEGER LastWriteTime;
  LARGE_INTEGER ChangeTime;
  LARGE_INTEGER EndOfFile;
  LARGE_INTEGER AllocationSize;
  ULONG FileAttributes;
  ULONG FileNameLength;
  ULONG EaInformationLength;
  WCHAR FileName[1];
} FILE_FULL_DIRECTORY_INFORMATION, *PFILE_FULL_DIRECTORY_INFORMATION;

typedef struct _FILE_BOTH_DIRECTORY_INFORMATION { // Information Class 3
  ULONG NextEntryOffset;
  ULONG Unknown;
  LARGE_INTEGER CreationTime;
  LARGE_INTEGER LastAccessTime;
  LARGE_INTEGER LastWriteTime;
  LARGE_INTEGER ChangeTime;
  LARGE_INTEGER EndOfFile;
  LARGE_INTEGER AllocationSize;
  ULONG FileAttributes;
  ULONG FileNameLength;
  ULONG EaInformationLength;
  UCHAR AlternateNameLength;
  WCHAR AlternateName[12];
  WCHAR FileName[1];
} FILE_BOTH_DIRECTORY_INFORMATION, *PFILE_BOTH_DIRECTORY_INFORMATION;

typedef struct _FILE_BASIC_INFORMATION { // Information Class 4
  LARGE_INTEGER CreationTime;
  LARGE_INTEGER LastAccessTime;
  LARGE_INTEGER LastWriteTime;
  LARGE_INTEGER ChangeTime;
  ULONG FileAttributes;
} FILE_BASIC_INFORMATION, *PFILE_BASIC_INFORMATION;

typedef struct _FILE_STANDARD_INFORMATION { // Information Class 5
  LARGE_INTEGER AllocationSize;
  LARGE_INTEGER EndOfFile;
  ULONG NumberOfLinks;
  BOOLEAN DeletePending;
  BOOLEAN Directory;
} FILE_STANDARD_INFORMATION, *PFILE_STANDARD_INFORMATION;

typedef struct _FILE_INTERNAL_INFORMATION { // Information Class 6
  LARGE_INTEGER FileId;
} FILE_INTERNAL_INFORMATION, *PFILE_INTERNAL_INFORMATION;

typedef struct _FILE_EA_INFORMATION { // Information Class 7
  ULONG EaInformationLength;
} FILE_EA_INFORMATION, *PFILE_EA_INFORMATION;

typedef struct _FILE_ACCESS_INFORMATION { // Information Class 8
  ACCESS_MASK GrantedAccess;
} FILE_ACCESS_INFORMATION, *PFILE_ACCESS_INFORMATION;

typedef struct _FILE_NAME_INFORMATION { // Information Classes 9 and 21
  ULONG FileNameLength;
  WCHAR FileName[1];
} FILE_NAME_INFORMATION, *PFILE_NAME_INFORMATION;

typedef struct _FILE_LINK_RENAME_INFORMATION { // Info Classes 10 and 11
  BOOLEAN ReplaceIfExists;
  HANDLE RootDirectory;
  ULONG FileNameLength;
  WCHAR FileName[1];
} FILE_LINK_INFORMATION, *PFILE_LINK_INFORMATION;

typedef struct _FILE_NAMES_INFORMATION { // Information Class 12
  ULONG NextEntryOffset;
  ULONG Unknown;
  ULONG FileNameLength;
  WCHAR FileName[1];
} FILE_NAMES_INFORMATION, *PFILE_NAMES_INFORMATION;

typedef struct _FILE_DISPOSITION_INFORMATION { // Information Class 13
  BOOLEAN DeleteFile;
} FILE_DISPOSITION_INFORMATION, *PFILE_DISPOSITION_INFORMATION;

typedef struct _FILE_POSITION_INFORMATION { // Information Class 14
  LARGE_INTEGER CurrentByteOffset;
} FILE_POSITION_INFORMATION, *PFILE_POSITION_INFORMATION;

typedef struct _FILE_MODE_INFORMATION { // Information Class 16
  ULONG Mode;
} FILE_MODE_INFORMATION, *PFILE_MODE_INFORMATION;

typedef struct _FILE_ALIGNMENT_INFORMATION { // Information Class 17
  ULONG AlignmentRequirement;
} FILE_ALIGNMENT_INFORMATION, *PFILE_ALIGNMENT_INFORMATION;

typedef struct _FILE_ALL_INFORMATION { // Information Class 18
  FILE_BASIC_INFORMATION BasicInformation;
  FILE_STANDARD_INFORMATION StandardInformation;
  FILE_INTERNAL_INFORMATION InternalInformation;
  FILE_EA_INFORMATION EaInformation;
  FILE_ACCESS_INFORMATION AccessInformation;
  FILE_POSITION_INFORMATION PositionInformation;
  FILE_MODE_INFORMATION ModeInformation;
  FILE_ALIGNMENT_INFORMATION AlignmentInformation;
  FILE_NAME_INFORMATION NameInformation;
} FILE_ALL_INFORMATION, *PFILE_ALL_INFORMATION;

typedef struct _FILE_ALLOCATION_INFORMATION { // Information Class 19
  LARGE_INTEGER AllocationSize;
} FILE_ALLOCATION_INFORMATION, *PFILE_ALLOCATION_INFORMATION;

typedef struct _FILE_END_OF_FILE_INFORMATION { // Information Class 20
  LARGE_INTEGER EndOfFile;
} FILE_END_OF_FILE_INFORMATION, *PFILE_END_OF_FILE_INFORMATION;

typedef struct _FILE_STREAM_INFORMATION { // Information Class 22
  ULONG NextEntryOffset;
  ULONG StreamNameLength;
  LARGE_INTEGER EndOfStream;
  LARGE_INTEGER AllocationSize;
  WCHAR StreamName[1];
} FILE_STREAM_INFORMATION, *PFILE_STREAM_INFORMATION;

typedef struct _FILE_PIPE_INFORMATION { // Information Class 23
  ULONG ReadModeMessage;
  ULONG WaitModeBlocking;
} FILE_PIPE_INFORMATION, *PFILE_PIPE_INFORMATION;

typedef struct _FILE_PIPE_LOCAL_INFORMATION { // Information Class 24
  ULONG MessageType;
  ULONG Unknown1;
  ULONG MaxInstances;
  ULONG CurInstances;
  ULONG InBufferSize;
  ULONG Unknown2;
  ULONG OutBufferSize;
  ULONG Unknown3[2];
  ULONG ServerEnd;
} FILE_PIPE_LOCAL_INFORMATION, *PFILE_PIPE_LOCAL_INFORMATION;

typedef struct _FILE_PIPE_REMOTE_INFORMATION { // Information Class 25
  LARGE_INTEGER CollectDataTimeout;
  ULONG MaxCollectionCount;
} FILE_PIPE_REMOTE_INFORMATION, *PFILE_PIPE_REMOTE_INFORMATION;

typedef struct _FILE_MAILSLOT_QUERY_INFORMATION { // Information Class 26
  ULONG MaxMessageSize;
  ULONG Unknown;
  ULONG NextSize;
  ULONG MessageCount;
  LARGE_INTEGER ReadTimeout;
} FILE_MAILSLOT_QUERY_INFORMATION, *PFILE_MAILSLOT_QUERY_INFORMATION;

typedef struct _FILE_MAILSLOT_SET_INFORMATION { // Information Class 27
  LARGE_INTEGER ReadTimeout;
} FILE_MAILSLOT_SET_INFORMATION, *PFILE_MAILSLOT_SET_INFORMATION;

typedef struct _FILE_COMPRESSION_INFORMATION { // Information Class 28
  LARGE_INTEGER CompressedSize;
  USHORT CompressionFormat;
  UCHAR CompressionUnitShift;
  UCHAR Unknown;
  UCHAR ClusterSizeShift;
} FILE_COMPRESSION_INFORMATION, *PFILE_COMPRESSION_INFORMATION;

typedef struct _FILE_COMPLETION_INFORMATION { // Information Class 30
  HANDLE IoCompletionHandle;
  ULONG CompletionKey;
} FILE_COMPLETION_INFORMATION, *PFILE_COMPLETION_INFORMATION;

typedef struct _FILE_NETWORK_OPEN_INFORMATION { // Information Class 34
  LARGE_INTEGER CreationTime;
  LARGE_INTEGER LastAccessTime;
  LARGE_INTEGER LastWriteTime;
  LARGE_INTEGER ChangeTime;
  LARGE_INTEGER AllocationSize;
  LARGE_INTEGER EndOfFile;
  ULONG FileAttributes;
} FILE_NETWORK_OPEN_INFORMATION, *PFILE_NETWORK_OPEN_INFORMATION;

typedef struct _FILE_ATTRIBUTE_TAG_INFORMATION {// Information Class 35
  ULONG FileAttributes;
  ULONG ReparseTag;
} FILE_ATTRIBUTE_TAG_INFORMATION, *PFILE_ATTRIBUTE_TAG_INFORMATION;

typedef enum _SYSTEM_INFORMATION_CLASS {
  SystemBasicInformation,               // 0  Y N
  SystemProcessorInformation,           // 1  Y N
  SystemPerformanceInformation,         // 2  Y N
  SystemTimeOfDayInformation,           // 3  Y N
  SystemNotImplemented1,                // 4  Y N
  SystemProcessesAndThreadsInformation, // 5  Y N
  SystemCallCounts,                     // 6  Y N
  SystemConfigurationInformation,       // 7  Y N
  SystemProcessorTimes,                 // 8  Y N
  SystemGlobalFlag,                     // 9  Y Y
  SystemNotImplemented2,                // 10 Y N
  SystemModuleInformation,              // 11 Y N
  SystemLockInformation,                // 12 Y N
  SystemNotImplemented3,                // 13 Y N
  SystemNotImplemented4,                // 14 Y N
  SystemNotImplemented5,                // 15 Y N
  SystemHandleInformation,              // 16 Y N
  SystemObjectInformation,              // 17 Y N
  SystemPagefileInformation,            // 18 Y N
  SystemInstructionEmulationCounts,     // 19 Y N
  SystemInvalidInfoClass1,              // 20
  SystemCacheInformation,               // 21 Y Y
  SystemPoolTagInformation,             // 22 Y N
  SystemProcessorStatistics,            // 23 Y N
  SystemDpcInformation,                 // 24 Y Y
  SystemNotImplemented6,                // 25 Y N
  SystemLoadImage,                      // 26 N Y
  SystemUnloadImage,                    // 27 N Y
  SystemTimeAdjustment,                 // 28 Y Y
  SystemNotImplemented7,                // 29 Y N
  SystemNotImplemented8,                // 30 Y N
  SystemNotImplemented9,                // 31 Y N
  SystemCrashDumpInformation,           // 32 Y N
  SystemExceptionInformation,           // 33 Y N
  SystemCrashDumpStateInformation,      // 34 Y Y/N
  SystemKernelDebuggerInformation,      // 35 Y N
  SystemContextSwitchInformation,       // 36 Y N
  SystemRegistryQuotaInformation,       // 37 Y Y
  SystemLoadAndCallImage,               // 38 N Y
  SystemPrioritySeparation,             // 39 N Y
  SystemNotImplemented10,               // 40 Y N
  SystemNotImplemented11,               // 41 Y N
  SystemInvalidInfoClass2,              // 42
  SystemInvalidInfoClass3,              // 43
  SystemTimeZoneInformation,            // 44 Y N
  SystemLookasideInformation,           // 45 Y N
  SystemSetTimeSlipEvent,               // 46 N Y
  SystemCreateSession,                  // 47 N Y
  SystemDeleteSession,                  // 48 N Y
  SystemInvalidInfoClass4,              // 49
  SystemRangeStartInformation,          // 50 Y N
  SystemVerifierInformation,            // 51 Y Y
  SystemAddVerifier,                    // 52 N Y
  SystemSessionProcessesInformation     // 53 Y N
} SYSTEM_INFORMATION_CLASS;

typedef struct _SYSTEM_BASIC_INFORMATION { // Information Class 0
  ULONG Unknown;
  ULONG MaximumIncrement;
  ULONG PhysicalPageSize;
  ULONG NumberOfPhysicalPages;
  ULONG LowestPhysicalPage;
  ULONG HighestPhysicalPage;
  ULONG AllocationGranularity;
  ULONG LowestUserAddress;
  ULONG HighestUserAddress;
  ULONG ActiveProcessors;
  UCHAR NumberProcessors;
} SYSTEM_BASIC_INFORMATION, *PSYSTEM_BASIC_INFORMATION;

typedef struct _SYSTEM_PROCESSOR_INFORMATION { // Information Class 1
  USHORT ProcessorArchitecture;
  USHORT ProcessorLevel;
  USHORT ProcessorRevision;
  USHORT Unknown;
  ULONG FeatureBits;
} SYSTEM_PROCESSOR_INFORMATION, *PSYSTEM_PROCESSOR_INFORMATION;

typedef struct _SYSTEM_PERFORMANCE_INFORMATION { // Information Class 2
  LARGE_INTEGER IdleTime;
  LARGE_INTEGER ReadTransferCount;
  LARGE_INTEGER WriteTransferCount;
  LARGE_INTEGER OtherTransferCount;
  ULONG ReadOperationCount;
  ULONG WriteOperationCount;
  ULONG OtherOperationCount;
  ULONG AvailablePages;
  ULONG TotalCommittedPages;
  ULONG TotalCommitLimit;
  ULONG PeakCommitment;
  ULONG PageFaults;
  ULONG WriteCopyFaults;
  ULONG TransitionFaults;
  ULONG Reserved1;
  ULONG DemandZeroFaults;
  ULONG PagesRead;
  ULONG PageReadIos;
  ULONG Reserved2[2];
  ULONG PagefilePagesWritten;
  ULONG PagefilePageWriteIos;
  ULONG MappedFilePagesWritten;
  ULONG MappedFilePageWriteIos;
  ULONG PagedPoolUsage;
  ULONG NonPagedPoolUsage;
  ULONG PagedPoolAllocs;
  ULONG PagedPoolFrees;
  ULONG NonPagedPoolAllocs;
  ULONG NonPagedPoolFrees;
  ULONG TotalFreeSystemPtes;
  ULONG SystemCodePage;
  ULONG TotalSystemDriverPages;
  ULONG TotalSystemCodePages;
  ULONG SmallNonPagedLookasideListAllocateHits;
  ULONG SmallPagedLookasideListAllocateHits;
  ULONG Reserved3;
  ULONG MmSystemCachePage;
  ULONG PagedPoolPage;
  ULONG SystemDriverPage;
  ULONG FastReadNoWait;
  ULONG FastReadWait;
  ULONG FastReadResourceMiss;
  ULONG FastReadNotPossible;
  ULONG FastMdlReadNoWait;
  ULONG FastMdlReadWait;
  ULONG FastMdlReadResourceMiss;
  ULONG FastMdlReadNotPossible;
  ULONG MapDataNoWait;
  ULONG MapDataWait;
  ULONG MapDataNoWaitMiss;
  ULONG MapDataWaitMiss;
  ULONG PinMappedDataCount;
  ULONG PinReadNoWait;
  ULONG PinReadWait;
  ULONG PinReadNoWaitMiss;
  ULONG PinReadWaitMiss;
  ULONG CopyReadNoWait;
  ULONG CopyReadWait;
  ULONG CopyReadNoWaitMiss;
  ULONG CopyReadWaitMiss;
  ULONG MdlReadNoWait;
  ULONG MdlReadWait;
  ULONG MdlReadNoWaitMiss;
  ULONG MdlReadWaitMiss;
  ULONG ReadAheadIos;
  ULONG LazyWriteIos;
  ULONG LazyWritePages;
  ULONG DataFlushes;
  ULONG DataPages;
  ULONG ContextSwitches;
  ULONG FirstLevelTbFills;
  ULONG SecondLevelTbFills;
  ULONG SystemCalls;
} SYSTEM_PERFORMANCE_INFORMATION, *PSYSTEM_PERFORMANCE_INFORMATION;

typedef struct _SYSTEM_TIME_OF_DAY_INFORMATION { // Information Class 3
  LARGE_INTEGER BootTime;
  LARGE_INTEGER CurrentTime;
  LARGE_INTEGER TimeZoneBias;
  ULONG CurrentTimeZoneId;
} SYSTEM_TIME_OF_DAY_INFORMATION, *PSYSTEM_TIME_OF_DAY_INFORMATION;

typedef struct _SYSTEM_THREADS {
  LARGE_INTEGER KernelTime;
  LARGE_INTEGER UserTime;
  LARGE_INTEGER CreateTime;
  ULONG WaitTime;
  PVOID StartAddress;
  CLIENT_ID ClientId;
  KPRIORITY Priority;
  KPRIORITY BasePriority;
  ULONG ContextSwitchCount;
  THREAD_STATE State;
  KWAIT_REASON WaitReason;
} SYSTEM_THREADS, *PSYSTEM_THREADS;

typedef struct _SYSTEM_PROCESSES { // Information Class 5
  ULONG NextEntryDelta;
  ULONG ThreadCount;
  ULONG Reserved1[6];
  LARGE_INTEGER CreateTime;
  LARGE_INTEGER UserTime;
  LARGE_INTEGER KernelTime;
  UNICODE_STRING ProcessName;
  KPRIORITY BasePriority;
  ULONG ProcessId;
  ULONG InheritedFromProcessId;
  ULONG HandleCount;
  ULONG Reserved2[2];
  VM_COUNTERS VmCounters;
  IO_COUNTERS IoCounters; // Windows 2000 only
  SYSTEM_THREADS Threads[1];
} SYSTEM_PROCESSES, *PSYSTEM_PROCESSES;

typedef struct _SYSTEM_CALLS_INFORMATION { // Information Class 6
  ULONG Size;
  ULONG NumberOfDescriptorTables;
  ULONG NumberOfRoutinesInTable[1];
//  ULONG CallCounts[];
} SYSTEM_CALLS_INFORMATION, *PSYSTEM_CALLS_INFORMATION;

typedef struct _SYSTEM_CONFIGURATION_INFORMATION { // Information Class 7
  ULONG DiskCount;
  ULONG FloppyCount;
  ULONG CdRomCount;
  ULONG TapeCount;
  ULONG SerialCount;
  ULONG ParallelCount;
} SYSTEM_CONFIGURATION_INFORMATION, *PSYSTEM_CONFIGURATION_INFORMATION;

typedef struct _SYSTEM_PROCESSOR_TIMES { // Information Class 8
  LARGE_INTEGER IdleTime;
  LARGE_INTEGER KernelTime;
  LARGE_INTEGER UserTime;
  LARGE_INTEGER DpcTime;
  LARGE_INTEGER InterruptTime;
  ULONG InterruptCount;
} SYSTEM_PROCESSOR_TIMES, *PSYSTEM_PROCESSOR_TIMES;

typedef struct _SYSTEM_GLOBAL_FLAG { // Information Class 9
  ULONG GlobalFlag;
} SYSTEM_GLOBAL_FLAG, *PSYSTEM_GLOBAL_FLAG;

typedef struct _SYSTEM_MODULE_INFORMATION { // Information Class 11
  ULONG Reserved[2];
  PVOID Base;
  ULONG Size;
  ULONG Flags;
  USHORT Index;
  USHORT Unknown;
  USHORT LoadCount;
  USHORT ModuleNameOffset;
  CHAR ImageName[256];
} SYSTEM_MODULE_INFORMATION, *PSYSTEM_MODULE_INFORMATION;

typedef struct _SYSTEM_LOCK_INFORMATION { // Information Class 12
  PVOID Address;
  USHORT Type;
  USHORT Reserved1;
  ULONG ExclusiveOwnerThreadId;
  ULONG ActiveCount;
  ULONG ContentionCount;
  ULONG Reserved2[2];
  ULONG NumberOfSharedWaiters;
  ULONG NumberOfExclusiveWaiters;
} SYSTEM_LOCK_INFORMATION, *PSYSTEM_LOCK_INFORMATION;

typedef struct _SYSTEM_HANDLE_INFORMATION { // Information Class 16
  ULONG ProcessId;
  UCHAR ObjectTypeNumber;
  UCHAR Flags; // 0x01 = PROTECT_FROM_CLOSE, 0x02 = INHERIT
  USHORT Handle;
  PVOID Object;
  ACCESS_MASK GrantedAccess;
} SYSTEM_HANDLE_INFORMATION, *PSYSTEM_HANDLE_INFORMATION;

typedef struct _SYSTEM_OBJECT_TYPE_INFORMATION { // Information Class 17
  ULONG NextEntryOffset;
  ULONG ObjectCount;
  ULONG HandleCount;
  ULONG TypeNumber;
  ULONG InvalidAttributes;
  GENERIC_MAPPING GenericMapping;
  ACCESS_MASK ValidAccessMask;
  POOL_TYPE PoolType;
  UCHAR Unknown;
  UNICODE_STRING Name;
} SYSTEM_OBJECT_TYPE_INFORMATION, *PSYSTEM_OBJECT_TYPE_INFORMATION;

typedef struct _SYSTEM_OBJECT_INFORMATION {
  ULONG NextEntryOffset;
  PVOID Object;
  ULONG CreatorProcessId;
  USHORT Unknown;
  USHORT Flags;
  ULONG PointerCount;
  ULONG HandleCount;
  ULONG PagedPoolUsage;
  ULONG NonPagedPoolUsage;
  ULONG ExclusiveProcessId;
  PSECURITY_DESCRIPTOR SecurityDescriptor;
  UNICODE_STRING Name;
} SYSTEM_OBJECT_INFORMATION, *PSYSTEM_OBJECT_INFORMATION;

typedef struct _SYSTEM_PAGEFILE_INFORMATION { // Information Class 18
  ULONG NextEntryOffset;
  ULONG CurrentSize;
  ULONG TotalUsed;
  ULONG PeakUsed;
  UNICODE_STRING FileName;
} SYSTEM_PAGEFILE_INFORMATION, *PSYSTEM_PAGEFILE_INFORMATION;

typedef struct _SYSTEM_INSTRUCTION_EMULATION_INFORMATION { // Info Class 19
  ULONG SegmentNotPresent;
  ULONG TwoByteOpcode;
  ULONG ESprefix;
  ULONG CSprefix;
  ULONG SSprefix;
  ULONG DSprefix;
  ULONG FSPrefix;
  ULONG GSprefix;
  ULONG OPER32prefix;
  ULONG ADDR32prefix;
  ULONG INSB;
  ULONG INSW;
  ULONG OUTSB;
  ULONG OUTSW;
  ULONG PUSHFD;
  ULONG POPFD;
  ULONG INTnn;
  ULONG INTO;
  ULONG IRETD;
  ULONG INBimm;
  ULONG INWimm;
  ULONG OUTBimm;
  ULONG OUTWimm;
  ULONG INB;
  ULONG INW;
  ULONG OUTB;
  ULONG OUTW;
  ULONG LOCKprefix;
  ULONG REPNEprefix;
  ULONG REPprefix;
  ULONG HLT;
  ULONG CLI;
  ULONG STI;
  ULONG GenericInvalidOpcode;
} SYSTEM_INSTRUCTION_EMULATION_INFORMATION, *PSYSTEM_INSTRUCTION_EMULATION_INFORMATION;

typedef struct _SYSTEM_CACHE_INFORMATION { // Information Class 21
  ULONG SystemCacheWsSize;
  ULONG SystemCacheWsPeakSize;
  ULONG SystemCacheWsFaults;
  ULONG SystemCacheWsMinimum;
  ULONG SystemCacheWsMaximum;
  ULONG TransitionSharedPages;
  ULONG TransitionSharedPagesPeak;
  ULONG Reserved[2];
} SYSTEM_CACHE_INFORMATION, *PSYSTEM_CACHE_INFORMATION;

typedef struct _SYSTEM_POOL_TAG_INFORMATION { // Information Class 22
  CHAR Tag[4];
  ULONG PagedPoolAllocs;
  ULONG PagedPoolFrees;
  ULONG PagedPoolUsage;
  ULONG NonPagedPoolAllocs;
  ULONG NonPagedPoolFrees;
  ULONG NonPagedPoolUsage;
} SYSTEM_POOL_TAG_INFORMATION, *PSYSTEM_POOL_TAG_INFORMATION;

typedef struct _SYSTEM_PROCESSOR_STATISTICS { // Information Class 23
  ULONG ContextSwitches;
  ULONG DpcCount;
  ULONG DpcRequestRate;
  ULONG TimeIncrement;
  ULONG DpcBypassCount;
  ULONG ApcBypassCount;
} SYSTEM_PROCESSOR_STATISTICS, *PSYSTEM_PROCESSOR_STATISTICS;

typedef struct _SYSTEM_DPC_INFORMATION { // Information Class 24
  ULONG Reserved;
  ULONG MaximumDpcQueueDepth;
  ULONG MinimumDpcRate;
  ULONG AdjustDpcThreshold;
  ULONG IdealDpcRate;
} SYSTEM_DPC_INFORMATION, *PSYSTEM_DPC_INFORMATION;

typedef struct _SYSTEM_LOAD_IMAGE { // Information Class 26
  UNICODE_STRING ModuleName;
  PVOID ModuleBase;
  PVOID Unknown;
  PVOID EntryPoint;
  PVOID ExportDirectory;
} SYSTEM_LOAD_IMAGE, *PSYSTEM_LOAD_IMAGE;

typedef struct _SYSTEM_UNLOAD_IMAGE { // Information Class 27
  PVOID ModuleBase;
} SYSTEM_UNLOAD_IMAGE, *PSYSTEM_UNLOAD_IMAGE;

typedef struct _SYSTEM_QUERY_TIME_ADJUSTMENT { // Information Class 28
  ULONG TimeAdjustment;
  ULONG MaximumIncrement;
  BOOLEAN TimeSynchronization;
} SYSTEM_QUERY_TIME_ADJUSTMENT, *PSYSTEM_QUERY_TIME_ADJUSTMENT;

typedef struct _SYSTEM_SET_TIME_ADJUSTMENT { // Information Class 28
  ULONG TimeAdjustment;
  BOOLEAN TimeSynchronization;
} SYSTEM_SET_TIME_ADJUSTMENT, *PSYSTEM_SET_TIME_ADJUSTMENT;

typedef struct _SYSTEM_CRASH_DUMP_INFORMATION { // Information Class 32
  HANDLE CrashDumpSectionHandle;
  HANDLE Unknown; // Windows 2000 only
} SYSTEM_CRASH_DUMP_INFORMATION, *PSYSTEM_CRASH_DUMP_INFORMATION;

typedef struct _SYSTEM_EXCEPTION_INFORMATION { // Information Class 33
  ULONG AlignmentFixupCount;
  ULONG ExceptionDispatchCount;
  ULONG FloatingEmulationCount;
  ULONG Reserved;
} SYSTEM_EXCEPTION_INFORMATION, *PSYSTEM_EXCEPTION_INFORMATION;

typedef struct _SYSTEM_CRASH_DUMP_STATE_INFORMATION { // Information Class 34
  ULONG CrashDumpSectionExists;
  ULONG Unknown; // Windows 2000 only
} SYSTEM_CRASH_DUMP_STATE_INFORMATION, *PSYSTEM_CRASH_DUMP_STATE_INFORMATION;

typedef struct _SYSTEM_KERNEL_DEBUGGER_INFORMATION { // Information Class 35
  BOOLEAN DebuggerEnabled;
  BOOLEAN DebuggerNotPresent;
} SYSTEM_KERNEL_DEBUGGER_INFORMATION, *PSYSTEM_KERNEL_DEBUGGER_INFORMATION;

typedef struct _SYSTEM_CONTEXT_SWITCH_INFORMATION { // Information Class 36
  ULONG ContextSwitches;
  ULONG ContextSwitchCounters[11];
} SYSTEM_CONTEXT_SWITCH_INFORMATION, *PSYSTEM_CONTEXT_SWITCH_INFORMATION;

typedef struct _SYSTEM_REGISTRY_QUOTA_INFORMATION { // Information Class 37
  ULONG RegistryQuota;
  ULONG RegistryQuotaInUse;
  ULONG PagedPoolSize;
} SYSTEM_REGISTRY_QUOTA_INFORMATION, *PSYSTEM_REGISTRY_QUOTA_INFORMATION;

typedef struct _SYSTEM_LOAD_AND_CALL_IMAGE { // Information Class 38
  UNICODE_STRING ModuleName;
} SYSTEM_LOAD_AND_CALL_IMAGE, *PSYSTEM_LOAD_AND_CALL_IMAGE;

typedef struct _SYSTEM_PRIORITY_SEPARATION { // Information Class 39
  ULONG PrioritySeparation;
} SYSTEM_PRIORITY_SEPARATION, *PSYSTEM_PRIORITY_SEPARATION;

typedef struct _SYSTEM_TIME_ZONE_INFORMATION { // Information Class 44
  LONG Bias;
  WCHAR StandardName[32];
  SYSTEMTIME StandardDate;
  LONG StandardBias;
  WCHAR DaylightName[32];
  SYSTEMTIME DaylightDate;
  LONG DaylightBias;
} SYSTEM_TIME_ZONE_INFORMATION, *PSYSTEM_TIME_ZONE_INFORMATION;

typedef struct _SYSTEM_LOOKASIDE_INFORMATION { // Information Class 45
  USHORT Depth;
  USHORT MaximumDepth;
  ULONG TotalAllocates;
  ULONG AllocateMisses;
  ULONG TotalFrees;
  ULONG FreeMisses;
  POOL_TYPE Type;
  ULONG Tag;
  ULONG Size;
} SYSTEM_LOOKASIDE_INFORMATION, *PSYSTEM_LOOKASIDE_INFORMATION;

typedef struct _SYSTEM_SET_TIME_SLIP_EVENT { // Information Class 46
  HANDLE TimeSlipEvent;
} SYSTEM_SET_TIME_SLIP_EVENT, *PSYSTEM_SET_TIME_SLIP_EVENT;

typedef struct _SYSTEM_CREATE_SESSION { // Information Class 47
  ULONG SessionId;
} SYSTEM_CREATE_SESSION, *PSYSTEM_CREATE_SESSION;

typedef struct _SYSTEM_DELETE_SESSION { // Information Class 48
  ULONG SessionId;
} SYSTEM_DELETE_SESSION, *PSYSTEM_DELETE_SESSION;

typedef struct _SYSTEM_RANGE_START_INFORMATION { // Information Class 50
  PVOID SystemRangeStart;
} SYSTEM_RANGE_START_INFORMATION, *PSYSTEM_RANGE_START_INFORMATION;

typedef struct _SYSTEM_SESSION_PROCESSES_INFORMATION { // Information Class 53
  ULONG SessionId;
  ULONG BufferSize;
  PVOID Buffer;
} SYSTEM_SESSION_PROCESSES_INFORMATION, *PSYSTEM_SESSION_PROCESSES_INFORMATION;

typedef struct _SYSTEM_POOL_BLOCK {
  BOOLEAN Allocated;
  USHORT Unknown;
  ULONG Size;
  CHAR Tag[4];
} SYSTEM_POOL_BLOCK, *PSYSTEM_POOL_BLOCK;

typedef struct _SYSTEM_POOL_BLOCKS_INFORMATION { // Info Classes 14 and 15
  ULONG PoolSize;
  PVOID PoolBase;
  USHORT Unknown;
  ULONG NumberOfBlocks;
  SYSTEM_POOL_BLOCK PoolBlocks[1];
} SYSTEM_POOL_BLOCKS_INFORMATION, *PSYSTEM_POOL_BLOCKS_INFORMATION;

typedef struct _SYSTEM_MEMORY_USAGE {
  PVOID Name;
  USHORT Valid;
  USHORT Standby;
  USHORT Modified;
  USHORT PageTables;
} SYSTEM_MEMORY_USAGE, *PSYSTEM_MEMORY_USAGE;

typedef struct _SYSTEM_MEMORY_USAGE_INFORMATION { // Info Classes 25 and 29
  ULONG Reserved;
  PVOID EndOfData;
  SYSTEM_MEMORY_USAGE MemoryUsage[1];
} SYSTEM_MEMORY_USAGE_INFORMATION, *PSYSTEM_MEMORY_USAGE_INFORMATION;

typedef enum _SHUTDOWN_ACTION {
  ShutdownNoReboot,
  ShutdownReboot,
  ShutdownPowerOff
} SHUTDOWN_ACTION;

typedef enum _DEBUG_CONTROL_CODE {
  DebugGetTraceInformation=1,
  DebugSetInternalBreakpoint,
  DebugSetSpecialCall,
  DebugClearSpecialCalls,
  DebugQuerySpecialCalls,
  DebugDbgBreakPoint
} DEBUG_CONTROL_CODE;

typedef struct _DBGKD_GET_INTERNAL_BREAKPOINT { // DebugGetTraceInformation
  DWORD_PTR BreakpointAddress;
  DWORD Flags;
  DWORD Calls;
  DWORD MaxCallsPerPeriod;
  DWORD MinInstructions;
  DWORD MaxInstructions;
  DWORD TotalInstructions;
} DBGKD_GET_INTERNAL_BREAKPOINT, *PDBGKD_GET_INTERNAL_BREAKPOINT;

typedef struct _DBGKD_READ_MEMORY {
  ULONG TargetBaseAddress;
  ULONG TransferCount;
  ULONG ActualBytesRead;
} DBGKD_READ_MEMORY, *PDBGKD_READ_MEMORY;

typedef struct _DBGKD_WRITE_MEMORY {
  ULONG TargetBaseAddress;
  ULONG TransferCount;
  ULONG ActualBytesWritten;
} DBGKD_WRITE_MEMORY, *PDBGKD_WRITE_MEMORY;

typedef struct _DBGKD_READ_MEMORY64 {
  ULONG64 TargetBaseAddress;
  ULONG TransferCount;
  ULONG ActualBytesRead;
} DBGKD_READ_MEMORY64, *PDBGKD_READ_MEMORY64;

typedef struct _DBGKD_WRITE_MEMORY64 {
  ULONG64 TargetBaseAddress;
  ULONG TransferCount;
  ULONG ActualBytesWritten;
} DBGKD_WRITE_MEMORY64, *PDBGKD_WRITE_MEMORY64;

typedef struct _DBGKD_GET_CONTEXT {
  ULONG Unused;
} DBGKD_GET_CONTEXT, *PDBGKD_GET_CONTEXT;

typedef struct _DBGKD_SET_CONTEXT {
  ULONG ContextFlags;
} DBGKD_SET_CONTEXT, *PDBGKD_SET_CONTEXT;

typedef struct _DBGKD_WRITE_BREAKPOINT {
  ULONG BreakPointAddress;
  ULONG BreakPointHandle;
} DBGKD_WRITE_BREAKPOINT, *PDBGKD_WRITE_BREAKPOINT;

typedef struct _DBGKD_RESTORE_BREAKPOINT {
  ULONG BreakPointHandle;
} DBGKD_RESTORE_BREAKPOINT, *PDBGKD_RESTORE_BREAKPOINT;

typedef struct _DBGKD_CONTROL_SET {
  ULONG   TraceFlag;
  ULONG   Dr7;
  ULONG   CurrentSymbolStart;
  ULONG   CurrentSymbolEnd;
} DBGKD_CONTROL_SET, *PDBGKD_CONTROL_SET;

typedef struct _DBGKD_CONTINUE {
  NTSTATUS ContinueStatus;
} DBGKD_CONTINUE, *PDBGKD_CONTINUE;

typedef struct _DBGKD_CONTINUE2 {
  NTSTATUS ContinueStatus;
  DBGKD_CONTROL_SET ControlSet;
} DBGKD_CONTINUE2, *PDBGKD_CONTINUE2;

typedef struct _DBGKD_READ_WRITE_IO {
  ULONG DataSize;
  ULONG IoAddress;
  ULONG DataValue;
} DBGKD_READ_WRITE_IO, *PDBGKD_READ_WRITE_IO;

typedef struct _DBGKD_READ_WRITE_IO_EXTENDED {
  ULONG DataSize;
  ULONG InterfaceType;
  ULONG BusNumber;
  ULONG AddressSpace;
  ULONG IoAddress;
  ULONG DataValue;
} DBGKD_READ_WRITE_IO_EXTENDED, *PDBGKD_READ_WRITE_IO_EXTENDED;

typedef struct _DBGKD_GET_VERSION {
  USHORT  MajorVersion;
  USHORT  MinorVersion;
  USHORT  ProtocolVersion;
  USHORT  Flags;
  ULONG   KernBase;
  ULONG   PsLoadedModuleList;
  USHORT  MachineType;
  USHORT  ThCallbackStack;
  USHORT  NextCallback;
  USHORT  FramePointer;
  ULONG   KiCallUserMode;
  ULONG   KeUserCallbackDispatcher;
  ULONG   BreakpointWithStatus;
  ULONG   DebuggerDataList;
} DBGKD_GET_VERSION, *PDBGKD_GET_VERSION;

typedef struct _DBGKD_BREAKPOINTEX {
  ULONG     BreakPointCount;
  NTSTATUS  ContinueStatus;
} DBGKD_BREAKPOINTEX, *PDBGKD_BREAKPOINTEX;

typedef struct _DBGKD_SET_INTERNAL_BREAKPOINT { // DebugSetInternalBreakpoint
  DWORD_PTR BreakpointAddress;
  DWORD Flags;
} DBGKD_SET_INTERNAL_BREAKPOINT, *PDBGKD_SET_INTERNAL_BREAKPOINT;

typedef struct _DBGKD_PAGEIN {
  DWORD_PTR   Address;
  DWORD   ContinueStatus;
} DBGKD_PAGEIN, *PDBGKD_PAGEIN;

typedef struct _DBGKD_READ_WRITE_MSR {
  ULONG Msr;
  ULONG DataValueLow;
  ULONG DataValueHigh;
} DBGKD_READ_WRITE_MSR, *PDBGKD_READ_WRITE_MSR;

typedef struct _DBGKD_SET_SPECIAL_CALL { // DebugSetSpecialCall
  DWORD SpecialCall;
} DBGKD_SET_SPECIAL_CALL, *PDBGKD_SET_SPECIAL_CALL;

typedef struct _DBGKD_QUERY_SPECIAL_CALLS { // DebugQuerySpecialCalls
  DWORD NumberOfSpecialCalls;
//  DWORD SpecialCalls[];
} DBGKD_QUERY_SPECIAL_CALLS, *PDBGKD_QUERY_SPECIAL_CALLS;

typedef struct _DBGKD_MANIPULATE_STATE {
  DWORD ApiNumber;
  WORD ProcessorLevel;
  WORD Processor;
  DWORD ReturnStatus;
  union {
    DBGKD_READ_MEMORY ReadMemory;
    DBGKD_WRITE_MEMORY WriteMemory;
    DBGKD_READ_MEMORY64 ReadMemory64;
    DBGKD_WRITE_MEMORY64 WriteMemory64;
    DBGKD_GET_CONTEXT GetContext;
    DBGKD_SET_CONTEXT SetContext;
    DBGKD_WRITE_BREAKPOINT WriteBreakPoint;
    DBGKD_RESTORE_BREAKPOINT RestoreBreakPoint;
    DBGKD_CONTINUE Continue;
    DBGKD_CONTINUE2 Continue2;
    DBGKD_READ_WRITE_IO ReadWriteIo;
    DBGKD_READ_WRITE_IO_EXTENDED ReadWriteIoExtended;
    DBGKD_QUERY_SPECIAL_CALLS QuerySpecialCalls;
    DBGKD_SET_SPECIAL_CALL SetSpecialCall;
    DBGKD_SET_INTERNAL_BREAKPOINT SetInternalBreakpoint;
    DBGKD_GET_INTERNAL_BREAKPOINT GetInternalBreakpoint;
    DBGKD_GET_VERSION GetVersion;
    DBGKD_BREAKPOINTEX BreakPointEx;
    DBGKD_PAGEIN PageIn;
    DBGKD_READ_WRITE_MSR ReadWriteMsr;
  } u;
} DBGKD_MANIPULATE_STATE, *PDBGKD_MANIPULATE_STATE;

typedef enum _OBJECT_INFORMATION_CLASS {
  ObjectBasicInformation,     // 0 Y N
  ObjectNameInformation,      // 1 Y N
  ObjectTypeInformation,      // 2 Y N
  ObjectAllTypesInformation,  // 3 Y N
  ObjectHandleInformation     // 4 Y Y
} OBJECT_INFORMATION_CLASS;

typedef struct _OBJECT_BASIC_INFORMATION { // Information Class 0
ULONG Attributes;
  ACCESS_MASK GrantedAccess;
  ULONG HandleCount;
  ULONG PointerCount;
  ULONG PagedPoolUsage;
  ULONG NonPagedPoolUsage;
  ULONG Reserved[3];
  ULONG NameInformationLength;
  ULONG TypeInformationLength;
  ULONG SecurityDescriptorLength;
  LARGE_INTEGER CreateTime;
} OBJECT_BASIC_INFORMATION, *POBJECT_BASIC_INFORMATION;

typedef struct _OBJECT_NAME_INFORMATION { // Information Class 1
  UNICODE_STRING Name;
} OBJECT_NAME_INFORMATION, *POBJECT_NAME_INFORMATION;

typedef struct _OBJECT_TYPE_INFORMATION { // Information Class 2
  UNICODE_STRING Name;
  ULONG ObjectCount;
  ULONG HandleCount;
  ULONG Reserved1[4];
  ULONG PeakObjectCount;
  ULONG PeakHandleCount;
  ULONG Reserved2[4];
  ULONG InvalidAttributes;
  GENERIC_MAPPING GenericMapping;
  ULONG ValidAccess;
  UCHAR Unknown;
  BOOLEAN MaintainHandleDatabase;
  POOL_TYPE PoolType;
  ULONG PagedPoolUsage;
  ULONG NonPagedPoolUsage;
} OBJECT_TYPE_INFORMATION, *POBJECT_TYPE_INFORMATION;

typedef struct _OBJECT_ALL_TYPES_INFORMATION { // Information Class 3
  ULONG NumberOfTypes;
  OBJECT_TYPE_INFORMATION TypeInformation;
} OBJECT_ALL_TYPES_INFORMATION, *POBJECT_ALL_TYPES_INFORMATION;

typedef struct _OBJECT_HANDLE_ATTRIBUTE_INFORMATION { // Information Class 4
  BOOLEAN Inherit;
  BOOLEAN ProtectFromClose;
} OBJECT_HANDLE_ATTRIBUTE_INFORMATION, *POBJECT_HANDLE_ATTRIBUTE_INFORMATION;

typedef struct _DIRECTORY_BASIC_INFORMATION {
  UNICODE_STRING ObjectName;
  UNICODE_STRING ObjectTypeName;
} DIRECTORY_BASIC_INFORMATION, *PDIRECTORY_BASIC_INFORMATION;

typedef enum _MEMORY_INFORMATION_CLASS {
  MemoryBasicInformation,
  MemoryWorkingSetList,
  MemorySectionName,
  MemoryBasicVlmInformation
} MEMORY_INFORMATION_CLASS;

typedef struct _MEMORY_WORKING_SET_LIST { // Information Class 1
  ULONG NumberOfPages;
  ULONG WorkingSetList[1];
} MEMORY_WORKING_SET_LIST, *PMEMORY_WORKING_SET_LIST;

typedef struct _MEMORY_SECTION_NAME { // Information Class 2
  UNICODE_STRING SectionFileName;
} MEMORY_SECTION_NAME, *PMEMORY_SECTION_NAME;

typedef enum _SECTION_INFORMATION_CLASS {
  SectionBasicInformation,
  SectionImageInformation
} SECTION_INFORMATION_CLASS;

typedef struct _SECTION_BASIC_INFORMATION { // Information Class 0
  PVOID BaseAddress;
  ULONG Attributes;
  LARGE_INTEGER Size;
} SECTION_BASIC_INFORMATION, *PSECTION_BASIC_INFORMATION;

typedef struct _SECTION_IMAGE_INFORMATION { // Information Class 1
  PVOID EntryPoint;
  ULONG Unknown1;
  ULONG StackReserve;
  ULONG StackCommit;
  ULONG Subsystem;
  USHORT MinorSubsystemVersion;
  USHORT MajorSubsystemVersion;
  ULONG Unknown2;
  ULONG Characteristics;
  USHORT ImageNumber;
  BOOLEAN Executable;
  UCHAR Unknown3;
  ULONG Unknown4[3];
} SECTION_IMAGE_INFORMATION, *PSECTION_IMAGE_INFORMATION;

typedef struct _USER_STACK {
  PVOID FixedStackBase;
  PVOID FixedStackLimit;
  PVOID ExpandableStackBase;
  PVOID ExpandableStackLimit;
  PVOID ExpandableStackBottom;
} USER_STACK, *PUSER_STACK;

typedef enum _THREADINFOCLASS {
  ThreadBasicInformation,           // 0 Y N
  ThreadTimes,                      // 1 Y N
  ThreadPriority,                   // 2 N Y
  ThreadBasePriority,               // 3 N Y
  ThreadAffinityMask,               // 4 N Y
  ThreadImpersonationToken,         // 5 N Y
  ThreadDescriptorTableEntry,       // 6 Y N
  ThreadEnableAlignmentFaultFixup,  // 7 N Y
  ThreadEventPair,                  // 8 N Y
  ThreadQuerySetWin32StartAddress,  // 9 Y Y
  ThreadZeroTlsCell,                // 10 N Y
  ThreadPerformanceCount,           // 11 Y N
  ThreadAmILastThread,              // 12 Y N
  ThreadIdealProcessor,             // 13 N Y
  ThreadPriorityBoost,              // 14 Y Y
  ThreadSetTlsArrayAddress,         // 15 N Y
  ThreadIsIoPending,                // 16 Y N
  ThreadHideFromDebugger            // 17 N Y
} THREADINFOCLASS;

typedef struct _THREAD_BASIC_INFORMATION { // Information Class 0
  NTSTATUS ExitStatus;
  PNT_TIB TebBaseAddress;
  CLIENT_ID ClientId;
  KAFFINITY AffinityMask;
  KPRIORITY Priority;
  KPRIORITY BasePriority;
} THREAD_BASIC_INFORMATION, *PTHREAD_BASIC_INFORMATION;

typedef struct _KERNEL_USER_TIMES { // Information Class 1
  LARGE_INTEGER CreateTime;
  LARGE_INTEGER ExitTime;
  LARGE_INTEGER KernelTime;
  LARGE_INTEGER UserTime;
} KERNEL_USER_TIMES, *PKERNEL_USER_TIMES;

typedef VOID (NTAPI *PKNORMAL_ROUTINE)(PVOID ApcContext, PVOID Argument1, PVOID Argument2);

typedef enum _PROCESSINFOCLASS {
  ProcessBasicInformation,          // 0  Y N
  ProcessQuotaLimits,               // 1  Y Y
  ProcessIoCounters,                // 2  Y N
  ProcessVmCounters,                // 3  Y N
  ProcessTimes,                     // 4  Y N
  ProcessBasePriority,              // 5  N Y
  ProcessRaisePriority,             // 6  N Y
  ProcessDebugPort,                 // 7  Y Y
  ProcessExceptionPort,             // 8  N Y
  ProcessAccessToken,               // 9  N Y
  ProcessLdtInformation,            // 10 Y Y
  ProcessLdtSize,                   // 11 N Y
  ProcessDefaultHardErrorMode,      // 12 Y Y
  ProcessIoPortHandlers,            // 13 N Y
  ProcessPooledUsageAndLimits,      // 14 Y N
  ProcessWorkingSetWatch,           // 15 Y Y
  ProcessUserModeIOPL,              // 16 N Y
  ProcessEnableAlignmentFaultFixup, // 17 N Y
  ProcessPriorityClass,             // 18 N Y
  ProcessWx86Information,           // 19 Y N
  ProcessHandleCount,               // 20 Y N
  ProcessAffinityMask,              // 21 N Y
  ProcessPriorityBoost,             // 22 Y Y
  ProcessDeviceMap,                 // 23 Y Y
  ProcessSessionInformation,        // 24 Y Y
  ProcessForegroundInformation,     // 25 N Y
  ProcessWow64Information           // 26 Y N
} PROCESSINFOCLASS;

typedef struct _PROCESS_BASIC_INFORMATION { // Information Class 0
  NTSTATUS ExitStatus;
  PPEB PebBaseAddress;
  KAFFINITY AffinityMask;
  KPRIORITY BasePriority;
  ULONG UniqueProcessId;
  ULONG InheritedFromUniqueProcessId;
} PROCESS_BASIC_INFORMATION, *PPROCESS_BASIC_INFORMATION;

typedef struct _PROCESS_ACCESS_TOKEN { // Information Class 9
  HANDLE Token;
  HANDLE Thread;
} PROCESS_ACCESS_TOKEN, *PPROCESS_ACCESS_TOKEN;

typedef struct _POOLED_USAGE_AND_LIMITS { // Information Class 14
  ULONG PeakPagedPoolUsage;
  ULONG PagedPoolUsage;
  ULONG PagedPoolLimit;
  ULONG PeakNonPagedPoolUsage;
  ULONG NonPagedPoolUsage;
  ULONG NonPagedPoolLimit;
  ULONG PeakPagefileUsage;
  ULONG PagefileUsage;
  ULONG PagefileLimit;
} POOLED_USAGE_AND_LIMITS, *PPOOLED_USAGE_AND_LIMITS;

typedef struct _PROCESS_WS_WATCH_INFORMATION { // Information Class 15
  PVOID FaultingPc;
  PVOID FaultingVa;
} PROCESS_WS_WATCH_INFORMATION, *PPROCESS_WS_WATCH_INFORMATION;

typedef struct _PROCESS_PRIORITY_CLASS { // Information Class 18
  BOOLEAN Foreground;
  UCHAR PriorityClass;
} PROCESS_PRIORITY_CLASS, *PPROCESS_PRIORITY_CLASS;

typedef struct _PROCESS_DEVICEMAP_INFORMATION { // Information Class 23
  union {
    struct {
      HANDLE DirectoryHandle;
    } Set;
    struct {
      ULONG DriveMap;
      UCHAR DriveType[32];
    } Query;
  };
} PROCESS_DEVICEMAP_INFORMATION, *PPROCESS_DEVICEMAP_INFORMATION;

typedef struct _PROCESS_SESSION_INFORMATION { // Information Class 24
  ULONG SessionId;
} PROCESS_SESSION_INFORMATION, *PPROCESS_SESSION_INFORMATION;

typedef struct _PROCESS_PARAMETERS {
  ULONG AllocationSize;
  ULONG Size;
  ULONG Flags;
  ULONG Reserved;
  LONG Console;
  ULONG ProcessGroup;
  HANDLE hStdInput;
  HANDLE hStdOutput;
  HANDLE hStdError;
  UNICODE_STRING CurrentDirectoryName;
  HANDLE CurrentDirectoryHandle;
  UNICODE_STRING DllPath;
  UNICODE_STRING ImageFile;
  UNICODE_STRING CommandLine;
  PWSTR Environment;
  ULONG dwX;
  ULONG dwY;
  ULONG dwXSize;
  ULONG dwYSize;
  ULONG dwXCountChars;
  ULONG dwYCountChars;
  ULONG dwFillAttribute;
  ULONG dwFlags;
  ULONG wShowWindow;
  UNICODE_STRING WindowTitle;
  UNICODE_STRING Desktop;
  UNICODE_STRING Reserved1;
  UNICODE_STRING Reserved2;
} PROCESS_PARAMETERS, *PPROCESS_PARAMETERS;

typedef struct _DEBUG_BUFFER {
  HANDLE SectionHandle;
  PVOID SectionBase;
  PVOID RemoteSectionBase;
  ULONG SectionBaseDelta;
  HANDLE EventPairHandle;
  ULONG Unknown[2];
  HANDLE RemoteThreadHandle;
  ULONG InfoClassMask;
  ULONG SizeOfInfo;
  ULONG AllocatedSize;
  ULONG SectionSize;
  PVOID ModuleInformation;
  PVOID BackTraceInformation;
  PVOID HeapInformation;
  PVOID LockInformation;
  PVOID Reserved[8];
} DEBUG_BUFFER, *PDEBUG_BUFFER;

typedef struct _DEBUG_MODULE_INFORMATION {
  ULONG Reserved[2];
  ULONG Base;
  ULONG Size;
  ULONG Flags;
  USHORT Index;
  USHORT Unknown;
  USHORT LoadCount;
  USHORT ModuleNameOffset;
  CHAR ImageName[256];
} DEBUG_MODULE_INFORMATION, *PDEBUG_MODULE_INFORMATION;

typedef struct _DEBUG_HEAP_INFORMATION {
  ULONG Base;
  ULONG Flags;
  USHORT Granularity;
  USHORT Unknown;
  ULONG Allocated;
  ULONG Committed;
  ULONG TagCount;
  ULONG BlockCount;
  ULONG Reserved[7];
  PVOID Tags;
  PVOID Blocks;
} DEBUG_HEAP_INFORMATION, *PDEBUG_HEAP_INFORMATION;

typedef struct _DEBUG_LOCK_INFORMATION {
  PVOID Address;
  USHORT Type;
  USHORT CreatorBackTraceIndex;
  ULONG OwnerThreadId;
  ULONG ActiveCount;
  ULONG ContentionCount;
  ULONG EntryCount;
  ULONG RecursionCount;
  ULONG NumberOfSharedWaiters;
  ULONG NumberOfExclusiveWaiters;
} DEBUG_LOCK_INFORMATION, *PDEBUG_LOCK_INFORMATION;

typedef enum _JOBOBJECTINFOCLASS {
  JobObjectBasicAccountingInformation           = 1, // Y N
  JobObjectBasicLimitInformation,              // 2     Y Y
  JobObjectBasicProcessIdList,                 // 3     Y N
  JobObjectBasicUIRestrictions,                // 4     Y Y
  JobObjectSecurityLimitInformation,           // 5     Y Y
  JobObjectEndOfJobTimeInformation,            // 6     N Y
  JobObjectAssociateCompletionPortInformation, // 7     N Y
  JobObjectBasicAndIoAccountingInformation,    // 8     Y N
  JobObjectExtendedLimitInformation            // 9     Y Y
} JOBOBJECTINFOCLASS;

typedef struct _JOBOBJECT_BASIC_ACCOUNTING_INFORMATION {
  LARGE_INTEGER TotalUserTime;
  LARGE_INTEGER TotalKernelTime;
  LARGE_INTEGER ThisPeriodTotalUserTime;
  LARGE_INTEGER ThisPeriodTotalKernelTime;
  ULONG TotalPageFaultCount;
  ULONG TotalProcesses;
  ULONG ActiveProcesses;
  ULONG TotalTerminatedProcesses;
} JOBOBJECT_BASIC_ACCOUNTING_INFORMATION, *PJOBOBJECT_BASIC_ACCOUNTING_INFORMATION;

typedef struct _JOBOBJECT_BASIC_LIMIT_INFORMATION {
  LARGE_INTEGER PerProcessUserTimeLimit;
  LARGE_INTEGER PerJobUserTimeLimit;
  ULONG LimitFlags;
  ULONG MinimumWorkingSetSize;
  ULONG MaximumWorkingSetSize;
  ULONG ActiveProcessLimit;
  ULONG Affinity;
  ULONG PriorityClass;
  ULONG SchedulingClass;
} JOBOBJECT_BASIC_LIMIT_INFORMATION, *PJOBOBJECT_BASIC_LIMIT_INFORMATION;

typedef struct _JOBOBJECT_BASIC_PROCESS_ID_LIST {
  ULONG NumberOfAssignedProcesses;
  ULONG NumberOfProcessIdsInList;
  ULONG_PTR ProcessIdList[1];
} JOBOBJECT_BASIC_PROCESS_ID_LIST, *PJOBOBJECT_BASIC_PROCESS_ID_LIST;

typedef struct _JOBOBJECT_BASIC_UI_RESTRICTIONS {
  ULONG UIRestrictionsClass;
} JOBOBJECT_BASIC_UI_RESTRICTIONS, *PJOBOBJECT_BASIC_UI_RESTRICTIONS;

typedef struct _JOBOBJECT_SECURITY_LIMIT_INFORMATION {
  ULONG SecurityLimitFlags;
  HANDLE JobToken;
  PTOKEN_GROUPS SidsToDisable;
  PTOKEN_PRIVILEGES PrivilegesToDelete;
  PTOKEN_GROUPS RestrictedSids;
} JOBOBJECT_SECURITY_LIMIT_INFORMATION, *PJOBOBJECT_SECURITY_LIMIT_INFORMATION;

typedef struct _JOBOBJECT_END_OF_JOB_TIME_INFORMATION {
  ULONG EndOfJobTimeAction;
} JOBOBJECT_END_OF_JOB_TIME_INFORMATION, *PJOBOBJECT_END_OF_JOB_TIME_INFORMATION;

typedef struct _JOBOBJECT_ASSOCIATE_COMPLETION_PORT {
  PVOID CompletionKey;
  HANDLE CompletionPort;
} JOBOBJECT_ASSOCIATE_COMPLETION_PORT, *PJOBOBJECT_ASSOCIATE_COMPLETION_PORT;

typedef struct JOBOBJECT_BASIC_AND_IO_ACCOUNTING_INFORMATION {
  JOBOBJECT_BASIC_ACCOUNTING_INFORMATION BasicInfo;
  IO_COUNTERS IoInfo;
} JOBOBJECT_BASIC_AND_IO_ACCOUNTING_INFORMATION, *PJOBOBJECT_BASIC_AND_IO_ACCOUNTING_INFORMATION;

typedef struct _JOBOBJECT_EXTENDED_LIMIT_INFORMATION {
  JOBOBJECT_BASIC_LIMIT_INFORMATION BasicLimitInformation;
  IO_COUNTERS IoInfo;
  ULONG ProcessMemoryLimit;
  ULONG JobMemoryLimit;
  ULONG PeakProcessMemoryUsed;
  ULONG PeakJobMemoryUsed;
} JOBOBJECT_EXTENDED_LIMIT_INFORMATION, *PJOBOBJECT_EXTENDED_LIMIT_INFORMATION;

typedef enum _WAIT_TYPE {
  WaitAll,
  WaitAny
} WAIT_TYPE, *PWAIT_TYPE;

typedef enum _TIMER_TYPE {
  NotificationTimer,
  SynchronizationTimer
} TIMER_TYPE;

typedef enum _TIMER_INFORMATION_CLASS {
  TimerBasicInformation
} TIMER_INFORMATION_CLASS;

typedef struct _TIMER_BASIC_INFORMATION {
  LARGE_INTEGER TimeRemaining;
  BOOLEAN SignalState;
} TIMER_BASIC_INFORMATION, *PTIMER_BASIC_INFORMATION;

typedef enum _EVENT_TYPE {
  NotificationEvent,
  SynchronizationEvent
} EVENT_TYPE;

typedef enum _EVENT_INFORMATION_CLASS {
  EventBasicInformation
} EVENT_INFORMATION_CLASS;

typedef struct _EVENT_BASIC_INFORMATION {
  EVENT_TYPE EventType;
  LONG SignalState;
} EVENT_BASIC_INFORMATION, *PEVENT_BASIC_INFORMATION;

typedef enum _SEMAPHORE_INFORMATION_CLASS {
  SemaphoreBasicInformation
} SEMAPHORE_INFORMATION_CLASS;

typedef struct _SEMAPHORE_BASIC_INFORMATION {
  LONG CurrentCount;
  LONG MaximumCount;
} SEMAPHORE_BASIC_INFORMATION, *PSEMAPHORE_BASIC_INFORMATION;

typedef enum _MUTANT_INFORMATION_CLASS {
  MutantBasicInformation
} MUTANT_INFORMATION_CLASS;

typedef struct _MUTANT_BASIC_INFORMATION {
  LONG SignalState;
  BOOLEAN Owned;
  BOOLEAN Abandoned;
} MUTANT_BASIC_INFORMATION, *PMUTANT_BASIC_INFORMATION;

typedef enum _IO_COMPLETION_INFORMATION_CLASS {
  IoCompletionBasicInformation
} IO_COMPLETION_INFORMATION_CLASS;

typedef struct _IO_COMPLETION_BASIC_INFORMATION {
  LONG SignalState;
} IO_COMPLETION_BASIC_INFORMATION, *PIO_COMPLETION_BASIC_INFORMATION;

typedef enum _KPROFILE_SOURCE {
  ProfileTime
} KPROFILE_SOURCE;

typedef struct _PORT_MESSAGE {
  USHORT DataSize;
  USHORT MessageSize;
  USHORT MessageType;
  USHORT VirtualRangesOffset;
  CLIENT_ID ClientId;
  ULONG MessageId;
  ULONG SectionSize;
  // UCHAR Data[];
} PORT_MESSAGE, *PPORT_MESSAGE;

typedef enum _LPC_TYPE {
  LPC_NEW_MESSAGE,        // A new message
  LPC_REQUEST,            // A request message
  LPC_REPLY,              // A reply to a request message
  LPC_DATAGRAM,           //
  LPC_LOST_REPLY,         //
  LPC_PORT_CLOSED,        // Sent when port is deleted
  LPC_CLIENT_DIED,        // Messages to thread termination ports
  LPC_EXCEPTION,          // Messages to thread exception port
  LPC_DEBUG_EVENT,        // Messages to thread debug port
  LPC_ERROR_EVENT,        // Used by ZwRaiseHardError
  LPC_CONNECTION_REQUEST  // Used by ZwConnectPort
} LPC_TYPE;

typedef struct _PORT_SECTION_WRITE {
  ULONG Length;
  HANDLE SectionHandle;
  ULONG SectionOffset;
  ULONG ViewSize;
  PVOID ViewBase;
  PVOID TargetViewBase;
} PORT_SECTION_WRITE, *PPORT_SECTION_WRITE;

typedef struct _PORT_SECTION_READ {
  ULONG Length;
  ULONG ViewSize;
  ULONG ViewBase;
} PORT_SECTION_READ, *PPORT_SECTION_READ;

typedef enum _PORT_INFORMATION_CLASS {
  PortBasicInformation
} PORT_INFORMATION_CLASS;

typedef struct _PORT_BASIC_INFORMATION {
} PORT_BASIC_INFORMATION, *PPORT_BASIC_INFORMATION;

typedef enum _KEY_SET_INFORMATION_CLASS {
  KeyLastWriteTimeInformation
} KEY_SET_INFORMATION_CLASS;

typedef struct _KEY_LAST_WRITE_TIME_INFORMATION {
  LARGE_INTEGER LastWriteTime;
} KEY_LAST_WRITE_TIME_INFORMATION, *PKEY_LAST_WRITE_TIME_INFORMATION;

typedef enum _KEY_INFORMATION_CLASS {
  KeyBasicInformation,
  KeyNodeInformation,
  KeyFullInformation,
  KeyNameInformation
} KEY_INFORMATION_CLASS;

typedef struct _KEY_BASIC_INFORMATION {
  LARGE_INTEGER LastWriteTime;
  ULONG TitleIndex;
  ULONG NameLength;
  WCHAR Name[1]; // Variable length string
} KEY_BASIC_INFORMATION, *PKEY_BASIC_INFORMATION;

typedef struct _KEY_NODE_INFORMATION {
  LARGE_INTEGER LastWriteTime;
  ULONG TitleIndex;
  ULONG ClassOffset;
  ULONG ClassLength;
  ULONG NameLength;
  WCHAR Name[1]; // Variable length string
  // Class[1]; // Variable length string not declared
} KEY_NODE_INFORMATION, *PKEY_NODE_INFORMATION;

typedef struct _KEY_FULL_INFORMATION {
  LARGE_INTEGER LastWriteTime;
  ULONG TitleIndex;
  ULONG ClassOffset;
  ULONG ClassLength;
  ULONG SubKeys;
  ULONG MaxNameLen;
  ULONG MaxClassLen;
  ULONG Values;
  ULONG MaxValueNameLen;
  ULONG MaxValueDataLen;
  WCHAR Class[1]; // Variable length string
} KEY_FULL_INFORMATION, *PKEY_FULL_INFORMATION;

typedef struct _KEY_NAME_INFORMATION {
  ULONG NameLength;
  WCHAR Name[1]; // Variable length string
} KEY_NAME_INFORMATION, *PKEY_NAME_INFORMATION;

typedef enum _KEY_VALUE_INFORMATION_CLASS {
  KeyValueBasicInformation,
  KeyValueFullInformation,
  KeyValuePartialInformation,
  KeyValueFullInformationAlign64
} KEY_VALUE_INFORMATION_CLASS;

typedef struct _KEY_VALUE_BASIC_INFORMATION {
  ULONG TitleIndex;
  ULONG Type;
  ULONG NameLength;
  WCHAR Name[1]; // Variable length string
} KEY_VALUE_BASIC_INFORMATION, *PKEY_VALUE_BASIC_INFORMATION;

typedef struct _KEY_VALUE_FULL_INFORMATION {
  ULONG TitleIndex;
  ULONG Type;
  ULONG DataOffset;
  ULONG DataLength;
  ULONG NameLength;
  WCHAR Name[1]; // Variable length string
  // Data[1]; // Variable length data not declared
} KEY_VALUE_FULL_INFORMATION, *PKEY_VALUE_FULL_INFORMATION;

typedef struct _KEY_VALUE_PARTIAL_INFORMATION {
  ULONG TitleIndex;
  ULONG Type;
  ULONG DataLength;
  UCHAR Data[1]; // Variable length data
} KEY_VALUE_PARTIAL_INFORMATION, *PKEY_VALUE_PARTIAL_INFORMATION;

typedef struct _KEY_VALUE_ENTRY {
  PUNICODE_STRING ValueName;
  ULONG DataLength;
  ULONG DataOffset;
  ULONG Type;
} KEY_VALUE_ENTRY, *PKEY_VALUE_ENTRY;

typedef enum _AUDIT_EVENT_TYPE {
  AuditEventObjectAccess,
  AuditEventDirectoryServiceAccess
} AUDIT_EVENT_TYPE, *PAUDIT_EVENT_TYPE;

typedef struct _OBJECT_TYPE_LIST {
  WORD Level;
  WORD Sbz;
  GUID *ObjectType;
} OBJECT_TYPE_LIST, *POBJECT_TYPE_LIST;

typedef enum {
  LT_DONT_CARE,
  LT_LOWEST_LATENCY
} LATENCY_TIME;

typedef enum _DEVICE_POWER_STATE {
  PowerDeviceUnspecified=0,
  PowerDeviceD0,
  PowerDeviceD1,
  PowerDeviceD2,
  PowerDeviceD3,
  PowerDeviceMaximum
} DEVICE_POWER_STATE, *PDEVICE_POWER_STATE;

typedef enum _POWER_ACTION {
  PowerActionNone=0,
  PowerActionReserved,
  PowerActionSleep,
  PowerActionHibernate,
  PowerActionShutdown,
  PowerActionShutdownReset,
  PowerActionShutdownOff,
  PowerActionWarmEject
} POWER_ACTION, *PPOWER_ACTION;

typedef enum _SYSTEM_POWER_STATE {
  PowerSystemUnspecified=0,
  PowerSystemWorking,
  PowerSystemSleeping1,
  PowerSystemSleeping2,
  PowerSystemSleeping3,
  PowerSystemHibernate,
  PowerSystemShutdown
} SYSTEM_POWER_STATE, *PSYSTEM_POWER_STATE;

typedef struct {
  POWER_ACTION  Action;
  ULONG Flags;
  ULONG EventCode;
} POWER_ACTION_POLICY, *PPOWER_ACTION_POLICY;

typedef struct _SYSTEM_POWER_LEVEL {
  BOOLEAN Enable;
  UCHAR Spare[3];
  ULONG BatteryLevel;
  POWER_ACTION_POLICY PowerPolicy;
  SYSTEM_POWER_STATE MinSystemState;
} SYSTEM_POWER_LEVEL, *PSYSTEM_POWER_LEVEL;

typedef struct {
  ULONG Granularity;
  ULONG Capacity;
} BATTERY_REPORTING_SCALE, *PBATTERY_REPORTING_SCALE;

typedef enum {
  SystemPowerPolicyAc,
  SystemPowerPolicyDc,
  VerifySystemPolicyAc,
  VerifySystemPolicyDc,
  SystemPowerCapabilities,
  SystemBatteryState,
  SystemPowerStateHandler,
  ProcessorStateHandler,
  SystemPowerPolicyCurrent,
  AdministratorPowerPolicy,
  SystemReserveHiberFile,
  ProcessorInformation,
  SystemPowerInformation
} POWER_INFORMATION_LEVEL;

/*
typedef struct _SYSTEM_POWER_POLICY {
  ULONG Revision;
  POWER_ACTION_POLICY PowerButton;
  POWER_ACTION_POLICY SleepButton;
  POWER_ACTION_POLICY LidClose;
  SYSTEM_POWER_STATE LidOpenWake;
  ULONG Reserved1;
  POWER_ACTION_POLICY Idle;
  ULONG IdleTimeout;
  UCHAR IdleSensitivity;
  UCHAR Reserved2[3];
  SYSTEM_POWER_STATE MinSleep;
  SYSTEM_POWER_STATE MaxSleep;
  SYSTEM_POWER_STATE ReducedLatencySleep;
  ULONG WinLogonFlags;
  ULONG Reserved3;
  ULONG DozeS4Timeout;
  ULONG BroadcastCapacityResolution;
  SYSTEM_POWER_LEVEL DischargePolicy[NUM_DISCHARGE_POLICIES];
  ULONG VideoTimeout;
  ULONG VideoReserved[4];
  ULONG SpindownTimeout;
  BOOLEAN OptimizeForPower;
  UCHAR FanThrottleTolerance;
  UCHAR ForcedThrottle;
  UCHAR MinThrottle;
  POWER_ACTION_POLICY OverThrottled;
} SYSTEM_POWER_POLICY, *PSYSTEM_POWER_POLICY;
*/

typedef struct _SYSTEM_POWER_CAPABILITIES {
  BOOLEAN PowerButtonPresent;
  BOOLEAN SleepButtonPresent;
  BOOLEAN LidPresent;
  BOOLEAN SystemS1;
  BOOLEAN SystemS2;
  BOOLEAN SystemS3;
  BOOLEAN SystemS4;
  BOOLEAN SystemS5;
  BOOLEAN HiberFilePresent;
  BOOLEAN FullWake;
  UCHAR Reserved1[3];
  BOOLEAN ThermalControl;
  BOOLEAN ProcessorThrottle;
  UCHAR ProcessorMinThrottle;
  UCHAR ProcessorThrottleScale;
  UCHAR Reserved2[4];
  BOOLEAN DiskSpinDown;
  UCHAR Reserved3[8];
  BOOLEAN SystemBatteriesPresent;
  BOOLEAN BatteriesAreShortTerm;
  BATTERY_REPORTING_SCALE BatteryScale[3];
  SYSTEM_POWER_STATE AcOnLineWake;
  SYSTEM_POWER_STATE SoftLidWake;
  SYSTEM_POWER_STATE RtcWake;
  SYSTEM_POWER_STATE MinDeviceWakeState;
  SYSTEM_POWER_STATE DefaultLowLatencyWake;
} SYSTEM_POWER_CAPABILITIES, *PSYSTEM_POWER_CAPABILITIES;

typedef struct _SYSTEM_BATTERY_STATE {
  BOOLEAN AcOnLine;
  BOOLEAN BatteryPresent;
  BOOLEAN Charging;
  BOOLEAN Discharging;
  BOOLEAN Reserved[4];
  ULONG MaxCapacity;
  ULONG RemainingCapacity;
  ULONG Rate;
  ULONG EstimatedTime;
  ULONG DefaultAlert1;
  ULONG DefaultAlert2;
} SYSTEM_BATTERY_STATE, *PSYSTEM_BATTERY_STATE;

/*
typedef struct _POWER_STATE_HANDLER {
  POWER_STATE_HANDLER_TYPE Type;
  BOOLEAN RtcWake;
  UCHAR Reserved[3];
  PENTER_STATE_HANDLER Handler;
  PVOID Context;
} POWER_STATE_HANDLER, *PPOWER_STATE_HANDLER;
*/

/*
typedef struct _PROCESSOR_STATE_HANDLER {
  UCHAR ThrottleScale;
  BOOLEAN ThrottleOnIdle;
  PSET_PROCESSOR_THROTTLE SetThrottle;
  ULONG NumIdleHandlers;
  PROCESSOR_IDLE_HANDLER_INFO IdleHandler[MAX_IDLE_HANDLERS];
} PROCESSOR_STATE_HANDLER, *PPROCESSOR_STATE_HANDLER;
*/

typedef struct _ADMINISTRATOR_POWER_POLICY {
  SYSTEM_POWER_STATE MinSleep;
  SYSTEM_POWER_STATE MaxSleep;
  ULONG MinVideoTimeout;
  ULONG MaxVideoTimeout;
  ULONG MinSpindownTimeout;
  ULONG MaxSpindownTimeout;
} ADMINISTRATOR_POWER_POLICY, *PADMINISTRATOR_POWER_POLICY;

typedef struct _PROCESSOR_POWER_INFORMATION {
  ULONG Number;
  ULONG MaxMhz;
  ULONG CurrentMhz;
  ULONG MhzLimit;
  ULONG MaxIdleState;
  ULONG CurrentIdleState;
} PROCESSOR_POWER_INFORMATION, *PPROCESSOR_POWER_INFORMATION;

typedef struct _SYSTEM_POWER_INFORMATION {
  ULONG MaxIdlenessAllowed;
  ULONG Idleness;
  ULONG TimeRemaining;
  UCHAR CoolingMode;
} SYSTEM_POWER_INFORMATION, *PSYSTEM_POWER_INFORMATION;

typedef struct _PLUGPLAY_NOTIFICATION_HEADER {
  USHORT Version;
  USHORT Size;
  GUID Event;
} PLUGPLAY_NOTIFICATION_HEADER, *PPLUGPLAY_NOTIFICATION_HEADER;

typedef enum _HARDERROR_RESPONSE_OPTION {
  OptionAbortRetryIgnore,
  OptionOk,
  OptionOkCancel,
  OptionRetryCancel,
  OptionYesNo,
  OptionYesNoCancel,
  OptionShutdownSystem
} HARDERROR_RESPONSE_OPTION, *PHARDERROR_RESPONSE_OPTION;

typedef enum _HARDERROR_RESPONSE {
  ResponseReturnToCaller,
  ResponseNotHandled,
  ResponseAbort,
  ResponseCancel,
  ResponseIgnore,
  ResponseNo,
  ResponseOk,
  ResponseRetry,
  ResponseYes
} HARDERROR_RESPONSE, *PHARDERROR_RESPONSE;

typedef enum _ATOM_INFORMATION_CLASS {
  AtomBasicInformation,
  AtomListInformation
} ATOM_INFORMATION_CLASS;

typedef struct _ATOM_BASIC_INFORMATION {
  USHORT ReferenceCount;
  USHORT Pinned;
  USHORT NameLength;
  WCHAR Name[1];
} ATOM_BASIC_INFORMATION, *PATOM_BASIC_INFORMATION;

typedef struct _ATOM_LIST_INFORMATION {
  ULONG NumberOfAtoms;
  ATOM Atoms[1];
} ATOM_LIST_INFORMATION, *PATOM_LIST_INFORMATION;
/**/

/***** zw start  *****/
/*system information*/
NTSYSAPI
NTSTATUS
NTAPI
ZwQuerySystemInformation(
  IN SYSTEM_INFORMATION_CLASS SystemInformationClass,
  IN OUT PVOID SystemInformation,
  IN ULONG SystemInformationLength,
  OUT PULONG ReturnLength OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetSystemInformation(
  IN SYSTEM_INFORMATION_CLASS SystemInformationClass,
  IN OUT PVOID SystemInformation,
  IN ULONG SystemInformationLength
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQuerySystemEnvironmentValue(
  IN PUNICODE_STRING Name,
  OUT PVOID Value,
  IN ULONG ValueLength,
  OUT PULONG ReturnLength OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetSystemEnvironmentValue(
  IN PUNICODE_STRING Name,
  IN PUNICODE_STRING Value
);

NTSYSAPI
NTSTATUS
NTAPI
ZwShutdownSystem(
  IN SHUTDOWN_ACTION Action
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSystemDebugControl(
  IN DEBUG_CONTROL_CODE ControlCode,
  IN PVOID InputBuffer OPTIONAL,
  IN ULONG InputBufferLength,
  OUT PVOID OutputBuffer OPTIONAL,
  IN ULONG OutputBufferLength,
  OUT PULONG ReturnLength OPTIONAL
);

/*objects*/
NTSYSAPI
NTSTATUS
NTAPI
ZwQueryObject(
  IN HANDLE ObjectHandle,
  IN OBJECT_INFORMATION_CLASS ObjectInformationClass,
  OUT PVOID ObjectInformation,
  IN ULONG ObjectInformationLength,
  OUT PULONG ReturnLength OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetInformationObject(
  IN HANDLE ObjectHandle,
  IN OBJECT_INFORMATION_CLASS ObjectInformationClass,
  IN PVOID ObjectInformation,
  IN ULONG ObjectInformationLength
);

NTSYSAPI
NTSTATUS
NTAPI
ZwDuplicateObject(
  IN HANDLE SourceProcessHandle,
  IN HANDLE SourceHandle,
  IN HANDLE TargetProcessHandle,
  OUT PHANDLE TargetHandle OPTIONAL,
  IN ACCESS_MASK DesiredAccess,
  IN ULONG Attributes,
  IN ULONG Options
);

NTSYSAPI
NTSTATUS
NTAPI
ZwMakeTemporaryObject(
  IN HANDLE Handle
);

NTSYSAPI
NTSTATUS
NTAPI
ZwClose(
  IN HANDLE Handle
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQuerySecurityObject(
  IN HANDLE Handle,
  IN SECURITY_INFORMATION SecurityInformation,
  OUT PSECURITY_DESCRIPTOR SecurityDescriptor,
  IN ULONG SecurityDescriptorLength,
  OUT PULONG ReturnLength
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetSecurityObject(
  IN HANDLE Handle,
  IN SECURITY_INFORMATION SecurityInformation,
  IN PSECURITY_DESCRIPTOR SecurityDescriptor
);

NTSYSAPI
NTSTATUS
NTAPI
ZwCreateDirectoryObject(
  OUT PHANDLE DirectoryHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes
);

NTSYSAPI
NTSTATUS
NTAPI
ZwOpenDirectoryObject(
  OUT PHANDLE DirectoryHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryDirectoryObject(
  IN HANDLE DirectoryHandle,
  OUT PVOID Buffer,
  IN ULONG BufferLength,
  IN BOOLEAN ReturnSingleEntry,
  IN BOOLEAN RestartScan,
  IN OUT PULONG Context,
  OUT PULONG ReturnLength OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwCreateSymbolicLinkObject(
  OUT PHANDLE SymbolicLinkHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes,
  IN PUNICODE_STRING TargetName
);

NTSYSAPI
NTSTATUS
NTAPI
ZwOpenSymbolicLinkObject(
  OUT PHANDLE SymbolicLinkHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQuerySymbolicLinkObject(
  IN HANDLE SymbolicLinkHandle,
  IN OUT PUNICODE_STRING TargetName,
  OUT PULONG ReturnLength OPTIONAL
);

/*virtual memory*/
NTSYSAPI
NTSTATUS
NTAPI
ZwAllocateVirtualMemory(
  IN HANDLE ProcessHandle,
  IN OUT PVOID *BaseAddress,
  IN ULONG ZeroBits,
  IN OUT PULONG AllocationSize,
  IN ULONG AllocationType,
  IN ULONG Protect
);

NTSYSAPI
NTSTATUS
NTAPI
ZwFreeVirtualMemory(
  IN HANDLE ProcessHandle,
  IN OUT PVOID *BaseAddress,
  IN OUT PULONG FreeSize,
  IN ULONG FreeType
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryVirtualMemory(
  IN HANDLE ProcessHandle,
  IN PVOID BaseAddress,
  IN MEMORY_INFORMATION_CLASS MemoryInformationClass,
  OUT PVOID MemoryInformation,
  IN ULONG MemoryInformationLength,
  OUT PULONG ReturnLength OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwLockVirtualMemory(
  IN HANDLE ProcessHandle,
  IN OUT PVOID *BaseAddress,
  IN OUT PULONG LockSize,
  IN ULONG LockType
);

NTSYSAPI
NTSTATUS
NTAPI
ZwUnlockVirtualMemory(
  IN HANDLE ProcessHandle,
  IN OUT PVOID *BaseAddress,
  IN OUT PULONG LockSize,
  IN ULONG LockType
);

NTSYSAPI
NTSTATUS
NTAPI
ZwReadVirtualMemory(
  IN HANDLE ProcessHandle,
  IN PVOID BaseAddress,
  OUT PVOID Buffer,
  IN ULONG BufferLength,
  OUT PULONG ReturnLength OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwWriteVirtualMemory(
  IN HANDLE ProcessHandle,
  IN PVOID BaseAddress,
  IN PVOID Buffer,
  IN ULONG BufferLength,
  OUT PULONG ReturnLength OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwProtectVirtualMemory(
  IN HANDLE ProcessHandle,
  IN OUT PVOID *BaseAddress,
  IN OUT PULONG ProtectSize,
  IN ULONG NewProtect,
  OUT PULONG OldProtect
);

NTSYSAPI
NTSTATUS
NTAPI
ZwFlushVirtualMemory(
  IN HANDLE ProcessHandle,
  IN OUT PVOID *BaseAddress,
  IN OUT PULONG FlushSize,
  OUT PIO_STATUS_BLOCK IoStatusBlock
);

NTSYSAPI
NTSTATUS
NTAPI
ZwAllocateUserPhysicalPages(
  IN HANDLE ProcessHandle,
  IN PULONG NumberOfPages,
  OUT PULONG PageFrameNumbers
);

NTSYSAPI
NTSTATUS
NTAPI
ZwFreeUserPhysicalPages(
  IN HANDLE ProcessHandle,
  IN OUT PULONG NumberOfPages,
  IN PULONG PageFrameNumbers
);

NTSYSAPI
NTSTATUS
NTAPI
ZwMapUserPhysicalPages(
  IN PVOID BaseAddress,
  IN PULONG NumberOfPages,
  IN PULONG PageFrameNumbers
);

NTSYSAPI
NTSTATUS
NTAPI
ZwMapUserPhysicalPagesScatter(
  IN PVOID *BaseAddresses,
  IN PULONG NumberOfPages,
  IN PULONG PageFrameNumbers
);

NTSYSAPI
NTSTATUS
NTAPI
ZwGetWriteWatch(
  IN HANDLE ProcessHandle,
  IN ULONG Flags,
  IN PVOID BaseAddress,
  IN ULONG RegionSize,
  OUT PULONG Buffer,
  IN OUT PULONG BufferEntries,
  OUT PULONG Granularity
);

NTSYSAPI
NTSTATUS
NTAPI
ZwResetWriteWatch(
  IN HANDLE ProcessHandle,
  IN PVOID BaseAddress,
  IN ULONG RegionSize
);
/*sections*/
NTSYSAPI
NTSTATUS
NTAPI
ZwCreateSection(
  OUT PHANDLE SectionHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes,
  IN PLARGE_INTEGER SectionSize OPTIONAL,
  IN ULONG Protect,
  IN ULONG Attributes,
  IN HANDLE FileHandle
);

NTSYSAPI
NTSTATUS
NTAPI
ZwOpenSection(
  OUT PHANDLE SectionHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQuerySection(
  IN HANDLE SectionHandle,
  IN SECTION_INFORMATION_CLASS SectionInformationClass,
  OUT PVOID SectionInformation,
  IN ULONG SectionInformationLength,
  OUT PULONG ResultLength OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwExtendSection(
  IN HANDLE SectionHandle,
  IN PLARGE_INTEGER SectionSize
);

NTSYSAPI
NTSTATUS
NTAPI
ZwMapViewOfSection(
  IN HANDLE SectionHandle,
  IN HANDLE ProcessHandle,
  IN OUT PVOID *BaseAddress,
  IN ULONG ZeroBits,
  IN ULONG CommitSize,
  IN OUT PLARGE_INTEGER SectionOffset OPTIONAL,
  IN OUT PULONG ViewSize,
  IN SECTION_INHERIT InheritDisposition,
  IN ULONG AllocationType,
  IN ULONG Protect
);

NTSYSAPI
NTSTATUS
NTAPI
ZwUnmapViewOfSection(
  IN HANDLE ProcessHandle,
  IN PVOID BaseAddress
);

NTSYSAPI
NTSTATUS
NTAPI
ZwAreMappedFilesTheSame(
  IN PVOID Address1,
  IN PVOID Address2
);
/*threads*/
NTSYSAPI
NTSTATUS
NTAPI
ZwCreateThread(
  OUT PHANDLE ThreadHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes,
  IN HANDLE ProcessHandle,
  OUT PCLIENT_ID ClientId,
  IN PCONTEXT ThreadContext,
  IN PUSER_STACK UserStack,
  IN BOOLEAN CreateSuspended
);

NTSYSAPI
NTSTATUS
NTAPI
ZwOpenThread(
  OUT PHANDLE ThreadHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes,
  IN PCLIENT_ID ClientId
);

NTSYSAPI
NTSTATUS
NTAPI
ZwTerminateThread(
  IN HANDLE ThreadHandle OPTIONAL,
  IN NTSTATUS ExitStatus
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryInformationThread(
  IN HANDLE ThreadHandle,
  IN THREADINFOCLASS ThreadInformationClass,
  OUT PVOID ThreadInformation,
  IN ULONG ThreadInformationLength,
  OUT PULONG ReturnLength OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetInformationThread(
  IN HANDLE ThreadHandle,
  IN THREADINFOCLASS ThreadInformationClass,
  IN PVOID ThreadInformation,
  IN ULONG ThreadInformationLength
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSuspendThread(
  IN HANDLE ThreadHandle,
  OUT PULONG PreviousSuspendCount OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwResumeThread(
  IN HANDLE ThreadHandle,
  OUT PULONG PreviousSuspendCount OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwGetContextThread(
  IN HANDLE ThreadHandle,
  OUT PCONTEXT Context
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetContextThread(
  IN HANDLE ThreadHandle,
  IN PCONTEXT Context
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueueApcThread(
  IN HANDLE ThreadHandle,
  IN PKNORMAL_ROUTINE ApcRoutine,
  IN PVOID ApcContext OPTIONAL,
  IN PVOID Argument1 OPTIONAL,
  IN PVOID Argument2 OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwTestAlert(
  VOID
);

NTSYSAPI
NTSTATUS
NTAPI
ZwAlertThread(
  IN HANDLE ThreadHandle
);

NTSYSAPI
NTSTATUS
NTAPI
ZwAlertResumeThread(
  IN HANDLE ThreadHandle,
  OUT PULONG PreviousSuspendCount OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwRegisterThreadTerminatePort(
  IN HANDLE PortHandle
);

NTSYSAPI
NTSTATUS
NTAPI
ZwImpersonateThread(
  IN HANDLE ThreadHandle,
  IN HANDLE TargetThreadHandle,
  IN PSECURITY_QUALITY_OF_SERVICE SecurityQos
);

NTSYSAPI
NTSTATUS
NTAPI
ZwImpersonateAnonymousToken(
  IN HANDLE ThreadHandle
);

/*processes*/
NTSYSAPI
NTSTATUS
NTAPI
ZwCreateProcess(
  OUT PHANDLE ProcessHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes,
  IN HANDLE InheritFromProcessHandle,
  IN BOOLEAN InheritHandles,
  IN HANDLE SectionHandle OPTIONAL,
  IN HANDLE DebugPort OPTIONAL,
  IN HANDLE ExceptionPort OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwOpenProcess(
  OUT PHANDLE ProcessHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes,
  IN PCLIENT_ID ClientId OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwTerminateProcess(
  IN HANDLE ProcessHandle OPTIONAL,
  IN NTSTATUS ExitStatus
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryInformationProcess(
  IN HANDLE ProcessHandle,
  IN PROCESSINFOCLASS ProcessInformationClass,
  OUT PVOID ProcessInformation,
  IN ULONG ProcessInformationLength,
  OUT PULONG ReturnLength OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetInformationProcess(
  IN HANDLE ProcessHandle,
  IN PROCESSINFOCLASS ProcessInformationClass,
  IN PVOID ProcessInformation,
  IN ULONG ProcessInformationLength
);

/*jobs*/
NTSYSAPI
NTSTATUS
NTAPI
ZwCreateJobObject(
  OUT PHANDLE JobHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes
);

NTSYSAPI
NTSTATUS
NTAPI
ZwOpenJobObject(
  OUT PHANDLE JobHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes
);

NTSYSAPI
NTSTATUS
NTAPI
ZwTerminateJobObject(
  IN HANDLE JobHandle,
  IN NTSTATUS ExitStatus
);

NTSYSAPI
NTSTATUS
NTAPI
ZwAssignProcessToJobObject(
  IN HANDLE JobHandle,
  IN HANDLE ProcessHandle
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryInformationJobObject(
  IN HANDLE JobHandle,
  IN JOBOBJECTINFOCLASS JobInformationClass,
  OUT PVOID JobInformation,
  IN ULONG JobInformationLength,
  OUT PULONG ReturnLength OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetInformationJobObject(
  IN HANDLE JobHandle,
  IN JOBOBJECTINFOCLASS JobInformationClass,
  IN PVOID JobInformation,
  IN ULONG JobInformationLength
);

/*tokens*/
NTSYSAPI
NTSTATUS
NTAPI
ZwCreateToken(
  OUT PHANDLE TokenHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes,
  IN TOKEN_TYPE Type,
  IN PLUID AuthenticationId,
  IN PLARGE_INTEGER ExpirationTime,
  IN PTOKEN_USER User,
  IN PTOKEN_GROUPS Groups,
  IN PTOKEN_PRIVILEGES Privileges,
  IN PTOKEN_OWNER Owner,
  IN PTOKEN_PRIMARY_GROUP PrimaryGroup,
  IN PTOKEN_DEFAULT_DACL DefaultDacl,
  IN PTOKEN_SOURCE Source
);

NTSYSAPI
NTSTATUS
NTAPI
ZwOpenProcessToken(
  IN HANDLE ProcessHandle,
  IN ACCESS_MASK DesiredAccess,
  OUT PHANDLE TokenHandle
);

NTSYSAPI
NTSTATUS
NTAPI
ZwOpenThreadToken(
  IN HANDLE ThreadHandle,
  IN ACCESS_MASK DesiredAccess,
  IN BOOLEAN OpenAsSelf,
  OUT PHANDLE TokenHandle
);

NTSYSAPI
NTSTATUS
NTAPI
ZwDuplicateToken(
  IN HANDLE ExistingTokenHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes,
  IN BOOLEAN EffectiveOnly,
  IN TOKEN_TYPE TokenType,
  OUT PHANDLE NewTokenHandle
);

NTSYSAPI
NTSTATUS
NTAPI
ZwFilterToken(
  IN HANDLE ExistingTokenHandle,
  IN ULONG Flags,
  IN PTOKEN_GROUPS SidsToDisable,
  IN PTOKEN_PRIVILEGES PrivilegesToDelete,
  IN PTOKEN_GROUPS SidsToRestricted,
  OUT PHANDLE NewTokenHandle
);

NTSYSAPI
NTSTATUS
NTAPI
ZwAdjustPrivilegesToken(
  IN HANDLE TokenHandle,
  IN BOOLEAN DisableAllPrivileges,
  IN PTOKEN_PRIVILEGES NewState,
  IN ULONG BufferLength,
  OUT PTOKEN_PRIVILEGES PreviousState OPTIONAL,
  OUT PULONG ReturnLength
);

NTSYSAPI
NTSTATUS
NTAPI
ZwAdjustGroupsToken(
  IN HANDLE TokenHandle,
  IN BOOLEAN ResetToDefault,
  IN PTOKEN_GROUPS NewState,
  IN ULONG BufferLength,
  OUT PTOKEN_GROUPS PreviousState OPTIONAL,
  OUT PULONG ReturnLength
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryInformationToken(
  IN HANDLE TokenHandle,
  IN TOKEN_INFORMATION_CLASS TokenInformationClass,
  OUT PVOID TokenInformation,
  IN ULONG TokenInformationLength,
  OUT PULONG ReturnLength
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetInformationToken(
  IN HANDLE TokenHandle,
  IN TOKEN_INFORMATION_CLASS TokenInformationClass,
  IN PVOID TokenInformation,
  IN ULONG TokenInformationLength
);

/*synchronization*/
NTSYSAPI
NTSTATUS
NTAPI
ZwWaitForSingleObject(
  IN HANDLE Handle,
  IN BOOLEAN Alertable,
  IN PLARGE_INTEGER Timeout OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSignalAndWaitForSingleObject(
  IN HANDLE HandleToSignal,
  IN HANDLE HandleToWait,
  IN BOOLEAN Alertable,
  IN PLARGE_INTEGER Timeout OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwWaitForMultipleObjects(
  IN ULONG HandleCount,
  IN PHANDLE Handles,
  IN WAIT_TYPE WaitType,
  IN BOOLEAN Alertable,
  IN PLARGE_INTEGER Timeout OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwCreateTimer(
  OUT PHANDLE TimerHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes,
  IN TIMER_TYPE TimerType
);

NTSYSAPI
NTSTATUS
NTAPI
ZwOpenTimer(
  OUT PHANDLE TimerHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes
);

NTSYSAPI
NTSTATUS
NTAPI
ZwCancelTimer(
  IN HANDLE TimerHandle,
  OUT PBOOLEAN PreviousState OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetTimer(
  IN HANDLE TimerHandle,
  IN PLARGE_INTEGER DueTime,
  IN PTIMER_APC_ROUTINE TimerApcRoutine OPTIONAL,
  IN PVOID TimerContext,
  IN BOOLEAN Resume,
  IN LONG Period,
  OUT PBOOLEAN PreviousState OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryTimer(
  IN HANDLE TimerHandle,
  IN TIMER_INFORMATION_CLASS TimerInformationClass,
  OUT PVOID TimerInformation,
  IN ULONG TimerInformationLength,
  OUT PULONG ResultLength OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwCreateEvent(
  OUT PHANDLE EventHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes,
  IN EVENT_TYPE EventType,
  IN BOOLEAN InitialState
);

NTSYSAPI
NTSTATUS
NTAPI
ZwOpenEvent(
  OUT PHANDLE EventHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetEvent(
  IN HANDLE EventHandle,
  OUT PULONG PreviousState OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwPulseEvent(
  IN HANDLE EventHandle,
  OUT PULONG PreviousState OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwResetEvent(
  IN HANDLE EventHandle,
  OUT PULONG PreviousState OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwClearEvent(
  IN HANDLE EventHandle
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryEvent(
  IN HANDLE EventHandle,
  IN EVENT_INFORMATION_CLASS EventInformationClass,
  OUT PVOID EventInformation,
  IN ULONG EventInformationLength,
  OUT PULONG ResultLength OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwCreateSemaphore(
  OUT PHANDLE SemaphoreHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes,
  IN LONG InitialCount,
  IN LONG MaximumCount
);

NTSYSAPI
NTSTATUS
NTAPI
ZwOpenSemaphore(
  OUT PHANDLE SemaphoreHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes
);

NTSYSAPI
NTSTATUS
NTAPI
ZwReleaseSemaphore(
  IN HANDLE SemaphoreHandle,
  IN LONG ReleaseCount,
  OUT PLONG PreviousCount OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQuerySemaphore(
  IN HANDLE SemaphoreHandle,
  IN SEMAPHORE_INFORMATION_CLASS SemaphoreInformationClass,
  OUT PVOID SemaphoreInformation,
  IN ULONG SemaphoreInformationLength,
  OUT PULONG ResultLength OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwCreateMutant(
  OUT PHANDLE MutantHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes,
  IN BOOLEAN InitialOwner
);

NTSYSAPI
NTSTATUS
NTAPI
ZwOpenMutant(
  OUT PHANDLE MutantHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes
);

NTSYSAPI
NTSTATUS
NTAPI
ZwReleaseMutant(
  IN HANDLE MutantHandle,
  OUT PULONG PreviousState
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryMutant(
  IN HANDLE MutantHandle,
  IN MUTANT_INFORMATION_CLASS MutantInformationClass,
  OUT PVOID MutantInformation,
  IN ULONG MutantInformationLength,
  OUT PULONG ResultLength OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwCreateIoCompletion(
  OUT PHANDLE IoCompletionHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes,
  IN ULONG NumberOfConcurrentThreads
);

NTSYSAPI
NTSTATUS
NTAPI
ZwOpenIoCompletion(
  OUT PHANDLE IoCompletionHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetIoCompletion(
  IN HANDLE IoCompletionHandle,
  IN ULONG CompletionKey,
  IN ULONG CompletionValue,
  IN NTSTATUS Status,
  IN ULONG Information
);

NTSYSAPI
NTSTATUS
NTAPI
ZwRemoveIoCompletion(
  IN HANDLE IoCompletionHandle,
  OUT PULONG CompletionKey,
  OUT PULONG CompletionValue,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  IN PLARGE_INTEGER Timeout OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryIoCompletion(
  IN HANDLE IoCompletionHandle,
  IN IO_COMPLETION_INFORMATION_CLASS IoCompletionInformationClass,
  OUT PVOID IoCompletionInformation,
  IN ULONG IoCompletionInformationLength,
  OUT PULONG ResultLength OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwCreateEventPair(
  OUT PHANDLE EventPairHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes
);

NTSYSAPI
NTSTATUS
NTAPI
ZwOpenEventPair(
  OUT PHANDLE EventPairHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes
);

NTSYSAPI
NTSTATUS
NTAPI
ZwWaitLowEventPair(
  IN HANDLE EventPairHandle
);

NTSYSAPI
NTSTATUS
NTAPI
ZwWaitHighEventPair(
  IN HANDLE EventPairHandle
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetLowWaitHighEventPair(
  IN HANDLE EventPairHandle
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetHighWaitLowEventPair(
  IN HANDLE EventPairHandle
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetLowEventPair(
  IN HANDLE EventPairHandle
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetHighEventPair(
  IN HANDLE EventPairHandle
);

/*time*/
NTSYSAPI
NTSTATUS
NTAPI
ZwQuerySystemTime(
  OUT PLARGE_INTEGER CurrentTime
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetSystemTime(
  IN PLARGE_INTEGER NewTime,
  OUT PLARGE_INTEGER OldTime OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryPerformanceCounter(
  OUT PLARGE_INTEGER PerformanceCount,
  OUT PLARGE_INTEGER PerformanceFrequency OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetTimerResolution(
  IN ULONG RequestedResolution,
  IN BOOLEAN Set,
  OUT PULONG ActualResolution
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryTimerResolution(
  OUT PULONG CoarsestResolution,
  OUT PULONG FinestResolution,
  OUT PULONG ActualResolution
);

NTSYSAPI
NTSTATUS
NTAPI
ZwDelayExecution(
  IN BOOLEAN Alertable,
  IN PLARGE_INTEGER Interval
);

NTSYSAPI
NTSTATUS
NTAPI
ZwYieldExecution(
  VOID
);

NTSYSAPI
ULONG
NTAPI
ZwGetTickCount(
  VOID
);

/*execution profiling*/
NTSYSAPI
NTSTATUS
NTAPI
ZwCreateProfile(
  OUT PHANDLE ProfileHandle,
  IN HANDLE ProcessHandle,
  IN PVOID Base,
  IN ULONG Size,
  IN ULONG BucketShift,
  IN PULONG Buffer,
  IN ULONG BufferLength,
  IN KPROFILE_SOURCE Source,
  IN ULONG ProcessorMask
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetIntervalProfile(
  IN ULONG Interval,
  IN KPROFILE_SOURCE Source
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryIntervalProfile(
  IN KPROFILE_SOURCE Source,
  OUT PULONG Interval
);

NTSYSAPI
NTSTATUS
NTAPI
ZwStartProfile(
  IN HANDLE ProfileHandle
);

NTSYSAPI
NTSTATUS
NTAPI
ZwStopProfile(
  IN HANDLE ProfileHandle
);

/*lpc*/
NTSYSAPI
NTSTATUS
NTAPI
ZwCreatePort(
  OUT PHANDLE PortHandle,
  IN POBJECT_ATTRIBUTES ObjectAttributes,
  IN ULONG MaxDataSize,
  IN ULONG MaxMessageSize,
  IN ULONG Reserved
);

NTSYSAPI
NTSTATUS
NTAPI
ZwCreateWaitablePort(
  OUT PHANDLE PortHandle,
  IN POBJECT_ATTRIBUTES ObjectAttributes,
  IN ULONG MaxDataSize,
  IN ULONG MaxMessageSize,
  IN ULONG Reserved
);

NTSYSAPI
NTSTATUS
NTAPI
ZwConnectPort(
  OUT PHANDLE PortHandle,
  IN PUNICODE_STRING PortName,
  IN PSECURITY_QUALITY_OF_SERVICE SecurityQos,
  IN OUT PPORT_SECTION_WRITE WriteSection OPTIONAL,
  IN OUT PPORT_SECTION_READ ReadSection OPTIONAL,
  OUT PULONG MaxMessageSize OPTIONAL,
  IN OUT PVOID ConnectData OPTIONAL,
  IN OUT PULONG ConnectDataLength OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSecureConnectPort(
  OUT PHANDLE PortHandle,
  IN PUNICODE_STRING PortName,
  IN PSECURITY_QUALITY_OF_SERVICE SecurityQos,
  IN OUT PPORT_SECTION_WRITE WriteSection OPTIONAL,
  IN PSID ServerSid OPTIONAL,
  IN OUT PPORT_SECTION_READ ReadSection OPTIONAL,
  OUT PULONG MaxMessageSize OPTIONAL,
  IN OUT PVOID ConnectData OPTIONAL,
  IN OUT PULONG ConnectDataLength OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwListenPort(
  IN HANDLE PortHandle,
  OUT PPORT_MESSAGE Message
);

NTSYSAPI
NTSTATUS
NTAPI
ZwAcceptConnectPort(
  OUT PHANDLE PortHandle,
  IN ULONG PortIdentifier,
  IN PPORT_MESSAGE Message,
  IN BOOLEAN Accept,
  IN OUT PPORT_SECTION_WRITE WriteSection OPTIONAL,
  IN OUT PPORT_SECTION_READ ReadSection OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwCompleteConnectPort(
  IN HANDLE PortHandle
);

NTSYSAPI
NTSTATUS
NTAPI
ZwRequestPort(
  IN HANDLE PortHandle,
  IN PPORT_MESSAGE RequestMessage
);

NTSYSAPI
NTSTATUS
NTAPI
ZwRequestWaitReplyPort(
  IN HANDLE PortHandle,
  IN PPORT_MESSAGE RequestMessage,
  OUT PPORT_MESSAGE ReplyMessage
);

NTSYSAPI
NTSTATUS
NTAPI
ZwReplyPort(
  IN HANDLE PortHandle,
  IN PPORT_MESSAGE ReplyMessage
);

NTSYSAPI
NTSTATUS
NTAPI
ZwReplyWaitReplyPort(
  IN HANDLE PortHandle,
  IN OUT PPORT_MESSAGE ReplyMessage
);

NTSYSAPI
NTSTATUS
NTAPI
ZwReplyWaitReceivePort(
  IN HANDLE PortHandle,
  OUT PULONG PortIdentifier OPTIONAL,
  IN PPORT_MESSAGE ReplyMessage OPTIONAL,
  OUT PPORT_MESSAGE Message
);

NTSYSAPI
NTSTATUS
NTAPI
ZwReplyWaitReceivePortEx(
  IN HANDLE PortHandle,
  OUT PULONG PortIdentifier OPTIONAL,
  IN PPORT_MESSAGE ReplyMessage OPTIONAL,
  OUT PPORT_MESSAGE Message,
  IN PLARGE_INTEGER Timeout
);

NTSYSAPI
NTSTATUS
NTAPI
ZwReadRequestData(
  IN HANDLE PortHandle,
  IN PPORT_MESSAGE Message,
  IN ULONG Index,
  OUT PVOID Buffer,
  IN ULONG BufferLength,
  OUT PULONG ReturnLength OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwWriteRequestData(
  IN HANDLE PortHandle,
  IN PPORT_MESSAGE Message,
  IN ULONG Index,
  IN PVOID Buffer,
  IN ULONG BufferLength,
  OUT PULONG ReturnLength OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryInformationPort(
  IN HANDLE PortHandle,
  IN PORT_INFORMATION_CLASS PortInformationClass,
  OUT PVOID PortInformation,
  IN ULONG PortInformationLength,
  OUT PULONG ReturnLength OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwImpersonateClientOfPort(
  IN HANDLE PortHandle,
  IN PPORT_MESSAGE Message
);

/*files*/
NTSYSAPI
NTSTATUS
NTAPI
ZwCreateFile(
  OUT PHANDLE FileHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  IN PLARGE_INTEGER AllocationSize OPTIONAL,
  IN ULONG FileAttributes,
  IN ULONG ShareAccess,
  IN ULONG CreateDisposition,
  IN ULONG CreateOptions,
  IN PVOID EaBuffer OPTIONAL,
  IN ULONG EaLength
);

NTSYSAPI
NTSTATUS
NTAPI
ZwOpenFile(
  OUT PHANDLE FileHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  IN ULONG ShareAccess,
  IN ULONG OpenOptions
);

NTSYSAPI
NTSTATUS
NTAPI
ZwDeleteFile(
  IN POBJECT_ATTRIBUTES ObjectAttributes
);

NTSYSAPI
NTSTATUS
NTAPI
ZwFlushBuffersFile(
  IN HANDLE FileHandle,
  OUT PIO_STATUS_BLOCK IoStatusBlock
);

NTSYSAPI
NTSTATUS
NTAPI
ZwCancelIoFile(
  IN HANDLE FileHandle,
  OUT PIO_STATUS_BLOCK IoStatusBlock
);

NTSYSAPI
NTSTATUS
NTAPI
ZwReadFile(
  IN HANDLE FileHandle,
  IN HANDLE Event OPTIONAL,
  IN PIO_APC_ROUTINE ApcRoutine OPTIONAL,
  IN PVOID ApcContext OPTIONAL,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  OUT PVOID Buffer,
  IN ULONG Length,
  IN PLARGE_INTEGER ByteOffset OPTIONAL,
  IN PULONG Key OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwWriteFile(
  IN HANDLE FileHandle,
  IN HANDLE Event OPTIONAL,
  IN PIO_APC_ROUTINE ApcRoutine OPTIONAL,
  IN PVOID ApcContext OPTIONAL,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  IN PVOID Buffer,
  IN ULONG Length,
  IN PLARGE_INTEGER ByteOffset OPTIONAL,
  IN PULONG Key OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwReadFileScatter(
  IN HANDLE FileHandle,
  IN HANDLE Event OPTIONAL,
  IN PIO_APC_ROUTINE ApcRoutine OPTIONAL,
  IN PVOID ApcContext OPTIONAL,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  IN PFILE_SEGMENT_ELEMENT Buffer,
  IN ULONG Length,
  IN PLARGE_INTEGER ByteOffset OPTIONAL,
  IN PULONG Key OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwWriteFileGather(
  IN HANDLE FileHandle,
  IN HANDLE Event OPTIONAL,
  IN PIO_APC_ROUTINE ApcRoutine OPTIONAL,
  IN PVOID ApcContext OPTIONAL,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  IN PFILE_SEGMENT_ELEMENT Buffer,
  IN ULONG Length,
  IN PLARGE_INTEGER ByteOffset OPTIONAL,
  IN PULONG Key OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwLockFile(
  IN HANDLE FileHandle,
  IN HANDLE Event OPTIONAL,
  IN PIO_APC_ROUTINE ApcRoutine OPTIONAL,
  IN PVOID ApcContext OPTIONAL,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  IN PULARGE_INTEGER LockOffset,
  IN PULARGE_INTEGER LockLength,
  IN ULONG Key,
  IN BOOLEAN FailImmediately,
  IN BOOLEAN ExclusiveLock
);

NTSYSAPI
NTSTATUS
NTAPI
ZwUnlockFile(
  IN HANDLE FileHandle,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  IN PULARGE_INTEGER LockOffset,
  IN PULARGE_INTEGER LockLength,
  IN ULONG Key
);

NTSYSAPI
NTSTATUS
NTAPI
ZwDeviceIoControlFile(
  IN HANDLE FileHandle,
  IN HANDLE Event OPTIONAL,
  IN PIO_APC_ROUTINE ApcRoutine OPTIONAL,
  IN PVOID ApcContext OPTIONAL,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  IN ULONG IoControlCode,
  IN PVOID InputBuffer OPTIONAL,
  IN ULONG InputBufferLength,
  OUT PVOID OutputBuffer OPTIONAL,
  IN ULONG OutputBufferLength
);

NTSYSAPI
NTSTATUS
NTAPI
ZwFsControlFile(
  IN HANDLE FileHandle,
  IN HANDLE Event OPTIONAL,
  IN PIO_APC_ROUTINE ApcRoutine OPTIONAL,
  IN PVOID ApcContext OPTIONAL,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  IN ULONG FsControlCode,
  IN PVOID InputBuffer OPTIONAL,
  IN ULONG InputBufferLength,
  OUT PVOID OutputBuffer OPTIONAL,
  IN ULONG OutputBufferLength
);

NTSYSAPI
NTSTATUS
NTAPI
ZwNotifyChangeDirectoryFile(
  IN HANDLE FileHandle,
  IN HANDLE Event OPTIONAL,
  IN PIO_APC_ROUTINE ApcRoutine OPTIONAL,
  IN PVOID ApcContext OPTIONAL,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  OUT PFILE_NOTIFY_INFORMATION Buffer,
  IN ULONG BufferLength,
  IN ULONG NotifyFilter,
  IN BOOLEAN WatchSubtree
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryEaFile(
  IN HANDLE FileHandle,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  OUT PFILE_FULL_EA_INFORMATION Buffer,
  IN ULONG BufferLength,
  IN BOOLEAN ReturnSingleEntry,
  IN PFILE_GET_EA_INFORMATION EaList OPTIONAL,
  IN ULONG EaListLength,
  IN PULONG EaIndex OPTIONAL,
  IN BOOLEAN RestartScan
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetEaFile(
  IN HANDLE FileHandle,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  IN PFILE_FULL_EA_INFORMATION Buffer,
  IN ULONG BufferLength
);

NTSYSAPI
NTSTATUS
NTAPI
ZwCreateNamedPipeFile(
  OUT PHANDLE FileHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  IN ULONG ShareAccess,
  IN ULONG CreateDisposition,
  IN ULONG CreateOptions,
  IN BOOLEAN TypeMessage,
  IN BOOLEAN ReadmodeMessage,
  IN BOOLEAN Nonblocking,
  IN ULONG MaxInstances,
  IN ULONG InBufferSize,
  IN ULONG OutBufferSize,
  IN PLARGE_INTEGER DefaultTimeout OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwCreateMailslotFile(
  OUT PHANDLE FileHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  IN ULONG CreateOptions,
  IN ULONG Unknown,
  IN ULONG MaxMessageSize,
  IN PLARGE_INTEGER ReadTimeout OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryVolumeInformationFile(
  IN HANDLE FileHandle,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  OUT PVOID VolumeInformation,
  IN ULONG VolumeInformationLength,
  IN FS_INFORMATION_CLASS VolumeInformationClass
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetVolumeInformationFile(
  IN HANDLE FileHandle,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  IN PVOID Buffer,
  IN ULONG BufferLength,
  IN FS_INFORMATION_CLASS VolumeInformationClass
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryQuotaInformationFile(
  IN HANDLE FileHandle,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  OUT PFILE_USER_QUOTA_INFORMATION Buffer,
  IN ULONG BufferLength,
  IN BOOLEAN ReturnSingleEntry,
  IN PFILE_QUOTA_LIST_INFORMATION QuotaList OPTIONAL,
  IN ULONG QuotaListLength,
  IN PSID ResumeSid OPTIONAL,
  IN BOOLEAN RestartScan
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetQuotaInformationFile(
  IN HANDLE FileHandle,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  IN PFILE_USER_QUOTA_INFORMATION Buffer,
  IN ULONG BufferLength
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryAttributesFile(
  IN POBJECT_ATTRIBUTES ObjectAttributes,
  OUT PFILE_BASIC_INFORMATION FileInformation
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryFullAttributesFile(
  IN POBJECT_ATTRIBUTES ObjectAttributes,
  OUT PFILE_NETWORK_OPEN_INFORMATION FileInformation
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryInformationFile(
  IN HANDLE FileHandle,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  OUT PVOID FileInformation,
  IN ULONG FileInformationLength,
  IN FILE_INFORMATION_CLASS FileInformationClass
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetInformationFile(
  IN HANDLE FileHandle,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  IN PVOID FileInformation,
  IN ULONG FileInformationLength,
  IN FILE_INFORMATION_CLASS FileInformationClass
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryDirectoryFile(
  IN HANDLE FileHandle,
  IN HANDLE Event OPTIONAL,
  IN PIO_APC_ROUTINE ApcRoutine OPTIONAL,
  IN PVOID ApcContext OPTIONAL,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  OUT PVOID FileInformation,
  IN ULONG FileInformationLength,
  IN FILE_INFORMATION_CLASS FileInformationClass,
  IN BOOLEAN ReturnSingleEntry,
  IN PUNICODE_STRING FileName OPTIONAL,
  IN BOOLEAN RestartScan
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryOleDirectoryFile(
  IN HANDLE FileHandle,
  IN HANDLE Event OPTIONAL,
  IN PIO_APC_ROUTINE ApcRoutine OPTIONAL,
  IN PVOID ApcContext OPTIONAL,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  OUT PVOID Buffer,
  IN ULONG BufferLength,
  IN FILE_INFORMATION_CLASS FileInformationClass,
  IN BOOLEAN ReturnSingleEntry,
  IN PUNICODE_STRING FileName,
  IN BOOLEAN RestartScan
);

/*registry*/
NTSYSAPI
NTSTATUS
NTAPI
ZwCreateKey(
  OUT PHANDLE KeyHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes,
  IN ULONG TitleIndex,
  IN PUNICODE_STRING Class OPTIONAL,
  IN ULONG CreateOptions,
  OUT PULONG Disposition OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwOpenKey(
  OUT PHANDLE KeyHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_ATTRIBUTES ObjectAttributes
);

NTSYSAPI
NTSTATUS
NTAPI
ZwDeleteKey(
  IN HANDLE KeyHandle
);

NTSYSAPI
NTSTATUS
NTAPI
ZwFlushKey(
  IN HANDLE KeyHandle
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSaveKey(
  IN HANDLE KeyHandle,
  IN HANDLE FileHandle
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSaveMergedKeys(
  IN HANDLE KeyHandle1,
  IN HANDLE KeyHandle2,
  IN HANDLE FileHandle
);

NTSYSAPI
NTSTATUS
NTAPI
ZwRestoreKey(
  IN HANDLE KeyHandle,
  IN HANDLE FileHandle,
  IN ULONG Flags
);

NTSYSAPI
NTSTATUS
NTAPI
ZwLoadKey(
  IN POBJECT_ATTRIBUTES KeyObjectAttributes,
  IN POBJECT_ATTRIBUTES FileObjectAttributes
);

NTSYSAPI
NTSTATUS
NTAPI
ZwLoadKey2(
  IN POBJECT_ATTRIBUTES KeyObjectAttributes,
  IN POBJECT_ATTRIBUTES FileObjectAttributes,
  IN ULONG Flags
);

NTSYSAPI
NTSTATUS
NTAPI
ZwUnloadKey(
  IN POBJECT_ATTRIBUTES KeyObjectAttributes
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryOpenSubKeys(
  IN POBJECT_ATTRIBUTES KeyObjectAttributes,
  OUT PULONG NumberOfKeys
);

NTSYSAPI
NTSTATUS
NTAPI
ZwReplaceKey(
  IN POBJECT_ATTRIBUTES NewFileObjectAttributes,
  IN HANDLE KeyHandle,
  IN POBJECT_ATTRIBUTES OldFileObjectAttributes
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetInformationKey(
  IN HANDLE KeyHandle,
  IN KEY_SET_INFORMATION_CLASS KeyInformationClass,
  IN PVOID KeyInformation,
  IN ULONG KeyInformationLength
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryKey(
  IN HANDLE KeyHandle,
  IN KEY_INFORMATION_CLASS KeyInformationClass,
  OUT PVOID KeyInformation,
  IN ULONG KeyInformationLength,
  OUT PULONG ResultLength
);

NTSYSAPI
NTSTATUS
NTAPI
ZwEnumerateKey(
  IN HANDLE KeyHandle,
  IN ULONG Index,
  IN KEY_INFORMATION_CLASS KeyInformationClass,
  OUT PVOID KeyInformation,
  IN ULONG KeyInformationLength,
  OUT PULONG ResultLength
);

NTSYSAPI
NTSTATUS
NTAPI
ZwNotifyChangeKey(
  IN HANDLE KeyHandle,
  IN HANDLE EventHandle OPTIONAL,
  IN PIO_APC_ROUTINE ApcRoutine OPTIONAL,
  IN PVOID ApcContext OPTIONAL,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  IN ULONG NotifyFilter,
  IN BOOLEAN WatchSubtree,
  IN PVOID Buffer,
  IN ULONG BufferLength,
  IN BOOLEAN Asynchronous
);

NTSYSAPI
NTSTATUS
NTAPI
ZwNotifyChangeMultipleKeys(
  IN HANDLE KeyHandle,
  IN ULONG Flags,
  IN POBJECT_ATTRIBUTES KeyObjectAttributes,
  IN HANDLE EventHandle OPTIONAL,
  IN PIO_APC_ROUTINE ApcRoutine OPTIONAL,
  IN PVOID ApcContext OPTIONAL,
  OUT PIO_STATUS_BLOCK IoStatusBlock,
  IN ULONG NotifyFilter,
  IN BOOLEAN WatchSubtree,
  IN PVOID Buffer,
  IN ULONG BufferLength,
  IN BOOLEAN Asynchronous
);

NTSYSAPI
NTSTATUS
NTAPI
ZwDeleteValueKey(
  IN HANDLE KeyHandle,
  IN PUNICODE_STRING ValueName
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetValueKey(
  IN HANDLE KeyHandle,
  IN PUNICODE_STRING ValueName,
  IN ULONG TitleIndex,
  IN ULONG Type,
  IN PVOID Data,
  IN ULONG DataSize
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryValueKey(
  IN HANDLE KeyHandle,
  IN PUNICODE_STRING ValueName,
  IN KEY_VALUE_INFORMATION_CLASS KeyValueInformationClass,
  OUT PVOID KeyValueInformation,
  IN ULONG KeyValueInformationLength,
  OUT PULONG ResultLength
);

NTSYSAPI
NTSTATUS
NTAPI
ZwEnumerateValueKey(
  IN HANDLE KeyHandle,
  IN ULONG Index,
  IN KEY_VALUE_INFORMATION_CLASS KeyValueInformationClass,
  OUT PVOID KeyValueInformation,
  IN ULONG KeyValueInformationLength,
  OUT PULONG ResultLength
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryMultipleValueKey(
  IN HANDLE KeyHandle,
  IN OUT PKEY_VALUE_ENTRY ValueList,
  IN ULONG NumberOfValues,
  OUT PVOID Buffer,
  IN OUT PULONG Length,
  OUT PULONG ReturnLength
);

NTSYSAPI
NTSTATUS
NTAPI
ZwInitializeRegistry(
  IN BOOLEAN Setup
);
/*security and auditing*/
NTSYSAPI
NTSTATUS
NTAPI
ZwPrivilegeCheck(
  IN HANDLE TokenHandle,
  IN PPRIVILEGE_SET RequiredPrivileges,
  OUT PBOOLEAN Result
);

NTSYSAPI
NTSTATUS
NTAPI
ZwPrivilegeObjectAuditAlarm(
  IN PUNICODE_STRING SubsystemName,
  IN PVOID HandleId,
  IN HANDLE TokenHandle,
  IN ACCESS_MASK DesiredAccess,
  IN PPRIVILEGE_SET Privileges,
  IN BOOLEAN AccessGranted
);


NTSYSAPI
NTSTATUS
NTAPI
ZwPrivilegedServiceAuditAlarm(
  IN PUNICODE_STRING SubsystemName,
  IN PUNICODE_STRING ServiceName,
  IN HANDLE TokenHandle,
  IN PPRIVILEGE_SET Privileges,
  IN BOOLEAN AccessGranted
);

NTSYSAPI
NTSTATUS
NTAPI
ZwAccessCheck(
  IN PSECURITY_DESCRIPTOR SecurityDescriptor,
  IN HANDLE TokenHandle,
  IN ACCESS_MASK DesiredAccess,
  IN PGENERIC_MAPPING GenericMapping,
  IN PPRIVILEGE_SET PrivilegeSet,
  IN PULONG PrivilegeSetLength,
  OUT ACCESS_MASK *GrantedAccess,
  OUT PBOOLEAN AccessStatus
);

NTSYSAPI
NTSTATUS
NTAPI
ZwAccessCheckAndAuditAlarm(
  IN PUNICODE_STRING SubsystemName,
  IN PVOID HandleId,
  IN PUNICODE_STRING ObjectTypeName,
  IN PUNICODE_STRING ObjectName,
  IN PSECURITY_DESCRIPTOR SecurityDescriptor,
  IN ACCESS_MASK DesiredAccess,
  IN PGENERIC_MAPPING GenericMapping,
  IN BOOLEAN ObjectCreation,
  OUT ACCESS_MASK *GrantedAccess,
  OUT PBOOLEAN AccessStatus,
  OUT PBOOLEAN GenerateOnClose
);

NTSYSAPI
NTSTATUS
NTAPI
ZwAccessCheckByType(
  IN PSECURITY_DESCRIPTOR SecurityDescriptor,
  IN PSID PrincipalSelfSid,
  IN HANDLE TokenHandle,
  IN ULONG DesiredAccess,
  IN POBJECT_TYPE_LIST ObjectTypeList,
  IN ULONG ObjectTypeListLength,
  IN PGENERIC_MAPPING GenericMapping,
  IN PPRIVILEGE_SET PrivilegeSet,
  IN PULONG PrivilegeSetLength,
  OUT ACCESS_MASK *GrantedAccess,
  OUT PULONG AccessStatus
);

NTSYSAPI
NTSTATUS
NTAPI
ZwAccessCheckByTypeAndAuditAlarm(
  IN PUNICODE_STRING SubsystemName,
  IN PVOID HandleId,
  IN PUNICODE_STRING ObjectTypeName,
  IN PUNICODE_STRING ObjectName,
  IN PSECURITY_DESCRIPTOR SecurityDescriptor,
  IN PSID PrincipalSelfSid,
  IN ACCESS_MASK DesiredAccess,
  IN AUDIT_EVENT_TYPE AuditType,
  IN ULONG Flags,
  IN POBJECT_TYPE_LIST ObjectTypeList,
  IN ULONG ObjectTypeListLength,
  IN PGENERIC_MAPPING GenericMapping,
  IN BOOLEAN ObjectCreation,
  OUT ACCESS_MASK *GrantedAccess,
  OUT PULONG AccessStatus,
  OUT PBOOLEAN GenerateOnClose
);

NTSYSAPI
NTSTATUS
NTAPI
ZwAccessCheckByTypeResultList(
  IN PSECURITY_DESCRIPTOR SecurityDescriptor,
  IN PSID PrincipalSelfSid,
  IN HANDLE TokenHandle,
  IN ACCESS_MASK DesiredAccess,
  IN POBJECT_TYPE_LIST ObjectTypeList,
  IN ULONG ObjectTypeListLength,
  IN PGENERIC_MAPPING GenericMapping,
  IN PPRIVILEGE_SET PrivilegeSet,
  IN PULONG PrivilegeSetLength,
  OUT ACCESS_MASK *GrantedAccessList,
  OUT PULONG AccessStatusList
);

NTSYSAPI
NTSTATUS
NTAPI
ZwAccessCheckByTypeResultListAndAuditAlarm(
  IN PUNICODE_STRING SubsystemName,
  IN PVOID HandleId,
  IN PUNICODE_STRING ObjectTypeName,
  IN PUNICODE_STRING ObjectName,
  IN PSECURITY_DESCRIPTOR SecurityDescriptor,
  IN PSID PrincipalSelfSid,
  IN ACCESS_MASK DesiredAccess,
  IN AUDIT_EVENT_TYPE AuditType,
  IN ULONG Flags,
  IN POBJECT_TYPE_LIST ObjectTypeList,
  IN ULONG ObjectTypeListLength,
  IN PGENERIC_MAPPING GenericMapping,
  IN BOOLEAN ObjectCreation,
  OUT ACCESS_MASK *GrantedAccessList,
  OUT PULONG AccessStatusList,
  OUT PULONG GenerateOnClose
);

NTSYSAPI
NTSTATUS
NTAPI
ZwAccessCheckByTypeResultListAndAuditAlarmByHandle(
  IN PUNICODE_STRING SubsystemName,
  IN PVOID HandleId,
  IN HANDLE TokenHandle,
  IN PUNICODE_STRING ObjectTypeName,
  IN PUNICODE_STRING ObjectName,
  IN PSECURITY_DESCRIPTOR SecurityDescriptor,
  IN PSID PrincipalSelfSid,
  IN ACCESS_MASK DesiredAccess,
  IN AUDIT_EVENT_TYPE AuditType,
  IN ULONG Flags,
  IN POBJECT_TYPE_LIST ObjectTypeList,
  IN ULONG ObjectTypeListLength,
  IN PGENERIC_MAPPING GenericMapping,
  IN BOOLEAN ObjectCreation,
  OUT ACCESS_MASK *GrantedAccessList,
  OUT PULONG AccessStatusList,
  OUT PULONG GenerateOnClose
);

NTSYSAPI
NTSTATUS
NTAPI
ZwOpenObjectAuditAlarm(
  IN PUNICODE_STRING SubsystemName,
  IN PVOID *HandleId,
  IN PUNICODE_STRING ObjectTypeName,
  IN PUNICODE_STRING ObjectName,
  IN PSECURITY_DESCRIPTOR SecurityDescriptor,
  IN HANDLE TokenHandle,
  IN ACCESS_MASK DesiredAccess,
  IN ACCESS_MASK GrantedAccess,
  IN PPRIVILEGE_SET Privileges OPTIONAL,
  IN BOOLEAN ObjectCreation,
  IN BOOLEAN AccessGranted,
  OUT PBOOLEAN GenerateOnClose
);

NTSYSAPI
NTSTATUS
NTAPI
ZwCloseObjectAuditAlarm(
  IN PUNICODE_STRING SubsystemName,
  IN PVOID HandleId,
  IN BOOLEAN GenerateOnClose
);

NTSYSAPI
NTSTATUS
NTAPI
ZwDeleteObjectAuditAlarm(
  IN PUNICODE_STRING SubsystemName,
  IN PVOID HandleId,
  IN BOOLEAN GenerateOnClose
);

/*plug and play and power managment*/

NTSYSAPI
NTSTATUS
NTAPI
ZwRequestWakeupLatency(
  IN LATENCY_TIME Latency
);

NTSYSAPI
NTSTATUS
NTAPI
ZwRequestDeviceWakeup(
  IN HANDLE DeviceHandle
);

NTSYSAPI
NTSTATUS
NTAPI
ZwCancelDeviceWakeupRequest(
  IN HANDLE DeviceHandle
);

NTSYSAPI
BOOLEAN
NTAPI
ZwIsSystemResumeAutomatic(
  VOID
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetThreadExecutionState(
  IN EXECUTION_STATE ExecutionState,
  OUT PEXECUTION_STATE PreviousExecutionState
);

NTSYSAPI
NTSTATUS
NTAPI
ZwGetDevicePowerState(
  IN HANDLE DeviceHandle,
  OUT PDEVICE_POWER_STATE DevicePowerState
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetSystemPowerState(
  IN POWER_ACTION SystemAction,
  IN SYSTEM_POWER_STATE MinSystemState,
  IN ULONG Flags
);

NTSYSAPI
NTSTATUS
NTAPI
ZwInitiatePowerAction(
  IN POWER_ACTION SystemAction,
  IN SYSTEM_POWER_STATE MinSystemState,
  IN ULONG Flags,
  IN BOOLEAN Asynchronous
);

NTSYSAPI
NTSTATUS
NTAPI
ZwPowerInformation(
  IN POWER_INFORMATION_LEVEL PowerInformationLevel,
  IN PVOID InputBuffer OPTIONAL,
  IN ULONG InputBufferLength,
  OUT PVOID OutputBuffer OPTIONAL,
  IN ULONG OutputBufferLength
);

NTSYSAPI
NTSTATUS
NTAPI
ZwPlugPlayControl(
  IN ULONG ControlCode,
  IN OUT PVOID Buffer,
  IN ULONG BufferLength,
  OUT PULONG ReturnLength
);

NTSYSAPI
NTSTATUS
NTAPI
ZwGetPlugPlayEvent(
  IN ULONG Reserved1,
  IN ULONG Reserved2,
  OUT PVOID Buffer,
  IN ULONG BufferLength
);

/*miscellany*/

NTSYSAPI
NTSTATUS
NTAPI
ZwRaiseException(
  IN PEXCEPTION_RECORD ExceptionRecord,
  IN PCONTEXT Context,
  IN BOOLEAN SearchFrames
);

NTSYSAPI
NTSTATUS
NTAPI
ZwContinue(
  IN PCONTEXT Context,
  IN BOOLEAN TestAlert
);

NTSYSAPI
NTSTATUS
NTAPI
ZwW32Call(
  IN ULONG RoutineIndex,
  IN PVOID Argument,
  IN ULONG ArgumentLength,
  OUT PVOID *Result OPTIONAL,
  OUT PULONG ResultLength OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwCallbackReturn(
  IN PVOID Result OPTIONAL,
  IN ULONG ResultLength,
  IN NTSTATUS Status
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetLowWaitHighThread(
  VOID
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetHighWaitLowThread(
  VOID
);

NTSYSAPI
NTSTATUS
NTAPI
ZwLoadDriver(
  IN PUNICODE_STRING DriverServiceName
);

NTSYSAPI
NTSTATUS
NTAPI
ZwUnloadDriver(
  IN PUNICODE_STRING DriverServiceName
);

NTSYSAPI
NTSTATUS
NTAPI
ZwFlushInstructionCache(
  IN HANDLE ProcessHandle,
  IN PVOID BaseAddress OPTIONAL,
  IN ULONG FlushSize
);

NTSYSAPI
NTSTATUS
NTAPI
ZwFlushWriteBuffer(
  VOID
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryDefaultLocale(
  IN BOOLEAN ThreadOrSystem,
  OUT PLCID Locale
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetDefaultLocale(
  IN BOOLEAN ThreadOrSystem,
  IN LCID Locale
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryDefaultUILanguage(
  OUT LANGID *LanguageId
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetDefaultUILanguage(
  IN LANGID LanguageId
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryInstallUILanguage(
  OUT LANGID *LanguageId
);

NTSYSAPI
NTSTATUS
NTAPI
ZwAllocateLocallyUniqueId(
  OUT PLUID Luid
);

NTSYSAPI
NTSTATUS
NTAPI
ZwAllocateUuids(
  OUT PLARGE_INTEGER UuidLastTimeAllocated,
  OUT PULONG UuidDeltaTime,
  OUT PULONG UuidSequenceNumber,
  OUT PUCHAR UuidSeed //not in NT4
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetUuidSeed(
  IN PUCHAR UuidSeed
);

NTSYSAPI
NTSTATUS
NTAPI
ZwRaiseHardError(
  IN NTSTATUS Status,
  IN ULONG NumberOfArguments,
  IN ULONG StringArgumentsMask,
  IN PULONG Arguments,
  IN HARDERROR_RESPONSE_OPTION ResponseOption,
  OUT PHARDERROR_RESPONSE Response
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetDefaultHardErrorPort(
  IN HANDLE PortHandle
);

NTSYSAPI
NTSTATUS
NTAPI
ZwDisplayString(
  IN PUNICODE_STRING String
);

NTSYSAPI
NTSTATUS
NTAPI
ZwCreatePagingFile(
  IN PUNICODE_STRING FileName,
  IN PULARGE_INTEGER InitialSize,
  IN PULARGE_INTEGER MaximumSize,
  IN ULONG Reserved
);

NTSYSAPI
NTSTATUS
NTAPI
ZwAddAtom(
  IN PWSTR String,
  IN ULONG StringLength, //not in NT4
  OUT PUSHORT Atom
);

NTSYSAPI
NTSTATUS
NTAPI
ZwFindAtom(
  IN PWSTR String,
  IN ULONG StringLength, //not in NT4
  OUT PUSHORT Atom
);

NTSYSAPI
NTSTATUS
NTAPI
ZwDeleteAtom(
  IN USHORT Atom
);

NTSYSAPI
NTSTATUS
NTAPI
ZwQueryInformationAtom(
  IN USHORT Atom,
  IN ATOM_INFORMATION_CLASS AtomInformationClass,
  OUT PVOID AtomInformation,
  IN ULONG AtomInformationLength,
  OUT PULONG ReturnLength OPTIONAL
);

NTSYSAPI
NTSTATUS
NTAPI
ZwSetLdtEntries(
  IN ULONG Selector1,
  IN LDT_ENTRY LdtEntry1,
  IN ULONG Selector2,
  IN LDT_ENTRY LdtEntry2
);

NTSYSAPI
NTSTATUS
NTAPI
ZwVdmControl(
  IN ULONG ControlCode,
  IN PVOID ControlData
);
/***** zw finish *****/

/***** rtl start  *****/
/*error*/

NTSYSAPI
ULONG
NTAPI
RtlNtStatusToDosError (
  IN NTSTATUS Status
);

/*unicode string*/

NTSYSAPI
NTSTATUS
NTAPI
RtlCharToInteger(
  PCSZ String,
  ULONG Base,
  PULONG Value
);

NTSYSAPI
NTSTATUS
NTAPI
RtlIntegerToUnicodeString(
  ULONG Value,
  ULONG Base,
  PUNICODE_STRING String
);

NTSYSAPI
NTSTATUS
NTAPI
RtlInt64ToUnicodeString(
  IN ULONGLONG Value,
  IN ULONG Base OPTIONAL,
  IN OUT PUNICODE_STRING String
);

NTSYSAPI
NTSTATUS
NTAPI
RtlUnicodeStringToInteger(
  PUNICODE_STRING String,
  ULONG Base,
  PULONG Value
);

NTSYSAPI
NTSTATUS
NTAPI
RtlUnicodeStringToAnsiString(
  PANSI_STRING DestinationString,
  PUNICODE_STRING SourceString,
  BOOLEAN AllocateDestinationString
);

NTSYSAPI
LONG
NTAPI
RtlCompareUnicodeString(
  PUNICODE_STRING String1,
  PUNICODE_STRING String2,
  BOOLEAN CaseInSensitive
);

NTSYSAPI
BOOLEAN
NTAPI
RtlEqualUnicodeString(
  const UNICODE_STRING *String1,
  const UNICODE_STRING *String2,
  BOOLEAN CaseInSensitive
);

NTSYSAPI
BOOLEAN
NTAPI
RtlPrefixUnicodeString(
  IN PUNICODE_STRING String1,
  IN PUNICODE_STRING String2,
  IN BOOLEAN CaseInSensitive
);

NTSYSAPI
NTSTATUS
NTAPI
RtlUpcaseUnicodeString(
  PUNICODE_STRING DestinationString,
  PCUNICODE_STRING SourceString,
  BOOLEAN AllocateDestinationString
);


NTSYSAPI
VOID
NTAPI
RtlCopyUnicodeString(
  PUNICODE_STRING DestinationString,
  PUNICODE_STRING SourceString
);

NTSYSAPI
NTSTATUS
NTAPI
RtlAppendUnicodeStringToString(
  PUNICODE_STRING Destination,
  PUNICODE_STRING Source
);

NTSYSAPI
NTSTATUS
NTAPI
RtlAppendUnicodeToString (
  PUNICODE_STRING Destination,
  PCWSTR Source
);

NTSYSAPI
NTSTATUS
NTAPI
RtlConvertSidToUnicodeString(
  OUT PUNICODE_STRING DestinationString,
  IN PSID Sid,
  IN BOOLEAN AllocateDestinationString
);

NTSYSAPI
VOID
NTAPI
RtlFreeUnicodeString(
  PUNICODE_STRING UnicodeString
);

NTSYSAPI
VOID
NTAPI
RtlInitString(
  PSTRING DestinationString,
  PCSZ SourceString
);

NTSYSAPI
VOID
NTAPI
RtlInitAnsiString(
  PANSI_STRING DestinationString,
  PCSZ SourceString
);

NTSYSAPI
VOID
NTAPI
RtlInitUnicodeString(
  PUNICODE_STRING DestinationString,
  PCWSTR SourceString
);


NTSYSAPI
VOID
NTAPI
RtlCopyString(
  PSTRING DestinationString,
  PSTRING SourceString
);

NTSYSAPI
CHAR
NTAPI
RtlUpperChar(
  CHAR Character
);

NTSYSAPI
LONG
NTAPI
RtlCompareString(
  PSTRING String1,
  PSTRING String2,
  BOOLEAN CaseInSensitive
);

NTSYSAPI
BOOLEAN
NTAPI
RtlEqualString(
  PSTRING String1,
  PSTRING String2,
  BOOLEAN CaseInSensitive
);

NTSYSAPI
VOID
NTAPI
RtlUpperString(
  PSTRING DestinationString,
  PSTRING SourceString
);

NTSYSAPI
NTSTATUS
NTAPI
RtlAnsiStringToUnicodeString(
  PUNICODE_STRING DestinationString,
  PANSI_STRING SourceString,
  BOOLEAN AllocateDestinationString
);

NTSYSAPI
WCHAR
NTAPI
RtlUpcaseUnicodeChar(
  WCHAR SourceCharacter
);

NTSYSAPI
VOID
NTAPI
RtlFreeAnsiString(
  PANSI_STRING AnsiString
);

NTSYSAPI
ULONG
NTAPI
RtlxAnsiStringToUnicodeSize(
  PANSI_STRING AnsiString
);

NTSYSAPI
NTSTATUS
NTAPI
RtlStringFromGUID(
  IN REFGUID Guid,
  OUT PUNICODE_STRING GuidString
);

NTSYSAPI
NTSTATUS
NTAPI
RtlGUIDFromString(
  IN PUNICODE_STRING GuidString,
  OUT GUID* Guid
);

/*path*/

NTSYSAPI
NTSTATUS
NTAPI
RtlDosPathNameToNtPathName_U(
  IN PCWSTR DosPathName,
  OUT PUNICODE_STRING NtPathName,
  OUT PWSTR* FilePathInNtPathName OPTIONAL,
  OUT PVOID* RelativeName OPTIONAL
);

/*processes*/

NTSTATUS
NTAPI
RtlCreateProcessParameters(
  OUT PPROCESS_PARAMETERS *ProcessParameters,
  IN PUNICODE_STRING ImageFile,
  IN PUNICODE_STRING DllPath OPTIONAL,
  IN PUNICODE_STRING CurrentDirectory OPTIONAL,
  IN PUNICODE_STRING CommandLine OPTIONAL,
  IN ULONG CreationFlags,
  IN PUNICODE_STRING WindowTitle OPTIONAL,
  IN PUNICODE_STRING Desktop OPTIONAL,
  IN PUNICODE_STRING Reserved OPTIONAL,
  IN PUNICODE_STRING Reserved2 OPTIONAL
);

NTSTATUS
NTAPI
RtlDestroyProcessParameters(
  IN PPROCESS_PARAMETERS ProcessParameters
);

PDEBUG_BUFFER
NTAPI
RtlCreateQueryDebugBuffer(
  IN ULONG Size,
  IN BOOLEAN EventPair
);

NTSTATUS
NTAPI
RtlQueryProcessDebugInformation(
  IN ULONG ProcessId,
  IN ULONG DebugInfoClassMask,
  IN OUT PDEBUG_BUFFER DebugBuffer
);

NTSTATUS
NTAPI
RtlDestroyQueryDebugBuffer(
  IN PDEBUG_BUFFER DebugBuffer
);
/***** rtl finish *****/

/***** Dbg start  *****/
ULONG
_cdecl
DbgPrint(
  PCH Format,
  ...
);
/***** Dbg finish *****/

#ifdef __cplusplus
};
#endif

#endif // _NTDLL_
