/*
   TTDECODE 1.02 (slightly fixed version)
   Written by Tom Torfs (2:292/516@fidonet.org)
   I hereby donate this code to the public domain

   Thanks to Arnold Hendriks (2:282/502.1@fidonet.org) for pointing
   out some potential problems and for contributing some ideas & code

   The CRC-16 routines are based on CRC-16.C from Snippets 10/95

   This code compiles without problems under Borland C++ 3.0 and
   Turbo C++ 1.0; probably other compilers require some changes
   Feel free to add the necessary #ifdef's and redistribute

   The compiler & OS-specific parts of this code are:
      - the get/set file time functions
      - I think getc(stdin) is DOS-only
      - filenames are converted to uppercase; remove the strupr() calls
 for case sensitive OSes
*/

/* TTCODE encoded file structure:

   TTCODE <name of software used to encode the file>

   FILE <filename> <size in bytes> <filedate DD-MM-YYYY> <filetime HH:MM>
   X <hex codes of the excluded characters, separated by spaces>

   SECTION <section number (base 1)>/<sections>
   T<encoded data>
   ...
   END CRC16=<section-CRC in hex>

   all statements are case sensitive

   everything before the TTCODE statement and after the END statement is
   ignored

   every TTcoded file must have the TTCODE statement in it; if this
   statement is missing TTDECODE will say the file doesn't contain
   any TTcoded data

   the FILE and X statements must come between the TTCODE statement and
   before the first SECTION statement
   the FILE statement must be the same in all sections, otherwise
   TTDECODE will give a warning
   the X statements may be different for every section, and the specified
   values will be used for that section (this allows to optimize every
   section separately, although TTCODE doesn't do this)

   the 37 excluded hex codes may be spread over multiple lines; however
   there must be exactly 37 hex codes, no more, no less

   there must be exactly one section per file, and TTDECODE requires the
   section files to have extensions 001,002,etc. (the first section may
   have another extension)
*/

/* TTCODE encoded data format

   219 of the 256 characters will be remapped to a character set with only
   219 characters; the following have been removed:
      0..31 (control codes), 32 (space), 127 (delete), 141 (soft return)
      and 255 (fixed space)

   the other 37 characters are encoded with 2 bytes: one id-byte, which is
   character 254, followed by the number of the excluded character (0..36)
   which is remapped to the encoded character set (which simply means adding
   33 here)

   the 37 least frequently used characters are picked as the excluded
   characters, since they take 2 encoded characters instead of 1

   each encoded data line contains the 'T' signature plus 59 code bytes
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>
#include <io.h>
#include <dos.h>
#include <ctype.h>

#define CRCPOLY 0x8408

#define FIRSTCHAR 33
#define DELETE 127
#define SOFTRETURN 141
#define MAXCHARS 219
#define EXCLUDED 37
#define XCHARID 254

#define BYTESPERLINE 59

#define MAXFILENAMELEN 80
#define MAXLINESIZE 256
#define BUFSIZE 512
#define CHARACTERS 256

char *binfile,*ttfile;
unsigned char *buf;
unsigned char *s;
int *convtable;
int *excluded,*isexcl;

unsigned crc;

/* calculate the CRC-16 for a single byte */
void crc16(int data)
{
   register int i;
   
   for (i = 0; i<8; i++, data >>= 1)
   {
      if ((crc & 0x0001) ^ (data & 0x0001))
         crc = (crc >> 1) ^ CRCPOLY;
      else
         crc >>= 1;
   }
}

void *checkmalloc(unsigned size)
{
   void *ptr;
   
   ptr = malloc(size);
   if (ptr==NULL)
   {
      printf("Not enough memory :-(\n");
      exit(1);
   }
   
   return ptr;
}

void allocdata(void)
{
   binfile = checkmalloc(MAXFILENAMELEN);
   ttfile = checkmalloc(MAXFILENAMELEN);
   buf = checkmalloc(BUFSIZE);
   s = checkmalloc(MAXLINESIZE);
   convtable = checkmalloc(sizeof(int)*CHARACTERS);
   excluded = checkmalloc(sizeof(int)*EXCLUDED);
   isexcl = checkmalloc(sizeof(int)*CHARACTERS);
}

void freedata(void)
{
   free(isexcl);
   free(excluded);
   free(convtable);
   free(s);
   free(buf);
   free(ttfile);
   free(binfile);
}

/* void because exit() is used */
void main(int argc, char *argv[])
{
   #define FIRSTCHAR 33
   #define DELETE 127
   #define SOFTRETURN 141
   #define MAXCHARS 219
   #define EXCLUDED 37
   #define XCHARID 254
      
   #define BUFSIZE 512
      
   char drive[4],path[68],name[9],ext[5];
   char name2[9],ext2[5];
   char *sptr;
   int i,j;
   int sl;
   int xcount;
   FILE *binf,*ttf;
   long fsize,count,bytes;
   int offset;
   int section,sections;
   struct ftime ftime;
   int c;
   int day,month,year,hour,min;
   unsigned goodcrc;
   int xchar;
   int samefile;
   
   if (argc<2)
   {
      puts("TTDECODE 1.02 -- ascii-2-bin encoder\n"
         "Written By Tom Torfs\n\n"
         "Syntax: TTDECODE <TTfile>\n"
         "The TTfile will have the default extension .001.\n"
         "If the TTfile consists of more than one section, the additional sections\n"
         "must have extensions 002, 003, ... upto 999.\n"
         "Alternatively, all sections may be in a single file.");
      exit(1);
   }
   
   allocdata();
   atexit(freedata);
   
   strcpy(ttfile, argv[1]);
   strupr(ttfile);
   fnsplit(ttfile, drive, path, name, ext);
   
   bytes = 0;
   offset = 0;
   xchar = 0;
   
   /* samefile is set to 1, until no more sections are found */
   samefile = 1;
   
   sections = 9999;
   for (section = 1; section<=sections; section++)
   {
      if (section>1 && samefile)
      {
         do
         {
            fgets(s, MAXLINESIZE, ttf);
            if (feof(ttf))
            {
               fclose(ttf);
               samefile = 0;
               goto notsamefile;       /* flame Arnold for this one ;-) */
            }
         }
         while (memcmp(s, "TTCODE", 6)!=0);
         
         puts("Reading some more data..");
         
      } else
      {
      notsamefile:
      if (section>1 || ext[0]=='\0')
         sprintf(ttfile, "%s%s%s.%03d", drive, path, name, section);
      if ((ttf = fopen(ttfile, "rt"))==NULL)
      {
         if (section==1 && !*ext)
         {
            sprintf(ttfile, "%s%s%s", drive, path, name);
            if ((ttf = fopen(ttfile, "rt"))==NULL)
            {
               printf("ERROR: %s not found\n", ttfile);
               exit(2);
            }
         } else
         {
         printf("ERROR: %s not found\n", ttfile);
         exit(2);
      }
      }
      
      do
      {
         fgets(s, MAXLINESIZE, ttf);
         if (feof(ttf))
         {
            printf("ERROR: %s contains no TTcoded data\n", ttfile);
            exit(3);
         }
      }
      while (memcmp(s, "TTCODE", 6)!=0);
      
      printf("Reading %s, encoded with %s", ttfile, s + 7);
   }
      
      do
      {
         fgets(s, 256, ttf);
         if (feof(ttf))
         {
            printf("ERROR: %s contains no FILE statement\n", ttfile);
            exit(3);
         }
      }
      while (memcmp(s, "FILE ", 5)!=0);
      
      sptr = strchr(s + 5, ' ');
      if (sptr==NULL)
      {
         printf("ERROR: %s has a syntax error in its FILE statement\n", ttfile);
         exit(3);
      }
      *(sptr++) = '\0';
      
      sscanf(sptr, "%lu %u-%u-%u %u:%u", 
         &count, &day, &month, &year, &hour, &min);
      
      if (section==1)
      {
         strcpy(binfile, s + 5);
         retry_with_other_filename:
         fnsplit(binfile, NULL, NULL, name2, ext2);
         fnmerge(binfile, NULL, NULL, name2, ext2);
         if ((binf = fopen(binfile, "rb"))!=NULL)
         {
            fclose(binf);
            printf("File %s already exists. Overwrite ? (Yes/No/Rename) ", 
               binfile);
            do
               c = toupper(getc(stdin));
            while (c!='Y' && c!='N' && c!='R');
            printf("%c\n", c);
            if (c=='N')
            {
               printf("--> aborted\n");
               exit(2);
            }
            if (c=='R')
            {
               printf("Enter new filename: ");
               fgets(binfile, MAXFILENAMELEN, stdin);
               if (binfile[0]=='\n')
               {
                  printf("--> aborted\n");
                  exit(2);
               }
               binfile[strlen(binfile) - 1] = '\0';
               goto retry_with_other_filename;
               /* flame me for this ;-) */
            }
         }
         if ((binf = fopen(binfile, "wb"))==NULL)
         {
            printf("File %s can't be created !\n", binfile);
            exit(2);
         }
         fsize = count;
         ftime.ft_day = day;
         ftime.ft_month = month;
         ftime.ft_year = year - 1980;
         ftime.ft_hour = hour;
         ftime.ft_min = min;
      }
      else
      {
         fnsplit(s + 5, NULL, NULL, name2, ext2);
         fnmerge(s + 5, NULL, NULL, name2, ext2);
         if (strcmp(binfile, s + 5)!=0
               || day!=ftime.ft_day
               || month!=ftime.ft_month
               || year!=ftime.ft_year + 1980
               || hour!=ftime.ft_hour
               || min!=ftime.ft_min)
         {
            printf("FILE statements mismatch !\n");
            
            fclose(binf);
            remove(binfile);
            exit(3);
         }
      }
      
      /* read excluded characters */
      for (i = 0; i<256; i++) isexcl[i] = 0;
      xcount = 0;
      do
      {
         do
         {
            fgets(s, 256, ttf);
            if (feof(ttf))
            {
               printf("ERROR: %s contains not enough "
                  "excluded characters\n", ttfile);
               
               fclose(binf);
               remove(binfile);
               
               exit(3);
            }
         } while (memcmp(s, "X ", 2)!=0);
         
         sptr = s + 2;
         do
         {
            sscanf(sptr, "%x", &i);
            excluded[xcount++] = i;
            isexcl[i] = 1;
            sptr = strchr(sptr, ' ');
            if (sptr!=NULL)
               sptr++;
         } while (sptr!=NULL && xcount<EXCLUDED);
      } while (xcount<EXCLUDED);
      
      /* build conversion table */
      j = FIRSTCHAR;
      for (i = 0; i<256; i++)
      {
         if (!isexcl[i])
         {
            convtable[j] = i;
            j++;
            if (j==DELETE || j==SOFTRETURN)
               j++;
         }
      }
      
      do
      {
         fgets(s, 256, ttf);
         if (feof(ttf))
         {
            printf("ERROR: %s contains no SECTION statement\n", ttfile);
            exit(3);
         }
      }
      while (memcmp(s, "SECTION ", 8)!=0);
      
      i = 0; j = 0;
      sscanf(s + 8, "%d/%d", &i, &j);
      if (i!=section)
      {
         printf("ERROR: section number mismatch in %s\n", ttfile);
         exit(3);
      }
      if (j==0 || (j!=sections && sections!=9999))
      {
         printf("ERROR: number of sections mismatch in %s\n", ttfile);
         exit(3);
      }
      sections = j;
      
      /* decode the data */
      crc = 0xFFFF;
      while (1)
      {
         fgets(s, 256, ttf);
         if (feof(ttf))
         {
            printf("ERROR: unexpected end-of-file in %s\n", ttfile);
            exit(3);
         }
         if (memcmp(s, "END", 3)==0)
            break;
         if (s[0]!='T')
            continue;
         sl = strlen(s) - 1;
         for (i = 1; i<sl;)
         {
            c = ((unsigned char *)s)[i++];
            if (c==XCHARID)
               xchar = 1;
            else
            {
               if (xchar)
                  c = excluded[c - FIRSTCHAR];
               else
                  c = convtable[c];
               crc16(c);
               bytes++;
               buf[offset++] = c;
               if (offset==BUFSIZE)
               {
                  fwrite(buf, 1, BUFSIZE, binf);
                  offset = 0;
               }
               xchar = 0;
            }
         }
      }
      
      crc = ~crc;
      crc = (crc << 8) | ((crc >> 8) & 0xff);
      
      if (memcmp(s + 4, "CRC16=", 6)!=0)
         printf("WARNING: unknown checksum method\n");
      else
      {
         sscanf(s + 10, "%X", &goodcrc);
         if (crc!=goodcrc)
         {
            printf("\x07*** CRC failed ***\n");
         }
         else
            printf("CRC verified\n");
      }
      if (!samefile) fclose(ttf);
   }
   
   if (offset>0)
      fwrite(buf, 1, offset, binf);
   
   fflush(binf);
   setftime(fileno(binf), &ftime);
   
   fclose(binf);
   
   if (bytes!=fsize)
   {
      printf("\x07ERROR: file size mismatch\n");
      exit(4);
   }
   
   printf("\nRebuilt: %s, %ld bytes, last modified %02d-%02d-%04d %02d:%02d\n", 
      binfile, fsize, 
      ftime.ft_day, ftime.ft_month, ftime.ft_year + 1980, 
      ftime.ft_hour, ftime.ft_min);
   
   exit(0);
}
