////////////////////////////////////////////////////////////////
// If this code works, it was written by Alexander Nazarenko.
// If not, I don't know who wrote it.

#include "winmem.h"
#include "lstring.h"

#include <plugin.hpp>

#include "farintf.h"
#include "scanreg.h"
#include "tbrk-lng.h"
#include "optimize.h"

#include "syslog.h"

#define dimOf(x) (sizeof(x)/sizeof(*(x)))

static PluginPanelItem *List = NULL, *ListPanel = NULL;

static unsigned DiskNumber = 0;
static unsigned DiskCount  = 0;
static unsigned ListCount  = 0;

static int DiskSize = 0;
static int SectSize = 0;
static int RestSize = 0;
static int BreakMax = 0;

static bool IsOldFar = true;

void WINAPI _export GetPluginInfo(struct PluginInfo *Info)
{
  if ( !IsOldFar )
  {
    Info->StructSize=sizeof(*Info);
    Info->Flags=0;
    static const char *PluginMenuStrings[1];
    PluginMenuStrings[0]=GetMsg(MTitle);
    Info->PluginMenuStrings=PluginMenuStrings;
    Info->PluginMenuStringsNumber=dimOf(PluginMenuStrings);
    static const char *PluginCfgStrings[1];
    PluginCfgStrings[0]=GetMsg(MTitle);
    Info->PluginConfigStrings=PluginCfgStrings;
    Info->PluginConfigStringsNumber=dimOf(PluginCfgStrings);
  }
}

int WINAPI _export GetMinFarVersion(void)
{
  /*return FARMANAGERVERSION;*/
  return MAKEFARVERSION(1, 70, 1282);
}

void WINAPI _export SetStartupInfo(const PluginStartupInfo *Info)
{
  ::Info = *Info;
  IsOldFar = true;
  if ( Info->StructSize >= sizeof(PluginStartupInfo) )
  {
    ::FSF = *Info->FSF;
    ::Info.FSF = &::FSF;
    IsOldFar = false;
    FSF.sprintf(PluginRootKey, "%s\\TRUE-BRK", Info->RootKey);
  }
}

static void GetOpt(char *key = "")
{
  DiskSize = GetRegKey(HKEY_CURRENT_USER, key, "DiskSize", 1457664);
  SectSize = GetRegKey(HKEY_CURRENT_USER, key, "SectSize", 512);
  RestSize = GetRegKey(HKEY_CURRENT_USER, key, "RestSize", 512);
  BreakMax = GetRegKey(HKEY_CURRENT_USER, key, "BreakMax", 32);
}

static void PutOpt(char *key = "")
{
  SetRegKey(HKEY_CURRENT_USER, key, "DiskSize", DiskSize);
  SetRegKey(HKEY_CURRENT_USER, key, "SectSize", SectSize);
  SetRegKey(HKEY_CURRENT_USER, key, "RestSize", RestSize);
  SetRegKey(HKEY_CURRENT_USER, key, "BreakMax", BreakMax);
}

static bool addPreset(HKEY, char*, char *key, FarMenuItem *data, int*, void*)
{
  lstrcpy(data->Text, key);
  return false;
}

static char *presetKey = "Presets";

static int ConfigPresets(void)
{
  FarMenuItem *menu = NULL;
  int ret = false, Code, n = 0, BreakKeys[] = { VK_RETURN, VK_DELETE, 0 };
  char key[256], Path[256];
  do
  {
    int Count = MenuFromRegKey(HKEY_CURRENT_USER, presetKey, addPreset, &menu, &n, NULL);
    if ( n < Count )
      menu[n].Selected = true;
    n = Info.Menu(Info.ModuleNumber, -1, -1, 0, FMENU_WRAPMODE, GetMsg(MMenuTop),
                  GetMsg(MMenuBottom), presetKey, BreakKeys, &Code, menu, Count);
    if ( n >= 0 && n < Count )
    {
      FSF.sprintf(key, "%s\\%s", presetKey, lstrcpy(Path, menu[n].Text));
      switch ( Code )
      {
        case 1:          //Delete
          if ( ( n < Count ) && menu[n].Text[0] )
          {
            char itemName[512];
            lstrcpy(itemName, menu[n].Text);
            const char *MsgItems[]={GetMsg(MMenuTop), GetMsg(MDeletePreset), itemName, "\x1", GetMsg(MDelete), GetMsg(MCancel)};
            if ( Info.Message(Info.ModuleNumber, FMSG_WARNING, NULL, MsgItems, dimOf(MsgItems), 2) == 0 )
            {
              FSF.sprintf(key, "%s\\%s", presetKey, Path);
              DeleteRegKey(HKEY_CURRENT_USER, key);
            }
          }
          break;
        default:  //Select
          GetOpt(key);
          n = -1;
          ret = true;
          break;
      }
    }
    if ( menu )
      delete [] menu;
    menu = NULL;
  } while ( n != -1 );
  return ret;
}

int OptionDialog(void)
{
  char s[256], key[256], cDiskSize[512], cSectSize[512], cRestSize[512], cBreakMax[512];
  GetOpt();
  for ( ; ; )
  {
    int useRestSize = RestSize >= 0;
    FSF.sprintf(cDiskSize, "%d", DiskSize);
    FSF.sprintf(cBreakMax, "%d", BreakMax);
    FSF.sprintf(cSectSize, "%d", SectSize);
    if ( RestSize < 0 )
      useRestSize = *cRestSize = 0;
    else
      FSF.sprintf(cRestSize, "%d", RestSize);
    const Y = 7;
    const bOK   = 10;
    const bSave = 11;
    const bLoad = 12;
    struct InitDialogItem InitItems[] =
    {
      { DI_DOUBLEBOX,  3,  1,62,Y+1,0,              0,(char*)MTitle    },
      { DI_TEXT,       5,  2,44,  0,0,              0,(char*)MDiskSize },
      { DI_EDIT,      45,  2,60,  0,0,              0,cDiskSize        }, // 2
      { DI_TEXT,       5,  3,44,  0,0,              0,(char*)MSectSize },
      { DI_EDIT,      45,  3,60,  0,0,              0,cSectSize        }, // 4
      { DI_CHECKBOX,   5,  4,44,  0,useRestSize,    0,(char*)MRestSize }, // 5
      { DI_EDIT,      45,  4,60,  0,0,              0,cRestSize        }, // 6
      { DI_TEXT,       5,  5,44,  0,0,              0,(char*)MBreakMax },
      { DI_EDIT,      45,  5,60,  0,0,              0,cBreakMax        }, // 8
      { DI_TEXT,       5,Y-1, 0,255,0,              0,NULL             },
      { DI_BUTTON,     0,  Y, 0,  0,0,DIF_CENTERGROUP,(char*)MOK       }, //10
      { DI_BUTTON,     0,  Y, 0,  0,0,DIF_CENTERGROUP,(char*)MSave     }, //11
      { DI_BUTTON,     0,  Y, 0,  0,0,DIF_CENTERGROUP,(char*)MLoad     }, //12
      { DI_BUTTON,     0,  Y, 0,  0,0,DIF_CENTERGROUP,(char*)MCancel   }
    };
    int def[] = { bOK, bSave, bLoad, 0 };
    int ExitCode = ExecDialog(InitItems, dimOf(InitItems), 2, def, NULL);
    switch ( ExitCode )
    {
      case bOK:
        DiskSize = FSF.atoi(cDiskSize);
        SectSize = FSF.atoi(cSectSize);
        BreakMax = FSF.atoi(cBreakMax);
        RestSize = InitItems[5].Selected ? FSF.atoi(cRestSize) : -1;
        PutOpt();
        return true;
      case bSave:
        if ( Info.InputBox(GetMsg(MSavePreset), GetMsg(MSaveName), NULL, cDiskSize, s, sizeof(s), NULL, FIB_BUTTONS|FIB_NOAMPERSAND) )
        {
          DiskSize = FSF.atoi(cDiskSize);
          SectSize = FSF.atoi(cSectSize);
          BreakMax = FSF.atoi(cBreakMax);
          RestSize = InitItems[5].Selected ? FSF.atoi(cRestSize) : -1;
          FSF.sprintf(key, "%s\\%s", presetKey, s);
          PutOpt(key);
        }
        break;
      case bLoad:
        ConfigPresets();
        break;
      default:
        return false;
    }
  }
}

int WINAPI _export Configure(int /*ItemNumber*/)
{
  return IsOldFar ? false : OptionDialog();
}

static inline int realSize(int size, int sect)
{
  return ( size < 0 ) ? size : (size/sect+( ( size%sect ) ? 1 : 0 ))*sect;
}

int CheckForEsc(void)
{
  int ExitCode=false;
  for ( ; ; )
  {
    INPUT_RECORD rec;
    HANDLE hConInp=GetStdHandle(STD_INPUT_HANDLE);
    DWORD ReadCount;
    PeekConsoleInput(hConInp, &rec, 1, &ReadCount);
    if (ReadCount==0)
      break;
    ReadConsoleInput(hConInp, &rec, 1, &ReadCount);
    if (rec.EventType==KEY_EVENT)
      if (rec.Event.KeyEvent.wVirtualKeyCode==VK_ESCAPE && rec.Event.KeyEvent.bKeyDown)
        ExitCode=true;
  }
  if ( ExitCode )
  {
    const char *MsgItems[] = { GetMsg(MWarning), GetMsg(MBreak) };
    if ( Info.Message(Info.ModuleNumber, FMSG_WARNING|FMSG_DOWN|FMSG_MB_YESNO, NULL, MsgItems, dimOf(MsgItems), 0) )
      ExitCode=false;
  }
  return ExitCode;
}

static inline char *repStr(char *s, char c, int n)
{
  if ( n )
    memset(s, c, n);
  s[n] = 0;
  return s;
}

void UpdateScreen(int ready, int ndisk, int odisk, int vol, int gi, int wi, int rmin, int rmax)
{
  const N = 50;
  char str1[64], str2[64], str3[64], progress[N+1];
  FSF.sprintf(str1, GetMsg(MStr1), odisk+ready);
  FSF.sprintf(str2, GetMsg(MStr2), ndisk+ready, 100-rmax*100/vol, 100-rmin*100/vol);
  FSF.sprintf(str3, GetMsg(MStr3), ready, gi, wi);
  int L = gi*N/(wi ? wi : 1);
  repStr(progress, '', L);
  repStr(progress+L, '', N-L);
  const char *MsgItems[] = { GetMsg(MOptimize), str1, "\x1", str2, str3, "\x1", progress, "\x1", GetMsg(MPressEsc) };
  Info.Message(Info.ModuleNumber, NULL, NULL, MsgItems, dimOf(MsgItems), 0);
}

static void DeletePanel(void)
{
  if ( List )
  {
    delete [] List;
    List = NULL;
  }
  if ( ListPanel )
  {
    delete [] ListPanel;
    ListPanel = NULL;
  }
  ListCount = 0;
  DiskCount = 0;
  DiskNumber = 0;
}

static HANDLE UpdatePanel(bool opt, char *Path = NULL, PluginPanelItem *Item = NULL, unsigned newCount = 0)
{
  DiskCount = 0;
  if ( opt )
    OptionDialog();
  if ( Path )
  {
    unsigned savedListCount = ListCount;
    unsigned N = ListCount = newCount;
    PluginPanelItem *savedList = List;
    if ( ListPanel )
    {
      delete [] ListPanel;
      ListPanel = NULL;
    }
    bool skipAll = false;
    for ( unsigned I = 0 ; I < N ; I++ )
    {
      WIN32_FIND_DATA *D = &Item[I].FindData;
      if ( D->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY )
        ListCount--;
      if ( realSize(D->nFileSizeLow, SectSize) > DiskSize )
      {
        if ( !skipAll )
        {
          const char *MsgItems[] = { GetMsg(MError), D->cFileName, GetMsg(MTooBig), GetMsg(MSkip), GetMsg(MSkipAll), GetMsg(MCancel) };
          int choice = Info.Message(Info.ModuleNumber, FMSG_WARNING, NULL, MsgItems, dimOf(MsgItems), 3);
          if ( choice < 2 )
          {
            if ( choice  )
              skipAll = true;
          }
          else
            return (HANDLE)NULL;
        }
        ListCount--;
      }
    }
    List = new PluginPanelItem[ListCount+savedListCount];
    ListPanel = new PluginPanelItem[ListCount+savedListCount];
    ListCount = 0;
    for ( unsigned I = 0 ; I < N ; I++ )
    {
      char fullName[NM];
      WIN32_FIND_DATA *D = &Item[I].FindData;
      if ( D->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY )
        continue;
      int size = realSize(D->nFileSizeLow, SectSize);
      if ( size > DiskSize )
        continue;
      memcpy(&List[ListCount], &Item[I], sizeof(PluginPanelItem));
      if ( *lstrcpy(fullName, Path) )
        FSF.AddEndSlash(fullName);
      lstrcat(fullName, D->cFileName);
      lstrcpy(List[ListCount].FindData.cFileName, fullName);
SysLog("Add = '%s'\n", fullName);
      ListCount++;
    }
    if ( savedListCount && savedList )
    {
      memcpy(List+ListCount, savedList, savedListCount*sizeof(PluginPanelItem));
      delete [] savedList;
    }
    ListCount += savedListCount;
  }
  if ( ListCount )
  {
    HANDLE hScreen=Info.SaveScreen(0, 0, -1, -1);
    const char *MsgItems[] = { GetMsg(MOptimize), GetMsg(MPrepare) };
    Info.Message(Info.ModuleNumber, NULL, NULL, MsgItems, dimOf(MsgItems), 0);
    TItem *sizes = new TItem[ListCount];
    for ( unsigned I = 0 ; I < ListCount ; I++ )
    {
      WIN32_FIND_DATA *D = &List[I].FindData;
      sizes[I].n = I;
      sizes[I].disk = List[I].UserData = 0;
      sizes[I].size = realSize(D->nFileSizeLow, SectSize);
    }
    DiskCount = optimize(sizes, ListCount, DiskSize, realSize(RestSize, SectSize), BreakMax, CheckForEsc, UpdateScreen);
    if ( DiskNumber >= DiskCount )
      DiskNumber = 0;
    for ( unsigned I = 0 ; I < ListCount ; I++ )
      List[sizes[I].n].UserData = sizes[I].disk;
    delete [] sizes;
    Info.RestoreScreen(hScreen);
  }
  else
    DeletePanel();
  return (HANDLE)List;
}

static unsigned PanelFiles(PluginPanelItem **Item, char **CurDir)
{
  const char *MsgItems[] = { GetMsg(MWarning), GetMsg(MProcessAll) };
  static PanelInfo pi;
  Info.Control(INVALID_HANDLE_VALUE, FCTL_GETPANELINFO, &pi);
  *CurDir = pi.CurDir;
  *Item = NULL;
  unsigned ItemsNumber = 0;
  if ( pi.SelectedItems[0].Flags & PPIF_SELECTED )
  {
    *Item = pi.SelectedItems;
    ItemsNumber = pi.SelectedItemsNumber;
  }
  else if ( !Info.Message(Info.ModuleNumber, FMSG_MB_YESNO, NULL, MsgItems, dimOf(MsgItems), 0) )
  {
    *Item = pi.PanelItems;
    ItemsNumber = pi.ItemsNumber;
  }
  return ItemsNumber;
}

static HANDLE NewPanel(void)
{
  DeletePanel();
  if ( OptionDialog() && DiskSize )
  {
    char *CurDir;
    PluginPanelItem *Item = NULL;
    unsigned ItemsNumber = PanelFiles(&Item, &CurDir);
    return UpdatePanel(false, CurDir, Item, ItemsNumber);
  }
  return (HANDLE)NULL;
}

static char *diskName(char *s, int i)
{
  char sstr[16];
  FSF.sprintf(sstr, "%u", DiskCount);
  int l = lstrlen(sstr);
  FSF.sprintf(sstr, "DISK_%%0%dd", l);
  FSF.sprintf(s, sstr, i);
  return s;
}

int WINAPI _export SetDirectory(HANDLE /*hPlugin*/, const char *aDir, int /*OpMode*/)
{
  int res = false;
  if ( !*aDir )
    return true;
  const char *Dir = ( *aDir == '\\' || *aDir == '/' ) ? aDir+1 : aDir;
  if ( !*Dir || !lstrcmp(Dir, "..") )
  {
    res = DiskNumber ? true : false;
    DiskNumber = 0;
  }
  else
  {
    char testDir[32];
    for ( unsigned i = 1 ; i <= DiskCount ; i++ )
    {
      if ( !FSF.LStricmp(Dir, diskName(testDir, i)) )
      {
        res = true;
        DiskNumber = i;
        break;
      }
    }
  }
  return res;
}

BOOL FileExists(const char* Name)
{
  return GetFileAttributes(Name)!=0xFFFFFFFF;
}

static bool checkList(void)
{
  bool res = false;
  if ( List )
  {
    unsigned NewListCount = ListCount;
    for ( unsigned I = 0 ; I < ListCount ; I++ )
      if ( !FileExists(List[I].FindData.cFileName) )
      {
        List[I].UserData = 0xFFFFFFFF;
        NewListCount--;
        res = true;
      }
    if ( res )
    {
      PluginPanelItem *NewList = List;
      List = new PluginPanelItem[NewListCount];
      unsigned N = ListCount;
      ListCount = 0;
      for ( unsigned I = 0 ; I < N ; I++ )
        if ( NewList[I].UserData != 0xFFFFFFFF )
          memcpy(&List[ListCount++], &NewList[I], sizeof(PluginPanelItem));
      delete [] NewList;
    }
  }
  return res;
}

int WINAPI _export GetFindData(HANDLE /*hPlugin*/, struct PluginPanelItem **pPanelItem, int *pItemsNumber, int /*OpMode*/)
{
  *pPanelItem = NULL;
  *pItemsNumber = 0;
  int CurItemPos = 0;
  checkList();
  if ( ( List != NULL ) && ( ListPanel != NULL ) )
  {
    if ( DiskNumber )
    {
      for ( unsigned I = 0 ; I < ListCount ; I++ )
        if ( List[I].UserData == DiskNumber )
          CurItemPos++;
      if ( !CurItemPos )
        return false;
      CurItemPos = 0;
      for ( unsigned I = 0 ; I < ListCount ; I++ )
        if ( List[I].UserData == DiskNumber )
          memcpy(&ListPanel[CurItemPos++], &List[I], sizeof(PluginPanelItem));
    }
    else
    {
      CurItemPos = DiskCount;
      if ( !CurItemPos )
        return false;
      for ( unsigned I = 0 ; I < DiskCount ; I++ )
      {
        memset(&ListPanel[I], 0, sizeof(PluginPanelItem));
        ListPanel[I].UserData = I+1;
        WIN32_FIND_DATA *D = &ListPanel[I].FindData;
        diskName(D->cFileName, I+1);
        D->dwFileAttributes = FILE_ATTRIBUTE_DIRECTORY;
      }
    }
  }
  if ( CurItemPos )
    *pPanelItem = ListPanel;
  *pItemsNumber = CurItemPos;
  return true;
}

int WINAPI _export PutFiles(HANDLE /*hPlugin*/, struct PluginPanelItem *PanelItem, int ItemsNumber, int /*Move*/, int /*OpMode*/)
{
  PanelInfo pi;
  Info.Control(INVALID_HANDLE_VALUE, FCTL_GETPANELINFO, &pi);
  return UpdatePanel(true, pi.CurDir, PanelItem, ItemsNumber) ? true : false;
}

void WINAPI _export GetOpenPluginInfo(HANDLE /*hPlugin*/, struct OpenPluginInfo *Info)
{
  static char Title[80], CurDir[80], Format[80];
  Info->StructSize=sizeof(*Info);
  *CurDir = 0;
  if ( DiskNumber )
    diskName(CurDir, DiskNumber);
  FSF.sprintf(Title, " %s%s%s ", lstrcpy(Format, GetMsg(MTitle)), *CurDir ? "\\" : "", CurDir);
  Info->PanelTitle=Title;
  Info->CurDir=CurDir;
  Info->Format=Format;
  static struct KeyBarTitles KeyBar[2]=
  {
    {
//      F1    F2    F3    F4    F5    F6    F7    F8    F9    F10   F11   F12
      { NULL, NULL, NULL, "",   "",   "",   NULL, "",   NULL, NULL, NULL, NULL },
      { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL },
      { NULL, NULL, NULL, "",   "",   "",   NULL, NULL, NULL, NULL, NULL, NULL },
      { "",   "",   "",   NULL, "",   "",   NULL, "",   NULL, NULL, NULL, NULL },
      { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL },
      { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL },
      { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL }
    },
    {
      { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL },
      { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL },
      { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL },
      { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL },
      { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL },
      { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL },
      { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL }
    }
  };
  KeyBar[0].Titles[4-1] = (char*)GetMsg(MF4);
  KeyBar[0].Titles[7-1] = KeyBar[1].Titles[7-1]=(char*)GetMsg(MF7);
  Info->Flags=OPIF_USEHIGHLIGHTING|OPIF_USEFILTER|OPIF_USESORTGROUPS|OPIF_ADDDOTS;
  if ( DiskNumber )
  {
    Info->KeyBar=&KeyBar[1];
    Info->Flags |= OPIF_SHOWNAMESONLY|OPIF_REALNAMES;
  }
  else
    Info->KeyBar=&KeyBar[0];
}

static void removeFiles()
{
  PanelInfo pi;
  Info.Control(INVALID_HANDLE_VALUE, FCTL_GETPANELINFO, &pi);
  if ( pi.ItemsNumber )
  {
    PluginPanelItem *Item;
    unsigned ItemsNumber;
    if ( pi.SelectedItems[0].Flags & PPIF_SELECTED )
    {
      Item = pi.SelectedItems;
      ItemsNumber = pi.SelectedItemsNumber;
    }
    else
    {
      Item = &pi.PanelItems[pi.CurrentItem];
      ItemsNumber = 1;
    }
    char fn[NM];
    if ( ItemsNumber == 1 )
      FSF.sprintf(fn, "%s", Item[0].FindData.cFileName);
    else
      FSF.sprintf(fn, GetMsg(MFiles), ItemsNumber);
    const char *MsgItems[] = { GetMsg(MWarning), GetMsg(MRemove1), fn, GetMsg(MRemove2) };
    if ( !Info.Message(Info.ModuleNumber, FMSG_MB_YESNO, NULL, MsgItems, dimOf(MsgItems), 0) )
    {
      PluginPanelItem *NewList = new PluginPanelItem[ListCount];
      unsigned NewListCount = ListCount;
      ListCount = 0;
      if ( DiskNumber )
      {
        for ( unsigned i = 0 ; i < NewListCount ; i++ )
        {
          bool found = false;
          for ( unsigned j = 0 ; j < ItemsNumber ; j++ )
            if ( !FSF.LStricmp(Item[j].FindData.cFileName, List[i].FindData.cFileName) )
            {
              found = true;
              break;
            }
          if ( !found )
            memcpy(&NewList[ListCount++], &List[i], sizeof(PluginPanelItem));
        }
      }
      else
      {
        for ( unsigned i = 0 ; i < NewListCount ; i++ )
          for ( unsigned j = 0 ; j < ItemsNumber ; j++ )
          {
            if ( Item[j].UserData != List[i].UserData )
              memcpy(&NewList[ListCount++], &List[i], sizeof(PluginPanelItem));
          }
      }
      if ( ListCount )
      {
        delete [] List;
        List = NewList;
      }
      else
      {
        const char *MsgItems[] = { GetMsg(MError), GetMsg(MRemoveAll) };
        ListCount = NewListCount;
        Info.Message(Info.ModuleNumber, FMSG_WARNING|FMSG_MB_OK, NULL, MsgItems, dimOf(MsgItems), 0);
      }
    }
  }
}

int WINAPI _export ProcessKey(HANDLE hPlugin, int Key, unsigned int ControlState)
{
  int processed = false;
  switch ( ControlState )
  {
    case 0:
      switch ( Key )
      {
        case VK_F4:
          checkList();
          UpdatePanel(true);
          processed = true;
          break;
        case VK_F7:
          removeFiles();
          UpdatePanel(false);
          processed = true;
          break;
        default:
          break;
      }
      break;
    default:
      break;
  }
  if ( processed )
  {
    Info.Control(hPlugin, FCTL_UPDATEPANEL, NULL);
    Info.Control(hPlugin, FCTL_REDRAWPANEL, NULL);
    return true;
  }
  return false;
}

HANDLE WINAPI _export OpenPlugin(int OpenFrom, int /*item*/)
{
  HANDLE hPlugin = NULL;
  if ( !IsOldFar )
  {
    switch ( OpenFrom )
    {
      case OPEN_PLUGINSMENU:
        hPlugin = NewPanel();
        break;
    }
  }
  return hPlugin ? hPlugin : INVALID_HANDLE_VALUE;
}

void WINAPI _export ClosePlugin(HANDLE /*hPlugin*/)
{
  DeletePanel();
}
