#include "winmem.h"
#include "farintf.h"
#include "scanreg.h"

static char key[512], FullKeyName[512];

int FindFirstRegKey(HKEY hRoot, char *Key, FIND_FUNC ff, void *data, char *ValueName, DWORD DataSize)
{
  int Result = 0;
  HKEY hKey;
  FSF.sprintf(FullKeyName,"%s%s%s", PluginRootKey, *Key ? "\\" : "", Key);
  if ( RegOpenKeyEx(hRoot,FullKeyName,0,KEY_READ,&hKey) == ERROR_SUCCESS )
  {
    int cont = 1;
    for ( DWORD i = 0 ; cont ; i++ )
    {
      DWORD size = sizeof(key);
      LONG res = RegEnumKeyEx(hKey, i, key, &size, NULL, NULL, NULL, NULL);
      switch ( res )
      {
        case ERROR_SUCCESS:
          if ( ff(hRoot, Key, key, data) )
          {
            lstrcpyn(ValueName, key, DataSize);
            ValueName[DataSize] = 0;
            Result = 1;
            cont = 0;
          }
          break;
        case ERROR_NO_MORE_ITEMS:
          cont = 0;
          break;
        default:
          cont = 0;
          break;
      }
    }
  }
  RegCloseKey(hKey);
  return Result;
}

int ForEachRegKey(HKEY hRoot, char *Key, FIND_FUNC ff, void *data)
{
  int n = 0;
  HKEY hKey;
  FSF.sprintf(FullKeyName,"%s%s%s", PluginRootKey, *Key ? "\\" : "", Key);
  if ( RegOpenKeyEx(hRoot,FullKeyName,0,KEY_READ,&hKey) == ERROR_SUCCESS )
  {
    int cont = 1;
    for ( DWORD i = 0 ; cont ; i++ )
    {
      DWORD size = sizeof(key);
      LONG res = RegEnumKeyEx(hKey, i, key, &size, NULL, NULL, NULL, NULL);
      switch ( res )
      {
        case ERROR_SUCCESS:
          if ( ff(hRoot, Key, key, data) )
            n++;
          else
            cont = 0;
          break;
        case ERROR_NO_MORE_ITEMS:
          cont = 0;
          break;
        default:
          cont = 0;
          break;
      }
    }
  }
  RegCloseKey(hKey);
  return n;
}

int MenuFromRegKey(HKEY hRoot, char *Key, ADD_FUNC af, FarMenuItem **menu, int* n, void *data)
{
  struct TMenuArray
  {
    FarMenuItem *Items;
    size_t Count, Size, Delta;
  } a = { NULL, 0, 0, 10 };
  FarMenuItem *newItems;
  bool empty;
  HKEY hKey;
  FSF.sprintf(FullKeyName,"%s%s%s", PluginRootKey, *Key ? "\\" : "", Key);
  if ( RegOpenKeyEx(hRoot,FullKeyName,0,KEY_READ,&hKey) == ERROR_SUCCESS )
  {
    int cont = 1;
    for ( DWORD i = 0 ; cont ; i++ )
    {
      DWORD size = sizeof(key);
      LONG res = RegEnumKeyEx(hKey, i, key, &size, NULL, NULL, NULL, NULL);
      switch ( res )
      {
        case ERROR_SUCCESS:
          empty = a.Items == NULL;
          if ( a.Count >= a.Size )
          {
            newItems = new FarMenuItem[a.Size+a.Delta];
            if ( a.Count != 0 )
            {
              memcpy(newItems, a.Items, a.Count*sizeof(FarMenuItem));
              delete [] a.Items;
            }
            a.Items = newItems;
            a.Size += a.Delta;
          }
          if ( empty )
            a.Count = 0;
          else
            a.Count++;
          a.Items[a.Count].Selected = a.Items[a.Count].Checked = a.Items[a.Count].Separator = false;
          if ( af(hRoot, Key, key, a.Items+a.Count, n, data) )
            a.Items[a.Count].Selected = true;
          break;
        case ERROR_NO_MORE_ITEMS:
          cont = 0;
          break;
        default:
          cont = 0;
          break;
      }
    }
  }
  RegCloseKey(hKey);
  if ( a.Items == NULL )
  {
    a.Items = new FarMenuItem;
    a.Count = a.Items[0].Selected = a.Items[0].Checked = a.Items[0].Separator = false;
    *a.Items[0].Text = 0;
  }
  *menu = a.Items;
  return ++a.Count;
}
