#include "winmem.h"
#include "optimize.h"

#include "syslog.h"

struct TData
{
  int nmax, vol_size, rmax, rmin, ndisk, odisk, nexclude, left;
  TItem *data;
  int *order, *excluded;
  CHECKFORESC CheckForEsc;
  UPDATESCREEN UpdateScreen;
  int gItem, aItem;
  TItem& operator[](size_t n) { return data[order[n]-1]; };
};

static void swap(int* a1, int* a2)
{
  int tmp;
  tmp = *a1;
  *a1 = *a2;
  *a2 = tmp;
}

static int minmax(int rest, int *rmin, int *rmax)
{
  if ( *rmax < rest )
    *rmax = rest;
  if ( *rmin > rest )
  {
    *rmin = rest;
    return 1;
  }
  return 0;
}

static int acceptorder(int res, int *order, TData *d, int *a, int n, int k)
{
  d->ndisk = k;
  for ( int i = 0 ; i < n ; i++ )
    order[i] = a[i];
  d->order = order;
  return res;
}

static int outfunc(TData *d, int *a, int n)
{
  int k = 1, s = 0, rmax = 0, rmin = d->vol_size, good = 0;
  int smin = d->vol_size, smax = 0;
  int nmin = -1, nmax = -1;
  int *order = d->order;
  d->order = a;
  for ( int i = 0 ; i < n ; i++ )
  {
    int f = (*d)[i].size;
    if ( smax < f )
    {
      smax = f;
      nmax = i;
    }
    if ( smin > f )
    {
      smin = f;
      nmin = i;
    }
    if ( s+f > d->vol_size )
    {
      if ( minmax(d->vol_size-s, &rmin, &rmax) )
        good = k;
      s = 0;
      k++;
    }
    s += f;
  }
  if ( minmax(d->vol_size-s, &rmin, &rmax) )
    good = k;
  if ( k <= 1 )
    return acceptorder(1, order, d, a, n, k);
  if ( nmin != nmax )
  {
    if ( smax+smin > d->vol_size )
    {
      d->nexclude = 1;
      d->excluded[0] = nmax;
      return acceptorder(2, order, d, a, n, k);
    }
    int nsec = -1, ssec = d->vol_size;
    for ( int i = 0 ; i < n ; i++ )
    {
      if ( ( i != nmin ) && ( i != nmax ) )
      {
        int f = (*d)[i].size;
        if ( ssec > f )
        {
          ssec = f;
          nsec = i;
        }
      }
    }
    if ( ( nsec >= 0 ) && ( smax+ssec > d->vol_size ) )
    {
      d->nexclude = 2;
      d->excluded[0] = nmax;
      d->excluded[1] = nmin;
      return acceptorder(2, order, d, a, n, k);
    }
  }
  if ( ( d->rmin >= 0 ) && ( rmin < d->rmin ) )
  {
    k = 1;
    s = d->nexclude = 0;
    for ( int i = 0 ; i < n ; i++ )
    {
      int f = (*d)[i].size;
      if ( s+f > d->vol_size )
      {
        s = 0;
        k++;
      }
      if ( k == good )
      {
        d->excluded[d->nexclude++] = i;
      }
      s += f;
    }
    return acceptorder(2, order, d, a, n, k);
  }
  if ( ( k < d->ndisk ) || ( ( k == d->ndisk ) && ( rmax > d->rmax ) ) )
  {
    d->rmax = rmax;
    acceptorder(1, order, d, a, n, k);
    d->UpdateScreen(d->left, d->ndisk, d->odisk, d->vol_size, d->gItem, d->aItem, rmin, rmax);
    if ( ( n > d->nmax ) && ( k <= d->odisk ) )
      return 1;
  }
  d->order = order;
  return 0;
}

static int generate(TData *data, int n, int& iter)
{
  int ret = 0;
  int *pi = new int[n+2];
  int *fi = new int[n+1];
  char *di = new char[n+1];
  for ( int i = 1 ; i <= n ; i++ )
  {
    pi[i] = fi[i] = i;
    di[i] = -1;
  }
  int m = pi[0] = pi[n+1] = n+1;
  di[1] = 0;
  while ( m != 1 )
  {
    m = n;
    while ( pi[fi[m]+di[m]] > m )
    {
      di[m] = (char)(-di[m]);
      --m;
    }
    ret = outfunc(data, pi+1, n);
    if ( ret )
      break;
    if ( iter++%10000 == 0 )
      if ( data->CheckForEsc() )
      {
        ret = 3;
        break;
      }
    swap(pi+fi[m], pi+fi[m]+di[m]);
    swap(fi+m, fi+pi[fi[m]]);
  }
  delete [] pi;
  delete [] fi;
  delete [] di;
  return ret;
}

static int split(TData& data, int arr_size, int vol_size, int restsize)
{
  int iter = 0, worksize = arr_size, goodsize = 0;
  data.vol_size = vol_size;
  data.rmax = data.left = 0;
  data.rmin = restsize;
  TItem *good = new TItem[arr_size];
  data.aItem = arr_size;
  for ( ; ; )
  {
    int s = 0;
    for ( int i = 0 ; i < worksize ; i++ )
    {
      data.order[i] = i+1;
      int f = data.data[i].size;
      s += f;
      if ( data.rmin > f )
        data.rmin = f;
    }
    data.gItem = data.aItem-worksize;
    data.odisk = s/vol_size+1;
    data.ndisk = arr_size+1;
    data.nexclude = 0;
    int exit_now = 1;
    switch ( generate(&data, worksize, iter) )
    {
      case 3:
//        printf("Terminated by user. Best case not found.\n");
        break;
      case 2:
        if ( ( data.nexclude > 0 ) && ( data.nexclude < worksize ) )
          exit_now = 0;
        break;
      default:
        break;
    }
    if ( exit_now )
    {
      for ( int i = 0 ; i < worksize ; i++ )
        memcpy(good+goodsize+i, &(data[i]), sizeof(TItem));
      memcpy(data.data, good, arr_size*sizeof(TItem));
      delete [] good;
      int k = 1;
      s = 0;
      for ( int i = 0 ; i < arr_size ; i++ )
      {
        data.order[i] = i+1;
        int f = data.data[i].size;
        if ( s+f > vol_size )
        {
          s = 0;
          k++;
        }
        data.data[i].disk = k;
        s += f;
      }
      return k;
    }
    for ( int i = 0 ; i < data.nexclude ; i++ )
    {
      int j = data.excluded[i];
      memcpy(good+goodsize, &(data[j]), sizeof(TItem));
      goodsize++;
    }
    TItem *mem = new TItem[worksize];
    int i1 = 0;
    for ( int i = 0 ; i < worksize ; i++ )
    {
      bool move = true;
      for ( int j = 0 ; j < data.nexclude ; j++ )
      {
        if ( i == data.excluded[j] )
        {
          move = false;
          break;
        }
      }
      if ( move )
      {
        memcpy(mem+i1, &(data[i]), sizeof(TItem));
        i1++;
      }
      data.order[i] = i+1;
    }
    data.rmax = 0;
    data.left++;
    worksize -= data.nexclude;
    memcpy(data.data, mem, worksize*sizeof(TItem));
    delete [] mem;
  }
}

int optimize(TItem *items, int arr_size, int vol_size, int restsize, int nmax, CHECKFORESC check, UPDATESCREEN screen)
{
  int *order = new int[arr_size];
  int *excluded = new int[arr_size];
  TData data;
  memset(&data, 0, sizeof(data));
  data.data = items;
  data.order = order;
  data.nmax = nmax;
  data.nexclude = 0;
  data.excluded = excluded;
  data.CheckForEsc = check;
  data.UpdateScreen = screen;
  for ( int i = 0 ; i < arr_size ; i++ )
  {
    excluded[i] = 0;
    order[i] = i+1;
  }
  int dc = split(data, arr_size, vol_size, restsize);
  delete [] excluded;
  delete [] order;
  return dc;
}
