#include "winmem.h"
#include "lstring.h"
char *lstrpbrk(char *s, const char *brk)
{
  char *p;
  for ( p = s ; *p ; p++ )
    for ( char *c = (char*)brk ; *c ; c++ )
      if ( *p == *c )
        return p;
  return NULL;
}

char *lstrchr(char *s, int c)
{
  char *p;
  for ( p = s ; *p ; p++ )
    if ( *p == c )
      return p;
  return c ? NULL : p;
}

char *lstrrchr(char *s, int c)
{
  char *p;
  for ( p = lstrchr(s, 0) ; p >= s ; p-- )
    if ( *p == c )
      return p;
  return c ? NULL : p;
}

char *lstrstr(char *s, const char *c)
{
  if ( c )
  {
    int l = lstrlen(c);
    for ( char *p = s ; *p ; p++ )
      if ( lstrncmp(p, c, l) == 0 )
        return p;
  }
  return NULL;
}

int lstrncmp(const char *s1, const char *s2, int l)
{
  if ( s1 && s2 )
  {
    char *p1 = (char *)s1;
    char *p2 = (char *)s2;
    for ( int i = 0 ; ( i < l ) && *p1 && *p2 ; i++,p1++,p2++ )
    {
      if ( *p1 != *p2 )
        return ( *p1 == *p2 ) ? 0 : ( ( *p1 > *p2 ) ? 1 : -1 );
      if ( i == l-1 )
        return 0;
    }
    return ( *p1 > *p2 ) ? 1 : -1;
  }
  return ( s1 == s2 ) ? 0 : ( s1 ? 1 : -1 );
}
