#include "winmem.h"
#include "eicoll.h"

#include <string.h>

TEInfo::TEInfo(int aID, int aLang, const char *aFn)
{
  ID = aID;
  lang = aLang;
  strcpy(fn, aFn);
}

unsigned TEICollection::insert(int aID, int aLang, const char *aFn)
{
  return TCollection::insert(new TEInfo(aID, aLang, aFn));
}

static int find_ID(void *it, void *data)
{
  return ((TEInfo*)it)->ID == *((int*)data);
}

TEICollection::TEICollection(unsigned aLimit, unsigned aDelta) :
  TCollection(aLimit, aDelta, NULL)
{
}

int TEICollection::findID(int aID)
{
  return findIndex(find_ID, &aID);
}

int TEICollection::findLang(int aID)
{
  TEInfo *i = (TEInfo*)find(find_ID, &aID);
  if ( i )
    return i->lang;
  return -1;
}

const char *TEICollection::findFile(int aID)
{
  TEInfo *i = (TEInfo*)find(find_ID, &aID);
  if ( i )
    return i->fn;
  return NULL;
}

unsigned TEICollection::removeID(int aID)
{
  int i = findIndex(find_ID, &aID);
  if ( i != -1 )
    return remove(i);
  return getCount();
}
