//
//  Copyright (c) Cail Lomecb (Igor Ruskih) 1999-2001 <ruiv@uic.nnov.ru>
//  You can use, modify, distribute this code or any other part
//  of colorer library in sources or in binaries only according
//  to Colorer License (see /doc/license.txt for more information).
//
#ifndef __CREGEXP__
#define __CREGEXP__
#include "clocale.h"

// with this define class uses extended command set for
// colorer compatibility mode
// if you undef it, it will compile stantard set for
// regexp compatibility mode
// #define COLORERMODE

#define MATCHESNUM 0x10

enum EOps
{
  ReBlockOps = 0x1000,
  ReMul,              // *
  RePlus,             // +
  ReQuest,            // ?
  ReNGMul,            // *?
  ReNGPlus,           // +?
  ReNGQuest,          // ??
  ReRangeN,           // {n,}
  ReRangeNM,          // {n,m}
  ReNGRangeN,         // {n,}?
  ReNGRangeNM,        // {n,m}?
  ReOr,               // |
  ReBehind  = 0x1100, // ?#n
  ReNBehind = 0x1200, // ?~n
  ReAhead   = 0x1300, // ?=
  ReNAhead  = 0x1400, // ?!

  ReSymbolOps = 0x2000,
  ReEmpty,
  ReSymb,             // a b c ...
//  ReMetaSymb,         // \W \s \d ...
  ReEnum,             // []
  ReNEnum,            // [^]
  ReBrackets,         // (...)
#ifdef COLORERMODE
  ReBkTrace = 0x2100, // \yN
  ReBkTraceN= 0x2200, // \YN
#endif
  ReBkBrack = 0x2300 // \N
};

enum ESymbols
{
  ReAnyChr = 0x4000,  // .
  ReSoL,              // ^
#ifdef COLORERMODE
  ReSoScheme,         // ~
#endif
  ReEoL,              // $
  ReDigit,            // \d
  ReNDigit,           // \D
  ReWordSymb,         // \w
  ReNWordSymb,        // \W
  ReWSpace,           // \s - space, tab, cr, lf
  ReNWSpace,          // \S
  ReUCase,            // \u
  ReNUCase ,          // \l
  ReWBound,           // \b
  ReNWBound,          // \B
  RePreNW,            // \c
#ifdef COLORERMODE
  ReStart,            // \m
  ReEnd,              // \M
#endif

  ReChrLast,
  ReChr    = 0x0      // Char in Lower Byte
};
enum ETempSymb
{
  ReTemp = 0x6000,
  ReLBrack, ReRBrack,
  ReEnumS, ReEnumE, ReNEnumS,
  ReRangeS, ReRangeE, ReNGRangeE, ReFrToEnum
};
enum EError
{
  EOK = 0, EERROR, ESYNTAX, EBRACKETS, EOP
};

typedef struct SRegInfo
{
  SRegInfo();
  ~SRegInfo();

  EOps op;
  union{
    SRegInfo *param;
    int symb;
    PCharData charclass;
  }un;
  int s, e;
  int param0, param1;
  char *oldParse;
  SRegInfo *parent;
  SRegInfo *next;
  SRegInfo *prev;
} *PRegInfo;

typedef struct SMatches
{
  int s[MATCHESNUM];
  int e[MATCHESNUM];
  int CurMatch;
} *PMatches;

typedef class CRegExp
{
  bool NoCase, Extend, NoMoves, SingleLine;
//  char *toParse, *StartPos;
  char *End, *Start;
#ifdef COLORERMODE
  char *SchemeStart;
#endif
  PRegInfo Info;
  int *Exprn;
  int FirstChar;
  bool startchange, endchange;
  EError Error;
#ifdef COLORERMODE
  PMatches bktrace;
  char *bkstr;
#endif

  EError SetExprLow(char *Expr);
  EError SetStructs(PRegInfo &Info, int st, int end);
  void Optimize();
  bool CheckSymb(int Symb, char **toParse);
  bool LowParse(PRegInfo re, PRegInfo prev, char *toParse);
  bool QuickCheck(char *toParse);
  bool ParseRe(char *Str);
  PMatches Matches;
  int CurMatch;
public:
  CRegExp();
  CRegExp(char *Text);
  ~CRegExp();

  bool isok();
  EError geterror();
  bool SetNoMoves(bool Moves);
#ifdef COLORERMODE
  bool SetBkTrace(char *str, PMatches trace);
  bool GetBkTrace(char **str, PMatches *trace);
  bool getfirstchar(PCharData cd);
#endif
  bool SetExpr(char *Expr);
  bool Parse(char *str, PMatches mtch);
  bool Parse(char *str, char *sol, char *eol, PMatches mtch, char *soscheme = 0, int moves = -1);
} *PRegExp;

#endif