#include "console.h"
#include "winmem.h"

#define BUFF_SIZE 4096

static char LineBuf[BUFF_SIZE];
static int LineBufPtr;

static void cls(HANDLE& StdOutput)
{
  CONSOLE_SCREEN_BUFFER_INFO csbi;
  GetConsoleScreenBufferInfo(StdOutput, &csbi);
  DWORD dummy;
  COORD C;
  C.X = 0;
  for ( int Y = 0 ; Y < csbi.dwSize.Y ; Y++ )
  {
    C.Y = (short)Y;
    FillConsoleOutputCharacter(StdOutput, ' ', csbi.dwSize.X, C, &dummy);
    FillConsoleOutputAttribute(StdOutput, 7,   csbi.dwSize.X, C, &dummy);
  }
  C.Y = (short)(csbi.dwSize.Y-1);
  SetConsoleCursorPosition(StdOutput, C);
}

static void OutputLine(HANDLE& h, TCollection *AppOutput)
{
  const char *crlf = "\r\n";
  char *eos = strpbrk(LineBuf, crlf);
  LineBuf[LineBufPtr] = 0;
  if ( eos )
    *eos = 0;
  char *p = new char[strlen(LineBuf)+1];
  strcpy(p, LineBuf);
  AppOutput->insert(p);
  LineBufPtr = 0;
  DWORD dummy;
  WriteConsole(h, p, strlen(p), &dummy, NULL);
  WriteConsole(h, crlf, strlen(crlf), &dummy, NULL);
}

struct TShowOutputData
{
  bool compilerDone, cls;
  HANDLE hInput, hOutput;
  TCollection *AppOutput;
};

void showPartOfCompilerOut(TShowOutputData *sd)
{
  if ( sd && ( sd->hInput != INVALID_HANDLE_VALUE ) )
  {
    char ReadBuf[BUFF_SIZE];
    DWORD BytesRead;
    memset(&BytesRead, 0, sizeof(BytesRead));
    while ( ReadFile(sd->hInput, ReadBuf, sizeof(ReadBuf), &BytesRead, NULL) )
    {
      for ( int i = 0 ; i < (int)BytesRead ; i++ )
      {
        if ( strchr("\n\r", ReadBuf[i]) )
        {
          if ( ( ReadBuf[i] == '\r' ) && ( ReadBuf[i+1] == '\n' ) )
            i++;
          OutputLine(sd->hOutput, sd->AppOutput);
        }
        else
        {
          LineBuf[LineBufPtr] = ReadBuf[i];
          LineBufPtr++;
          if ( LineBufPtr >= sizeof(LineBuf)-1 )
            OutputLine(sd->hOutput, sd->AppOutput);
        }
      }
    }
  }
}

DWORD WINAPI ThreadWhatUpdateScreen(LPVOID par)
{
  if ( par )
  {
    TShowOutputData *sd = (TShowOutputData*)par;
    if ( sd->cls )
      cls(sd->hOutput);
    for ( ; ; )
    {
      if ( sd->compilerDone )
        break;
      showPartOfCompilerOut(sd);
      Sleep(500);
    }
    showPartOfCompilerOut(sd);
  }
  return 0;
}

static inline const char *getExt(const char *FileName)
{
  char *ext = strrchr((char*)FileName, '.');
  return (const char *)(ext ? ext : strrchr((char*)FileName, 0));
}

enum CmdType { none, com, exe, bat, cmd, gui };

static bool ExeExist(const char *FileName, const char *ext, const char *testExt, char *FullName, size_t sizeofFullName)
{
  if ( !*ext || !stricmp(ext, testExt) )
  {
    char *FilePart;
    if ( SearchPath(NULL, FileName, testExt, sizeofFullName, FullName, &FilePart) )
      return true;
  }
  return false;
}

static CmdType CommandType(bool NT, const char *Command)
{
  char FileName[4096], FullName[4096], *EndName;
  if ( *Command == '\"' )
  {
    OemToChar(Command+1, FileName);
    if ( ( EndName = strchr(FileName,'\"') ) != NULL )
      *EndName = 0;
  }
  else
  {
    OemToChar(Command, FileName);
    if ( ( EndName = strpbrk(FileName, " \t/")) != NULL)
      *EndName = 0;
  }
  const char *ext = getExt(FileName);
  if ( ExeExist(FileName, ext, ".com", FullName, sizeof(FullName)) )
    return com;
  if ( ExeExist(FileName, ext, ".exe", FullName, sizeof(FullName)) )
  {
    SHFILEINFO sfi;
    DWORD ExeType = SHGetFileInfo(FullName, 0, &sfi, sizeof(sfi), SHGFI_EXETYPE);
    bool GUIType = HIWORD(ExeType) >= 0x0300 && HIWORD(ExeType) <= 0x1000 && HIBYTE(ExeType) == 'E' && ( LOBYTE(ExeType) == 'N' || LOBYTE(ExeType) == 'P' );
    return GUIType ? gui : exe;
  }
  if ( ExeExist(FileName, ext, ".bat", FullName, sizeof(FullName)) )
    return bat;
  if ( NT && ExeExist(FileName, ext, ".cmd", FullName, sizeof(FullName)) )
    return cmd;
  return none;
}

DWORD ExecConsoleApp(const char *CmdStr, TCollection *OutputColl, bool clear)
{
  if ( !OutputColl )
    return -1;
  STARTUPINFO si;
  PROCESS_INFORMATION pi;
  SECURITY_ATTRIBUTES sa;
  OSVERSIONINFO WinVer;
  char ExecLine[1024], CommandName[512];
  WinVer.dwOSVersionInfoSize = sizeof(WinVer);
  GetVersionEx(&WinVer);
  bool NT = WinVer.dwPlatformId == VER_PLATFORM_WIN32_NT;
  bool OldNT = NT && WinVer.dwMajorVersion < 4;
  *CommandName=0;
  GetEnvironmentVariable("COMSPEC", CommandName, sizeof(CommandName));
  CmdType GUIType = CommandType(NT, CmdStr);
  strcat(strcpy(ExecLine, CommandName), " /C");
  if ( !OldNT && ( ( GUIType == gui ) || ( GUIType == none ) ) )
  {
    strcat(ExecLine," start");
    if ( GUIType == gui )
      strcat(ExecLine," /wait");
    if ( NT && *CmdStr == '\"' )
      strcat(ExecLine, " \"\"");
  }
  strcat(strcat(ExecLine," "), CmdStr);
  HANDLE WriteHandle = INVALID_HANDLE_VALUE, ReadHandle = INVALID_HANDLE_VALUE;
  HANDLE StdInput = GetStdHandle(STD_INPUT_HANDLE);
  DWORD ConsoleMode, ExitCode = -1;
  memset(&si, 0, sizeof(si));
  si.cb = sizeof(si);
  memset(&sa, 0, sizeof(sa));
  LineBufPtr = 0;
  sa.nLength = sizeof(sa);
  sa.bInheritHandle = true;
  if ( CreatePipe(&ReadHandle, &WriteHandle, &sa, 0) )
  {
    if ( NT )
      SetHandleInformation(ReadHandle, HANDLE_FLAG_INHERIT, 0);
    else
    {
      HANDLE TempHandle;
      DuplicateHandle(GetCurrentProcess(), ReadHandle, GetCurrentProcess(), &TempHandle, 0, true, DUPLICATE_SAME_ACCESS);
      ReadHandle = TempHandle;
    }
    GetConsoleMode(StdInput,&ConsoleMode);
    SetConsoleMode(StdInput, ENABLE_PROCESSED_INPUT|ENABLE_LINE_INPUT|ENABLE_ECHO_INPUT|ENABLE_MOUSE_INPUT);
    si.cb = sizeof(si);
    si.dwFlags = STARTF_USESTDHANDLES;
    si.hStdInput = StdInput;
    si.hStdOutput = WriteHandle;
    si.hStdError = WriteHandle;
    char OldTitle[256];
    GetConsoleTitle(OldTitle, sizeof(OldTitle));
    SetConsoleTitle(CmdStr);
    DWORD dummy;
    TShowOutputData *sd = (TShowOutputData*)GlobalAlloc(GPTR,sizeof(TShowOutputData));
    if ( sd )
    {
      sd->compilerDone = false;
      sd->cls = clear;
      sd->hInput = ReadHandle;
      sd->hOutput = GetStdHandle(STD_OUTPUT_HANDLE);
      sd->AppOutput = OutputColl;
      ExitCode = CreateProcess(NULL, ExecLine, NULL, NULL, true, CREATE_NO_WINDOW, NULL, NULL, &si, &pi);
      if ( ExitCode )
      {
        HANDLE hThread = CreateThread(NULL, 0xf000, ThreadWhatUpdateScreen, sd, 0, &dummy);
        WaitForSingleObject(pi.hProcess, INFINITE);
        sd->compilerDone = true;
        GetExitCodeProcess(pi.hProcess, &ExitCode);
        CloseHandle(WriteHandle);
        WaitForSingleObject(hThread, INFINITE);
        CloseHandle(pi.hThread);
        CloseHandle(pi.hProcess);
        CloseHandle(hThread);
      }
      else
        ExitCode = -1;
      showPartOfCompilerOut(sd);
      OutputLine(sd->hOutput, OutputColl);
      GlobalFree((LPVOID)sd);
    }
    CloseHandle(ReadHandle);
    SetConsoleTitle(OldTitle);
  }
  return ExitCode;
}
