//
//  Copyright (c) Cail Lomecb (Igor Ruskih) 1999-2001 <ruiv@uic.nnov.ru>
//  You can use, modify, distribute this code or any other part
//  of colorer library in sources or in binaries only according
//  to Colorer License (see /doc/license.txt for more information).
//

typedef union SCharData
{
  long IArr[8];  // must be 32 bytes!!!
  char CArr[32];
  void setbit(unsigned char Bit);
  void clearbit(unsigned char Bit);
  bool getbit(unsigned char Bit);
} *PCharData;

class CLocale
{
  static SCharData UCData, LCData;
  static char *toupper;
  static char *tolower;
public:
  // names conflict - need prefix :(
  bool static cl_setlocale(char *upper, char *lower);
  bool static cl_isdigit(char c);
  bool static cl_isword(char c);
  bool static cl_isuppercase(char c);
  bool static cl_islowercase(char c);
  char static cl_lowcase(char c);
  char static cl_upcase(char c);
  int static cl_stricmp(char *c1, char *c2);
  int static cl_strnicmp(char *c1, char *c2, int len);
};

////////////////////////////////////////////////////////////////////////////
// bit ops - inline (good speedup)
void inline SCharData::setbit(unsigned char Bit)
{
  CArr[Bit >> 3] |= (char)(1 << (Bit&7));
};
void inline SCharData::clearbit(unsigned char Bit)
{
  CArr[Bit >> 3] &= (char)(~(1 << (Bit&7)));
};
bool inline SCharData::getbit(unsigned char Bit)
{
  return (CArr[Bit >> 3] & (1 << (Bit&7))) != 0;
};
bool inline CLocale::cl_isword(char c)
{
  if ((c >= 0x30 && c <= 0x39) || c == '_') return true;
  if (toupper && tolower)
    return (toupper[(unsigned char)c] != c) || (tolower[(unsigned char)c] != c);
  return UCData.getbit(c) || LCData.getbit(c);
};


#if defined __unix__
extern "C" int stricmp(char *s1, char *s2);
extern "C" int strnicmp(char *s1, char *s2, int n);
#endif
