//
//  Copyright (c) Cail Lomecb (Igor Ruskih) 1999-2001 <ruiv@uic.nnov.ru>
//  You can use, modify, distribute this code or any other part
//  of colorer library in sources or in binaries only according
//  to Colorer License (see /doc/license.txt for more information).
//

/////////////////////////////////////////////////////////////////////////////
// substs standard insensitive string compares for ANSI compatibility
//
#include "clocale.h"

/////////////////////////////////////////////////////////////////////////////
// dos866
SCharData CLocale::UCData  = { { 0x0, 0x0, 0x7fffffe, 0x0, 0xffffffff, 0x0, 0x0, 0x10000 } };
SCharData CLocale::LCData  = { { 0x0, 0x0, 0x0, 0x7fffffe, 0x0, 0xffff, 0x0, 0x2ffff } };
char *CLocale::toupper = 0;
char *CLocale::tolower = 0;

bool CLocale::cl_setlocale(char *upper, char *lower)
{
  toupper = upper;
  tolower = lower;
  return true;
};
bool CLocale::cl_isdigit(char c)
{
  return c >= 0x30 && c <= 0x39;
};
bool CLocale::cl_isuppercase(char c)
{
  if (toupper && tolower)
    return (toupper[(unsigned char)c] == c) || (tolower[(unsigned char)c] != c);
  return UCData.getbit(c);
};
bool CLocale::cl_islowercase(char c)
{
  if (toupper && tolower)
    return (toupper[(unsigned char)c] != c) || (tolower[(unsigned char)c] == c);
  return LCData.getbit(c);
};
char CLocale::cl_lowcase(char c)
{
  if (tolower)
    return tolower[(unsigned char)c];
  if (UCData.getbit(c))
    return c + ((unsigned char)c >= 0x90) ? '\x50' : '\x20';
  return c;
};
char CLocale::cl_upcase(char c)
{
  if (toupper)
    return toupper[(unsigned char)c];
  if (LCData.getbit(c))
    return c - ((unsigned char)c >= 0xE0) ? '\x50' : '\x20';
  return c;
};

int CLocale::cl_stricmp(char *c1, char *c2)
{
unsigned int i1, i2;
  while(*c1 || *c2){
    i1 = CLocale::cl_lowcase(*c1);
    i2 = CLocale::cl_lowcase(*c2);
    if (i1 < i2) return -1;
    if (i1 > i2) return 1;
    if (!i1) return -1;
    if (!i2) return 1;
    c1++;
    c2++;
  };
  return 0;
};
int CLocale::cl_strnicmp(char *c1, char *c2, int len)
{
unsigned int i1, i2;
  while((*c1 || *c2) && len){
    i1 = CLocale::cl_lowcase(*c1);
    i2 = CLocale::cl_lowcase(*c2);
    if (i1 < i2) return -1;
    if (i1 > i2) return 1;
    if (!i1) return -1;
    if (!i2) return 1;
    c1++;
    c2++;
    len--;
  };
  return 0;
};



#ifdef __unix__
extern "C" int stricmp(char *c1, char *c2)
{
  return CLocale::cl_stricmp(c1, c2);
};
extern "C" int strnicmp(char *c1, char *c2, int len)
{
  return CLocale::cl_strnicmp(c1, c2, len);
};
#endif