#include "..\..\plugin.hpp"
#include "..\srplugin.hpp"
#include "transl.hpp"

BOOL WINAPI SaveConfig(const void *data, const char *key)
{
  const MainOpt &CurOpt=*static_cast<const MainOpt *>(data);

  return
    SRInfo.WriteStr(PluginRootKey,key,"name",CurOpt.name)&&
    SRInfo.WriteStr(PluginRootKey,key,"mask",CurOpt.mask)&&
    SRInfo.WriteStr(PluginRootKey,key,"dir",CurOpt.dir)&&
    SRInfo.WriteDWORD(PluginRootKey,key,"target",CurOpt.target)&&
    SRInfo.WriteDWORD(PluginRootKey,key,"searchmode",CurOpt.searchmode)&&
    SRInfo.WriteDWORD(PluginRootKey,key,"transliterate",CurOpt.transliterate)&&
    SRInfo.WriteDWORD(PluginRootKey,key,"log",CurOpt.log)&&
    SRInfo.WriteDWORD(PluginRootKey,key,"dot",CurOpt.dot)&&
    SRInfo.WriteDWORD(PluginRootKey,key,"subfolders",CurOpt.subfolders)&&
    SRInfo.ESO_Save(PluginRootKey,key,CurOpt.ESOpt)
  ;
}

BOOL WINAPI LoadConfig(void * data, const char *key)
{
  MainOpt &CurOpt = *static_cast<MainOpt *>(data);
  CurOpt.type=false;
  SRInfo.ReadStr(PluginRootKey,key,"name",CurOpt.name,"",sizeof(CurOpt.name));
  SRInfo.ReadStr(PluginRootKey,key,"mask",CurOpt.mask,"",sizeof(CurOpt.mask));
  SRInfo.ReadStr(PluginRootKey,key,"dir",CurOpt.dir,"",sizeof(CurOpt.dir));
  CurOpt.target=SRInfo.ReadDWORD(PluginRootKey,key,"target",0);
  CurOpt.searchmode=(FS_SEARCHMODE)SRInfo.ReadDWORD(PluginRootKey,key,"searchmode",0);
  CurOpt.transliterate=SRInfo.ReadDWORD(PluginRootKey,key,"transliterate",0);
  CurOpt.log=SRInfo.ReadDWORD(PluginRootKey,key,"log",0);
  CurOpt.dot=SRInfo.ReadDWORD(PluginRootKey,key,"dot",0);
  CurOpt.subfolders=SRInfo.ReadDWORD(PluginRootKey,key,"subfolders",0);
  return SRInfo.ESO_Load(PluginRootKey,key,CurOpt.ESOpt);
}

bool LoadScheme(MainOpt &O,const int Number)
{
  int total=SRInfo.ReadDWORD(PluginRootKey,"Scheme","total",0);
  if(Number>=0&&Number<total)
  {
    char Key[256];
    FSF.sprintf(Key,"%s\\%c","Scheme",'0'+Number);
    LoadConfig(&O,Key);
    return true;
  }
  return false;
}
