#include <stdio.h>
#include "..\..\plugin.hpp"
#include "..\..\farkeys.hpp"
#include "..\srplugin.hpp"
#include "transl.hpp"

#define Dialog_SetText(Index,Text) Info.SendDlgMessage(hDlg,DM_SETTEXTPTR,Index,(long)Text)
#define Dialog_GetText(Index,Text) Info.SendDlgMessage(hDlg,DM_GETTEXTPTR,Index,(long)Text)
#define Dialog_SetState(Index,State) Info.SendDlgMessage(hDlg,DM_SETCHECK,Index,State?BSTATE_CHECKED:BSTATE_UNCHECKED)
#define Dialog_GetState(Index) Info.SendDlgMessage(hDlg,DM_GETCHECK,Index,0)
#define Dialog_Show(Index) Info.SendDlgMessage(hDlg,DM_SHOWITEM,Index,1)
#define Dialog_Hide(Index) Info.SendDlgMessage(hDlg,DM_SHOWITEM,Index,0)
#define Dialog_Visible(Index) Info.SendDlgMessage(hDlg,DM_SHOWITEM,Index,-1)
#define Dialog_Focus(Index) Info.SendDlgMessage(hDlg,DM_SETFOCUS,Index,0)
#define Dialog_GetListPos(Index) Info.SendDlgMessage(hDlg,DM_LISTGETCURPOS,Index,0)
#define Dialog_SetListPos(Index,Pos) {FarListPos LPos={Pos,-1}; Info.SendDlgMessage(hDlg,DM_LISTSETCURPOS,Index,(long)&LPos);}
#define Dialog_Unchanged(Index,State) Info.SendDlgMessage(hDlg,DM_EDITUNCHANGEDFLAG,Index,State)

enum
{
  iTitle=0,
  iR2L,
  iL2R,
  iUNI,
  iMask=iUNI+3,
  iSelected,
  iFileMask,
  iFolders,
  iTargetLabel,
  iTarget,
  iDir,
  iSubfolders,
  iMoreCheck,
  iMoreButton,
  iDot=iMoreButton+2,
  iLog,
  iOk=iLog+2,
  iScheme=iOk+2,
  iSave,
  iRename,
};

struct DialogOpt
{
  bool Type;
  MainOpt MOpt;
};

int WINAPI EditScheme(void *data,const char *Name);

static void ArrangeButtons(HANDLE hDlg,int start,int finish)
{
  SMALL_RECT rect;
  Info.SendDlgMessage(hDlg,DM_GETDLGRECT,0,(long)&rect);
  int width=rect.Right-rect.Left-7,button_width=0;
  for(int i=start;i<=finish;i++)
    if(Dialog_Visible(i))
    {
      Info.SendDlgMessage(hDlg,DM_GETITEMPOSITION,i,(long)&rect);
      button_width+=rect.Right-rect.Left+2;
    }
  if(button_width)
  {
    int left=4;
    button_width-=2;
    if(button_width<width)
    {
      left+=(width-button_width)/2;
    }
    for(int i=start;i<=finish;i++)
      if(Dialog_Visible(i))
      {
        Info.SendDlgMessage(hDlg,DM_GETITEMPOSITION,i,(long)&rect);
        button_width=rect.Right-rect.Left+2;
        rect.Left=left;
        Info.SendDlgMessage(hDlg,DM_SETITEMPOSITION,i,(long)&rect);
        left+=button_width;
      }
  }
}

static void LoadDialog(HANDLE hDlg,MainOpt &MOpt)
{
  Dialog_SetText(iMask,MOpt.mask);
  Dialog_SetText(iDir,MOpt.dir);
  Dialog_SetListPos(iTarget,MOpt.target);
  Dialog_Unchanged(iMask,1);
  Dialog_Unchanged(iDir,1);
  Dialog_Unchanged(iTarget,1);
  Dialog_SetState(iSelected,false);
  Dialog_SetState(iFileMask,false);
  Dialog_SetState(iFolders,false);
  switch(MOpt.searchmode)
  {
    case FSSM_SELECTION:
      Dialog_SetState(iSelected,true);
      break;
    case FSSM_MASK:
      Dialog_SetState(iFileMask,true);
      break;
    case FSSM_LIST:
      Dialog_SetState(iFolders,true);
      break;
    default:
      Dialog_SetState(iSelected,true);
      break;
  }
  Dialog_SetState(iR2L,false);
  Dialog_SetState(iL2R,false);
  Dialog_SetState(iUNI,false);
  switch(MOpt.transliterate)
  {
    case TRANS_RUS:
      Dialog_SetState(iR2L,true);
      break;
    case TRANS_LAT:
      Dialog_SetState(iL2R,true);
      break;
    case TRANS_UNI:
      Dialog_SetState(iUNI,true);
      break;
    default:
      Dialog_SetState(iR2L,true);
      break;
  }
  Dialog_SetState(iLog,MOpt.log);
  Dialog_SetState(iDot,MOpt.dot);
  Dialog_SetState(iSubfolders,MOpt.subfolders);
  Dialog_SetState(iMoreCheck,SRInfo.ESO_GetMode(MOpt.ESOpt));
}

static void SaveDialog(HANDLE hDlg,MainOpt &MOpt)
{
  Dialog_GetText(iMask,MOpt.mask);
  Dialog_GetText(iDir,MOpt.dir);
  MOpt.target=Dialog_GetListPos(iTarget);
  if(Dialog_GetState(iR2L))
    MOpt.transliterate=TRANS_RUS;
  else if(Dialog_GetState(iL2R))
    MOpt.transliterate=TRANS_LAT;
  else
    MOpt.transliterate=TRANS_UNI;
  if(Dialog_GetState(iSelected))
    MOpt.searchmode=FSSM_SELECTION;
  else if(Dialog_GetState(iFileMask))
    MOpt.searchmode=FSSM_MASK;
  else
    MOpt.searchmode=FSSM_LIST;
  MOpt.log=Dialog_GetState(iLog);
  MOpt.dot=Dialog_GetState(iDot);
  MOpt.subfolders=Dialog_GetState(iSubfolders);
  SRInfo.ESO_SetMode(MOpt.ESOpt,Dialog_GetState(iMoreCheck));
}

long WINAPI MainDlgProc(HANDLE hDlg,int Msg,int Param1,long Param2)
{
  MainOpt &MOpt=*static_cast<MainOpt *>((void *)Info.SendDlgMessage(hDlg,DM_GETDLGDATA,0,0));
  switch(Msg)
  {
    case DN_INITDIALOG:
      Info.SendDlgMessage(hDlg,DM_SETTEXTLENGTH,iMask,MAX_PATH-1);
      Info.SendDlgMessage(hDlg,DM_SETTEXTLENGTH,iDir,MAX_PATH-1);
      //load options
      LoadDialog(hDlg,MOpt);
      if(MOpt.type)
      {
        Dialog_Hide(iRename);
      }
      else
      {
        Dialog_Hide(iScheme);
        Dialog_Hide(iSave);
      }
      ArrangeButtons(hDlg,iOk,iRename);
      break;
    case DN_KEY:
      if(Param2>=KEY_ALTSHIFT0&&Param2<=KEY_ALTSHIFT9&&MOpt.type)
      {
        MainOpt MOptLoad;
        MOptLoad.ESOpt=SRInfo.ESO_Create();
        if(MOptLoad.ESOpt&&LoadScheme(MOptLoad,Param2-KEY_ALTSHIFT0))
        {
          LoadDialog(hDlg,MOptLoad);
          Info.SendDlgMessage(hDlg,DM_REDRAW,0,0);
        }
        if(MOptLoad.ESOpt) SRInfo.ESO_Delete(&MOptLoad.ESOpt);
      }
      break;
    case DN_BTNCLICK:
      if(Param1==iMoreButton)
      {
        SRInfo.ESO_Edit(MOpt.ESOpt);
        Dialog_Focus(iMoreCheck);
        return TRUE;
      }
      else if(Param1==iScheme)
      {
        char buff[64]; LocMsg("SchemeTitle",buff,sizeof(buff));
        MainOpt MOpt2;
        CSchemes *scheme=SRInfo.SCHEME_Create(PluginRootKey,"Scheme","name","total",buff,&MOpt,&MOpt2,LoadConfig,SaveConfig,EditScheme,0);
        MOpt2.ESOpt=SRInfo.ESO_Create();
        if(scheme&&MOpt2.ESOpt)
        {
          if(SRInfo.SCHEME_Menu(scheme,0)>-1) Dialog_Focus(iOk);
          else Dialog_Focus(iR2L);
          LoadDialog(hDlg,MOpt);
        }
        if(scheme)
          SRInfo.SCHEME_Delete(&scheme);
        if(MOpt2.ESOpt)
          SRInfo.ESO_Delete(&MOpt2.ESOpt);
        return TRUE;
      }
      else if(Param1==iSave)
      {
        char buff[64]; LocMsg("SchemeTitle",buff,sizeof(buff));
        MainOpt MOpt1,MOpt2;
        CSchemes *scheme=SRInfo.SCHEME_Create(PluginRootKey,"Scheme","name","total",buff,&MOpt1,&MOpt2,LoadConfig,SaveConfig,EditScheme,0);
        MOpt1.ESOpt=SRInfo.ESO_Create();
        MOpt2.ESOpt=SRInfo.ESO_Create();
        if(scheme&&MOpt1.ESOpt&&MOpt2.ESOpt)
        {
          SaveDialog(hDlg,MOpt1);
          SRInfo.SCHEME_Add(scheme,&MOpt1);
        }
        if(scheme)
          SRInfo.SCHEME_Delete(&scheme);
        if(MOpt1.ESOpt)
          SRInfo.ESO_Delete(&MOpt1.ESOpt);
        if(MOpt2.ESOpt)
          SRInfo.ESO_Delete(&MOpt2.ESOpt);
        Dialog_Focus(iOk);
        return TRUE;
      }
      break;
    case DN_CLOSE:
      if((Param1==iOk)||(Param1==iRename)) SaveDialog(hDlg,MOpt);
      break;
    case DN_HELP:
      Info.ShowHelp(Info.ModuleName,NULL,FHELP_SELFHELP);
      return (long)NULL;
  }
  return Info.DefDlgProc(hDlg,Msg,Param1,Param2);
}

int ShowDialog(MainOpt &MOpt,const char *Name)
{
  char maskHist[80],directoryHist[80];
  SR_CMD_GetString maskData={SRSTR_MASKHIST,maskHist,sizeof(maskHist),0};
  SR_CMD_GetString directoryData={SRSTR_DIRECTORYHIST,directoryHist,sizeof(directoryHist),0};

  SRInfo.Cmd(SRC_GETSTRING,&maskData);
  SRInfo.Cmd(SRC_GETSTRING,&directoryData);
  /*
    000000000011111111112222222222333333333344444444445555555555666666666677777
    012345678901234567890123456789012345678901234567890123456789012345678901234
  00                                                                           00
  01    Rename files ͻ   01
  02    (*) Rusian to latin                                                  02
  03    ( ) Latin to russian                                                 03
  04    ( ) Strip unicode                                                    04
  05   Ķ   05
  06    File mask: *                                                     |   06
  07    (*) Search in selected                                               07
  08    ( ) Search with file-mask                                            08
  09    ( ) Search in folders:                                           |   09
  10    [ ] Process subfolders [ ] More options... [ Configure ]             10
  11   Ķ   11
  12    [ ] Stop on dot                                                      12
  13    [ ] Write log-file                                                   13
  14   Ķ   14
  15                [ OK ]  [ Cancel ]  [ Scheme ]  [ Save ]                 15
  16   ͼ   16
  17                                                                           17
    000000000011111111112222222222333333333344444444445555555555666666666677777
    012345678901234567890123456789012345678901234567890123456789012345678901234
  */
  InitDialogItem InitItems[]={
    {DI_DOUBLEBOX,3,1,71,16,0,0,0,0,true,"Name"},
    {DI_RADIOBUTTON,5,2,0,0,1,0,DIF_GROUP,0,true,"DialogType1"},
    {DI_RADIOBUTTON,5,3,0,0,0,0,0,0,true,"DialogType2"},
    {DI_RADIOBUTTON,5,4,0,0,0,0,DIF_DISABLE,0,true,"DialogType3"},
    {DI_TEXT,0,05,0,0,0,0,DIF_SEPARATOR,0,false,""},
    {DI_TEXT,5,6,0,0,0,0,0,0,true,"DialogMask"},
    {DI_EDIT,0,6,69,0,TRUE,(DWORD)maskHist,DIF_HISTORY,0,false,""},
    {DI_RADIOBUTTON,5,7,0,0,0,0,DIF_GROUP,0,true,"DialogSelected"},
    {DI_RADIOBUTTON,5,8,0,0,0,0,0,0,true,"DialogFileMask"},
    {DI_RADIOBUTTON,5,9,0,0,0,0,0,0,true,"DialogFolders"},
    {DI_TEXT,0,7,0,0,0,0,0,0,true,"DialogTarget"},
    {DI_COMBOBOX,0,7,69,0,0,0,DIF_DROPDOWNLIST,0,false,""},
    {DI_EDIT,0,9,69,0,0,(DWORD)directoryHist,DIF_HISTORY,0,false,""},
    {DI_CHECKBOX,5,10,0,0,0,0,0,0,true,"DialogProcessSubfolders"},
    {DI_CHECKBOX,0,10,0,0,0,0,0,0,true,"DialogMoreOptions"},
    {DI_BUTTON,60,10,0,0,0,0,DIF_BTNNOCLOSE,0,true,"DialogConfigure"},
    {DI_TEXT,0,11,0,0,0,0,DIF_SEPARATOR,0,false,""},
    {DI_CHECKBOX,5,12,0,0,0,0,0,0,true,"DialogStopOnDot"},
    {DI_CHECKBOX,5,13,0,0,0,0,0,0,true,"DialogWriteLog"},
    {DI_TEXT,0,14,0,0,0,0,DIF_SEPARATOR,0,false,""},
    {DI_BUTTON,0,15,0,0,0,0,0,1,true,"Ok"},
    {DI_BUTTON,0,15,0,0,0,0,0,0,true,"Cancel"},
    {DI_BUTTON,0,15,0,0,0,0,DIF_BTNNOCLOSE,0,true,"Scheme"},
    {DI_BUTTON,0,15,0,0,0,0,DIF_BTNNOCLOSE,0,true,"Save"},
    {DI_BUTTON,0,15,0,0,0,0,0,0,true,"Rename"},
  };

  FarDialogItem DialogItems[sizeofa(InitItems)];
  InitDialogItems(InitItems,DialogItems,sizeofa(InitItems));

  DialogItems[iMask].X1=DialogItems[iMask-1].X1+strlen(DialogItems[iMask-1].Data);
  DialogItems[iDir].X1=DialogItems[iFolders].X1+strlen(DialogItems[iFolders].Data)+4;
  DialogItems[iMoreCheck].X1=DialogItems[iSubfolders].X1+strlen(DialogItems[iSubfolders].Data)+4;
  DialogItems[iMoreButton].X1=DialogItems[iMoreCheck].X1+strlen(DialogItems[iMoreCheck].Data)+4;
  DialogItems[iTargetLabel].X1=DialogItems[iSelected].X1+strlen(DialogItems[iSelected].Data)+8;
  DialogItems[iTarget].X1=DialogItems[iTargetLabel].X1+strlen(DialogItems[iTargetLabel].Data)+1;

  char *TargetIndex[]={"DialogComboFiles","DialogComboFolders","DialogComboFF"};
  FarListItem Target[sizeofa(TargetIndex)];
  FarList Targets={sizeofa(Target),Target};
  for(unsigned int i=0;i<sizeofa(Target);i++)
  {
    Target[i].Flags=0;
    LocMsg(TargetIndex[i],Target[i].Text,sizeof(Target[i].Text));
  }
  Target[0].Flags=LIF_SELECTED;
  DialogItems[iTarget].ListItems=&Targets;
  if(Name)
  {
    strcat(DialogItems[iTitle].Data,": ");
    strcat(DialogItems[iTitle].Data,Name);
  }

  int ExitCode=Info.DialogEx(Info.ModuleNumber,-1,-1,75,18,NULL,DialogItems,sizeofa(InitItems),0,0,MainDlgProc,(DWORD)&MOpt);
  if(ExitCode==iOk)
    return 1;
  if(ExitCode==iRename)
    return 2;
  return 0;
}

int WINAPI EditScheme(void *data,const char *Name)
{
  MainOpt &MOpt=*static_cast<MainOpt *>(data);
  return ShowDialog(MOpt,Name)-1;
}
