#ifndef __TRANSL_HPP__
#define __TRANSL_HPP__

#define TRANS_RUS 0
#define TRANS_LAT 1
#define TRANS_UNI 2

#define sizeofa(array) (sizeof(array)/sizeof(array[0]))

struct InitDialogItem
{
  int Type;
  int X1, Y1, X2, Y2;
  int Focus;
  int Selected;
  unsigned int Flags;
  int DefaultButton;
  bool Load;
  char *Data;
};

struct pair
{
  char latin[64];
  int latin_len;
  char russian[64];
  int russian_len;
};

struct MainOpt
{
  bool type;
  char name[128];
  char mask[MAX_PATH];
  char dir[MAX_PATH];
  FS_SEARCHMODE searchmode;
  int transliterate,log,dot,subfolders,target;
  EXTENDEDSEARCHOPTIONS *ESOpt;
};

struct SearchOpt
{
  int transliterate,log,dot;
  HANDLE logfile;
  char logfilename[MAX_PATH];
  SRWORKSTATUS srwStatus;
};

extern struct PluginStartupInfo Info;
extern struct SRPluginStartupInfo SRInfo;
extern struct FarStandardFunctions FSF;
extern char PluginRootKey[256];

extern char *LocMsg(const char *MsgName,char *Dest,int maxsize);
extern void InitDialogItems(InitDialogItem *Init,FarDialogItem *Item,int ItemsNumber);

extern int ShowDialog(struct MainOpt &Mopt,const char *Name);

extern BOOL WINAPI SaveConfig(const void *data, const char *key);
extern BOOL WINAPI LoadConfig(void * data, const char *key);
extern bool LoadScheme(MainOpt &O,const int Number);

extern BOOL WriteData(HANDLE file,BYTE *buffer,DWORD length);
extern void GetLogName(char *name);

#define FAR165_INFO_SIZE 336

#endif
