#include "..\..\plugin.hpp"
#include "..\srplugin.hpp"
#include <stdio.h>
#include <stdlib.h>
#include "transl.hpp"

struct PluginStartupInfo Info;
struct SRPluginStartupInfo SRInfo;
struct FarStandardFunctions FSF;
char MsgFileName[MAX_PATH];
char PluginRootKey[256];
bool IsOldFAR=true,IsOldSR=true;

pair *pairs=NULL;
int pair_count=0;

/*static int Config(void);*/

extern "C"
{
  void WINAPI _export GetInfo(struct SRPluginInfo *);
  void WINAPI _export Start(const struct PluginStartupInfo *,const struct SRPluginStartupInfo *);
  void WINAPI _export Exit(void);
  int WINAPI _export Run(DWORD,DWORD,DWORD);
}

char *LocMsg(const char *MsgName,char *Dest,int maxsize)
{
  return SRInfo.LocMsg(MsgFileName,MsgName,Dest,maxsize);
}

void InitDialogItems(InitDialogItem *Init,FarDialogItem *Item,int ItemsNumber)
{
  for (int i=0;i<ItemsNumber;i++)
  {
    Item[i].Type=Init[i].Type;
    Item[i].X1=Init[i].X1;
    Item[i].Y1=Init[i].Y1;
    Item[i].X2=Init[i].X2;
    Item[i].Y2=Init[i].Y2;
    Item[i].Focus=Init[i].Focus;
    Item[i].Selected=Init[i].Selected;
    Item[i].Flags=Init[i].Flags;
    Item[i].DefaultButton=Init[i].DefaultButton;
    if(Init[i].Load)
      LocMsg(Init[i].Data,Item[i].Data,sizeof(Item[i].Data));
    else
      strcpy(Item[i].Data,Init[i].Data);
  }
}

void WINAPI _export GetInfo(struct SRPluginInfo *SRPInfo)
{
  SRPInfo->StructSize=sizeof(SRPluginInfo);
  SRPInfo->Flags=SRPIF_PANEL/*|SRPIF_CONFIG*/;
  LocMsg("Name",SRPInfo->MenuString,sizeof(SRPInfo->MenuString));
  SRPInfo->SR_MinVer=MAKE_SANDRVERSION(2,0,0);
}

void WINAPI _export Exit(void)
{
  if(pairs) { HeapFree(GetProcessHeap(),0,pairs); pair_count=0; }
}

int __cdecl fcmp(const void *first,const void *second)
{
  return (((const pair *)second)->latin_len)-(((const pair *)first)->latin_len);
}

void WINAPI _export Start(const struct PluginStartupInfo *psInfo,const SRPluginStartupInfo *srInfo)
{
  memset(&Info,0,sizeof(Info));
  memset(&SRInfo,0,sizeof(SRInfo));
  memmove(&Info,psInfo,(psInfo->StructSize>(int)sizeof(Info))?sizeof(Info):psInfo->StructSize);
  memmove(&SRInfo,srInfo,(srInfo->StructSize>(int)sizeof(SRInfo))?sizeof(SRInfo):srInfo->StructSize);
  if(psInfo->StructSize>FAR165_INFO_SIZE)
  {
    memcpy(&FSF,psInfo->FSF,sizeof(FSF));
    Info.FSF=&FSF;

    if(((Info.AdvControl(Info.ModuleNumber,ACTL_GETFARVERSION,NULL)&0XFFFF0000)>>16)>=1272)
      IsOldFAR=false;
    if(HIBYTE(LOWORD(SRInfo.Cmd(SRC_GETVERSION,NULL)))>=2)
    {
      IsOldSR=false;
      SRInfo.InitLocMsg(Info.ModuleName,MsgFileName);
      strcpy(PluginRootKey,Info.RootKey);
      strcat(PluginRootKey,"\\Transl");
      {
        char buff[64],*delim_ptr;
        LocMsg("PairsCount",buff,sizeof(buff));
        int count=atoi(buff);
        if(count>0)
        {
          pairs=(pair *)HeapAlloc(GetProcessHeap(),HEAP_ZERO_MEMORY,count*sizeof(pair));
          if(pairs)
          {
            for(int i=0;i<count;i++)
            {
              _itoa(i,buff,10);
              LocMsg(buff,buff,sizeof(buff));
              delim_ptr=strchr(buff,'|');
              if(delim_ptr)
              {
                strncpy(pairs[i].latin,buff,delim_ptr-buff);
                pairs[i].latin_len=strlen(pairs[i].latin);
                strcpy(pairs[i].russian,delim_ptr+1);
                pairs[i].russian_len=strlen(pairs[i].russian);
              }
            }
            pair_count=count;
            FSF.qsort(pairs,pair_count,sizeof(pair),fcmp);
          }
        }
      }
    }
  }
}

#define MAX_PATH1 (MAX_PATH-1)
int Replace(const WIN32_FIND_DATA *wfd,char *newname,int type,int dot)
{
  char *pName=FSF.PointToName(wfd->cFileName);
  int newlen,stop=FALSE;
  newlen=pName-wfd->cFileName;
  memcpy(newname,wfd->cFileName,newlen);
  while((*pName)&&(newlen<MAX_PATH1))
  {
    if(dot&&(*pName=='.')) stop=TRUE;
    bool updated=false;
    if(!stop)
      for(int i=0;i<pair_count;i++)
      {
        if(type==TRANS_RUS)
        {
          if(!strncmp(pairs[i].russian,pName,pairs[i].russian_len))
          {
            int copylen=((newlen+pairs[i].latin_len)>MAX_PATH1)?(MAX_PATH1-newlen):(pairs[i].latin_len);
            updated=true;
            strncpy(newname+newlen,pairs[i].latin,copylen);
            newlen+=copylen;
            pName+=pairs[i].russian_len;
            break;
          }
        }
        else if(type==TRANS_LAT)
        {
          if(!strncmp(pairs[i].latin,pName,pairs[i].latin_len))
          {
            int copylen=((newlen+pairs[i].russian_len)>MAX_PATH1)?(MAX_PATH1-newlen):(pairs[i].russian_len);
            updated=true;
            strncpy(newname+newlen,pairs[i].russian,copylen);
            newlen+=copylen;
            pName+=pairs[i].latin_len;
            break;
          }
        }
      }
    if(!updated)
    {
      *(newname+newlen)=*pName;
      newlen++;
      pName++;
    }
  }
  newname[newlen]=0;
  return newlen;
}
#undef MAX_PATH1

void WINAPI RenameOneFile(WIN32_FIND_DATA *wfd,void *UserData)
{
  char newname[MAX_PATH];
  struct SearchOpt &SOpt=*static_cast<SearchOpt *>(UserData);
  if(SOpt.log&&(!strcmp(wfd->cFileName,SOpt.logfilename))) return;
  if(Replace(wfd,newname,SOpt.transliterate,SOpt.dot))
  {
    if(strcmp(wfd->cFileName,newname))
    {
      BOOL ok=MoveFile(wfd->cFileName,newname);
      if(!ok)
      {
        SOpt.srwStatus.LastError=GetLastError();
        SOpt.srwStatus.ExitCode=SRWE_RENAMEFILE;
        strcpy(SOpt.srwStatus.file2,newname);
      }
      if(SOpt.log&&(SOpt.logfile!=INVALID_HANDLE_VALUE))
      {
        static char logbuf[MAX_PATH*3];
        sprintf(logbuf,"%s -> %s -> %s\r\n",wfd->cFileName,newname,ok?"OK":"Error");
        strcpy(wfd->cFileName,newname);
        if(!WriteData(SOpt.logfile,(BYTE *)logbuf,strlen(logbuf)))
        {
          SOpt.srwStatus.ExitCode=SRWE_WRITEFILE;
          SOpt.srwStatus.LastError=GetLastError();
          strcpy(SOpt.srwStatus.file2,newname);
        }
      }
      strncpy(wfd->cFileName,newname,sizeof(wfd->cFileName));
    }
  }
}

void WINAPI ShowProgress(const char *FileName)
{
  char Path[MAX_PATH]; int len;
  strcpy(Path,FileName);
  FSF.TruncPathStr(Path,50);
  len=strlen(Path);
  if(len<50)
  {
    memset(Path+len,' ',50-len);
    Path[50]=0;
  }
  const char *MsgItems[]={"",Path};
  Info.Message(Info.ModuleNumber,0,NULL,MsgItems,sizeofa(MsgItems),0);
}

int WINAPI _export Run(DWORD OpenFrom,DWORD Reserved1,DWORD Reserved2)
{
  (void)Reserved1;
  (void)Reserved2;
  CFileSearch *FileSearch;
  MainOpt MOpt;
  SearchOpt SOpt;
  PanelInfo PInfo;
/*  if(OpenFrom==SRPO_CONFIG)
    return Config();*/
  if(OpenFrom!=SRPO_PANEL)
    return FALSE;
  if(IsOldFAR||IsOldSR)
  {
    char MsgData[3][80];
    const char *MsgItems[]={MsgData[0],MsgData[1],MsgData[2]};
    LocMsg("Error",MsgData[0],sizeof(MsgData[0]));
    LocMsg((IsOldFAR?"OldFAR":"OldSR"),MsgData[1],sizeof(MsgData[1]));
    LocMsg("Ok",MsgData[2],sizeof(MsgData[2]));
    Info.Message(Info.ModuleNumber,FMSG_WARNING,NULL,MsgItems,sizeofa(MsgItems),1);
    return FALSE;
  }
  FileSearch=SRInfo.FS_Create();
  MOpt.ESOpt=SRInfo.ESO_Create();
  if(FileSearch&&MOpt.ESOpt)
  {
    LoadConfig(&MOpt,"");
    MOpt.type=true;
    if(ShowDialog(MOpt,NULL)==1)
    {
      SaveConfig(&MOpt,"");
      int flags=FSSF_PROCESSDIR;
      if(MOpt.subfolders) flags|=FSSF_PROCESSSUBDIR;
      if(MOpt.target==1) flags|=FSSF_PROCESSDIR|FSSF_ONLYDIR;
      else if(MOpt.target==2) flags|=FSSF_PROCESSDIR;
      Info.Control(INVALID_HANDLE_VALUE,FCTL_GETPANELINFO,&PInfo);
      FS_ERROR_CODE err=(FS_ERROR_CODE)SRInfo.FS_Set(FileSearch,MOpt.searchmode,flags,MOpt.ESOpt,(MOpt.searchmode==FSSM_MASK)?PInfo.CurDir:((MOpt.searchmode==FSSM_LIST)?MOpt.dir:NULL),MOpt.mask,&PInfo,&SOpt.srwStatus,0);
      if(err==FSE_SUCCESS)
      {
        SOpt.transliterate=MOpt.transliterate;
        SOpt.log=MOpt.log;
        SOpt.dot=MOpt.dot;
        SOpt.logfile=INVALID_HANDLE_VALUE;
        SOpt.srwStatus.ExitCode=SRWE_OK;
        if(SOpt.log)
        {
          char LogName[MAX_PATH],*filenameptr;
          GetLogName(LogName);
          if(GetFullPathName(LogName,sizeof(SOpt.logfilename),SOpt.logfilename,&filenameptr))
          {
            SOpt.logfile=CreateFile(SOpt.logfilename,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_ALWAYS,0,NULL);
            if(SOpt.logfile==INVALID_HANDLE_VALUE)
            {
              SOpt.srwStatus.ExitCode=SRWE_OPENFILE;
              SOpt.srwStatus.LastError=GetLastError();
              strcpy(SOpt.srwStatus.file1,SOpt.logfilename);
            }
          }
          else
          {
            SOpt.srwStatus.ExitCode=SRWE_OPENFILE;
            SOpt.srwStatus.LastError=GetLastError();
            strcpy(SOpt.srwStatus.file1,LogName);
          }
        }
        if(!SOpt.srwStatus.ExitCode)
        {
          HANDLE screen=Info.SaveScreen(0,0,-1,-1);
          SRInfo.FS_Search(FileSearch,&SOpt,NULL,ShowProgress,RenameOneFile,0);
          Info.RestoreScreen(screen);
          if(SOpt.log)
          {
            DWORD high,len=GetFileSize(SOpt.logfile,&high);
            CloseHandle(SOpt.logfile);
            if(len||high) SRInfo.Cmd(SRC_GOTOFILE,SOpt.logfilename);
            else DeleteFile(SOpt.logfilename);
          }
          Info.Control(INVALID_HANDLE_VALUE,FCTL_UPDATEPANEL,(void *)1);
          Info.Control(INVALID_HANDLE_VALUE,FCTL_REDRAWPANEL,NULL);
        }
        if(SOpt.srwStatus.ExitCode&&(SOpt.srwStatus.ExitCode!=SRWE_ESCAPE))
        {
          SR_CMD_ErrorMsg error={&SOpt.srwStatus,TRUE};
          SRInfo.Cmd(SRC_ERRORMSG,&error);
        }
      }
    }
  }
  if(MOpt.ESOpt)
    SRInfo.ESO_Delete(&MOpt.ESOpt);
  if(FileSearch)
    SRInfo.FS_Delete(&FileSearch);
  return TRUE;
}

/*static int Config(void)
{
  Beep(100,100);
  return TRUE;
}*/

#ifdef __cplusplus
extern "C"{
#endif
  BOOL WINAPI DllMainCRTStartup(HANDLE hDll,DWORD dwReason,LPVOID lpReserved);
#ifdef __cplusplus
};
#endif

BOOL WINAPI DllMainCRTStartup(HANDLE hDll,DWORD dwReason,LPVOID lpReserved)
{
  (void)hDll;
  (void)dwReason;
  (void)lpReserved;
  return TRUE;
}
