#ifndef __WINMEM_H
#define __WINMEM_H
#include <windows.h>
#ifdef USE_BC_RTL
#define winNew(type, size) new type[size]
#define winDel(var) delete var
#else
extern HANDLE heap;

inline void initMem(void)
{
  heap = GetProcessHeap();
}

inline void *malloc(size_t size)
{
  return HeapAlloc(heap, HEAP_ZERO_MEMORY, size);
}

inline void free(void *block)
{
 if ( block != NULL && heap ) HeapFree(heap, 0, block);
}

#define winNew(type, size) (type*)malloc((size)*sizeof(type))
#define winDel(var) free(var)
#endif
#endif
