#include <windows.h>

/*extern "C"
{
  void   WINAPI _export ClosePlugin(HANDLE hPlugin);
  int    WINAPI _export Compare(HANDLE hPlugin,struct PluginPanelItem *Item1,struct PluginPanelItem *Item2,unsigned int Mode);
  int    WINAPI _export Configure(int ItemNumber);
  void   WINAPI _export FreeFindData(HANDLE hPlugin,struct PluginPanelItem *PanelItem,int ItemsNumber);
  int    WINAPI _export GetFindData(HANDLE hPlugin,struct PluginPanelItem **pPanelItem,int *pItemsNumber,int OpMode);
  void   WINAPI _export GetOpenPluginInfo(HANDLE hPlugin,struct OpenPluginInfo *Info);
  int    WINAPI _export GetMinFarVersion(void);
  void   WINAPI _export GetPluginInfo(struct PluginInfo *Info);
  HANDLE WINAPI _export OpenPlugin(int OpenFrom,int Item);
  int    WINAPI _export ProcessEvent(HANDLE hPlugin,int Event,void *Param);
  int    WINAPI _export ProcessKey(HANDLE hPlugin,int Key,unsigned int ControlState);
  int    WINAPI _export PutFiles(HANDLE hPlugin,struct PluginPanelItem *PanelItem,int ItemsNumber,int Move,int OpMode);
  int    WINAPI _export SetDirectory(HANDLE hPlugin,const char *Dir,int OpMode);
  void   WINAPI _export SetStartupInfo(const struct PluginStartupInfo *Info);
};*/

struct BSORESOURCE
{
  WIN32_FIND_DATA FileInfo;
  char BUSY_Status;
  char BOX_Status;
  char REQ_Status;
  char KS_Status;
  LPSTR MailFlavor;
  LPSTR FileFlavor;
  LPSTR LoExt;
  int LoLine;
};

enum enBSOType { tyNO, tyUT, tyLO, tyBSY, tyREQ };
enum enBSOFlavor { flNO, fl_I, fl_C, fl_D, fl_F, fl_H, fl_NB, fl_HB };

struct TFTNAddress
{
  unsigned zone, net, node, point;
  int valid;
  int parse(const char*, TFTNAddress* = NULL);
  char *bso(char*, const char*, const char*, TFTNAddress *defAddress);
  char *box(char*, const char*, int, int);
  char *print(char*, int, TFTNAddress* = NULL);
  TFTNAddress() { valid = zone = net = node = point = 0; };
  TFTNAddress(const char *s, TFTNAddress *defAddress = NULL) { valid = parse(s, defAddress); };
};

extern BSORESOURCE *BSORes;
extern DWORD BSOCount;
extern char rootDir[NM];
extern HANDLE checkHandle;

struct Options
{
  int AddToDisksMenu;
  int DisksMenuDigit;
  int LinksPanelMode;
  int FilesPanelMode;
  int NoChangePanelMode;
  char PathToOutbound[256];
  char Address[256];
  char BasePath[256];
  char TempPath[256];
  char BoxesPath[256];
  int PollFlavor;
  int AttachFlavor;
  int UseLongBoxes;
  int AutoRefresh;
  int UseSlashes;
  int UseRelative;
  int OEMInOutbound;
  int RestoreFolder;
  int Highlighting;
  int AutoCheck;
  int DeleteEmptyLO;
  int AttachFromTemp;
  int UseShortNames;
  int UnsortedPanel;
  int ShortAddresses;
  int UpperPath;
} Opt;

enum enCustomData
{
  custBRK,
  custMail,
  custFile,
  custExt,
  custLine,
  custMAX
};

int Config();
