#include "winmem.h"
#include "FARIntf.h"
#include <direct.h>

#include <plugin.hpp>

#include "scanreg.h"
#include "bsolng.h"
#include "true-bso.h"

#include "syslog.h"

#define dimOf(x) (sizeof(x)/sizeof(*(x)))
#define iMessage(MsgItems, Buttons) Info.Message(Info.ModuleNumber, 0,                           NULL, (MsgItems), dimOf(MsgItems), (Buttons))
#define wMessage(MsgItems, Buttons) Info.Message(Info.ModuleNumber, FMSG_WARNING,                NULL, (MsgItems), dimOf(MsgItems), (Buttons))
#define eMessage(MsgItems, Buttons) Info.Message(Info.ModuleNumber, FMSG_WARNING|FMSG_ERRORTYPE, NULL, (MsgItems), dimOf(MsgItems), (Buttons))

static bool IsOldFar = true;

static inline char *addBackslash(char *s)
{
  if ( *s && ( *(strchr(s, 0)-1) != '\\' ) )
    strcat(s, "\\");
  return s;
}

static inline char *delBackslash(char *s)
{
  if ( *s )
  {
    char *p = strchr(s, 0)-1;
    if ( *p == '\\' )
      *p = 0;
  }
  return s;
}

static inline int isCharSpace(char c)
{
  return strchr(" \t\r\n", c) != NULL;
}

static char toUpper(char c)
{
  char Ansi, ReverseOem;
  OemToCharBuff(&c, &Ansi, 1);
  CharToOemBuff(&Ansi, &ReverseOem, 1);
  if ( IsCharAlpha(Ansi) && ReverseOem == c )
  {
    c = (char)CharUpper((LPTSTR)(unsigned char)Ansi);
    CharToOemBuff(&c, &c, 1);
  }
  return c;
}

static int isXdigit(char c)
{
  if ( c )
  {
    char *s = "0123456789ABCDEF", *p = strchr(s, toUpper(c));
    if ( p )
      return p-s;
  }
  return -1;
}

static inline int isDigit(char c)
{
  return c >= '0' && c <= '9';
}

static int getNum(char*s, unsigned short &n)
{
  n = 0;
  if ( *s )
    while ( isDigit(*s) )
      n = (unsigned short)(n*10+(*s++-'0'));
  else
    n = 0xFFFF;
  return !*s;
}

char *TFTNAddress::print(char *s, int shortForm, TFTNAddress *defAddress)
{
  FSF.sprintf(s, "%u:%u/%u.%u", zone, net, node, point);
  if ( shortForm && defAddress )
  {
    if ( defAddress->zone == zone )
      if ( defAddress->net == net )
        FSF.sprintf(s, "%u.%u", node, point);
      else
        FSF.sprintf(s, "%u/%u.%u", net, node, point);
    else
      FSF.sprintf(s, "%u:%u/%u.%u", zone, net, node, point);
  }
  else
    FSF.sprintf(s, "%u:%u/%u.%u", zone, net, node, point);
  if ( !point )
    *strchr(s, '.') = 0;
  return s;
}

static char *s32 = "0123456789ABCDEFGHIJKLMNOPQRSTUV";

static char *to32(unsigned n, int len)
{
  static char s[12];
  for ( int i = 0 ; i < len ; i++ )
    s[i] = '0';
  s[len] = 0;
  while ( n  )
  {
    s[--len] = s32[n % 32];
    n /= 32;
  }
  return s;
}

static unsigned from32(char *s, int len)
{
  unsigned n = 0;
  for ( int i = 0 ; i < len ; i++ )
  {
    char *p = strchr(s32, toUpper(s[i]));
    if ( p )
      n = n*32+(p-s32);
    else
      return 0xFFFF;
  }
  return n;
}

char *TFTNAddress::box(char *f, const char *box, int sh, int hold)
{
  char *p = strchr(addBackslash(strcpy(f,box)), 0);
  if ( sh )
  {
    strcat(f, to32(zone,  2));
    strcat(f, to32(net,   3));
    strcat(f, to32(node,  3));
    strcat(f, ".");
    strcat(f, to32(point, 2));
    if ( hold )
      strcat(f, "H");
  }
  else
    FSF.sprintf(p, "%u.%u.%u.%u%s", zone, net, node, point, hold ? ".H" : "");
  return addBackslash(f);
}

char *TFTNAddress::bso(char *f, const char *bso, const char *ext, TFTNAddress *defAddress)
{
  char *p = strchr(strcpy(f, bso), 0);
  if ( defAddress->zone != zone )
    FSF.sprintf(p, ".%03X", zone);
  p = strchr(f, 0);
  FSF.sprintf(p, "\\%04X%04X", net, node);
  p = strchr(f, 0);
  if ( point )
    FSF.sprintf(p, ".PNT\\%08X", point);
  return strcat(f, ext);
}

int TFTNAddress::parse(const char *aAddr, TFTNAddress *defAddress)
{
  unsigned short n;
  char addr[64];
  zone = net = node = point = 0;
  int pointSet = 0;
  char *p = strchr(strcpy(addr, aAddr), '.');
  if ( p )
  {
    *p++ = 0;
    if ( getNum(p, n) )
    {
      if ( n == 0xFFFF )
        return 0;
      point = n;
      pointSet = 1;
    }
    else
      return 0;
  }
  p = strchr(addr, '/');
  if ( p )
  {
    *p++ = 0;
    if ( getNum(p, n) )
    {
      if ( n == 0xFFFF )
        return 0;
      node = n;
      p = strchr(addr, ':');
      if ( p )
      {
        *p++ = 0;
        if ( getNum(p, n) )
        {
          if ( n == 0xFFFF )
            return 0;
          net = n;
        }
        else
          return 0;
        if ( getNum(addr, n) )
        {
          if ( n == 0xFFFF )
            return 0;
          zone = n;
        }
        else
          return 0;
      }
      else
      {
        if ( getNum(addr, n) )
        {
          if ( n == 0xFFFF )
            if ( defAddress )
              net = defAddress->net;
            else
              return 0;
          else
            net = n;
          zone = defAddress ? defAddress->zone : (unsigned short)2;
        }
        else
          return 0;
      }
    }
    else
      return 0;
  }
  else if ( defAddress != NULL )
  {
    if ( getNum(addr, n) )
    {
      if ( n == 0xFFFF )
      {
        if ( pointSet )
        {
          zone = defAddress->zone;
          net = defAddress->net;
          node = defAddress->node;
        }
        else
          return 0;
      }
      else
      {
        node = n;
        zone = defAddress->zone;
        net = defAddress->net;
      }
    }
    else
      return 0;
  }
  else
    return 0;
  return 1;
}

static char *cSlash(char *s)
{
  for ( char *p = s ; *p ; p++ )
    if ( *p == '/' )
      *p = '\\';
  return s;
}

static char *cBackslash(char *s)
{
  for ( char *p = s ; *p ; p++ )
    if ( *p == '\\' )
      *p = '/';
  return s;
}

void SaveConfig(void)
{
  SetRegKey(HKEY_CURRENT_USER, "", "Address",           Opt.Address);
  SetRegKey(HKEY_CURRENT_USER, "", "AddToDisksMenu",    Opt.AddToDisksMenu);
  SetRegKey(HKEY_CURRENT_USER, "", "AttachFlavor",      Opt.AttachFlavor);
  SetRegKey(HKEY_CURRENT_USER, "", "AttachFromTemp",    Opt.AttachFromTemp);
  SetRegKey(HKEY_CURRENT_USER, "", "AutoCheck",         Opt.AutoCheck);
  SetRegKey(HKEY_CURRENT_USER, "", "AutoRefresh",       Opt.AutoRefresh);
  SetRegKey(HKEY_CURRENT_USER, "", "BasePath",          Opt.BasePath);
  SetRegKey(HKEY_CURRENT_USER, "", "BoxesPath",         Opt.BoxesPath);
  SetRegKey(HKEY_CURRENT_USER, "", "DeleteEmptyLO",     Opt.DeleteEmptyLO);
  SetRegKey(HKEY_CURRENT_USER, "", "DisksMenuDigit",    Opt.DisksMenuDigit);
  SetRegKey(HKEY_CURRENT_USER, "", "FilesPanelMode",    Opt.FilesPanelMode);
  SetRegKey(HKEY_CURRENT_USER, "", "Highlighting",      Opt.Highlighting);
  SetRegKey(HKEY_CURRENT_USER, "", "LinksPanelMode",    Opt.LinksPanelMode);
  SetRegKey(HKEY_CURRENT_USER, "", "NoChangePanelMode", Opt.NoChangePanelMode);
  SetRegKey(HKEY_CURRENT_USER, "", "OEMInOutbound",     Opt.OEMInOutbound);
  SetRegKey(HKEY_CURRENT_USER, "", "PathToOutbound",    Opt.PathToOutbound);
  SetRegKey(HKEY_CURRENT_USER, "", "PollFlavor",        Opt.PollFlavor);
  SetRegKey(HKEY_CURRENT_USER, "", "RestoreFolder",     Opt.RestoreFolder);
  SetRegKey(HKEY_CURRENT_USER, "", "TempPath",          Opt.TempPath);
  SetRegKey(HKEY_CURRENT_USER, "", "UpperPath",         Opt.UpperPath);
  SetRegKey(HKEY_CURRENT_USER, "", "UnsortedPanel",     Opt.UnsortedPanel);
  SetRegKey(HKEY_CURRENT_USER, "", "ShortAddresses",    Opt.ShortAddresses);
  SetRegKey(HKEY_CURRENT_USER, "", "UseRelative",       Opt.UseRelative);
  SetRegKey(HKEY_CURRENT_USER, "", "UseShortNames",     Opt.UseShortNames);
  SetRegKey(HKEY_CURRENT_USER, "", "UseSlashes",        Opt.UseSlashes);
  SetRegKey(HKEY_CURRENT_USER, "", "UseLongBoxes",      Opt.UseLongBoxes);
}

int ConfigMain(void)
{
  struct InitDialogItem InitItems[] =
  {
    { DI_DOUBLEBOX,   3, 1,72, 14,0,                 0,(char*)MConfigTitleMain       },
    { DI_TEXT,        5, 2,29,  0,0,                 0,(char*)MConfigAddress         },
    { DI_EDIT,       30, 2,70,  0,0,                 0,Opt.Address                   }, // 2
    { DI_TEXT,        5, 3,29,  0,0,                 0,(char*)MConfigPathToOutbound  },
    { DI_EDIT,       30, 3,70,  0,0,                 0,Opt.PathToOutbound            }, // 4
    { DI_TEXT,        5, 4,29,  0,0,                 0,(char*)MConfigBasePath        },
    { DI_EDIT,       30, 4,70,  0,0,                 0,Opt.BasePath                  }, // 6
    { DI_CHECKBOX,    5, 5,29,  0,Opt.AttachFromTemp,0,(char*)MConfigTempPath        }, // 7
    { DI_EDIT,       30, 5,70,  0,0,                 0,Opt.TempPath                  }, // 8
    { DI_TEXT,        5, 6,29,  0,0,                 0,(char*)MConfigBoxesPath       },
    { DI_EDIT,       30, 6,70,  0,0,                 0,Opt.BoxesPath                 }, //10
    { DI_TEXT,        5, 7, 0,255,0,                 0,NULL                          },
    { DI_CHECKBOX,    5, 8,70,  0,Opt.UseSlashes,    0,(char*)MConfigUseSlashes      }, //12
    { DI_CHECKBOX,    5, 9,70,  0,Opt.UseRelative,   0,(char*)MConfigUseRelative     }, //13
    { DI_CHECKBOX,    5,10,70,  0,Opt.OEMInOutbound, 0,(char*)MConfigOEMInOutbound   }, //14
    { DI_CHECKBOX,    5,11,70,  0,Opt.UseShortNames, 0,(char*)MConfigUseShortNames   }, //15
    { DI_TEXT,        5,12, 0,255,0,                 0,NULL                          },
    { DI_BUTTON,      0,13, 0,  0,0,DIF_CENTERGROUP,   (char*)MOk                    }, //17
    { DI_BUTTON,      0,13, 0,  0,0,DIF_CENTERGROUP,   (char*)MCancel                }  //18
  };

  int ExitCode = ExecDialog(InitItems,sizeof(InitItems)/sizeof(InitItems[0]),2,17,"BSOCfgMain");
  if ( ExitCode != 17 )
    return false;
  delBackslash(Opt.PathToOutbound);
  delBackslash(Opt.BasePath);
  delBackslash(Opt.TempPath);
  delBackslash(Opt.BoxesPath);
  Opt.AttachFromTemp = InitItems[7].Selected;
  Opt.UseSlashes     = InitItems[12].Selected;
  Opt.UseRelative    = InitItems[13].Selected;
  Opt.OEMInOutbound  = InitItems[14].Selected;
  Opt.UseShortNames  = InitItems[15].Selected;
  SaveConfig();
  return true;
}

int ConfigPanel(void)
{
  char OptDisksMenuDigit[8] = "", OptLinksPanelMode[8], OptFilesPanelMode[8], OptAutoRefresh[8];
  struct InitDialogItem InitItems[] =
  {
    { DI_DOUBLEBOX,   3, 1,42, 19,0,0,                    (char*)MConfigTitlePanel        },
    { DI_CHECKBOX,    5, 2, 0,  0,Opt.AddToDisksMenu,   0,(char*)MConfigAddToDisksMenu    }, // 1
    { DI_FIXEDIT,     6, 3, 6,  3,0,                    0,OptDisksMenuDigit               }, // 2
    { DI_TEXT,        9, 3, 0,  0,0,                    0,(char*)MConfigDisksMenuDigit    },
    { DI_TEXT,        5, 4, 0,255,0,                    0,NULL                            },
    { DI_CHECKBOX,    5, 5, 0,  0,Opt.RestoreFolder,    0,(char*)MConfigRestoreFolder     }, // 5
    { DI_CHECKBOX,    5, 6, 0,  0,Opt.Highlighting,     0,(char*)MConfigHighlighting      }, // 6
    { DI_CHECKBOX,    5, 7, 0,  0,Opt.UpperPath,        0,(char*)MConfigUpperPath         }, // 7
    { DI_CHECKBOX,    5, 8, 0,  0,Opt.UnsortedPanel,    0,(char*)MConfigUnsortedPanel     }, // 8
    { DI_CHECKBOX,    5, 9, 0,  0,Opt.ShortAddresses,   0,(char*)MConfigShortAddresses    }, // 9
    { DI_TEXT,        5,10, 0,255,0,                    0,NULL                            },
    { DI_TEXT,        5,11, 0,  0,0,                    0,(char*)MConfigPanelMode         },
    { DI_TEXT,        9,12, 0,  0,0,                    0,(char*)MConfigLinksPanelMode    },
    { DI_FIXEDIT,     6,12, 6,  0,0,                    0,OptLinksPanelMode               }, //13
    { DI_TEXT,        9,13, 0,  0,0,                    0,(char*)MConfigFilesPanelMode    },
    { DI_FIXEDIT,     6,13, 6,  0,0,                    0,OptFilesPanelMode               }, //15
    { DI_CHECKBOX,    5,14, 0,  0,Opt.NoChangePanelMode,0,(char*)MConfigNoChangePanelMode }, //16
    { DI_TEXT,        5,15, 0,255,0,                    0,NULL                            },
    { DI_TEXT,        9,16, 0,  0,0,                    0,(char*)MConfigAutoRefresh       },
    { DI_EDIT,        5,16, 7,  0,0,                    0,OptAutoRefresh                  }, //19
    { DI_TEXT,        5,17, 0,255,0,                    0,NULL                            },
    { DI_BUTTON,      0,18, 0,  0,0,                    DIF_CENTERGROUP,(char*)MOk        }, //21
    { DI_BUTTON,      0,18, 0,  0,0,                    DIF_CENTERGROUP,(char*)MCancel    }
  };

  if ( Opt.DisksMenuDigit )
    FSF.sprintf(OptDisksMenuDigit,"%d", Opt.DisksMenuDigit);
  FSF.sprintf(OptLinksPanelMode,"%d", Opt.LinksPanelMode);
  FSF.sprintf(OptFilesPanelMode,"%d", Opt.FilesPanelMode);
  FSF.sprintf(OptAutoRefresh,   "%d", Opt.AutoRefresh);
  int ExitCode = ExecDialog(InitItems,sizeof(InitItems)/sizeof(InitItems[0]),1,21,"BSOCfgPanel");
  if ( ExitCode != 21 )
    return false;
  Opt.LinksPanelMode    = FSF.atoi(OptLinksPanelMode);
  Opt.FilesPanelMode    = FSF.atoi(OptFilesPanelMode);
  Opt.DisksMenuDigit    = FSF.atoi(OptDisksMenuDigit);
  Opt.AutoRefresh       = FSF.atoi(OptAutoRefresh);
  Opt.AddToDisksMenu    = InitItems[1].Selected;
  Opt.RestoreFolder     = InitItems[5].Selected;
  Opt.Highlighting      = InitItems[6].Selected;
  Opt.UpperPath         = InitItems[7].Selected;
  Opt.UnsortedPanel     = InitItems[8].Selected;
  Opt.ShortAddresses    = InitItems[9].Selected;
  Opt.NoChangePanelMode = InitItems[16].Selected;
  SaveConfig();
  return true;
}

int ConfigFlavor(void)
{
  struct InitDialogItem InitItems[] =
  {
    { DI_DOUBLEBOX,   3, 1,49, 13,0,0,              (char*)MConfigTitleFlavor },
    { DI_TEXT,        5, 2,26,  0,0,0,              (char*)MConfigPollFlavor  },
    { DI_RADIOBUTTON, 5, 3,26,  0,0,DIF_GROUP,      (char*)MImmediate         }, // 2
    { DI_RADIOBUTTON, 5, 4,26,  0,0,0,              (char*)MCrash             },
    { DI_RADIOBUTTON, 5, 5,26,  0,0,0,              (char*)MDirect            },
    { DI_RADIOBUTTON, 5, 6,26,  0,0,0,              (char*)MNormal            },
    { DI_TEXT,       27, 2,46,  0,0,0,              (char*)MConfigAttachFlavor},
    { DI_RADIOBUTTON,27, 3,46,  0,0,DIF_GROUP,      (char*)MImmediate         }, // 7
    { DI_RADIOBUTTON,27, 4,46,  0,0,0,              (char*)MCrash             },
    { DI_RADIOBUTTON,27, 5,46,  0,0,0,              (char*)MDirect            },
    { DI_RADIOBUTTON,27, 6,46,  0,0,0,              (char*)MNormal            },
    { DI_RADIOBUTTON,27, 7,46,  0,0,0,              (char*)MHold              },
    { DI_RADIOBUTTON,27, 8,46,  0,0,0,              (char*)MBoxNormal         },
    { DI_RADIOBUTTON,27, 9,46,  0,0,0,              (char*)MBoxHold           },
    { DI_CHECKBOX,    5,10,46,  0,0,0,              (char*)MLongBox           }, //14
    { DI_TEXT,        5,11, 0,255,0,0,              NULL                      },
    { DI_BUTTON,      0,12, 0,  0,0,DIF_CENTERGROUP,(char*)MOk                }, //16
    { DI_BUTTON,      0,12, 0,  0,0,DIF_CENTERGROUP,(char*)MCancel            }
  };

  InitItems[2+Opt.PollFlavor].Selected = InitItems[7+Opt.AttachFlavor].Selected = 1;
  InitItems[14].Selected = Opt.UseLongBoxes;
  int ExitCode = ExecDialog(InitItems,sizeof(InitItems)/sizeof(InitItems[0]),2,16,"BSOCfgFlavor");
  if ( ExitCode != 16 )
    return false;
  for ( int i = 0 ; i < 4 ; i++ )
    if ( InitItems[2+i].Selected )
    {
      Opt.PollFlavor = i;
      break;
    }
  for ( int i = 0 ; i < 7 ; i++ )
    if ( InitItems[7+i].Selected )
    {
      Opt.AttachFlavor = i;
      break;
    }
  Opt.UseLongBoxes = InitItems[14].Selected;
  SaveConfig();
  return true;
}

int ConfigConfirm(void)
{
  struct InitDialogItem InitItems[] =
  {
    { DI_DOUBLEBOX,   3,1,42,  8,0,0,              (char*)MConfigTitleConfirm  },
    { DI_CHECKBOX,    5,2,40,  0,Opt.AutoCheck,0,  (char*)MConfigAutoCheck     }, // 1
    { DI_TEXT,        5,4,40,  0,0,0,              (char*)MConfigDeleteEmptyLO },
    { DI_RADIOBUTTON, 5,5,13,  0,0,0,              (char*)MYes                 }, // 3
    { DI_RADIOBUTTON,13,5,21,  0,0,0,              (char*)MNo                  },
    { DI_RADIOBUTTON,21,5,40,  0,0,0,              (char*)MPrompt              },
    { DI_TEXT,        5,6, 0,255,0,0,              NULL                        },
    { DI_BUTTON,      0,7, 0,  0,0,DIF_CENTERGROUP,(char*)MOk                  }, // 7
    { DI_BUTTON,      0,7, 0,  0,0,DIF_CENTERGROUP,(char*)MCancel              }
  };

  InitItems[3+Opt.DeleteEmptyLO].Selected = 1;
  int ExitCode = ExecDialog(InitItems,sizeof(InitItems)/sizeof(InitItems[0]),1,7,"BSOCfgConfirm");
  if ( ExitCode != 7 )
    return false;
  Opt.AutoCheck = InitItems[1].Selected;
  for ( int i = 0 ; i < 3 ; i++ )
    if ( InitItems[3+i].Selected )
    {
      Opt.DeleteEmptyLO = i;
      break;
    }
  SaveConfig();
  return true;
}

static bool Edit(char* Path, char* Subst)
{
  if ( *Path )
    addBackslash(cSlash(Path));
  if ( *Subst )
    addBackslash(cSlash(Subst));
  struct InitDialogItem InitItems[] =
  {
    { DI_DOUBLEBOX, 3,1,70,  8,0,0,              (char*)MEditSubst         },
    { DI_TEXT,      5,2, 0,  0,0,0,              (char*)MConfigPathSrc     },
    { DI_EDIT,      5,3,68,  0,0,0,              Path                      }, // 2
    { DI_TEXT,      5,4, 0,  0,0,0,              (char*)MConfigPathSubst   },
    { DI_EDIT,      5,5,68,  0,0,0,              Subst                     }, // 4
    { DI_TEXT,      2,6, 0,255,0,0,              NULL                      },
    { DI_BUTTON,    0,7, 0,  0,0,DIF_CENTERGROUP,(char*)MOk                }, // 6
    { DI_BUTTON,    0,7, 0,  0,0,DIF_CENTERGROUP,(char*)MCancel            }  // 7
  };
  int Result = ExecDialog(InitItems, sizeof(InitItems)/sizeof(InitItems[0]),2,6,"Subst");
  if ( Result != 6 )
    return false;
  if ( Result )
  {
    if ( *Path && * Subst )
    {
      cBackslash(addBackslash(cSlash(Path)));
      cBackslash(addBackslash(cSlash(Subst)));
    }
    else
      Result = false;
  }
  return Result;
}

static bool addPath(HKEY, char*, char *key, FarMenuItem *data, int*, void*)
{
  addBackslash(cSlash(strcpy(data->Text, key)));
  return false;
}

int ConfigSubst(void)
{
  FarMenuItem *menu = NULL;
  int Code, n = 0, BreakKeys[5] = { VK_RETURN, VK_INSERT, VK_DELETE, VK_F4, 0 };
  char key[256], Path[256], Subst[256];
  do
  {
    int Count = MenuFromRegKey(HKEY_CURRENT_USER, "Subst", addPath, &menu, &n, NULL);
    if ( n < Count )
      menu[n].Selected = true;
    n = Info.Menu(Info.ModuleNumber, -1, -1, 0, FMENU_WRAPMODE, GetMsg(MMenuTop),
                  GetMsg(MMenuBottom), "Subst", BreakKeys, &Code, menu, Count);
    if ( n >= 0 && n < Count )
    {
      FSF.sprintf(key, "Subst\\%s", cBackslash(addBackslash(strcpy(Path, menu[n].Text))));
      switch ( Code )
      {
        case 1:          //Insert
          *Path = *Subst = 0;
          if ( Edit(Path, Subst) && *Path )
          {
            FSF.sprintf(key, "Subst\\%s", Path);
            SetRegKey(HKEY_CURRENT_USER, key, "", Subst);
          }
          break;
        case 2:          //Delete
          if ( n < Count )
          {
            const char *MsgItems[]={GetMsg(MMenuTop),GetMsg(MDeleteSubst),menu[n].Text,"\x1",GetMsg(MDelete),GetMsg(MCancel)};
            if ( wMessage(MsgItems, 2) == 0 )
            {
              FSF.sprintf(key, "Subst\\%s", Path);
              DeleteRegKey(HKEY_CURRENT_USER, key);
            }
          }
          break;
        default:  //Edit
          if ( n < Count )
          {
            GetRegKey(HKEY_CURRENT_USER, key, "", Subst, "", 255);
            if ( Edit(Path, Subst) )
            {
              FSF.sprintf(key, "Subst\\%s", Path);
              SetRegKey(HKEY_CURRENT_USER, key, "", Subst);
            }
          }
          break;
      }
    }
    if ( menu )
      winDel(menu);
    menu = NULL;
  } while ( n != -1 );
  return true;
}

int Config(void)
{
  struct FarMenuItem MainMenu[5];
  int i, count = sizeof(MainMenu)/sizeof(*MainMenu);
  for ( i = 0 ; i < count ; i++ )
    MainMenu[i].Selected = MainMenu[i].Checked = MainMenu[i].Separator = false;
  strcpy(MainMenu[0].Text, GetMsg(MBSOMenuConfigMain));
  strcpy(MainMenu[1].Text, GetMsg(MBSOMenuConfigPanel));
  strcpy(MainMenu[2].Text, GetMsg(MBSOMenuConfigFlavor));
  strcpy(MainMenu[3].Text, GetMsg(MBSOMenuConfigConfirm));
  strcpy(MainMenu[4].Text, GetMsg(MBSOMenuConfigSubst));
  while ( ( i = Info.Menu(Info.ModuleNumber,-1,-1,0,FMENU_WRAPMODE,GetMsg(MConfigTitle),NULL,NULL,NULL,NULL,MainMenu,count) ) >= 0 )
  {
    switch ( i )
    {
      case 0: ConfigMain();    break;
      case 1: ConfigPanel();   break;
      case 2: ConfigFlavor();  break;
      case 3: ConfigConfirm(); break;
      case 4: ConfigSubst(); break;
    }
    for ( int j = 0 ; j < count ; j++ )
      MainMenu[j].Selected = false;
    MainMenu[i].Selected = true;
  }
  return true;
}

#define WAIT_CHECK_TIMEOUT 512

static char prevDir[NM] = ".";
BSORESOURCE *BSORes = NULL;
DWORD BSOCount = 0;
char rootDir[NM] = "";
HANDLE checkHandle = INVALID_HANDLE_VALUE;

void GetBSOList(BSORESOURCE *(&Res),DWORD &EnumCount,int);

inline void setHomeDir(void)
{
  *rootDir = 0;
}

static void DeleteBSOText(BSORESOURCE &Res)
{
  if ( Res.MailFlavor )
    winDel(Res.MailFlavor);
  if ( Res.FileFlavor )
    winDel(Res.FileFlavor);
  if ( Res.LoExt )
    winDel(Res.LoExt);
  Res.MailFlavor = Res.FileFlavor = Res.LoExt = NULL;
  Res.LoLine = Res.BUSY_Status = Res.BOX_Status = Res.REQ_Status = Res.KS_Status = 0;
}

static void DeleteBSOList(BSORESOURCE *(&Res),DWORD &ResCount)
{
  for ( unsigned I = 0 ; I < ResCount ; I++ )
    DeleteBSOText(Res[I]);
  winDel(Res);
  Res = NULL;
  ResCount = 0;
}

static HANDLE newBSOBrowser(char* Dir = NULL)
{
  PanelInfo panelInfo;
  Info.Control(INVALID_HANDLE_VALUE,FCTL_GETPANELINFO,&panelInfo);
  strcpy(prevDir,panelInfo.CurDir);
  BSORes = NULL;
  BSOCount = 0;
  checkHandle=FindFirstChangeNotification(Opt.PathToOutbound,true,
    FILE_NOTIFY_CHANGE_FILE_NAME|
    FILE_NOTIFY_CHANGE_DIR_NAME|
    FILE_NOTIFY_CHANGE_SIZE);
  if ( Dir )
  {
    TFTNAddress homeAddr(Opt.Address);
    TFTNAddress(Dir,&homeAddr).print(rootDir,0);
    GetBSOList(BSORes,BSOCount,0);
  }
  else
    setHomeDir();
  return (HANDLE)(&Opt);
}

static void deleteBSOBrowser()
{
  FindCloseChangeNotification(checkHandle);
  DeleteBSOList(BSORes,BSOCount);
}

static int checkBSY(TFTNAddress addr2poll)
{
  TFTNAddress addr(Opt.Address);
  WIN32_FIND_DATA bf;
  char bsy[NM];
  HANDLE bh = FindFirstFile(addr2poll.bso(bsy,Opt.PathToOutbound,".BSY",&addr), &bf);
  int isBusy = ( bh != INVALID_HANDLE_VALUE );
  FindClose(bh);
  return isBusy;
}

static void squeeze(char *path)
{
  char *dest = path;
  char *src = path;
  while ( *src != 0 )
  {
    if ( *src != '.' )
      *dest++ = *src++;
    else
    {
      src++;
      if ( *src == '.' )
      {
        src += 2;
        dest--;
        while( *--dest != '\\' )
          ;
        dest++;
      }
      else
      {
        src++;
        dest += 2;
      }
    }
  }
  *dest = 0;
}

enum enSplitType { enDRIVE = 1, enDIRECTORY = 2, enFILENAME = 4, enEXTENTION = 8 };

static int fnSplit(const char *path, char *drive, char *dir, char *file, char *ext)
{
  int flag = *drive = *dir = *file = *ext = 0;
  char ch, *p = strchr((char*)path, ':');
  if ( p )
  {
    ch = p[1];
    p[1] = 0;
    strcpy(drive, path);
    flag |= enDRIVE;
    p[1] = ch;
    p++;
  }
  else
    p = (char*)path;
  char *dp = strrchr(p, '\\');
  if ( dp )
  {
    ch = dp[1];
    dp[1] = 0;
    strcpy(dir, p);
    dp[1] = ch;
    p = dp+1;
    flag |= enDIRECTORY;
  }
  dp = strchr(p, '.');
  if ( dp )
  {
    strcpy(ext, dp);
    flag |= enEXTENTION;
    ch = *dp;
    *dp = 0;
    strcpy(file, p);
    *dp = ch;
  }
  else
    strcpy(file, p);
  if ( *file  ) flag |= enFILENAME;
  return flag;
}

static inline char *fnMerge(char *path, char *drive, char *dir, char *file, char *ext)
{
  return strcat(strcat(addBackslash(strcat(strcpy(path, drive), dir)), file), ext);
}

static char *fexpand(char *rpath, char *defPath)
{
  static char path[NM], drive[NM], dir[NM], file[NM], ext[NM];
  static char defDrive[4], defDir[NM];
  if ( defPath && *defPath )
    fnSplit(addBackslash(strcpy(path, defPath)), defDrive, defDir, file, ext);
  else
    *defDrive = *defDir = 0;
  int flags = fnSplit(rpath, drive, dir, file, ext);
  if ( (flags & enDRIVE) == 0 )
  {
    if ( *defDrive )
      strcpy(drive, defDrive);
    else
    {
      GetCurrentDirectory(sizeof(drive), drive);
      drive[2] = 0;
    }
  }
  CharUpperBuff(drive, 1);
  if ( (flags & enDIRECTORY) == 0 || (dir[0] != '\\' && dir[0] != '/') )
  {
    static char curdir[NM];
    if ( *defDir )
    {
      strcpy(curdir, dir);
      strcat(strcpy(dir, defDir), curdir);
    }
    else
    {
      _getdcwd(drive[0]-'A'+1, curdir, sizeof(curdir));
      char *dp = strchr(curdir, ':');
      if ( dp )
        strcpy(curdir, dp+1);
      strcat(addBackslash(curdir), dir);
      if ( *curdir != '\\' && *curdir != '/' )
      {
        *dir = '\\';
        strcpy(dir+1, curdir);
      }
      else
        strcpy(dir, curdir);
    }
  }
  squeeze(dir);
  fnMerge(path, drive, dir, file, ext);
  return strcpy(rpath, path);
}

static inline int existDir(const char *path)
{
  WIN32_FIND_DATA ff;
  HANDLE fh = FindFirstFile(path, &ff);
  int isDir = ( fh != INVALID_HANDLE_VALUE ) && ( ff.dwFileAttributes && FILE_ATTRIBUTE_DIRECTORY );
  FindClose(fh);
  return isDir;
}

static int createDir(const char *path)
{
  char dir[NM];
  static char Drv[4], Dir[NM], File[NM], Ext[NM];
  fexpand(strcpy(dir, path), Opt.BasePath);
  fnSplit(dir, Drv, Dir, File, Ext);
  strcat(strcpy(dir, Drv), Dir);
  dir[strlen(dir)-1] = 0;
  if ( strcmp(Dir, "\\") && !existDir(dir) )
  {
    if ( !createDir(dir) )
      return 0;
    return CreateDirectory(dir, NULL);
  }
  return 1;
}

static int confirmBSY(TFTNAddress& addr)
{
  int pollNow = true;
  if ( checkBSY(addr) )
  {
    char s[64];
    addr.print(s, 0, NULL);
    const char *MsgItems[]={GetMsg(MError),GetMsg(MAddressIsBusy),s,GetMsg(MWantToContinue),"\x1",GetMsg(MOk),GetMsg(MCancel)};
    pollNow = !wMessage(MsgItems, 2);
  }
  return pollNow;
}

static char hId[] = "FAtt.ToAddr";

static void makePoll(char *aAddr)
{
  char addrTo[256];
  strcpy(addrTo, aAddr);
  struct InitDialogItem InitItems[] =
  {
    { DI_DOUBLEBOX,  3, 1,42, 11,0,0,                         (char*)MPollTitle     },
    { DI_TEXT,       5, 2, 0,  0,0,0,                         (char*)MPollAddress   },
    { DI_EDIT,       5, 3,40,  0,(DWORD)hId,DIF_HISTORY|DIF_USELASTHISTORY,addrTo   },
    { DI_TEXT,       5, 4, 0,255,0,0,                         NULL                  },
    { DI_RADIOBUTTON,5, 5,40,  0,0,DIF_GROUP,                 (char*)MImmediate     },
    { DI_RADIOBUTTON,5, 6,40,  0,0,0,                         (char*)MCrash         },
    { DI_RADIOBUTTON,5, 7,40,  0,0,0,                         (char*)MDirect        },
    { DI_RADIOBUTTON,5, 8,40,  0,0,0,                         (char*)MNormal        },
    { DI_TEXT,       5, 9, 0,255,0,0,                         NULL                  },
    { DI_BUTTON,     0,10, 0,  0,0,DIF_CENTERGROUP,           (char*)MOk            },
    { DI_BUTTON,     0,10, 0,  0,0,DIF_CENTERGROUP,           (char*)MCancel        }
  };

  InitItems[4+Opt.PollFlavor].Selected = 1;
  int ExitCode = ExecDialog(InitItems,sizeof(InitItems)/sizeof(InitItems[0]),2,9,"BSOPoll");
  if ( ExitCode == 9 )
  {
    TFTNAddress addr2poll, addr(Opt.Address);
    if ( addr2poll.parse(addrTo, &addr) )
    {
      int pollNow = confirmBSY(addr2poll);
      if ( pollNow )
      {
        char lo[NM], ext[] = ".FLO";
        if      ( InitItems[4].Selected ) ext[1] = 'I';
        else if ( InitItems[5].Selected ) ext[1] = 'C';
        else if ( InitItems[6].Selected ) ext[1] = 'D';
        createDir(addr2poll.bso(lo,Opt.PathToOutbound,ext,&addr));
        HANDLE f = CreateFile(lo,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
        CloseHandle(f);
      }
    }
    else
    {
      const char *MsgItems[]={GetMsg(MPollTitle),GetMsg(MInvalidAddress),InitItems[2].Data,GetMsg(MOk)};
      wMessage(MsgItems, 1);
    }
  }
}

static void BrowserMakePoll(void)
{
  struct PanelInfo panelItem;
  char addrTo[40] = "";
  TFTNAddress addr2poll, addr(Opt.Address);
  Info.Control(INVALID_HANDLE_VALUE,FCTL_GETPANELINFO,&panelItem);
  if ( panelItem.ItemsNumber > 0 )
  {
    if ( addr2poll.parse(panelItem.PanelItems[panelItem.CurrentItem].FindData.cFileName, &addr) )
      addr2poll.print(addrTo, Opt.ShortAddresses, &addr);
  }
  makePoll(addrTo);
}

static void makeFREQ(char *aAddr)
{
  char addrTo[256];
  strcpy(addrTo, aAddr);
  struct InitDialogItem InitItems[] =
  {
    { DI_DOUBLEBOX,  3,1,42,  6,0,0,                         (char*)MFREQTitle   },
    { DI_TEXT,       5,2, 0,  0,0,0,                         (char*)MFREQAddress },
    { DI_EDIT,       5,3,40,  0,(DWORD)hId,DIF_HISTORY|DIF_USELASTHISTORY,addrTo },
    { DI_TEXT,       5,4, 0,255,0,0,                         NULL                },
    { DI_BUTTON,     0,5, 0,  0,0,DIF_CENTERGROUP,           (char*)MOk          },
    { DI_BUTTON,     0,5, 0,  0,0,DIF_CENTERGROUP,           (char*)MCancel      }
  };

  int ExitCode = ExecDialog(InitItems,sizeof(InitItems)/sizeof(InitItems[0]),2,4,"BSOFREQ");
  if ( ExitCode == 4 )
  {
    TFTNAddress addr2poll, addr(Opt.Address);
    if ( addr2poll.parse(addrTo, &addr) )
    {
      int pollNow = confirmBSY(addr2poll);
      if ( pollNow )
      {
        char title[NM],lo[NM];
        FSF.sprintf(title, "%s:%s", GetMsg(MFREQTitle),addr2poll.print(lo,0));
        WIN32_FIND_DATA ff;
        createDir(addr2poll.bso(lo,Opt.PathToOutbound,".REQ",&addr));
        HANDLE fh = FindFirstFile(lo, &ff);
        if ( fh == INVALID_HANDLE_VALUE )
        {
          FindClose(fh);
          HANDLE f = CreateFile(lo,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
          CloseHandle(f);
        }
        else
          FindClose(fh);
        Info.Editor(lo,title,0,0,-1,-1,0,1,1);
        fh = FindFirstFile(lo, &ff);
        if ( fh != INVALID_HANDLE_VALUE )
        {
          FindClose(fh);
          if ( !ff.nFileSizeLow && !ff.nFileSizeHigh )
            DeleteFile(lo);
        }
        else
          FindClose(fh);
      }
    }
    else
    {
      const char *MsgItems[]={GetMsg(MFREQTitle),GetMsg(MInvalidAddress),InitItems[2].Data,GetMsg(MOk)};
      wMessage(MsgItems, 1);
    }
  }
}

static void BrowserMakeFREQ(void)
{
  struct PanelInfo panelItem;
  char addrTo[40] = "";
  TFTNAddress addr2poll, addr(Opt.Address);
  Info.Control(INVALID_HANDLE_VALUE,FCTL_GETPANELINFO,&panelItem);
  if ( panelItem.ItemsNumber > 0 )
  {
    if ( addr2poll.parse(rootDir, &addr) )
      addr2poll.print(addrTo, Opt.ShortAddresses, &addr);
    else if ( addr2poll.parse(panelItem.PanelItems[panelItem.CurrentItem].FindData.cFileName, &addr) )
      addr2poll.print(addrTo, Opt.ShortAddresses, &addr);
  }
  makeFREQ(addrTo);
}

static char *GetAddress(BSORESOURCE *BSORes,char *Address)
{
  return strcpy(Address,BSORes->FileInfo.cFileName);
}

static char *GetMailFlavor(BSORESOURCE *BSORes,char *Flavor)
{
  if ( BSORes->MailFlavor == NULL)
    *Flavor = 0;
  else
    strcpy(Flavor,BSORes->MailFlavor);
  return Flavor;
}

static char *GetLoLine(BSORESOURCE *BSORes,char *line)
{
  FSF.sprintf(line, "%d",BSORes->LoLine);
  return line;
}

static char *GetLoExt(BSORESOURCE *BSORes,char *ext)
{
  if ( BSORes->LoExt == NULL)
    *ext = 0;
  else
    strcpy(ext,BSORes->LoExt);
  return ext;
}

static char *GetFileFlavor(BSORESOURCE *BSORes,char *Flavor)
{
  if ( BSORes->FileFlavor == NULL)
    *Flavor = 0;
  else
    strcpy(Flavor,BSORes->FileFlavor);
  return Flavor;
}

static char *GetBRKStatus(BSORESOURCE *BSORes,char *Status)
{
  Status[0] = BSORes->BOX_Status ? 'B' : '.';
  Status[1] = BSORes->REQ_Status ? 'R' : '.';
  Status[2] = BSORes->KS_Status  ? 'K' : '.';
  Status[3] = 0;
  return Status;
}

static void modifyFlavor(char *s, enBSOFlavor f)
{
  const char *flavorText = "ICDFH";
  if ( f != flNO )
    s[f-1] = flavorText[f-1];
}

static char* CopyText(const char *Text)
{
  if ( Text == NULL )
    return NULL;
  char *Buf = winNew(char, strlen(Text)+1);
  return strcpy(Buf,Text);
}

static char *strUpr(char *str)
{
  for ( char *c = str ; *c ; c++ )
    *c = toUpper(*c);
  return str;
}

static int strIcmp(const char *s1, const char *s2)
{
  char *p1 = strUpr(CopyText(s1 ? s1 : ""));
  char *p2 = strUpr(CopyText(s2 ? s2 : ""));
  int ret = strcmp(p1,p2);
  winDel(p1);
  winDel(p2);
  return ret;
}

static int strNIcmp(const char *s1, const char *s2, size_t len)
{
  char *p1 = strUpr(CopyText(s1 ? s1 : ""));
  char *p2 = strUpr(CopyText(s2 ? s2 : ""));
  int ret = strncmp(p1,p2,len);
  winDel(p1);
  winDel(p2);
  return ret;
}

static void addLo(BSORESOURCE *r, DWORD *i, DWORD n, TFTNAddress& addr, WIN32_FIND_DATA *ff, enBSOType t, enBSOFlavor f)
{
  if ( *i < n )
  {
    char s[64];
    int j = -1;
    TFTNAddress home(Opt.Address);
    addr.print(s, Opt.ShortAddresses, &home);
    for ( unsigned k = 0 ; k < *i ; k++ )
    {
      if ( !strIcmp(s, r[k].FileInfo.cFileName) )
      {
        j = k;
        break;
      }
    }
    if ( j == -1 )
    {
      j = (*i)++;
      memcpy(&r[j].FileInfo,ff,sizeof(r[j].FileInfo));
      strcpy(r[j].FileInfo.cFileName,s);
      r[j].FileInfo.nFileSizeHigh=r[j].FileInfo.nFileSizeLow=0;
      r[j].FileInfo.dwFileAttributes=FILE_ATTRIBUTE_DIRECTORY;
      r[j].BUSY_Status = r[j].BOX_Status = r[j].REQ_Status = r[j].KS_Status = 0;
      r[j].MailFlavor = CopyText(".....");
      r[j].FileFlavor = CopyText(".....");
      r[j].LoExt = NULL;
      r[j].LoLine = 0;
    }
    switch ( t )
    {
      case tyREQ:
        r[j].REQ_Status = '*';
        break;
      case tyBSY:
        r[j].BUSY_Status = '*';
        break;
      case tyUT:
        r[j].KS_Status = '*';
        modifyFlavor(r[j].MailFlavor, f);
        break;
      case tyLO:
        modifyFlavor(r[j].FileFlavor, f);
        break;
    }
  }
}

static char *trims(char *s)
{
  char *p = strchr(s, 0);
  while ( --p > s && strchr("\r\n\t ", *p) )
    *p = 0;
  return s;
}

static char *str2fn(char *s, int& ks)
{
  char *p = NULL;
  ks = 0;
  switch ( *trims(s) )
  {
    case '^':
    case '#':
      p = s+1;
      ks = 1;
      break;
    case '~':
      break;
    default:
      p = s;
      break;
  }
  return p;
}

static inline char *getPath(char *p)
{
  char *pp = strrchr(p, '\\');
  *( pp ? pp+1 : p) = 0;
  return p;
}

static char *correctLoFile(char *s, char *p, char *f)
{
  getPath(cSlash(strcpy(s, p)));
  if ( Opt.UpperPath )
  {
    char temp[NM];
    CharToOem(s, temp);
    OemToChar(strUpr(temp), s);
  }
  return fexpand(strcat(s, f), Opt.BasePath);
}

static void addLoFile(BSORESOURCE *r, DWORD *i, DWORD n, char* p, WIN32_FIND_DATA *zf, char *loExt, enBSOType t, enBSOFlavor f, int loLine, int ks, int box)
{
  if ( *i < n )
  {
    char temp[NM], path[NM];
    int j = (*i)++;
    memcpy(&r[j].FileInfo,zf,sizeof(*zf));
    OemToChar(p, path);
    OemToChar(zf->cFileName, temp);
    correctLoFile(r[j].FileInfo.cFileName, path, temp);
    r[j].BUSY_Status = r[j].REQ_Status = 0;
    r[j].BOX_Status = (box ? '*' : '\x0');
    r[j].KS_Status = (ks ? '*' : '\x0');
    r[j].MailFlavor = CopyText(".....");
    r[j].FileFlavor = CopyText(".....");
    r[j].LoExt = CopyText(loExt);
    r[j].LoLine = loLine;
    switch ( t )
    {
      case tyREQ:
        r[j].REQ_Status = '*';
        break;
      case tyBSY:
        r[j].BUSY_Status = '*';
        break;
      case tyUT:
        modifyFlavor(r[j].MailFlavor, f);
        break;
      case tyLO:
        modifyFlavor(r[j].FileFlavor, f);
        break;
    }
  }
}

static int getFileType(char *e, enBSOType& t, enBSOFlavor& f)
{
  t = tyNO;
  f = flNO;
  char c = toUpper(e[1]);
  if ( !strIcmp(e+1, "REQ" ) )
  {
    t = tyREQ;
    f = fl_F;
  }
  else if ( !strIcmp(e+1, "BSY" ) )
  {
    t = tyBSY;
    f = fl_F;
  }
  else if ( !strIcmp(e+2, "LO" ) )
  {
    t = tyLO;
    switch ( c )
    {
      case 'I':
        f = fl_I;
        break;
      case 'C':
        f = fl_C;
        break;
      case 'D':
        f = fl_D;
        break;
      case 'F':
      case 'N':
        f = fl_F;
        break;
      case 'H':
        f = fl_H;
        break;
    }
  }
  else if ( !strIcmp(e+2, "UT" ) )
  {
    t = tyUT;
    switch ( c )
    {
      case 'I':
        f = fl_I;
        break;
      case 'C':
        f = fl_C;
        break;
      case 'D':
        f = fl_D;
        break;
      case 'O':
      case 'N':
        f = fl_F;
        break;
      case 'H':
        f = fl_H;
        break;
    }
  }
  return ( t != tyNO ) && ( f != flNO );
}

static void long2net_node(long l, unsigned& net, unsigned& node)
{
  net = (l >> 16) & 0x0000FFFFl;
  node = l & 0x0000FFFFl;
}

static int ch03x(const char *s, unsigned int *t)
{
  int k;
  *t = 0;
  for ( int i = 0 ; i < 3 ; i++ )
    if ( ( k = isXdigit(s[i]) ) != -1 )
      *t = (*t)*16+k;
    else
      return 0;
  return s[3] == 0;
}

static int ch08x(const char *s, long *t)
{
  int k;
  *t = 0;
  for ( int i = 0 ; i < 8 ; i++ )
    if ( ( k = isXdigit(s[i]) ) != -1 )
      *t = (*t)*16+k;
    else
      return 0;
  return s[8] == '.';
}

static void scanBoxDir(char *p, BSORESOURCE *r, DWORD *i, DWORD n, enBSOFlavor fl)
{
  WIN32_FIND_DATA ff;
  static char f[256], tempP[NM];
  HANDLE h = FindFirstFile(strcat(addBackslash(strcpy(f, p)), "*"), &ff);
  if ( h != INVALID_HANDLE_VALUE )
    do
    {
      if ( ! ( ff.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ) && *i < n )
        addLoFile(r, i, n, strcat(addBackslash(strcpy(tempP, p)), ff.cFileName), &ff, NULL, tyLO, fl, 0, 1, 1);
    } while ( FindNextFile(h, &ff) );
  FindClose(h);
}

static void scanBoxDirs(BSORESOURCE *r, DWORD *i, DWORD n, TFTNAddress& addr)
{
  char box[NM];
  scanBoxDir(addr.box(box,Opt.BoxesPath,1,0), r, i, n, fl_D);
  scanBoxDir(addr.box(box,Opt.BoxesPath,0,0), r, i, n, fl_D);
  scanBoxDir(addr.box(box,Opt.BoxesPath,1,1), r, i, n, fl_H);
  scanBoxDir(addr.box(box,Opt.BoxesPath,0,1), r, i, n, fl_H);
}

static void scanBox(char *p, BSORESOURCE *r, DWORD *i, DWORD n, TFTNAddress& addr, enBSOFlavor fl)
{
  WIN32_FIND_DATA ff;
  static char f[256], s[64];
  TFTNAddress home(Opt.Address);
  addr.print(s, Opt.ShortAddresses, &home);
  HANDLE h = FindFirstFile(strcat(addBackslash(strcpy(f, p)), "*"), &ff);
  if ( h != INVALID_HANDLE_VALUE )
  {
    do
    {
      if ( ! ( ff.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ) && *i < n )
      {
        int j = -1;
        for ( unsigned k = 0 ; k < *i ; k++ )
        {
          if ( !strIcmp(s, r[k].FileInfo.cFileName) )
          {
            j = k;
            break;
          }
        }
        if ( j == -1 )
        {
          j = (*i)++;
          memcpy(&r[j].FileInfo,&ff,sizeof(r[j].FileInfo));
          strcpy(r[j].FileInfo.cFileName,s);
          r[j].FileInfo.nFileSizeHigh=r[j].FileInfo.nFileSizeLow=0;
          r[j].FileInfo.dwFileAttributes=FILE_ATTRIBUTE_DIRECTORY;
          r[j].BUSY_Status = r[j].REQ_Status = r[j].KS_Status = 0;
          r[j].BOX_Status = '*';
          r[j].MailFlavor = CopyText(".....");
          r[j].FileFlavor = CopyText(".....");
          r[j].LoExt = NULL;
          r[j].LoLine = 0;
        }
        modifyFlavor(r[j].FileFlavor, fl);
      }
    } while ( FindNextFile(h, &ff) );
  }
  FindClose(h);
}

static void scanPnt(char *p, BSORESOURCE *r, DWORD *i, DWORD n, TFTNAddress& addr, long net_node)
{
  WIN32_FIND_DATA lf;
  static char f[256], l[256];
  HANDLE h = FindFirstFile(strcat(strcpy(f, p), "\\????????.???"), &lf);
  if ( h != INVALID_HANDLE_VALUE )
  {
    do
    {
      if ( ! ( lf.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ) )
      {
        char *e = strchr(lf.cFileName, '.');
        enBSOType ty;
        enBSOFlavor fl;
        if ( e && strlen(e) == 4 && getFileType(e, ty, fl) )
        {
          long test;
          if ( ch08x(lf.cFileName, &test) )
          {
            FSF.sprintf(l, "%08X%s", test, e);
            if ( !strIcmp(l, lf.cFileName) )
            {
              strcat(strcat(strcpy(l, p), "\\"), lf.cFileName);
              if ( net_node == -1 )
              {
                long2net_node(test, addr.net, addr.node);
                addr.point = 0;
              }
              else
              {
                long2net_node(net_node, addr.net, addr.node);
                addr.point = test;
              }
              addLo(r, i, n, addr, &lf, ty, fl);
            }
          }
        }
      }
    } while ( FindNextFile(h, &lf) );
  }
  FindClose(h);
}

static void scanZone(char *z, BSORESOURCE *r, DWORD *i, DWORD n, TFTNAddress& addr)
{
  WIN32_FIND_DATA pf;
  static char f[256], p[256];
  scanPnt(z, r, i, n, addr, -1);
  HANDLE h = FindFirstFile(strcat(strcpy(f, z), "\\????????.PNT"), &pf);
  if ( h != INVALID_HANDLE_VALUE )
  {
    do
    {
      if ( pf.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY )
      {
        long net_node;
        if ( ch08x(pf.cFileName, &net_node) )
        {
          FSF.sprintf(p, "%08X.PNT", net_node);
          if ( !strIcmp(p, pf.cFileName) )
          {
            strcat(strcat(strcpy(p, z), "\\"), pf.cFileName);
            scanPnt(p, r, i, n, addr, net_node);
          }
        }
      }
    } while ( FindNextFile(h, &pf) );
  }
  FindClose(h);
}

static char *addExt(char *path, char *defExt)
{
  int n = strlen(path)-1;
  for ( int i = n ; i >= 0 ; i-- )
  {
    if ( path[i] == '.' )
    {
      strcpy(path+i, defExt);
      break;
    }
    if ( ( path[i] == '\\' ) || ( path[i] == ':' ) || ( i == 0 ) )
      return strcat(path, defExt);
  }
  return path;
}

static char *getStr(char* s, char **fp)
{
  if ( *fp )
  {
    char ch, *p = strchr(*fp, '\n');
    if ( p )
    {
      ch = *p;
      *p = 0;
      strcpy(s, *fp);
      *fp = p+1;
      *p = ch;
      FSF.Trim(s);
      return s;
    }
    *fp = NULL;
  }
  return NULL;
}

static bool findSubst(HKEY, char*, char *key, void *data)
{
  char SubKeyName[NM], s[256];
  FSF.sprintf(SubKeyName, "Subst\\%s", key);
  GetRegKey(HKEY_CURRENT_USER, SubKeyName, "", s, "", 255);
  if ( *cBackslash(s) )
  {
    size_t len = strlen(s);
    char *p = (char*)data;
    if ( !strNIcmp(p, s, len) )
    {
      strcat(strcpy(SubKeyName, key), p+len);
      cSlash(strcpy(p, SubKeyName));
      return true;
    }
  }
  return false;
}

static bool findPath(HKEY, char*, char *key, void *data)
{
  char SubKeyName[NM], k[256], s[256], *p = (char*)data;
  size_t len = strlen(cSlash(strcpy(k, key)));
  if ( !strNIcmp(p, k, len) )
  {
    FSF.sprintf(SubKeyName, "Subst\\%s", key);
    GetRegKey(HKEY_CURRENT_USER, SubKeyName, "", s, "", 255);
    strcat(strcpy(SubKeyName, s), p+len);
    cSlash(strcpy(p, SubKeyName));
    return true;
  }
  return false;
}

static int removeFile(char *lo, struct PluginPanelItem *PanelItem, int removeKS, char *str)
{
  char tmp[NM];
  int ret = 0, writed = 0;
  HANDLE r = CreateFile(lo, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
  if ( r != INVALID_HANDLE_VALUE )
  {
    unsigned fileSize = GetFileSize(r, NULL);
    if ( fileSize )
    {
      char *fileBuff = winNew(char,fileSize+1);
      if ( fileBuff )
      {
        DWORD rb = 0;
        if ( ReadFile(r, fileBuff, fileSize, &rb, NULL) && rb )
        {
          fileBuff[fileSize] = 0;
          HANDLE w = CreateFile(addExt(strcpy(tmp, lo), ".TMP"), GENERIC_WRITE, FILE_SHARE_READ, NULL, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
          if ( w != INVALID_HANDLE_VALUE )
          {
            char s[NM], *fp = fileBuff;
            int ks;
            while ( getStr(s, &fp) )
            {
              char *p = str2fn(s, ks);
              if ( p )
              {
                char tempP[NM], key[256];
                if ( Opt.OEMInOutbound )
                  strcpy(tempP, p);
                else
                  CharToOem(p, tempP);
                cSlash(tempP);
                fexpand(tempP, Opt.BasePath);
                if ( Opt.UseShortNames )
                {
                  char tempFile[NM];
                  OemToChar(tempP, tempFile);
                  GetShortPathName(tempFile, tempP, sizeof(tempP));
                  CharToOem(tempP, tempFile);
                  strcpy(tempP, tempFile);
                }
                FindFirstRegKey(HKEY_CURRENT_USER, "Subst", findSubst, cBackslash(tempP), key, 255);
                cSlash(tempP);
                if ( Info.CmpName(tempP, PanelItem->FindData.cFileName, false) )
                {
                  ret = strcpy(str,s) != NULL;
                  if ( ks && removeKS )
                    if ( !DeleteFile(tempP) )
                      ret = 0;
                }
                else
                {
                  strcat(s, "\r\n");
                  DWORD ls = strlen(s), lw = 0, dwPos = SetFilePointer(w, 0, 0, FILE_CURRENT);
                  LockFile(w, dwPos, 0, dwPos+ls, 0);
                  WriteFile(w, s, ls, &lw, NULL);
                  UnlockFile(w, dwPos, 0, dwPos+ls, 0);
                  ++writed;
                }
              }
            }
          }
          CloseHandle(w);
        }
        winDel(fileBuff);
      }
    }
  }
  CloseHandle(r);
  if ( !DeleteFile(lo) )
    return 0;
  if ( !writed )
  {
    int choice = Opt.DeleteEmptyLO;
    if ( Opt.DeleteEmptyLO > 1 )
    {
      const char *MsgItems[]={GetMsg(MRemoveEmptyLOTitle),GetMsg(MRemoveEmptyLO),lo,"\x1",GetMsg(MDelete),GetMsg(MCancel)};
      choice = wMessage(MsgItems, 2);
    }
    if ( !choice )
      return DeleteFile(tmp) ? ret : 0;
  }
  return MoveFile(tmp, lo) ? ret : 0;
}

void GetBSOList(BSORESOURCE *(&Res),DWORD &EnumCount,int OpMode)
{
  DeleteBSOList(Res,EnumCount);
  BSORESOURCE nr[2048];
  DWORD BSOCount = 0, BSOMaxCount = sizeof(nr)/sizeof(nr[0]);
  WIN32_FIND_DATA zf;
  static char f[NM], z[NM], bso[NM];
  strcpy(bso, Opt.PathToOutbound);
  TFTNAddress addr(Opt.Address);
  HANDLE h;
  if ( isDigit(*rootDir) )
  {
    TFTNAddress addr4scan(rootDir,&addr);
    scanBoxDirs(nr, &BSOCount, BSOMaxCount, addr4scan);
    addr4scan.bso(z,bso,"",&addr);
    h = FindFirstFile(strcat(strcpy(f, z), ".???"), &zf);
    if ( h != INVALID_HANDLE_VALUE )
    {
      do
      {
        if ( ! ( zf.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ) )
        {
          enBSOType ty;
          enBSOFlavor fl;
          char *e = strchr(zf.cFileName, '.');
          if ( e && strlen(e) == 4 && getFileType(e, ty, fl) )
          {
            char lo[NM];
            strcat(strcpy(lo, z), e);
            if ( ty == tyLO )
            {
              int rescanLoNeeded = true;
              int allChoice = !Opt.AutoCheck || (OpMode & OPM_FIND);
              int choice = 0;
              while ( rescanLoNeeded )
              {
                rescanLoNeeded = false;
                HANDLE r = CreateFile(lo, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
                if ( r != INVALID_HANDLE_VALUE )
                {
                  unsigned fileSize = GetFileSize(r, NULL);
                  if ( fileSize )
                  {
                    char *fileBuff = winNew(char,fileSize+1);
                    if ( fileBuff )
                    {
                      DWORD rb = 0;
                      if ( ReadFile(r, fileBuff, fileSize, &rb, NULL) && rb )
                      {
                        int nFiles = fileBuff[fileSize] = 0;
                        DWORD saveCount = BSOCount;
                        char s[NM], *p, *fp = fileBuff;
                        while ( getStr(s, &fp) )
                        {
                          int ks;
                          if ( ( p = str2fn(s, ks) ) != NULL )
                          {
                            WIN32_FIND_DATA ff;
                            char tempP[NM], tempOrig[NM], key[256];
                            if ( Opt.OEMInOutbound )
                              strcpy(tempP, p);
                            else
                              CharToOem(p, tempP);
                            strcpy(tempOrig, tempP);
                            FindFirstRegKey(HKEY_CURRENT_USER, "Subst", findSubst, cBackslash(tempP), key, 255);
                            HANDLE hh = FindFirstFile(fexpand(cSlash(tempP), Opt.BasePath), &ff);
                            if ( hh != INVALID_HANDLE_VALUE )
                              addLoFile(nr, &BSOCount, BSOMaxCount, tempP, &ff, e, ty, fl, ++nFiles, ks, 0);
                            else
                            {
                              if ( !allChoice )
                              {
                                const char *MsgItems[]={GetMsg(MError),GetMsg(MFileNotFound),tempP,GetMsg(MRemoveInvalidFile),"\x1",GetMsg(MKeep),GetMsg(MDelete),GetMsg(MDeleteAll),GetMsg(MCancel)};
                                choice = wMessage(MsgItems, 4);
                              }
                              if ( choice == 1 || choice == 2 )
                              {
                                FindClose(hh);
                                CloseHandle(r);
                                char str[NM];
                                struct PluginPanelItem PanelItem;
                                fexpand(strcpy(PanelItem.FindData.cFileName, tempP), Opt.BasePath);
                                removeFile(lo,&PanelItem,0,str);
                                rescanLoNeeded = true;
                                BSOCount = saveCount;
                                if ( choice == 2 )
                                {
                                  allChoice = true;
                                  choice = 1;
                                }
                                break;
                              }
                              else
                              {
                                WIN32_FIND_DATA bf;
                                memset(&bf,0,sizeof(bf));
                                strcpy(bf.cFileName, tempOrig);
                                bf.dwFileAttributes = FILE_ATTRIBUTE_HIDDEN;
                                addLoFile(nr, &BSOCount, BSOMaxCount, "", &bf, e, ty, fl, ++nFiles, ks, 0);
                                if ( choice )
                                {
                                  allChoice = true;
                                  choice = 0;
                                }
                              }
                            }
                            FindClose(hh);
                          }
                        }
                        if ( !rescanLoNeeded && !nFiles )
                          addLoFile(nr, &BSOCount, BSOMaxCount, lo, &zf, NULL, ty, fl, 0, 1, 0);
                      }
                      winDel(fileBuff);
                    }
                  }
                  else
                    addLoFile(nr, &BSOCount, BSOMaxCount, lo, &zf, NULL, ty, fl, 0, 1, 0);
                }
                CloseHandle(r);
              }
            }
            else
              addLoFile(nr, &BSOCount, BSOMaxCount, lo, &zf, NULL, ty, fl, 0, 0, 0);
          }
        }
      } while ( FindNextFile(h, &zf) );
    }
  }
  else
  {
    h = FindFirstFile(strcat(addBackslash(strcpy(f, Opt.BoxesPath)), "*"), &zf);
    if ( h != INVALID_HANDLE_VALUE )
    {
      char box[NM];
      do
      {
        if ( *zf.cFileName != '.' && ( zf.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ) )
        {
          char testBox[NM] = "", *p = strchr(strcpy(box, zf.cFileName), '.');
          if ( p )
          {
            char *last = strchr(p, 0)-1;
            int doScan = 1, hold = toUpper(*last) == 'H';
            if ( hold )
              *last = 0;
            last = strchr(p, 0)-1;
            if ( *last != '.' )
              strcat(box, ".");
            TFTNAddress addr4scan;
            unsigned short part[4];
            p = box;
            for ( int i = 0 ; i < 4 ; i++ )
            {
              part[i] = 0xFFFF;
              char *pp = strchr(p, '.');
              if ( pp == NULL )
              {
                doScan = 0;
                break;
              }
              else
              {
                *pp = 0;
                if ( getNum(p, part[i]) )
                {
                  if ( part[i] == 0xFFFF )
                  {
                    doScan = 0;
                    break;
                  }
                }
                else
                {
                  doScan = 0;
                  break;
                }
              }
              *pp = '.';
              p = pp+1;
            }
            if ( doScan )
            {
              addr4scan.zone  = part[0];
              addr4scan.net   = part[1];
              addr4scan.node  = part[2];
              addr4scan.point = part[3];
              addr4scan.valid = 1;
              delBackslash(addr4scan.box(testBox, "", 0, hold));
              doScan = !stricmp(zf.cFileName, testBox);
            }
            else
            {
              doScan = 0;
              strcpy(box, zf.cFileName);
              if ( strlen(box) > 10 && box[8] == '.' )
              {
                addr4scan.zone  = from32(box,   2);
                addr4scan.net   = from32(box+2, 3);
                addr4scan.node  = from32(box+5, 3);
                addr4scan.point = from32(box+9, 2);
                addr4scan.valid = 1;
                delBackslash(addr4scan.box(testBox, "", 1, hold));
                doScan = !stricmp(zf.cFileName, testBox);
              }
            }
            if ( doScan )
              scanBox(strcat(addBackslash(strcpy(box, Opt.BoxesPath)), zf.cFileName), nr, &BSOCount, BSOMaxCount, addr4scan, hold ? fl_H : fl_D);
          }
        }
      } while ( FindNextFile(h, &zf) );
    }
    FindClose(h);
    scanZone(bso, nr, &BSOCount, BSOMaxCount, addr);
    h = FindFirstFile(strcat(strcpy(f, bso), ".???"), &zf);
    if ( h != INVALID_HANDLE_VALUE )
    {
      do
      {
        if ( zf.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY )
        {
          char *p = strchr(zf.cFileName, '.');
          if ( p )
          {
            char txtz[4];
            if ( ch03x(p+1, &addr.zone) )
            {
              FSF.sprintf(txtz, "%03X", addr.zone);
              if ( !strIcmp(txtz, p+1) )
                scanZone(strcat(strcpy(z, bso), p ), nr, &BSOCount, BSOMaxCount, addr);
            }
          }
        }
      } while ( FindNextFile(h, &zf) );
    }
  }
  FindClose(h);
  if ( BSOCount > 0 )
  {
    Res = (BSORESOURCE *)realloc(Res,BSOCount*sizeof(*Res));
    for ( unsigned I = 0 ; I < BSOCount ; I++ )
    {
      BSORESOURCE *destnr = Res+EnumCount+I;
      memcpy(&destnr->FileInfo,&nr[I].FileInfo, sizeof(nr[I].FileInfo));
      destnr->BUSY_Status = nr[I].BUSY_Status;
      destnr->BOX_Status = nr[I].BOX_Status;
      destnr->KS_Status = nr[I].KS_Status;
      destnr->REQ_Status = nr[I].REQ_Status;
      destnr->MailFlavor = CopyText(nr[I].MailFlavor);
      destnr->FileFlavor = CopyText(nr[I].FileFlavor);
      destnr->LoExt = CopyText(nr[I].LoExt);
      destnr->LoLine = nr[I].LoLine;
    }
  }
  EnumCount = BSOCount;
}

static void formatInfoStr(char *s, char *ttl, const WIN32_FIND_DATA& ff)
{
  FILETIME LocalDate;
  SYSTEMTIME SysDate;
  char strD[32], strT[32];
  FileTimeToLocalFileTime(&ff.ftLastWriteTime, &LocalDate);
  FileTimeToSystemTime(&LocalDate, &SysDate);
  GetDateFormat(LOCALE_SYSTEM_DEFAULT, DATE_SHORTDATE, &SysDate, NULL, strD, sizeof(strD));
  GetTimeFormat(LOCALE_SYSTEM_DEFAULT, 0,              &SysDate, NULL, strT, sizeof(strT));
  FSF.sprintf(s, "%-20s%10d %s %s", ttl, ff.nFileSizeLow, strD, strT);
}

static char *repStr(char *s, char c, size_t n)
{
  if ( n )
  {
    memset(s, c, n);
    s[n] = 0;
  }
  else
    *s = 0;
  return s;
}

static int fileCopyMove(const WIN32_FIND_DATA& ff, char *file, char *destPath, int move, int itemI, int itemN)
{
  WIN32_FIND_DATA tf;
  char tempFilePath[NM], tempFile[NM];
  const char *sfn = strrchr(ff.cFileName, '\\');
  BOOL success = true, fileExists = false, OverWrite = false, DoCopy = true;
  addBackslash(strcpy(tempFilePath,destPath));
  strcat(strcpy(tempFile, tempFilePath), sfn ? sfn+1 : ff.cFileName);
  if ( !stricmp(file, tempFile) )
    return true;
  HANDLE th = FindFirstFile(tempFile, &tf);
  if ( th != INVALID_HANDLE_VALUE )
    fileExists = true;
  FindClose(th);
  if ( fileExists )
  {
    char src[NM], dst[NM];
    formatInfoStr(src, GetMsg(MSrcFile), ff);
    formatInfoStr(dst, GetMsg(MDstFile), tf);
    const char *MsgItems[]={GetMsg(MError),GetMsg(MFileAlreadyExists),tempFile,"\x1",src,dst,"\x1",GetMsg(MOverwrite),GetMsg(MKeepExisting),GetMsg(MCancel)};
    switch ( wMessage(MsgItems, 3) )
    {
      case 0:
        OverWrite = true;
        break;
      case 1:
        DoCopy = false;
        break;
      default:
        success = false;
        break;
    }
  }
  if ( success )
  {
    if ( DoCopy )
    {
      HANDLE hScreen;
      hScreen=Info.SaveScreen(0,0,-1,-1);
      const N = 60;
      char progress[N+1];
      const char *MsgItems[] = { GetMsg(MCopyTitle), file, progress };
      int L = itemI*N/itemN;
      repStr(progress, '', L);
      repStr(progress+L, '', N-L);
      iMessage(MsgItems, 0);
      BOOL copyRes = CopyFile(file, tempFile, !OverWrite);
      Info.RestoreScreen(hScreen);
      if ( copyRes )
      {
        if ( move )
          DeleteFile(file);
        strcpy(file, tempFile);
      }
      else
      {
        const char *MsgItems[]={GetMsg(MError),tempFile,GetMsg(MCopyError),GetMsg(MOk)};
        eMessage(MsgItems, 1);
        success = false;
      }
    }
  }
  return success;
}

static void AttachFile(struct PluginPanelItem *pi, int Move, int box, int fromOrig, char *lo, char *pathFrom, int itemI, int itemN)
{
  WIN32_FIND_DATA bf;
  char curDir[NM], file[NM];
  addBackslash(strcpy(curDir,pathFrom));
  HANDLE bh = FindFirstFile(strcat(strcpy(file, curDir), pi->FindData.cFileName), &bf);
  if ( bh == INVALID_HANDLE_VALUE )
  {
    const char *MsgItems[]={GetMsg(MError),GetMsg(MFileNotFound),file,GetMsg(MOk)};
    wMessage(MsgItems, 1);
  }
  else if ( bf.dwFileAttributes == FILE_ATTRIBUTE_DIRECTORY )
  {
    const char *MsgItems[]={GetMsg(MAttachTitle),GetMsg(MFolderNotCopyed),file,GetMsg(MOk)};
    wMessage(MsgItems, 1);
  }
  else
  {
    char tempFile[NM];
    if ( !createDir(lo) )
    {
      const char *MsgItems[]={GetMsg(MError),lo,GetMsg(MOk)};
      eMessage(MsgItems, 1);
    }
    if ( box )
    {
      if ( fileCopyMove(pi->FindData, file, lo, Move, itemI, itemN) )
        pi->Flags &= ~PPIF_SELECTED;
    }
    else
    {
      if ( fromOrig || fileCopyMove(pi->FindData, file, Opt.TempPath, Move, itemI, itemN) )
      {
        char key[256];
        FindFirstRegKey(HKEY_CURRENT_USER, "Subst", findPath, file, key, 255);
        if ( Opt.UseShortNames )
        {
          OemToChar(file, tempFile);
          GetShortPathName(tempFile, file, sizeof(file));
          CharToOem(file, tempFile);
          strcpy(file, tempFile);
        }
        if ( Opt.UseRelative )
        {
          int len = strlen(Opt.BasePath);
          if ( !strNIcmp(file, Opt.BasePath, len) )
            strcpy(file, file+len+1);
        }
        if ( !Opt.OEMInOutbound )
        {
          OemToChar(file, tempFile);
          strcpy(file, tempFile);
        }
        if ( Opt.UseSlashes )
          cBackslash(file);
        HANDLE f = CreateFile(lo, GENERIC_WRITE, 0, NULL, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
        if ( f != INVALID_HANDLE_VALUE )
        {
          FSF.sprintf(tempFile, "%s%s\r\n", Move ? "^" : "", file);
          DWORD dwBytesRead = strlen(tempFile), dwBytesWritten = 0;
          DWORD dwPos = SetFilePointer(f, 0, NULL, FILE_END);
          LockFile(f, dwPos, 0, dwPos+dwBytesRead, 0);
          WriteFile(f, tempFile, dwBytesRead, &dwBytesWritten, NULL);
          UnlockFile(f, dwPos, 0, dwPos+dwBytesRead, 0);
          pi->Flags &= ~PPIF_SELECTED;
        }
        CloseHandle(f);
      }
    }
  }
  FindClose(bh);
}

static int AttachFiles(char *aAddr, char *pathFrom, struct PluginPanelItem *PanelItem,int ItemsNumber,int Move,int OpMode)
{
  char addrTo[256];
  strcpy(addrTo, aAddr);
  struct InitDialogItem InitItems[] =
  {
    { DI_DOUBLEBOX,  3, 1,42, 18,0,0,                         (char*)MAttachTitle   },
    { DI_TEXT,       5, 2, 0,  0,0,0,                         (char*)MAttachAddress },
    { DI_EDIT,       5, 3,40,  0,(DWORD)hId,DIF_HISTORY|DIF_USELASTHISTORY,addrTo   }, // 2
    { DI_TEXT,       5, 4, 0,255,0,0,                         NULL                  },
    { DI_RADIOBUTTON,5, 5,40,  0,0,DIF_GROUP,                 (char*)MImmediate     }, // 4
    { DI_RADIOBUTTON,5, 6,40,  0,0,0,                         (char*)MCrash         },
    { DI_RADIOBUTTON,5, 7,40,  0,0,0,                         (char*)MDirect        },
    { DI_RADIOBUTTON,5, 8,40,  0,0,0,                         (char*)MNormal        },
    { DI_RADIOBUTTON,5, 9,40,  0,0,0,                         (char*)MHold          },
    { DI_RADIOBUTTON,5,10,40,  0,0,0,                         (char*)MBoxNormal     },
    { DI_RADIOBUTTON,5,11,40,  0,0,0,                         (char*)MBoxHold       },
    { DI_CHECKBOX,   5,13,40,  0,Move,0,                      (char*)MAttachKS      }, //11
    { DI_CHECKBOX,   5,14,40,  0,Opt.AttachFromTemp,0,        (char*)MAttachTemp    }, //12
    { DI_CHECKBOX,   5,15,40,  0,Opt.UseLongBoxes,0,          (char*)MLongBox       }, //13
    { DI_TEXT,       5,16, 0,255,0,0,                         NULL                  },
    { DI_BUTTON,     0,17, 0,  0,0,DIF_CENTERGROUP,           (char*)MOk            }, //15
    { DI_BUTTON,     0,17, 0,  0,0,DIF_CENTERGROUP,           (char*)MCancel        }
  };
  if ( OpMode & OPM_SILENT )
    InitItems[2].Type = DI_TEXT;
  TFTNAddress addr2poll, addr(Opt.Address);
  if ( addr2poll.parse(addrTo, &addr) )
    addr2poll.print(addrTo, Opt.ShortAddresses, &addr);
  InitItems[4+Opt.AttachFlavor].Selected = 1;
  int ExitCode = ExecDialog(InitItems,sizeof(InitItems)/sizeof(InitItems[0]),2,15,"BSOAttach");
  if ( ExitCode == 15 )
  {
    if ( addr2poll.parse(addrTo, &addr) )
    {
      int pollNow = confirmBSY(addr2poll);
      if ( pollNow )
      {
        int box = 0;
        char lo[256], ext[] = ".FLO";
        if      ( InitItems[ 4].Selected ) ext[1] = 'I';
        else if ( InitItems[ 5].Selected ) ext[1] = 'C';
        else if ( InitItems[ 6].Selected ) ext[1] = 'D';
        else if ( InitItems[ 8].Selected ) ext[1] = 'H';
        else if ( InitItems[ 9].Selected ) box = 1;
        else if ( InitItems[10].Selected ) box = ext[1] = 'H';
        Move = InitItems[11].Selected;
        int longbox = InitItems[13].Selected;
        if ( box )
          addr2poll.box(lo,Opt.BoxesPath,!longbox,ext[1]=='H');
        else
          addr2poll.bso(lo,Opt.PathToOutbound,ext,&addr);
        for ( int I = 0 ; I < ItemsNumber ; I++ )
          AttachFile(&PanelItem[I], Move, box, !InitItems[12].Selected, lo, pathFrom, I, ItemsNumber);
        return 1;
      }
    }
    else
    {
      const char *MsgItems[]={GetMsg(MError),GetMsg(MInvalidAddress),InitItems[2].Data,GetMsg(MOk)};
      wMessage(MsgItems, 1);
    }
  }
  return 0;
}

static int changeFileFlavor(struct PluginPanelItem *PanelItem,char *alo, char *boxStr, enBSOFlavor newFl, int ks, int flavorIdx, int itemsI, int itemsN)
{
  if ( PanelItem->CustomColumnNumber == custMAX && PanelItem->CustomColumnData != NULL)
  {
    enBSOFlavor fl;
    enBSOType ty;
    WIN32_FIND_DATA bf;
    HANDLE bh;
    char ext[4], lo[NM], *e = PanelItem->CustomColumnData[custExt];
    strcpy(lo,alo);
    if ( e && strlen(e) == 4 && getFileType(e, ty, fl) )
    {
      switch ( ty )
      {
        case tyBSY:
        case tyREQ:
          return 1;
        case tyUT:
          strcpy(ext,".OUT");
          ext[1] = "NICDOH"[newFl];
          bh = FindFirstFile(strcat(lo,ext), &bf);
          if ( bh != INVALID_HANDLE_VALUE )
          {
            const char *MsgItems[]={GetMsg(MError),GetMsg(MFileAlreadyExists),lo,GetMsg(MOk)};
            wMessage(MsgItems, 1);
            FindClose(bh);
            return 0;
          }
          FindClose(bh);
          MoveFile(PanelItem->FindData.cFileName,lo);
          return 1;
        case tyLO:
          strcpy(ext,".?LO");
          ext[1] = "NICDFH"[newFl];
          char *p = strchr(lo,0);
          bh = FindFirstFile(strcat(lo,e), &bf);
          if ( bh == INVALID_HANDLE_VALUE )
          {
            const char *MsgItems[]={GetMsg(MError),GetMsg(MFileNotFound),lo,GetMsg(MOk)};
            wMessage(MsgItems, 1);
            FindClose(bh);
            return 0;
          }
          FindClose(bh);
          char s[NM];
          if ( removeFile(lo,PanelItem,0,s) )
          {
            int Move = ks == 2;
            if ( !ks )
              Move = *s == '^' || *s == '#';
            strcpy(p,ext);
            AttachFile(PanelItem, Move, boxStr != NULL, 1, boxStr ? boxStr : lo, "", itemsI, itemsN);
            return 1;
          }
          else
          {
            const char *MsgItems[]={GetMsg(MError),GetMsg(MFileNotRemoved),lo,GetMsg(MOk)};
            wMessage(MsgItems, 1);
          }
          return 0;
      }
    }
    else
    {
      if ( boxStr )
      {
        AttachFile(PanelItem, 1, boxStr != NULL, 1, boxStr ? boxStr : lo, "", itemsI, itemsN);
        return 1;
      }
      else
      {
        FSF.sprintf(lo, GetMsg(MCantChangeFlavor), GetMsg(flavorIdx));
        const char *MsgItems[]={GetMsg(MError),GetMsg(MFileAttachedFromBox),PanelItem->FindData.cFileName,lo,GetMsg(MOk)};
        wMessage(MsgItems, 1);
      }
    }
    return 0;
  }
  return 1;
}

static int editLoFile(void)
{
  TFTNAddress addr2poll, addr(Opt.Address);
  if ( addr2poll.parse(rootDir, &addr) )
  {
    char lo[256];
    int pollNow = confirmBSY(addr2poll);
    if ( pollNow )
    {
      PanelInfo panelInfo;
      Info.Control(INVALID_HANDLE_VALUE,FCTL_GETPANELINFO,&panelInfo);
      if ( panelInfo.ItemsNumber )
      {
        addr2poll.bso(lo,Opt.PathToOutbound,"",&addr);
        char *p = strchr(lo,0);
        struct PluginPanelItem *pi = &panelInfo.PanelItems[panelInfo.CurrentItem];
        if ( pi->CustomColumnNumber == custMAX && pi->CustomColumnData != NULL)
        {
          if ( *strcpy(p,pi->CustomColumnData[custExt]) )
          {
            int l = FSF.atoi(pi->CustomColumnData[custLine]);
            Info.Editor(lo,NULL,0,0,-1,-1,0,l,1);
            return 1;
          }
          else
          {
            const char *MsgItems[]={GetMsg(MError),GetMsg(MFileCantEdited),pi->FindData.cFileName,GetMsg(MFileMustBeDeleted),GetMsg(MOk)};
            wMessage(MsgItems, 1);
          }
        }
      }
    }
  }
  return 0;
}

static enBSOFlavor charToFlavor(char ch)
{
  switch ( toUpper(ch) )
  {
    case 'I': return fl_I;
    case 'C': return fl_C;
    case 'D': return fl_D;
    case 'F': return fl_F;
    case 'N': return fl_F;
    case 'O': return fl_F;
    case 'H': return fl_H;
  }
  return flNO;
}

static int changeFlavor(int selected)
{
  struct InitDialogItem InitItems[] =
  {
    { DI_DOUBLEBOX,   3, 1,42, 15,0,0,              (char*)MFlavorTitle },
    { DI_RADIOBUTTON, 5, 2,40,  0,0,DIF_GROUP,      (char*)MImmediate   }, //  1
    { DI_RADIOBUTTON, 5, 3,40,  0,0,0,              (char*)MCrash       }, //  2
    { DI_RADIOBUTTON, 5, 4,40,  0,0,0,              (char*)MDirect      }, //  3
    { DI_RADIOBUTTON, 5, 5,40,  0,0,0,              (char*)MNormal      }, //  4
    { DI_RADIOBUTTON, 5, 6,40,  0,0,0,              (char*)MHold        }, //  5
    { DI_RADIOBUTTON, 5, 7,40,  0,0,0,              (char*)MBoxNormal   }, //  6
    { DI_RADIOBUTTON, 5, 8,40,  0,0,0,              (char*)MBoxHold     }, //  7
    { DI_CHECKBOX,    5, 9,46,  0,0,0,              (char*)MLongBox     }, //  8
    { DI_TEXT,        5,11,40,  0,0,0,              (char*)MAttachKS    },
    { DI_RADIOBUTTON, 5,12,12,  0,0,0,              (char*)MYes         }, // 10
    { DI_RADIOBUTTON,13,12,20,  0,0,0,              (char*)MNo          }, // 11
    { DI_RADIOBUTTON,21,12,40,  0,0,0,              (char*)MDontChange  }, // 12
    { DI_TEXT,        5,13, 0,255,0,0,              NULL                },
    { DI_BUTTON,      0,14, 0,  0,0,DIF_CENTERGROUP,(char*)MOk          }, // 14
    { DI_BUTTON,      0,14, 0,  0,0,DIF_CENTERGROUP,(char*)MCancel      }
  };
  int currFlavor = 1+Opt.AttachFlavor;
  PanelInfo panelInfo;
  Info.Control(INVALID_HANDLE_VALUE,FCTL_GETPANELINFO,&panelInfo);
  if ( selected )
    if ( panelInfo.SelectedItemsNumber > 1 )
      InitItems[12].Selected = 1;
    else
    {
      PluginPanelItem *pi = panelInfo.SelectedItems;
      if ( *pi->CustomColumnData[custExt] )
        currFlavor = charToFlavor(pi->CustomColumnData[custExt][1]);
      else
        currFlavor = pi->CustomColumnData[custFile][4] == '.' ? fl_NB : fl_HB;
      InitItems[(*pi).CustomColumnData[custBRK][2] == '.' ? 11 : 10].Selected = 1;
    }
  else
  {
    PluginPanelItem *pi = panelInfo.PanelItems+panelInfo.CurrentItem;
    if ( *pi->CustomColumnData[custExt] )
      currFlavor = charToFlavor(pi->CustomColumnData[custExt][1]);
    else
      currFlavor = pi->CustomColumnData[custFile][4] == '.' ? fl_NB : fl_HB;
    InitItems[pi->CustomColumnData[custBRK][2] == '.' ? 11 : 10].Selected = 1;
  }
  InitItems[8].Selected = Opt.UseLongBoxes;
  InitItems[currFlavor].Selected = 1;
  int ExitCode = ExecDialog(InitItems,sizeof(InitItems)/sizeof(InitItems[0]),currFlavor,14,"BSOFlavor");
  if ( ExitCode == 14 )
  {
    TFTNAddress addr2poll, addr(Opt.Address);
    if ( addr2poll.parse(rootDir, &addr) )
    {
      char lo[256];
      int fs = MNormal;
      enBSOFlavor fl = flNO;
      int pollNow = confirmBSY(addr2poll);
      if ( pollNow )
      {
        if ( panelInfo.ItemsNumber )
        {
          int ks = 0, longbox = InitItems[8].Selected;
          char boxBuf[NM], *boxStr = NULL;
          if      ( InitItems[10].Selected ) ks = 2;
          else if ( InitItems[11].Selected ) ks = 1;
          else if ( InitItems[12].Selected ) ks = 0;
          if      ( InitItems[1].Selected ) { fl = fl_I; fs = MImmediate; }
          else if ( InitItems[2].Selected ) { fl = fl_C; fs = MCrash; }
          else if ( InitItems[3].Selected ) { fl = fl_D; fs = MDirect; }
          else if ( InitItems[4].Selected ) { fl = fl_F; fs = MNormal; }
          else if ( InitItems[5].Selected ) { fl = fl_H; fs = MHold; }
          else if ( InitItems[6].Selected ) { fl = fl_D; fs = MBoxNormal; boxStr = boxBuf; }
          else if ( InitItems[7].Selected ) { fl = fl_H; fs = MBoxHold;   boxStr = boxBuf; }
          addr2poll.bso(lo,Opt.PathToOutbound,"",&addr);
          addr2poll.box(boxBuf,Opt.BoxesPath,!longbox,fl==fl_H);
          if ( selected && panelInfo.SelectedItemsNumber )
            for ( int I = 0 ; I < panelInfo.SelectedItemsNumber ; I++ )
              changeFileFlavor(&panelInfo.SelectedItems[I],lo,boxStr,fl,ks,fs,I,panelInfo.SelectedItemsNumber);
          else
            changeFileFlavor(&panelInfo.PanelItems[panelInfo.CurrentItem],lo,boxStr,fl,ks,fs,0,1);
        }
        return 1;
      }
    }
  }
  return 0;
}

static void tryRemove(char *p, char *lo, int removeKS, struct PluginPanelItem *pi, int& defChoice)
{
  char s[NM];
  if ( pi->CustomColumnNumber == custMAX && pi->CustomColumnData != NULL)
  {
    if ( *strcpy(p,pi->CustomColumnData[custExt]) )
    {
      if ( !removeFile(lo,pi,removeKS,s) )
      {
        const char *MsgItems[]={GetMsg(MError),GetMsg(MFileNotRemoved),lo,GetMsg(MOk)};
        wMessage(MsgItems, 1);
      }
    }
    else
    {
      const char *MsgItems[]={GetMsg(MError),GetMsg(MFileCantRemoved),pi->FindData.cFileName,GetMsg(MFileMustBeDeleted),"\x1",GetMsg(MDelete),GetMsg(MDeleteAll),GetMsg(MSkip),GetMsg(MCancel)};
      switch ( defChoice )
      {
        case 0: // mDelete
        case 2: // mSkip
          defChoice = wMessage(MsgItems, 4);
          break;
      }
      bool deleteAll = false;
      switch ( defChoice )
      {
        case 0: // mDelete
          break;
        case 1: // mDeleteAll
          deleteAll = true;
          break;
        default:
          return;
      }
      if ( deleteAll || defChoice == 0 )
        if ( !DeleteFile(pi->FindData.cFileName) )
        {
          const char *MsgItems[]={GetMsg(MError),pi->FindData.cFileName,GetMsg(MOk)};
          eMessage(MsgItems, 1);
        }
    }
  }
}

static int removeFiles(void)
{
  PanelInfo panelInfo;
  char lo[NM];
  Info.Control(INVALID_HANDLE_VALUE,FCTL_GETPANELINFO,&panelInfo);
  TFTNAddress addr2poll, addr(Opt.Address);
  if ( addr2poll.parse(rootDir, &addr) )
  {
    int pollNow = confirmBSY(addr2poll);
    if ( pollNow )
    {
      if ( panelInfo.ItemsNumber )
      {
        switch ( panelInfo.SelectedItemsNumber )
        {
          case 0:
            strcpy(lo, panelInfo.PanelItems[panelInfo.CurrentItem].FindData.cFileName);
            break;
          case 1:
            strcpy(lo, panelInfo.SelectedItems[0].FindData.cFileName);
            break;
          default:
            FSF.sprintf(lo, GetMsg(MFiles), panelInfo.SelectedItemsNumber);
            break;
        }
        char shortFN[64];
        int len = strlen(lo);
        if ( len > 40 )
          strcat(strcpy(shortFN, "..."), lo+(len-40));
        else
          strcpy(shortFN, lo);
        struct InitDialogItem InitItems[] =
        {
          { DI_DOUBLEBOX,   3, 1,50,  9,0,0,              (char*)MRemoveWarningTitle },
          { DI_TEXT,        5, 2, 0,  0,0,DIF_CENTERGROUP,(char*)MRemoveWarning      },
          { DI_TEXT,        4, 2, 0,  0,0,0,              ""                         },
          { DI_TEXT,        5, 3, 0,  0,0,DIF_CENTERGROUP,shortFN                    },
          { DI_TEXT,        4, 3, 0,  0,0,0,              ""                         },
          { DI_TEXT,        5, 4, 0,  0,0,DIF_CENTERGROUP,(char*)MWantToContinue     },
          { DI_TEXT,        5, 5, 0,255,0,0,              NULL                       },
          { DI_CHECKBOX,    5, 6,70,  0,1,0,              (char*)MRemoveKS           }, // 7
          { DI_TEXT,        5, 7, 0,255,0,0,              NULL                       },
          { DI_BUTTON,      0, 8, 0,  0,0,DIF_CENTERGROUP,(char*)MOk                 }, // 9
          { DI_BUTTON,      0, 8, 0,  0,0,DIF_CENTERGROUP,(char*)MCancel             }
        };
        int ExitCode = ExecDialog(InitItems,sizeof(InitItems)/sizeof(InitItems[0]),7,9,"BSOKill");
        if ( ExitCode != 9 )
          return 1;
        int defChoice = 0, removeKS = InitItems[7].Selected;
        addr2poll.bso(lo,Opt.PathToOutbound,"",&addr);
        char *p = strchr(lo,0);
        if ( panelInfo.SelectedItemsNumber )
          for ( int I = 0 ; I < panelInfo.SelectedItemsNumber ; I++ )
            tryRemove(p, lo, removeKS, &panelInfo.SelectedItems[I], defChoice);
        else
          tryRemove(p, lo, removeKS, &panelInfo.PanelItems[panelInfo.CurrentItem], defChoice);
      }
      return 1;
    }
  }
  return 0;
}

int WINAPI _export GetMinFarVersion(void)
{
  // return FARMANAGERVERSION;
  return 0x01410146UL;
}

HANDLE heap;

void WINAPI _export SetStartupInfo(const struct PluginStartupInfo *Info)
{
  initMem();
  ::Info = *Info;
  IsOldFar = true;
  if ( Info->StructSize >= sizeof(struct PluginStartupInfo) )
  {
    ::FSF = *Info->FSF;
    ::Info.FSF = &::FSF;
    IsOldFar = false;
    FSF.sprintf(PluginRootKey,"%s\\TRUE-BSO",Info->RootKey);
    Opt.AddToDisksMenu    = GetRegKey(HKEY_CURRENT_USER,"","AddToDisksMenu",1);
    Opt.AutoRefresh       = GetRegKey(HKEY_CURRENT_USER,"","AutoRefresh",1);
    Opt.DisksMenuDigit    = GetRegKey(HKEY_CURRENT_USER,"","DisksMenuDigit",3);
    Opt.LinksPanelMode    = GetRegKey(HKEY_CURRENT_USER,"","LinksPanelMode",3);
    Opt.FilesPanelMode    = GetRegKey(HKEY_CURRENT_USER,"","FilesPanelMode",3);
    Opt.NoChangePanelMode = GetRegKey(HKEY_CURRENT_USER,"","NoChangePanelMode",0);
    Opt.UpperPath         = GetRegKey(HKEY_CURRENT_USER,"","UpperPath",1);
    Opt.UnsortedPanel     = GetRegKey(HKEY_CURRENT_USER,"","UnsortedPanel",0);
    Opt.ShortAddresses    = GetRegKey(HKEY_CURRENT_USER,"","ShortAddresses",0);
    Opt.AttachFlavor      = GetRegKey(HKEY_CURRENT_USER,"","AttachFlavor", 3) % 7;
    Opt.PollFlavor        = GetRegKey(HKEY_CURRENT_USER,"","PollFlavor", 3) % 5;
    Opt.UseSlashes        = GetRegKey(HKEY_CURRENT_USER,"","UseSlashes",0);
    Opt.UseLongBoxes      = GetRegKey(HKEY_CURRENT_USER,"","UseLongBoxes",0);
    Opt.UseRelative       = GetRegKey(HKEY_CURRENT_USER,"","UseRelative",0);
    Opt.UseShortNames     = GetRegKey(HKEY_CURRENT_USER,"","UseShortNames",0);
    Opt.OEMInOutbound     = GetRegKey(HKEY_CURRENT_USER,"","OEMInOutbound",1);
    Opt.RestoreFolder     = GetRegKey(HKEY_CURRENT_USER,"","RestoreFolder",0);
    Opt.Highlighting      = GetRegKey(HKEY_CURRENT_USER,"","Highlighting",0);
    Opt.AutoCheck         = GetRegKey(HKEY_CURRENT_USER,"","AutoCheck",1);
    Opt.DeleteEmptyLO     = GetRegKey(HKEY_CURRENT_USER,"","DeleteEmptyLO",2);
    Opt.AttachFromTemp    = GetRegKey(HKEY_CURRENT_USER,"","AttachFromTemp",0);
    GetRegKey(HKEY_CURRENT_USER,"","PathToOutbound", Opt.PathToOutbound, "", 255);
    delBackslash(Opt.PathToOutbound);
    GetRegKey(HKEY_CURRENT_USER,"","BasePath", Opt.BasePath, "", 255);
    delBackslash(Opt.BasePath);
    GetRegKey(HKEY_CURRENT_USER,"","TempPath", Opt.TempPath, "", 255);
    delBackslash(Opt.TempPath);
    GetRegKey(HKEY_CURRENT_USER,"","BoxesPath", Opt.BoxesPath, "", 255);
    delBackslash(Opt.BoxesPath);
    GetRegKey(HKEY_CURRENT_USER,"","Address", Opt.Address, "2:464/991", 255);
  }
}

HANDLE WINAPI _export OpenPlugin(int OpenFrom, int item)
{
  HANDLE hPlugin = NULL;
  if ( !IsOldFar )
  {
    struct FarMenuItem MainMenu[7];
    int i, count = sizeof(MainMenu)/sizeof(*MainMenu);
    PanelInfo panelInfo;
    char top[80];
    switch ( OpenFrom )
    {
      case OPEN_FINDLIST:
      case OPEN_DISKMENU:
        hPlugin = newBSOBrowser();
        break;
      case OPEN_PLUGINSMENU:
        for ( i = 0 ; i < count ; i++ )
          MainMenu[i].Selected = MainMenu[i].Checked = MainMenu[i].Separator = false;
        strcpy(top,GetMsg(MBSOMenu));
        strcpy(MainMenu[0].Text, GetMsg(MBSOMenuPanel));
        strcpy(MainMenu[2].Text, GetMsg(MBSOMenuAttach));
        strcpy(MainMenu[3].Text, GetMsg(MBSOMenuFREQ));
        strcpy(MainMenu[4].Text, GetMsg(MBSOMenuPoll));
        strcpy(MainMenu[6].Text, GetMsg(MBSOMenuConfig));
        *MainMenu[1].Text = *MainMenu[5].Text = 0;
        MainMenu[1].Separator = MainMenu[5].Separator = true;
        switch ( Info.Menu(Info.ModuleNumber,-1,-1,0,FMENU_WRAPMODE,top,NULL,NULL,NULL,NULL,MainMenu,count) )
        {
          case 0:
            hPlugin = newBSOBrowser();
            break;
          case 2:
            Info.Control(INVALID_HANDLE_VALUE,FCTL_GETPANELINFO,&panelInfo);
            if ( panelInfo.ItemsNumber )
            {
              char curDir[NM];
              strcpy(curDir,panelInfo.CurDir);
              if ( panelInfo.SelectedItemsNumber )
                AttachFiles("", curDir, panelInfo.SelectedItems, panelInfo.SelectedItemsNumber, 0, 0);
              else
                AttachFiles("", curDir, &panelInfo.PanelItems[panelInfo.CurrentItem], 1, 0, 0);
            }
            break;
          case 3:
            makeFREQ("");
            break;
          case 4:
            makePoll("");
            break;
          case 6:
            Config();
            break;
          default:
            break;
        }
        break;
      case OPEN_SHORTCUT:
      case OPEN_COMMANDLINE:
        hPlugin = newBSOBrowser((char*)item);
        break;
      case OPEN_EDITOR:
      case OPEN_VIEWER:
        for ( i = 0 ; i < count ; i++ )
          MainMenu[i].Selected = MainMenu[i].Checked = MainMenu[i].Separator = false;
        strcpy(top,GetMsg(MBSOMenu));
        strcpy(MainMenu[0].Text, GetMsg(MBSOMenuFREQ));
        strcpy(MainMenu[1].Text, GetMsg(MBSOMenuPoll));
        strcpy(MainMenu[3].Text, GetMsg(MBSOMenuConfig));
        *MainMenu[2].Text = 0;
        MainMenu[2].Separator = true;
        switch ( Info.Menu(Info.ModuleNumber,-1,-1,0,FMENU_WRAPMODE,top,NULL,NULL,NULL,NULL,MainMenu,4) )
        {
          case 0:
            makeFREQ("");
            break;
          case 1:
            makePoll("");
            break;
          case 3:
            Config();
            break;
        }
        break;
    }
  }
  return ( hPlugin == NULL ) ? INVALID_HANDLE_VALUE : hPlugin;
}

void WINAPI _export ClosePlugin(HANDLE /*hPlugin*/)
{
  if ( Opt.RestoreFolder && strcmp(prevDir, ".") )
  {
    Info.Control(INVALID_HANDLE_VALUE, FCTL_SETPANELDIR, prevDir);
    strcpy(prevDir, ".");
  }
  deleteBSOBrowser();
}

int WINAPI _export GetFindData(HANDLE /*hPlugin*/,struct PluginPanelItem **pPanelItem,int *pItemsNumber,int OpMode)
{
  *pPanelItem = NULL;
  *pItemsNumber = 0;
  GetBSOList(BSORes,BSOCount,OpMode);
  PluginPanelItem *NewPanelItem = winNew(PluginPanelItem,BSOCount);
  *pPanelItem = NewPanelItem;
  if ( NewPanelItem == NULL )
    return false;
  int CurItemPos=0;
  for ( unsigned I = 0 ; I < BSOCount ; I++ )
  {
    char buff[NM];
    memset(&NewPanelItem[CurItemPos],0,sizeof(PluginPanelItem));
    memcpy(&NewPanelItem[CurItemPos].FindData,&BSORes[I].FileInfo,sizeof(BSORes[I].FileInfo));
    CharToOem(GetAddress(&BSORes[I],buff),NewPanelItem[CurItemPos].FindData.cFileName);
    if ( !isDigit(*rootDir) && BSORes[I].BUSY_Status )
      NewPanelItem[CurItemPos].FindData.dwFileAttributes |= FILE_ATTRIBUTE_HIDDEN;
    NewPanelItem[CurItemPos].CustomColumnData = winNew(LPSTR,custMAX);
    NewPanelItem[CurItemPos].CustomColumnData[custBRK] = CopyText(GetBRKStatus(&BSORes[I],buff));
    NewPanelItem[CurItemPos].CustomColumnData[custMail] = CopyText(GetMailFlavor(&BSORes[I],buff));
    NewPanelItem[CurItemPos].CustomColumnData[custFile] = CopyText(GetFileFlavor(&BSORes[I],buff));
    NewPanelItem[CurItemPos].CustomColumnData[custExt] = CopyText(GetLoExt(&BSORes[I],buff));
    NewPanelItem[CurItemPos].CustomColumnData[custLine] = CopyText(GetLoLine(&BSORes[I],buff));
    NewPanelItem[CurItemPos].CustomColumnNumber=custMAX;
    CurItemPos++;
  }
  *pItemsNumber = CurItemPos;
  return true;
}

void WINAPI _export FreeFindData(HANDLE /*hPlugin*/,struct PluginPanelItem *PanelItem,int ItemsNumber)
{
  for ( int I = 0 ; I < ItemsNumber ; I++ )
  {
    for ( int J = 0 ; J < PanelItem[I].CustomColumnNumber ; J++ )
      winDel(PanelItem[I].CustomColumnData[J]);
    winDel(PanelItem[I].CustomColumnData);
  }
  winDel(PanelItem);
}

void WINAPI _export GetPluginInfo(struct PluginInfo *Info)
{
  if ( !IsOldFar )
  {
    Info->StructSize=sizeof(*Info);
    Info->Flags=PF_EDITOR|PF_VIEWER;
    static char *DiskMenuStrings[1];
    DiskMenuStrings[0]=GetMsg(MDiskMenuString);
    static int DiskMenuNumbers[1];
    Info->DiskMenuStrings=DiskMenuStrings;
    Info->CommandPrefix=DiskMenuStrings[0];
    DiskMenuNumbers[0]=Opt.DisksMenuDigit;
    Info->DiskMenuNumbers=DiskMenuNumbers;
    Info->DiskMenuStringsNumber=Opt.AddToDisksMenu ? 1 : 0;
    static char *PluginMenuStrings[1];
    PluginMenuStrings[0]=GetMsg(MBSOMenu);
    Info->PluginMenuStrings=PluginMenuStrings;
    Info->PluginMenuStringsNumber=sizeof(PluginMenuStrings)/sizeof(PluginMenuStrings[0]);
    static char *PluginCfgStrings[1];
    PluginCfgStrings[0]=GetMsg(MBSOMenu);
    Info->PluginConfigStrings=PluginCfgStrings;
    Info->PluginConfigStringsNumber=sizeof(PluginCfgStrings)/sizeof(PluginCfgStrings[0]);
  }
}

void WINAPI _export GetOpenPluginInfo(HANDLE /*hPlugin*/,struct OpenPluginInfo *Info)
{
  static char Title[100];
  int isFilePanel=isDigit(*rootDir) ? 1 : 0;
  Info->StructSize=sizeof(*Info);
  FSF.sprintf(Title," %s:%s ",GetMsg(MBSOTitle),rootDir);
  Info->ShortcutData=rootDir;
  Info->PanelTitle=Title;

  Info->StartSortMode = ( Opt.UnsortedPanel ? SM_UNSORTED : SM_DEFAULT );
  Info->StartSortOrder = 1;
  Info->Flags=OPIF_USEHIGHLIGHTING|OPIF_USEFILTER|OPIF_USESORTGROUPS|OPIF_ADDDOTS;
  if ( isFilePanel )
    Info->Flags |= OPIF_SHOWNAMESONLY|OPIF_REALNAMES;
  else if ( Opt.Highlighting )
    Info->Flags |= OPIF_USEATTRHIGHLIGHTING;
  else
    Info->Flags &= ~OPIF_USEHIGHLIGHTING;
  Info->HostFile=NULL;
  Info->CurDir=rootDir;
  Info->Format=GetMsg(MBSOTitle);
  Info->InfoLines=NULL;
  Info->InfoLinesNumber=0;
  if ( isFilePanel )
  Info->DescrFiles=NULL;
  Info->DescrFilesNumber=0;
  static struct PanelMode PanelModesArray[10];
  static char *ColumnTitles[8];
  static char *ColumnFmtStr[2][2] =
  {
    { "NR,SC,C0,C1,C2", "NR,SC,C0" },
    { "NO,SC,C0,C1,C2", "NO,SC,C0" }
  };
  ColumnTitles[0]=GetMsg(MColumnAddress);
  ColumnTitles[1]=GetMsg(MColumnSize);
  ColumnTitles[2]=GetMsg(MColumnBRK);
  ColumnTitles[3]=GetMsg(MColumnMailFlavor);
  ColumnTitles[4]=GetMsg(MColumnFileFlavor);
  ColumnTitles[5]=GetMsg(MColumnDate);
  ColumnTitles[6]=GetMsg(MColumnTime);

  PanelModesArray[3].ColumnTypes=ColumnFmtStr[isFilePanel][0];
  PanelModesArray[3].ColumnWidths="0,8,3,5,5";
  PanelModesArray[3].ColumnTitles=ColumnTitles;
  PanelModesArray[3].CaseConversion=true;
  PanelModesArray[3].FullScreen=false;
  PanelModesArray[4].ColumnTypes=ColumnFmtStr[isFilePanel][1];
  PanelModesArray[4].ColumnWidths="0,8,3";
  PanelModesArray[4].ColumnTitles=ColumnTitles;
  PanelModesArray[4].CaseConversion=true;
  PanelModesArray[4].FullScreen=false;
  PanelModesArray[5].ColumnTypes="NR,SC,C0,C1,C2,D,T";
  PanelModesArray[5].ColumnWidths="0,8,3,5,5,0,0";
  PanelModesArray[5].ColumnTitles=ColumnTitles;
  PanelModesArray[5].CaseConversion=true;
  PanelModesArray[5].FullScreen=true;

  Info->PanelModesArray=PanelModesArray;
  Info->PanelModesNumber=sizeof(PanelModesArray)/sizeof(PanelModesArray[0]);
  if ( !Opt.NoChangePanelMode )
    Info->StartPanelMode='0'+(isFilePanel ? Opt.FilesPanelMode : Opt.LinksPanelMode);
  static struct KeyBarTitles KeyBar[2]=
  {
    {
      { NULL, NULL, "",   "",   "",   "",   NULL, "",   NULL, NULL, NULL, NULL },
      { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL },
      { NULL, NULL, "",   "",   "",   "",   NULL, NULL, NULL, NULL, NULL, NULL },
      { "",   "",   "",   NULL, "",   "",   "",   "",   NULL, NULL, NULL, NULL }
    },
    {
      { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL },
      { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL },
      { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL },
      { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL }
    }
  };
  KeyBar[0].Titles[7-1]=GetMsg(MF7Dir);
  KeyBar[0].Titles[4-1]=GetMsg(MF4);
  KeyBar[0].ShiftTitles[4-1]=GetMsg(MShiftF4);
  KeyBar[1].Titles[6-1]=GetMsg(MF6);
  KeyBar[1].ShiftTitles[6-1]=GetMsg(MShiftF6);
  KeyBar[1].Titles[7-1]=GetMsg(MF7File);
  KeyBar[1].ShiftTitles[3-1]=GetMsg(MShiftF3);
  KeyBar[1].ShiftTitles[4-1]=GetMsg(MShiftF4);
  Info->KeyBar=&KeyBar[isFilePanel];
}

int WINAPI _export SetDirectory(HANDLE hPlugin, const char *Dir,int OpMode)
{
  int res = !strcmp(Dir, rootDir);
  if ( !res )
  {
    if ( !*Dir || !strcmp(Dir,"\\") || ( !strcmp(Dir,"..") && isDigit(*rootDir) ) )
    {
      res = true;
      setHomeDir();
    }
    else
    {
      TFTNAddress homeAddr(Opt.Address);
      TFTNAddress destAddr(Dir,&homeAddr);
      if ( destAddr.valid )
      {
        destAddr.print(rootDir,0);
        res = true;
      }
    }
  }
  if ( res && !((OpMode & OPM_FIND) || Opt.NoChangePanelMode) )
    Info.Control(hPlugin, FCTL_SETVIEWMODE, isDigit(*rootDir) ? &Opt.FilesPanelMode : &Opt.LinksPanelMode);
  return res;
}

int WINAPI _export ProcessKey(HANDLE hPlugin,int Key,unsigned int ControlState)
{
  int processed = true;
  if ( isDigit(*rootDir) )
  {
    switch ( ControlState )
    {
      case 0:
        switch ( Key )
        {
          case VK_F7: removeFiles();         break;
          case VK_F6: changeFlavor(true);    break;
          default:    processed = false;     break;
        }
        break;
      case PKF_SHIFT:
        switch ( Key )
        {
          case VK_F3: editLoFile();          break;
          case VK_F4: BrowserMakeFREQ();     break;
          case VK_F6: changeFlavor(false);   break;
          default:    processed = false;     break;
        }
        break;
      default:        processed = false;     break;
    }
  }
  else
  {
    switch ( ControlState )
    {
      case 0:
        switch ( Key )
        {
          case VK_F4: BrowserMakeFREQ();     break;
          case VK_F7: BrowserMakePoll();     break;
          default:    processed = false;     break;
        }
        break;
      case PKF_SHIFT:
        switch ( Key )
        {
          case VK_F4: BrowserMakeFREQ();     break;
          default:    processed = false;     break;
        }
        break;
      default:        processed = false;     break;
    }
  }
  if ( processed )
  {
    Info.Control(hPlugin,FCTL_UPDATEPANEL,NULL);
    Info.Control(hPlugin,FCTL_REDRAWPANEL,NULL);
    return true;
  }
  return false;
}

int WINAPI _export Configure(int ItemNumber)
{
  if ( ItemNumber )
    return false;
  return Config();
}

int WINAPI _export Compare(HANDLE /*hPlugin*/,const struct PluginPanelItem *el1,const struct PluginPanelItem *el2,unsigned int Mode)
{
  int ret = -2;
  if ( !isDigit(*rootDir) )
  {
    char s1[32], s2[32];
    TFTNAddress home(Opt.Address);
    TFTNAddress a1(el1->FindData.cFileName, &home);
    TFTNAddress a2(el2->FindData.cFileName, &home);
    switch ( Mode )
    {
      case SM_NAME:
      case SM_DESCR:
      case SM_OWNER:
        FSF.sprintf(s1, "%07u%07u%07u%07u", a1.zone, a1.net, a1.node, a1.point);
        FSF.sprintf(s2, "%07u%07u%07u%07u", a2.zone, a2.net, a2.node, a2.point);
        ret = strcmp(s1, s2);
        ret = ret ? (ret > 0 ? 1 : -1) : 0;
        break;
      case SM_EXT:
        FSF.sprintf(s1, "%c%07u%07u%07u%07u", a1.point ? '1' : '0', a1.zone, a1.net, a1.node, a1.point);
        FSF.sprintf(s2, "%c%07u%07u%07u%07u", a2.point ? '1' : '0', a2.zone, a2.net, a2.node, a2.point);
        ret = strcmp(s1, s2);
        ret = ret ? (ret > 0 ? 1 : -1) : 0;
        break;
    }
  }
  return ret;
}

int WINAPI _export PutFiles(HANDLE hPlugin,struct PluginPanelItem *PanelItem,int ItemsNumber,int Move,int OpMode)
{
  PanelInfo panelInfo;
  char curDir[NM];
  Info.Control(hPlugin,FCTL_GETANOTHERPANELINFO,&panelInfo);
  return AttachFiles(rootDir, strcpy(curDir,panelInfo.CurDir), PanelItem, ItemsNumber, Move, OpMode);
}

int WINAPI _export ProcessEvent(HANDLE hPlugin,int Event,void */*Param*/)
{
  static int tryCount = 0;
  switch ( Event )
  {
    case FE_IDLE:
      if ( Opt.AutoRefresh )
      {
        if ( ++tryCount >= Opt.AutoRefresh )
        {
          tryCount = 0;
          if ( WaitForSingleObject(checkHandle,WAIT_CHECK_TIMEOUT) == WAIT_OBJECT_0 )
            if ( FindNextChangeNotification(checkHandle) )
            {
              Info.Control(hPlugin,FCTL_UPDATEPANEL,&Opt);
              Info.Control(hPlugin,FCTL_REDRAWPANEL,NULL);
            }
        }
      }
      break;
  }
  return false;
}
