(********************************************************
* FMT.PAS
* Archive Support API for FAR Manager 1.70 and MultiArc plugin
*
* Copyright (c) 1996-2000 Eugene Roshal
* Copyrigth (c) 2000 [ FAR group ]
* Translated by Vasily V. Moshninov
*********************************************************)

{$IFDEF VPASCAL}
  {&H-,Use32+,Z+,AlignRec+}
{$ELSE}
  {$ALIGN OFF}
  {$MINENUMSIZE 4}
{$ENDIF}

unit fmt;

interface
uses windows;

const
  GETARC_EOF       = 0;
  GETARC_SUCCESS   = 1;
  GETARC_BROKEN    = 2;
  GETARC_UNEXPEOF  = 3;
  GETARC_READERROR = 4;

type

  TArcItemInfo = packed record
    HostOS: packed array[0..31] of char;
    Description: packed array[0..255] of char;
    Solid: integer;
    Comment: integer;
    Encrypted: integer;
    DictSize: integer;
    UnpVer: integer;
  end; { TArcItemInfo record }
  PArcItemInfo = ^TArcItemInfo;


const
// ARCINFO_FLAGS
  AF_AVPRESENT    = 1;
  AF_IGNOREERRORS = 2;

type

  TArcInfo = packed record
    SFXSize: integer;
    Volume: integer;
    Comment: integer;
    Recovery: integer;
    Lock: integer;
    Flags: DWORD;
  end; { TArcInfo record }
  PArcInfo = ^TArcInfo;

implementation

end.
