library DBXFmt;
  {&H-,Use32+,StdCall+,D-,LocInfo-}
uses
    Plugin,
    FMT,
    MyUtils,
    MemUtils,
    EmlUtils,
    DateUtils,
{$IFDEF VPASCAL}
    Strings,
{$ELSE}
    DStrings,
//    SysUtils,
{$ENDIF}
    Windows;

type
    TMsgBaseHeader = record
      Sig: LongInt;
      MsgOffset: LongInt;
    end;

    TMsgHeader = record
      Sig: LongInt;
      Unk1: Longint;
      Unk2: Longint;
      Unk3: Longint;
      Unk4: Longint;
      Flags: Longint;
      Unk5: Longint;
      ColorGrp: Longint;
      Priority: Longint;
      MsgSize: Longint;
      Unk7: Longint;
      Unk8: Longint;
    end;

var
   hTBB: THandle;
   MsgCurrent, MsgBeginOffset, NextMsgOffset: LongInt;
   ModuleName, IniName: array[1..MAX_PATH] of Char;

{.$DEFINE DEBUG}

{$IFNDEF DEBUG}

{$IFDEF VPASCAL}
  {$L DllInit.obj}
{$ENDIF}

{$ENDIF}

function LoadFormatModule(NewModuleName: PChar): LongInt; StdCall;
begin
     GetShortPathName(NewModuleName, @ModuleName, sizeof(ModuleName));

     lstrcat(lstrcpyn(@IniName, @ModuleName, lstrlen(@ModuleName)-2), 'INI');

     Result:=0;
end;

function IsArchive(const Name: PChar; const Data: Pointer; DataSize: DWORD): LongInt; StdCall;
begin
     Result:=LongInt(TMsgBaseHeader(Data^).Sig=$19790620);
end;

function OpenArchive(const Name: PChar; var aType: DWORD): LongInt; StdCall;
var
   MsgBaseHeader: TMsgBaseHeader;
   ReadSize: DWORD;
begin
     Result:=LongInt(False);
     hTBB:=CreateFile(Name, GENERIC_READ, FILE_SHARE_READ or FILE_SHARE_WRITE,
                          nil, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, 0);
     if (hTBB<>INVALID_HANDLE_VALUE) then
        if ReadFile(hTBB, MsgBaseHeader, SizeOf(MsgBaseHeader), ReadSize, nil) and
        (ReadSize=SizeOf(MsgBaseHeader)) then
          begin
               MsgBeginOffset:=MsgBaseHeader.MsgOffset;
               NextMsgOffset:=MsgBeginOffset;
          	   MsgCurrent:=0;
               Result:=LongInt(True);
          end
       else
         CloseHandle(hTBB);
end;
type
    TEMLHeaders = array[0..3] of PChar;

function GetArcItem(var Item: TPluginPanelItem; var Info: TArcItemInfo): Integer; StdCall;
const
     ctNoSubject = '(NoSubject)';
     ctNoName = '(NoName)';
     EMLNameHeaders: TEMLHeaders = ('Date:', 'From:', 'Subject:', 'Content-Type:');
var
   ReadSize: DWORD;
   MsgHeader: TMsgHeader;
   pSubject, pFromName: PChar;
   pTmp, pMsgBuf: PChar;
   pFT: PFileTime;
   EMLValueHeaders: TEMLHeaders;
   DefCharsetBuf, CharsetBuf: array[0..19] of Char;
{$IFDEF DEBUG}
        F: Text;
{$ENDIF}

begin
  if SetFilePointer(hTBB, NextMsgOffset, nil, FILE_BEGIN)<>$FFFFFFFF then
    begin
      if ReadFile(hTBB, MsgHeader, SizeOf(MsgHeader),
                  ReadSize, nil) then
        if ReadSize=0 then
          Result:=GETARC_EOF
        else
        begin
          pMsgBuf:=MemAlloc(MsgHeader.MsgSize+1);

          if ReadFile(hTBB, pMsgBuf^, MsgHeader.MsgSize,
             ReadSize, nil) and (ReadSize=MsgHeader.MsgSize) then
            begin
              FindHeaders(pMsgBuf, EMLNameHeaders, EMLValueHeaders);
              pTmp:=GetPropertyByName(EMLValueHeaders[3], 'charset');
              lstrcpy(@DefCharsetBuf, pTmp);
              MemFree(pTmp);
{$IFDEF DEBUG}
              AssignFile(F, 'C:\CharsetLog.txt');
              Append(F);
              Writeln(F, PChar(@DefCharsetBuf));
              CloseFile(F);
{$ENDIF}
              pSubject:=DecodeMIME(EMLValueHeaders[2], CharsetBuf);


              KonvertCharset(pSubject, @CharsetBuf, @DefCharsetBuf, @IniName);
              ClSubject(pSubject);

              pTmp:=StrCopySpec(Item.FindData.cFileName, pSubject, 150);
              MemFree(pSubject);

              pTmp^:='\';
              Inc(pTmp);

              pFromName:=DecodeMIME(EMLValueHeaders[1], CharsetBuf);

              KonvertCharset(pFromName, @CharsetBuf, @DefCharsetBuf, @IniName);

              pTmp:=StrCopySpec(pTmp, pFromName, 100);
              MemFree(pFromName);

              pTmp^:='.';
              Inc(pTmp);
//              pTmp:=StrCopySpec(pTmp, '                        ', 24);

              LongIntToHex(NextMsgOffset, pTmp);
              Inc(pTmp, 8);
              lstrcpy(pTmp, '.msg');

              NextMsgOffset:=NextMsgOffset+SizeOf(MsgHeader)+
                             MsgHeader.MsgSize;

              GetDate(EMLValueHeaders[0], Item.FindData.ftLastWriteTime);
              Item.FindData.nFileSizeHigh:=0;
              Item.FindData.nFileSizeLow:=MsgHeader.MsgSize;
              if (MsgHeader.Flags and 1)<>0 then
                Item.FindData.dwFileAttributes:=FILE_ATTRIBUTE_HIDDEN;

              Inc(MsgCurrent);
              Result:=GETARC_SUCCESS;
            end
          else
            Result:=GETARC_READERROR;
          MemFree(pMsgBuf);
        end
      else
        Result:=GETARC_READERROR;
    end
  else
    Result:=GETARC_EOF;
end;

function CloseArchive(var Info: TArcInfo): LongInt; StdCall;
begin
     Result:=LongInt(CloseHandle(hTBB));
end;

function GetFormatName(aType: DWORD; FormatName, DefaultExt: PChar): LongInt; StdCall;
begin
     if aType=0 then
       begin
            FormatName:=lstrcpy(FormatName, 'The Bat! Message Base');
            DefaultExt:=lstrcpy(DefaultExt, 'TBB');
            Result:=LongInt(True);
       end
     else
       Result:=LongInt(False);
end;

function GetDefaultCommands(aType: DWORD; Command: DWORD; Dest: PChar): LongInt; StdCall;
begin
     Result:=LongInt(False);
     if aType=0 then
       begin
         if Command=1 then
           begin
                Dest:=lstrcat(lstrcat(lstrcat(Dest, 'RunDll32 '), @ModuleName), ',Extract %%a %%fW');
           end;
         Result:=LongInt(True);
       end;
end;

function Extract(ahWnd: HWND; hInstance: HINST; CmdLine: PChar; dummy: LongInt): LongInt; StdCall;
var
   TBBName: array[1..MAX_PATH] of Char;
   MsgOffset, ReadSize: DWORD;
   MsgHeader: TMsgHeader;
   pMsgName, pMsgBuf: PChar;
   hMSG: THandle;
begin
     lstrcpyn(@TBBName, CmdLine, StrScan(CmdLine, ' ')-CmdLine+1);
//     StrLCopy(@TBBName, CmdLine, StrScan(CmdLine, ' ')-CmdLine);
     pMsgName:=CmdLine+lstrlen(CmdLine)-12;
     MsgOffset:=HexToLongInt(pMsgName);
     hTBB:=CreateFile(@TBBName, GENERIC_READ, FILE_SHARE_READ,
                      nil, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, 0);
     if (hTBB<>INVALID_HANDLE_VALUE) then
     begin
         SetFilePointer(hTBB, MsgOffset, nil, FILE_BEGIN);
         if ReadFile(hTBB, MsgHeader, SizeOf(MsgHeader),
                     ReadSize, nil) and (ReadSize=SizeOf(MsgHeader)) then
         begin
              pMsgBuf:=MemAlloc(MsgHeader.MsgSize+1);

              if ReadFile(hTBB, pMsgBuf^, MsgHeader.MsgSize,
                 ReadSize, nil) and (ReadSize=MsgHeader.MsgSize) then
              begin
                   hMSG:=CreateFile(pMsgName, GENERIC_WRITE, FILE_SHARE_READ,
                             nil, CREATE_ALWAYS, FILE_FLAG_SEQUENTIAL_SCAN, 0);
                   if (hTBB<>INVALID_HANDLE_VALUE) then
                   begin
                        WriteFile(hMSG, pMsgBuf^, MsgHeader.MsgSize,
                                  ReadSize, nil);
                        CloseHandle(hMSG);
                   end;
              end;
              MemFree(pMsgBuf);
         end;
         CloseHandle(hTBB);
     end
end;

exports
  LoadFormatModule,
  IsArchive,
  OpenArchive,
  GetArcItem,
  CloseArchive,
  GetFormatName,
  GetDefaultCommands,
  Extract;

Begin
End.
