unit MyUtils;

{.$DEFINE DEBUG}
{$IFDEF VPASCAL}
  {&H-,Use32+}
{$ELSE}
  {$ALIGN OFF}
  {$MINENUMSIZE 4}
{$ENDIF}

interface

  function IgnoreSpace(Buf: PChar): PChar;
  function HexToLongInt(Hex: PChar): LongInt;
  function LongIntToHex(L: LongInt; Hex: PChar): PChar;
  function StrCopySpec(Dest, Source: PChar; Count: LongInt): PChar;
//  function KOIToDOS(St: PChar): PChar;
  function KonvertCharset(aBuf, aCharset, aDefCharset, aIniName: PChar): PChar;

implementation
uses
    Windows,
{$IFDEF VPASCAL}
    Strings;
{$ELSE}
    DStrings;
//    SysUtils;
{$ENDIF}

const
  KOI_2_DOS: Array[$80..$FF] of Byte = (
   $C4,$C3,$Da,$BF,$C0,$D9,$C3,$B4,$C2,$C1,$C5,$DF,$DC,$DB,$DD,$DE,
   $B0,$B1,$b2,$f4,$fe,$f9,$fb,$f7,$f3,$f2,$ff,$f5,$f8,$fd,$fa,$f6,
   $cd,$ba,$d5,$f1,$d6,$c9,$b8,$b7,$bb,$d4,$d3,$c8,$be,$bd,$bc,$c6,
   $c7,$cc,$b5,$f0,$b6,$b9,$d1,$d2,$cb,$cf,$d0,$ca,$d8,$d7,$ce,$fc,
   $ee,$a0,$a1,$e6,$a4,$a5,$e4,$a3,$e5,$a8,$a9,$aa,$ab,$ac,$ad,$ae,
   $af,$ef,$e0,$e1,$e2,$e3,$a6,$a2,$ec,$eb,$a7,$e8,$ed,$e9,$e7,$ea,
   $9e,$80,$81,$96,$84,$85,$94,$83,$95,$88,$89,$8a,$8b,$8c,$8d,$8e,
   $8f,$9f,$90,$91,$92,$93,$86,$82,$9c,$9b,$87,$98,$9d,$99,$97,$9a);

  Win_2_DOS: Array[$80..$FF] of Byte = (
   $3f,$3f,$27,$3f,$22,$3a,$c5,$d8,$3f,$25,$3f,$3c,$3f,$3f,$3f,$3f,
   $3f,$27,$27,$22,$22,$07,$2d,$2d,$3f,$54,$3f,$3e,$3f,$3f,$3f,$3f,
   $ff,$f6,$f7,$3f,$fd,$3f,$b3,$15,$f0,$63,$f2,$3c,$bf,$2d,$52,$f4,
   $f8,$2b,$49,$69,$3f,$e7,$14,$fa,$f1,$fc,$f3,$3e,$3f,$3f,$3f,$f5,
   $80,$81,$82,$83,$84,$85,$86,$87,$88,$89,$8a,$8b,$8c,$8d,$8e,$8f,
   $90,$91,$92,$93,$94,$95,$96,$97,$98,$99,$9a,$9b,$9c,$9d,$9e,$9f,
   $a0,$a1,$a2,$a3,$a4,$a5,$a6,$a7,$a8,$a9,$aa,$ab,$ac,$ad,$ae,$af,
   $e0,$e1,$e2,$e3,$e4,$e5,$e6,$e7,$e8,$e9,$ea,$eb,$ec,$ed,$ee,$ef);
{
function HexToLongInt(Hex: PChar): LongInt;
var
   I: Byte;
begin
     Result:=0;
     for I:=0 to 7 do
     begin
          Result:=Result shl 4;
          case UpCase(Hex[I]) of
            '0'..'9': Result:=Result or (Ord(UpCase(Hex[I]))-Ord('0'));
            'A'..'F': Result:=Result or (Ord(UpCase(Hex[I]))-Ord('A')+10);
          end;
     end;
end;
}

function IgnoreSpace(Buf: PChar): PChar;
begin
     while (Buf^ in [#$20, #$9]) and (Buf^<>#0) do Inc(Buf);
     Result:=Buf;
end;

function HexToLongInt(Hex: PChar): LongInt;
var
   I: Byte;
begin
     Result:=0;
     for I:=0 to 7 do
     begin
          Result:=Result shl 4;
          case Hex[I] of
            '0'..'9': Result:=Result or (Ord(Hex[I])-Ord('0'));
            'A'..'F': Result:=Result or (Ord(Hex[I])-Ord('A')+10);
          end;
     end;
end;

function LongIntToHex(L: LongInt; Hex: PChar): PChar;
const
     dig: array[0..17] of char = '0123456789ABCDEF';
var
   I: Byte;
begin
     for I:=7 downto 0 do
     begin
          Hex[I]:=Dig[L and $F];
          L:=L shr 4;
     end;
     Hex[8]:=#0;
     Result:=Hex;
end;

function StrCopySpec(Dest, Source: PChar; Count: LongInt): PChar;
var
   I: LongInt;
begin
     I:=0;
     if (Source<>nil) and (Dest<>nil) then
     begin
       Source:=IgnoreSpace(Source);
       while (not (Source[I] in [#$D, #$A, #0])) and (I<Count) do
       begin
            if Source[I] in ['\', '/'] then
              Dest[I]:='|'
            else
              Dest[I]:=Source[I];
            Inc(I);
       end;
       while (I>0) and (Source[I-1]=#$20) do Dec(I);
     end;
     Dest[I]:=#0;
     Result:=@Dest[I];
end;

function KOIToDOS(St: PChar): PChar;
var
  i: Integer;
begin
  i := lstrlen(St);
  if i <> 0 then
   for i := 0 to i-1 do
    if byte(St[i]) > $7F then
     St[i] := char(KOI_2_DOS[byte(St[i])]);
  Result := St;
end;

function WinToDOS(St: PChar): PChar;
var
  i: Integer;
begin
  i := lstrlen(St);
  if i <> 0 then
   for i := 0 to i-1 do
    if byte(St[i]) > $7F then
     St[i] := char(Win_2_DOS[byte(St[i])]);
  Result := St;
end;

function KonvertCharset(aBuf, aCharset, aDefCharset, aIniName: PChar): PChar;
const
     ctCharset = 'Charset';
var
   CharsetCode: array[0..1] of Char;
{$IFDEF DEBUG}
        F: Text;
{$ENDIF}
begin
     if aBuf<>nil then
     begin
       GetPrivateProfileString(ctCharset, aCharset, '0',
                               @CharsetCode, SizeOf(CharsetCode),
                               aIniName);
{$IFDEF DEBUG}
              AssignFile(F, 'C:\CharsetLog.txt');
              Append(F);
              Writeln(F, aIniName);
              Writeln(F, aCharSet);
              Writeln(F, PChar(@CharSetCode));
              CloseFile(F);
{$ENDIF}
       if CharsetCode[0]='0' then
         GetPrivateProfileString(ctCharset, aDefCharset, '0',
                                 @CharsetCode, SizeOf(CharsetCode),
                                 aIniName);
       if CharsetCode[0]='0' then
         GetPrivateProfileString(ctCharset, 'Default', '0',
                                 @CharsetCode, SizeOf(CharsetCode),
                                 aIniName);
{$IFDEF DEBUG}
              AssignFile(F, 'C:\CharsetLog.txt');
              Append(F);
              Writeln(F, PChar(@CharSetCode));
              CloseFile(F);
{$ENDIF}
       case CharsetCode[0] of
         '1': Result:=KOIToDOS(aBuf);
         '2': Result:=WinToDOS(aBuf);
       else
         Result:=aBuf;
       end;
     end;
end;

end.
