unit EMLUtils;
{.$DEFINE DEBUG}
interface
uses
    Windows;

  function FindHeaders(pMessage: PChar;
                       const aEMLNameHeaders: array of PChar;
                       var aEMLPointerHeaders: array of PChar): PChar;
  function DecodeMIME(aBuf: PChar; var aCharSet: array of Char): PChar;
  function GetPropertyByName(aHeader, aValueName: PChar): PChar;
  function ClSubject(Subj: pChar): pChar;

implementation
uses
    MemUtils,
    MyUtils,
{$IFDEF VPASCAL}
    Strings;
{$ELSE}
    DStrings;
//    SysUtils;
{$ENDIF}

function DecodeBase64(aInBuf, aOutBut: PChar;
                      var aNumReadBytes, aNumWriteBytes: LongInt): Boolean;

  function CharToNumber(Ch: Char): Byte;
  begin
       case Ch of
         'A'..'Z': Result:=Ord(Ch)-Ord('A');
         'a'..'z': Result:=Ord(Ch)-Ord('a')+26;
         '0'..'9': Result:=Ord(Ch)-Ord('0')+52;
         '+': Result:=62;
         '/': Result:=63;
         '=': Result:=64;
       else
         Result:=65;
       end;
  end;

type
    TW = array[0..3] of Char;
var
   I, J, K, N: LongInt;
   B: Byte;
   W: LongInt;
begin
     I:=0;
     J:=0;
     Result:=True;
     while ((Result) and (CharToNumber(aInBuf[I])<64)) or
           (aInBuf[I] in [#$D, #$A]) do
     begin
          N:=0;
          W:=0;
          if aInBuf[I] in [#$D, #$A] then
            Inc(I)
          else
            begin
              for K:=3 downto 0 do
              begin
                   B:=CharToNumber(aInBuf[I]);
                   case B of
                     65: begin
                              W:=W shl (6*(4-N));
                              Break;
                         end;
                     64: W:=W shl 6;
                   else
                     begin
                          W:=(W shl 6) or B;
                          Inc(N);
                     end;
                   end;
                   Inc(I);
              end;
              aOutBut[J]:=TW(W)[2];
              aOutBut[J+1]:=TW(W)[1];
              aOutBut[J+2]:=TW(W)[0];
              case N of
                1: Result:=False;
                2: Inc(J);
                3: Inc(J, 2);
                4: Inc(J, 3);
              end;
            end;
     end;
     aNumReadBytes:=I;
     aNumWriteBytes:=J;
end;

function DecodeQP(aInBuf, aOutBut: PChar;
                      var aNumReadBytes, aNumWriteBytes: LongInt): Boolean;
var
   I, J, K: LongInt;
   B, C: Byte;
begin
     I:=0;
     J:=0;
     Result:=True;
     while (aInBuf[I]<>'?') and (aInBuf[I]<>#0) and Result do
     begin
       case aInBuf[I] of
         '_': begin
                   aOutBut[J]:=' ';
                   Inc(I);
                   Inc(J);
              end;
         '=': begin
                   Inc(I);
                   C:=0;
                   for K:=1 downto 0 do
                   begin
                        B:=Ord(aInBuf[I])-Ord('0');
                        if B>9 then B:=B-7;
                        C:=(C shl 4) or B;
                        Inc(I);
                   end;
                   aOutBut[J]:=Chr(C);
                   Inc(J);
              end;
       else
           aOutBut[J]:=aInBuf[I];
           Inc(I);
           Inc(J);
       end;
{
         ' ', #9, '!'..'<', '>', '@'..'^', '`'..'~':
              begin
                   aOutBut[J]:=aInBuf[I];
                   Inc(I);
                   Inc(J);
              end;
       else
         Result:=False;
       end;
}
     end;
     aNumReadBytes:=I;
     aNumWriteBytes:=J;
end;

function FindHeaders(pMessage: PChar;
                     const aEMLNameHeaders: array of PChar;
                     var aEMLPointerHeaders: array of PChar): PChar;
var
   I: LongInt;
   flEOLN, flEOH: Boolean;
  procedure Compare;
  var
     J: LongInt;
  begin
               J:=0;
               while (J<=High(aEMLNameHeaders)) and
                     (StrLIComp(pMessage+I, aEMLNameHeaders[J],
                      lstrlen(aEMLNameHeaders[J]))<>0) do
                                                        Inc(J);
               if J<=High(aEMLNameHeaders) then
                          aEMLPointerHeaders[J]:=pMessage+I+lstrlen(aEMLNameHeaders[J])+1;
  end;

begin
     for I:=0 to High(aEMLPointerHeaders) do aEMLPointerHeaders[I]:=nil;
     flEOLN:=True;
     flEOH:=False;
     I:=0;
     Compare;
     while (not flEOH) and (pMessage[I]<>#0) do
     begin
          case pMessage[I] of
            #$D: begin
                      flEOH:=flEOLN;
                      flEOLN:=True;
                      Inc(I);
                      if pMessage[I]=#$A then Inc(I);
                      if not flEOH then Compare;
                 end;
            #$A: begin
                      flEOH:=flEOLN;
                      flEOLN:=True;
                      Inc(I);
                      if pMessage[I]=#$D then Inc(I);
                      if not flEOH then Compare;
                 end;
          else
            begin
                 flEOLN:=False;
                 Inc(I);
            end;
          end;
     end;
     Result:=pMessage+I;
end;

function GetHeaderMaxLength(aHeader: PChar): LongInt;
var
   I: LongInt;
   flEND: Boolean;
begin
     Result:=0;
     if (aHeader<>nil) then
     begin
       I:=0;
       flEND:=False;
       while (not flEND) and (aHeader[I]<>#0) do
       begin
            case aHeader[I] of
              #$D: begin
                        Inc(I);
                        if aHeader[I]=#$A then Inc(I);
                        if not (aHeader[I] in [#$20, #$9]) then flEND:=True;
                   end;
              #$A: begin
                        Inc(I);
                        if aHeader[I]=#$D then Inc(I);
                        if not (aHeader[I] in [#$20, #$9]) then flEND:=True;
                   end;
            else
              begin
                   Inc(I);
                   Inc(Result)
              end;
            end;
       end;
     end;
end;

function GetPropertyByName(aHeader, aValueName: PChar): PChar;
var
   I, N: LongInt;
   flEND: Boolean;
  function Get(aBuf: PChar): PChar;
  var
    I: LongInt;
  begin
    I:=0;
    if aBuf^='"' then Inc(aBuf);
    while not (aBuf[I] in ['"', ';', #$D, #$A, #0, #$20, #9]) do Inc(I);
    Result:=lstrcpyn(MemAlloc(I+1), aBuf, I+1);
  end;
begin
     Result:=nil;
     if (aHeader<>nil) then
     begin
       N:=lstrlen(aValueName);
       I:=0;
       if N=0{aValueName=nil} then
         Result:=Get(aHeader)
       else
         begin
           flEND:=False;
           while (not flEND) and (aHeader^<>#0) do
           begin
                case aHeader^ of
                  #$D, #$A: begin
                            if (PWORD(aHeader)^=$0A0D) or
                               (PWORD(aHeader)^=$0D0A) then
                              Inc(aHeader, 2)
                            else
                              Inc(aHeader);
                            if aHeader^ in [#$20, #$9] then
                              begin
                                aHeader:=IgnoreSpace(aHeader);
                                if StrLIComp(aHeader, aValueName, N)=0 then
                                begin
                                  Inc(aHeader, N+1);
                                  Result:=Get(aHeader);
                                  flEND:=True;
                                end;
                              end
                            else
                              flEND:=True;
                       end;
{
                  #$D: begin
                            Inc(aHeader);
                            if aHeader^=#$A then Inc(aHeader);
                            if aHeader^ in [#$20, #$9] then
                              begin
                                aHeader:=IgnoreSpace(aHeader);
                                if StrLIComp(aHeader, aValueName, N)=0 then
                                begin
                                  Inc(aHeader, N+1);
                                  Result:=Get(aHeader);
                                  flEND:=True;
                                end;
                              end
                            else
                              flEND:=True;
                       end;
                  #$A: begin
                            Inc(aHeader);
                            if aHeader^=#$D then Inc(aHeader);
                            if aHeader^ in [#$20, #$9] then
                              begin
                                aHeader:=IgnoreSpace(aHeader);
                                if StrLIComp(aHeader, aValueName, N)=0 then
                                begin
                                  Inc(aHeader, N+1);
                                  Result:=Get(aHeader);
                                  flEND:=True;
                                end;
                              end
                            else
                              flEND:=True;
                       end;
}
                  ';': begin
                         Inc(aHeader);
                         aHeader:=IgnoreSpace(aHeader);
                         if StrLIComp(aHeader, aValueName, N)=0 then
                         begin
                           Inc(aHeader, N+1);
                           Result:=Get(aHeader);
                           flEND:=True;
                         end;
                       end
                else
                  Inc(aHeader);
                end;
           end;
         end;
       end;
end;

function DecodeMIME(aBuf: PChar; var aCharSet: array of Char): PChar;
var
   I, J, Old_I, Old_J, K, NumReadBytes, NumWriteBytes: LongInt;
   pTempBuf: PChar;
   flEND: Boolean;

  procedure Undo;
  begin
       I:=Old_I;
       J:=Old_J;
       pTempBuf[J]:=aBuf[I];
       Inc(I);
       Inc(J);
  end;

begin
  aCharSet[0]:=#0;
  if aBuf=nil then
    Result:=nil
  else
    begin
      pTempBuf:=MemAlloc(GetHeaderMaxLength(aBuf)+1);
      I:=0;
      J:=0;
      flEnd:=False;
      while (not flEnd) and (aBuf[I]<>#0) do
      begin
        case aBuf[I] of
          '=': if aBuf[I+1]='?' then
                 begin
                   Old_I:=I;
                   Old_J:=J;
                   Inc(I, 2);
                   K:=0;
                   while (K<High(aCharSet)) and (aBuf[I]<>'?') do
                   begin
                        aCharSet[K]:=aBuf[I];
                        Inc(I);
                        Inc(K);
                   end;
                   if (aBuf[I]='?') and (aBuf[I+2]='?') then
                     begin
                       aCharSet[K]:=#0;
                       Inc(I, 3);
                       case aBuf[I-2] of
                         'B', 'b': if DecodeBase64(@aBuf[I],
                                                   @pTempBuf[J],
                                                   NumReadBytes,
                                                   NumWriteBytes) then
                                     begin
                                          Inc(I, NumReadBytes+2);
                                          Inc(J, NumWriteBytes);
                                     end
                                   else
                                     Undo;
                         'Q', 'q': if DecodeQP(@aBuf[I],
                                               @pTempBuf[J],
                                               NumReadBytes,
                                               NumWriteBytes) then
                                     begin
                                          Inc(I, NumReadBytes+2);
                                          Inc(J, NumWriteBytes);
                                     end
                                   else
                                     Undo;
                       else
                         Undo;
                       end;
                     end
                   else
                     begin
                       Undo;
                       aCharSet[0]:=#0;
                     end;
                 end
               else
                 begin
                      pTempBuf[J]:=aBuf[I];
                      Inc(I);
                      Inc(J);
                 end;
          '"':   Inc(I);
          '\':   begin
                      Inc(I);
                      pTempBuf[J]:=aBuf[I];
                      Inc(I);
                      Inc(J);
                 end;
          #$D:   begin
                      Inc(I);
                      if aBuf[I]=#$A then Inc(I);
                      if aBuf[I] in [#$20, #$9] then
//                        I:=I+LongInt(IgnoreSpace(@aBuf[I])-@aBuf[I])
                        Inc(I)
                      else
                        flEND:=True;
                 end;
          #$A:   begin
                      Inc(I);
                      if aBuf[I]=#$D then Inc(I);
                      if aBuf[I] in [#$20, #$9] then
//                        I:=I+LongInt(IgnoreSpace(@aBuf[I])-@aBuf[I])
                        Inc(I)
                      else
                        flEND:=True;
                 end;
        else
          begin
               pTempBuf[J]:=aBuf[I];
               Inc(I);
               Inc(J);
          end;
        end;
      end;
      pTempBuf[J]:=#0;
      Result:=pTempBuf;
    end;
end;

function ClSubject(Subj: pChar): pChar;
var
   I: LongInt;
   FlDel: Boolean;

   function _Re_Del(pRe: pChar): Boolean;
   var
      pEndRe: pChar;
   begin
        pEndRe:=StrPos(pRe, ':');
        if pEndRe<>nil then
          begin
               Inc(pEndRe);
               pEndRe:=IgnoreSpace(pEndRe);
//               while (pEndRe^<>#0) and (pEndRe^=#$20) do Inc(pEndRe);
               lstrcpy(pRe, pEndRe);
               Result:=True;
          end
        else
          Result:=False;
   end;

begin
     if Subj<>nil then
     begin
       I:=0;
       while not (Subj[I]=#0) do
       begin
         FlDel:=False;
         case Subj[I] of
           'R', 'r': if Subj[I+1] in ['e', 'E'] then
                  if Subj[I+2] in [':', '[', '^', '1'..'9'] then
                     FlDel:=_Re_Del(Subj+I);
{
                  Case Subj[I+2] of
                    ':': FlDel:=_Re_Del(Subj+I);
                    '[': FlDel:=_Re_Del(Subj+I);
                    '^': FlDel:=_Re_Del(Subj+I);
                    '1'..'9': FlDel:=_Re_Del(Subj+I);
                  end;
}
           '': if StrLIComp(Subj+I+1, '⢥:', 5)=0 then FlDel:=_Re_Del(Subj+I);
           '': if (Subj[I+1] in ['', '']) and (Subj[I+2]=':') then FlDel:=_Re_Del(Subj+I);
           'H': if (Subj[I+1] in ['A', 'a', '']) and (Subj[I+2]=':') then FlDel:=_Re_Del(Subj+I);
//           'H': if StrLComp(Subj+I+1, 'A:', 2)=0 then FlDel:=_Re_Del(Subj+I);
         end;
         if not FlDel then Inc(I);
       end;
     end;
     Result:=Subj;
end;

end.
