unit DateUtils;

interface

uses
    Windows;

  procedure GetDate(aBuf: PChar; var aFT: TFileTime);

implementation

function StrToIntDef(S: PChar; Default: Integer): Integer;
var
  E: Integer;
begin
  Val(S, Result, E);
  if E <> 0 then
    Result := Default;
end;

function IsLeapYear(AYear: Integer): Boolean;
begin
  Result := (AYear mod 4 = 0) and ((AYear mod 100 <> 0) or (AYear mod 400 = 0));
end;

function DaysPerMonth(AYear, AMonth: Integer): Integer;
const
  DaysInMonth: array[1..12] of Integer =
    (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
begin
  Result := DaysInMonth[AMonth];
  if (AMonth = 2) and IsLeapYear(AYear) then Inc(Result); { leap-year Feb is special }
end;

procedure LocalTimeToGMTTime(var aYear, aMonth, aDay, aHour, aMinute, aGMT: Integer);
begin
     begin
          Dec(aMinute, aGMT mod 100);
          if aMinute<0 then
            begin
                 Inc(aMinute, 60);
                 Dec(aHour);
            end
          else
            if aMinute>59 then
            begin
                 Dec(aMinute, 60);
                 Inc(aHour);
            end;

          Dec(aHour, aGMT div 100);
          if Integer(aHour)<0 then
            begin
                 Inc(aHour, 24);
                 Dec(aDay);
            end
          else
            if aHour>23 then
            begin
                 Dec(aHour, 24);
                 Inc(aDay);
            end;
          if aDay<1 then
            begin
                 Dec(aMonth);
                 if aMonth<1 then
                 begin
                      Inc(aMonth, 12);
                      Dec(aYear);
                 end;
                 aDay:=aDay+DaysPerMonth(aYear, aMonth);
            end
          else
            if aDay>DaysPerMonth(aYear, aMonth) then
            begin
                 aDay:=aDay-DaysPerMonth(aYear, aMonth);
                 Inc(aMonth);
                 if aMonth>12 then
                 begin
                      Dec(aMonth, 11);
                      Inc(aYear);
                 end;
            end;
     end;
end;

procedure GetDate(aBuf: PChar; var aFT: TFileTime);

  function GetToken(aInBuf: PChar; var aOutBuf: array of Char): PChar;
  var
     I: LongInt;
  begin
       I:=0;
       while (aInBuf^ in [#$20, #9]) and (not (aInBuf^ in [#$D, #$A, #0])) do
         Inc(aInBuf);
       while (not (aInBuf^ in [#$20, #$9, ',', ':', #$D, #$A, #0])) and
             (I<High(aOutBuf)) do
       begin
            aOutBuf[I]:=aInBuf^;
            Inc(aInBuf);
            Inc(I)
       end;
       aOutBuf[I]:=#0;
       Result:=aInBuf;
  end;

  function GetMonthNumber(aMonth: PChar): Integer;
  const
       Months: array[1..12] of PChar = ('Jan', 'Feb', 'Mar',
                                        'Apr', 'May', 'Jun',
                                        'Jul', 'Aug', 'Sep',
                                        'Oct', 'Nov', 'Dec');
  var
     I: LongInt;
  begin
       I:=1;
       while (I<13) and (lstrcmp(aMonth, Months[I])<>0) do
         Inc(I);
       if I<13 then
         Result:=I
       else
         Result:=-1;
  end;

var
   TempBuf: array[1..20] of Char;
   Count: LongInt;
   Year, Month, Day, Hour, Minute, Second, GMT: Integer;
   ST: TSystemTime;
begin
     GetSystemTimeAsFileTime(aFT);
//     LocalFileTimeToFileTime(aFT, aFT);

     if aBuf<>nil then
     begin
       aBuf:=GetToken(aBuf, TempBuf);
       if (aBuf^=',') then
       begin
         Inc(aBuf);
         aBuf:=GetToken(aBuf, TempBuf);
       end;
       Day:=StrToIntDef(@TempBuf, -1);
       aBuf:=GetToken(aBuf, TempBuf);
       Month:=GetMonthNumber(@TempBuf);
       aBuf:=GetToken(aBuf, TempBuf);
       Year:=StrToIntDef(@TempBuf, -1);
       aBuf:=GetToken(aBuf, TempBuf);
       if aBuf^=':' then
         begin
              Inc(aBuf);
              Hour:=StrToIntDef(@TempBuf, -1);
         end
       else
         Hour:=-1;
       aBuf:=GetToken(aBuf, TempBuf);
       if aBuf^=':' then
         begin
              Inc(aBuf);
              Minute:=StrToIntDef(@TempBuf, -1);
         end
       else
         Minute:=-1;
       aBuf:=GetToken(aBuf, TempBuf);
       Second:=StrToIntDef(@TempBuf, -1);
       if aBuf^=' ' then
         begin
              aBuf:=GetToken(aBuf, TempBuf);
              GMT:=StrToIntDef(@TempBuf, 0);
         end
       else
         GMT:=0;
       if (Year>0) and (Month>0) and (Month<13) and
          (Day>0) and (Day<=DaysPerMonth(Year, Month)) and
          (Second>-1) and (Second<60) and (Minute>-1) and (Minute<60) and
          (Hour>-1) and (Hour<24) then
         begin
           LocalTimeToGMTTime(Year, Month, Day, Hour, Minute, GMT);
           ST.wYear:=Year;
           ST.wMonth:=Month;
           ST.wDayOfWeek:=0;
           ST.wDay:=Day;
           ST.wHour:=Hour;
           ST.wMinute:=Minute;
           ST.wSecond:=Second;
           ST.wMilliseconds:=0;
           SystemTimeToFileTime(ST, aFT);
         end
{
       else
         begin
              GetSystemTimeAsFileTime(aFT);
              LocalFileTimeToFileTime(aFT, aFT);
         end;
}
     end;
end;

End.