#include <stdio.h>
#include <stdlib.h>


/************************  USAGE FUNCTION  ****************************************/

void usage(void){
char buffer;
printf ("\n************************************************************************");
printf ("\n WELCOME to Pro Splitter v1.3	Copyright (c) 1998 \n");
printf ("\n Usage : splitter [-OPTION] [SIZE] [FILE_NAME] [NUMBER OF 1st PART]\n");
printf ("\n[OPTION] = -h/-s/-m/-v");
printf ("\n	-h = displays this help menu");
printf ("\n	-s = splits up file");
printf ("\n	-m = rebuilds original file (no other options needed if starting");
printf ("\n   	     with 001 otherwise number of 1st part needed as 2nd argument)");
printf ("\n	-v = displays version number.");
printf ("\n\n[SIZE] = 1/2/3/4/or any size in bytes");
printf ("\n	1 = 1.2  Mb parts	      (Ready");
printf ("\n	2 = 700  Kb parts		  made");
printf ("\n 	3 = 320  Kb parts	             values for");
printf ("\n 	4 = 60   Kb parts	                common applications.)");
printf ("\n\n[FILE_NAME]");
printf ("\n	The name of the filename to split");
printf ("\n\n[NUMBER OF 1st PART]");
printf ("\n	Optional - The number of the first part. If no number entered it will");
printf ("\n		   assume 001.");
printf ("\nPress <RETURN> to continue.\n ");
scanf  ("%c",&buffer); 
printf ("............................................\n");
printf ("| Feel free to distribute this program.     |\n");
printf ("| This product is Postcardware so if you    |\n");
printf ("| use it please send me a postcard.         |\n");
printf ("|				            |\n");	
printf ("| 			   Oscar Agra       |\n");
printf ("|			   92 Palermo Road, |\n");
printf ("|			   London NW10 5YN. |\n");
printf ("| :-)			   ENGLAND (UK)     |\n");
printf ("|  _      _  _             _                |\n");  
printf (" \\/ \\..__/ \\/ \\...._/\\/\\__/ \\__..__/\\__/\\../ \n");
printf ("     \\/        \\/\\/            \\/        \\/  \n\n");
exit (1);
}


/***************  MAKING THE ORIGINAL FILE FROM THE PARTS  ************************/

int
make_file(char **arg2)
{
char file_name2[]={"000"},
     SRC_file[]={"001.CHK"},
     original_name[30],
     verify_num[4],
     num[4],
     buffer;
  
FILE *original_file,
     *parts,
     *verify;
     
int  ch,i,j,start,checksum;


if (*(arg2+2)!=NULL)
{
        if (atoi(*(arg2+2))>999) printf ("\n\a Value out of range !! [1-999]\n");
        if (atoi(*(arg2+2))<1000 && atoi(*(arg2+2))>99) 
        for (i=0;i<3;*(SRC_file+i)=*(arg2[2]+i),i++);
	if (atoi(*(arg2+2))<100 && atoi(*(arg2+2))>9)  
	for (j=0,i=1;i<3;*(SRC_file+i)=*(arg2[2]+j),i++,j++);
	if (atoi(*(arg2+2))<10)	  *(SRC_file+2)=*arg2[2];
}

if ((verify=fopen(SRC_file,"rb"))==NULL){
	fprintf(stderr,"\a\nError : Cannot open %s\n\n",SRC_file);	
	exit(-1);}					
	for (i=0;ch!=EOF;i++){				
		ch=getc(verify);
		*(verify_num+i)=ch;
		if (ch==' ')
			{
			   *(verify_num+i)='\0';
			   for(j=0,ch=getc(verify);ch!=' ';*(original_name+j)=ch,ch=getc(verify),j++);
			   *(original_name+(j++))='\0';
			   for(j=0,ch=getc(verify);ch!=EOF;*(num+j)=ch,ch=getc(verify),j++);
			   *(num+(j++))='\0';
			   break;
			}
		}
fclose(verify);

if ((original_file=fopen(original_name,"rb"))!=NULL)
{
        fprintf (stderr,"\a\n File %s already exists...Overwrite ? [Y/N] > ",original_name);
        scanf ("%c",&buffer);
        if (buffer=='y' || buffer=='Y') 
        original_file=fopen(original_name,"wb");
        else
        { 
        printf ("\nOperation Aborted \n");
        exit(-1);
        }
}

start=atoi(num);
printf ("\n");
for (i=0;;i++,start++)
{
        char int2char[4];
        sprintf (int2char,"%d",start);
        if (start<10) *(file_name2+2)=*(int2char);
        if (start>9 && start<100){ 
        	*(file_name2+1)=*(int2char);
        	*(file_name2+2)=*(int2char+1);
               	}
        if (start>99 && start<1000){
                *(file_name2)=*(int2char);
                *(file_name2+1)=*(int2char+1);
                *(file_name2+2)=*(int2char+2);
                }
                
           printf (". ");   
           if (parts=fopen(file_name2,"rb"));
		if (parts==NULL) break;	
		original_file=fopen(original_name,"ab");	  /* Reads data from     */
		for (ch=getc(parts);ch!=EOF;ch=getc(parts)){	  /* parts and generates */
		putc(ch,original_file);}			  /* the original file   */
	fclose(parts);
	fclose(original_file);
}

checksum=atoi(verify_num);					  /* Performs Checksum  */
if (i==checksum) {
        	  printf (" Done\n");
        	  printf ("\nVerify Checksum = TRUE\n");
	          printf ("The file %s has been created succesfully.\n\n",original_name);
	         }
else {
     printf ("\n\aVerify Checksum = FALSE\n");
     printf ("Error : One or more parts of the original file are missing.\n");
     printf ("The file %s created is incomplete. \n\n",original_name);
     }

return (0);
}


/****************** READING THE OPTIONS AND MAKING THE PARTS  **************************/
int
split_file(char **arg2)
{

int  ch,i=0,start,buffer;
int  size,checksum;
char file_name[]={"000"},
     SRC_file[]={"000.CHK"},
     temp;
    

FILE *input,*output,*verify;

if ((input=fopen(arg2[3],"rb"))==NULL){
			fprintf (stderr,"\n\a Error : Cannot open %s for input\n\n",arg2[3]);
			exit(-1);
				      }				   

if (atoi(*(arg2+2))==1) size=1200000; 		/* Generates the size of the */
else if (atoi(*(arg2+2))==2) size=700000 ; 	/* parts to be made	     */
else if (atoi(*(arg2+2))==3) size=320000 ;
else if (atoi(*(arg2+2))==4) size=60000  ; 
else size=atoi(*(arg2+2));

if (*(arg2+4)==NULL) start=1;
else
start=atoi(*(arg2+4));

buffer=start;
printf ("\n");
for (checksum=1;;checksum++,start++)
{
	char int2char[4];
	sprintf (int2char,"%d",start);
        if (start<10) *(file_name+2)=*(int2char);
        if (start>9 && start<100){  
        	*(file_name+1)=*(int2char);
        	*(file_name+2)=*(int2char+1);
        	}
        if (start>99 && start<1000){
                *(file_name)=*(int2char);
                *(file_name+1)=*(int2char+1);
                *(file_name+2)=*(int2char+2);
                if (start==999) 
                printf ("\n\a Error : Limit of number of parts exceeded [1-999]!!!\n\n"); 
                }
	if (checksum==1)
	for (i=0;i<3;*(SRC_file+i)=*(file_name+i),i++);
	i=0;
	printf (". ");
		ch=getc(input);
			if (ch==EOF){ 
			     verify=fopen(SRC_file,"wb");
			     fprintf(verify,"%d %s %d",checksum-1,*(arg2+3),buffer);
			     fclose(verify);
			     printf (" Done\n");
		       	     exit(1);}             
			else ungetc(ch,input);
		output=fopen(file_name,"wb");			/* Generates files*/
		for (;i<size;i++){
		ch=getc(input);
			if (ch==EOF) {fclose(output);		
			verify=fopen(SRC_file,"wb");		
			fprintf(verify,"%d %s %d",checksum,*(arg2+3),buffer);		
			fclose(verify);
			printf (" Done\n");
			exit(1);}
		putc(ch,output);}
}

printf (" Done\n");
fclose (input);
fclose (output);

return (0);
}


int
main(int arg1,char **arg2)
{
if (arg1>1){
       	    switch (*++arg2[1]){
       	                case 'h' : usage();break;
			case 's' : split_file(arg2);break;
			case 'm' : make_file(arg2);break;
			case 'v' : printf ("\n\n ProSplitter v1.3\n\t\t by Oscar Agra\n");
				   return (0);
				   break;
			default  : usage();
			       }
	   }      
else {
        usage();
     }

return (0);
}

