{******************************************************************************
  Smart BS v1.0 (c) Igor Yudincev
    -  "Hello, World!" (c) 2000, Vasily V. Moshninov
******************************************************************************}
{$APPTYPE CONSOLE}
{$MINENUMSIZE 4}
library smart_bs;

uses windows, plugin, FARKEYS;

const Spaces=[' ',#9];

type
  TSettings=record
    bCopySpaces:BOOL; //   ,    
  end;

type
  TMessages = (MTitle, MCopySpaces, MBOk, MBCancel);

var
  FARAPI: TPluginStartupInfo;
  Settings:TSettings;
  PluginRootKey:string;

(*
   GetMsg      .
      Info.GetMsg    :-)
*)
function GetMsg(MsgId: TMessages): PChar;
begin
  result:= FARAPI.GetMsg(FARAPI.ModuleNumber, integer(MsgId));
end;

(*
   SetStartupInfo   ,  
   .    ,
     .
*)
procedure SetStartupInfo(var psi: TPluginStartupInfo); stdcall;
var k:HKEY;
    p,s:PChar;typ,n:DWORD;
begin
  Move(psi, FARAPI, SizeOf(FARAPI));
  PluginRootKey:=string(FARAPI.RootKey)+'\SmartBS';
  // 
  if RegCreateKey(HKEY_CURRENT_USER,PChar(PluginRootKey),k)=ERROR_SUCCESS then begin
    GetMem(p,64);
    if RegQueryValueEx(k,'CopySpaces',nil,@typ,Pointer(p),@n)=ERROR_SUCCESS then
      Settings.bCopySpaces:=string(p)='1'
    else begin
      s:='0';
      RegSetValueEx(k,'CopySpaces',0,REG_SZ,s,1);
    end;
    FreeMem(p);
    RegCloseKey(k);
  end
end;

(*
   GetPluginInfo    
  (general)   
*)
var
  PluginCfg: array[0..0] of PChar;

procedure GetPluginInfo(var pi: TPluginInfo); stdcall;
begin
  pi.StructSize:= SizeOf(pi);
  pi.Flags:= PF_DISABLEPANELS;
  PluginCfg[0]:=GetMsg(MTitle);
  pi.PluginConfigStrings:=@PluginCfg;
  pi.PluginConfigStringsNumber:=1;
end;

(*
   Configure    .
*)
function Configure(ItemNumber: integer): Integer; stdcall;
var
  Cfg: array[0..4] of TFarDialogItem;
  p:PChar;
  k:HKEY; s:PChar;
begin
  FillChar(Cfg,SizeOf(Cfg),0);
  with Cfg[0] do begin
    ItemType:=DI_DOUBLEBOX;
    X1:=3;Y1:=1;X2:=46;Y2:=5;
    Focus:=0;
    p:=GetMsg(MTitle);
    Move(p^,Data.Data,Length(p));
  end;
  with Cfg[1] do begin
    ItemType:=DI_CHECKBOX;
    X1:=4;Y1:=2;X2:=45;Y2:=2;
    Focus:=1;
    Param.Selected:=Settings.bCopySpaces;
    p:=GetMsg(MCopySpaces);
    Move(p^,Data.Data,Length(p));
  end;
  with Cfg[2] do begin
    ItemType:=DI_TEXT;
    X1:=-1;Y1:=3;
    Flags:=DIF_SEPARATOR;
  end;
  with Cfg[3] do begin
    ItemType:=DI_BUTTON;
    X1:=4;Y1:=4;X2:=14;Y2:=4;
    DefaultButton:=true;
    p:=GetMsg(MBOk);
    Move(p^,Data.Data,Length(p));
  end;
  with Cfg[4] do begin
    ItemType:=DI_BUTTON;
    X1:=16;Y1:=4;X2:=26;Y2:=4;
    p:=GetMsg(MBCancel);
    Move(p^,Data.Data,Length(p));
  end;

  if FARAPI.Dialog(FARAPI.ModuleNumber,    // PluginNumber
              -1,-1,50,7,                  // x,y,w,h
              'Settings',                  // HelpTopic
              @Cfg,                        // Items
              5)=3                         // Items number
  then begin
    // 
    if RegCreateKey(HKEY_CURRENT_USER,PChar(PluginRootKey),k)=ERROR_SUCCESS then begin
      Settings.bCopySpaces:=Cfg[1].Param.Selected;
      if Settings.bCopySpaces then s:='1' else s:='0';
      RegSetValueEx(k,'CopySpaces',0,REG_SZ,s,1);
      RegCloseKey(k);
    end;
    Result:=1;
  end
  else Result:=0;
end;

(*
  INPUT_RECORD structure containing the information about the last input event
  (usually a keyboard or mouse event).
  If the plugin returns 0, the input event is processed by the FAR editor.
  The plugin should return 1 if it has completely processed the event or if the event should be discarded.
*)
function ProcessEditorInput(const Rec:TInputRecord):integer; stdcall;
var nfo:TEditorInfo;
    snfo,lnfo:TEditorGetString;
    cpos:TEditorSetPosition;
    ess:TEditorSetString;
    cnv:TEditorConvertPos;
    i,line,start,first:Integer;bEmpty,bBOL,found:BOOL;
    newline:string;
begin
  result:=0;
  if Rec.EventType<>KEY_EVENT then Exit;
  if Rec.Event.KeyEvent.AsciiChar<>#8 then exit;
  if not Rec.Event.KeyEvent.bKeyDown then begin Result:=1;exit end; //. BS

  // BS
  FARAPI.EditorControl(ECTL_GETINFO,@nfo);
  if nfo.CurPos=0 then Exit; //   -  

  //   (  );   -     1- 
  snfo.StringNumber:=-1;
  FARAPI.EditorControl(ECTL_GETSTRING,@snfo);
  bEmpty:=true;
  bBOL:=False;
  First:=0;
  for i:=0 to snfo.StringLength-1 do                   //   
    if not (snfo.StringText[i] in Spaces) then begin // 
      bEmpty:=False;
      bBOL:=i=nfo.CurPos;
      First:=i;
      Break;
    end;

  if not (bEmpty or bBOL) then Exit; // ,   -  

  newline:='';
  start:=0; //   
  //    1- , .  . 
  found:=False;
  for line:=nfo.CurLine-1 downto 0 do begin
    lnfo.StringNumber:=line;
    FARAPI.EditorControl(ECTL_GETSTRING,@lnfo);
    for i:=0 to lnfo.StringLength-1 do begin           //  
      if not (lnfo.StringText[i] in Spaces) then begin //  
        cnv.StringNumber:=line;                        //   
        cnv.SrcPos:=i;
        FARAPI.EditorControl(ECTL_REALTOTAB,@cnv);
        if cnv.DestPos<nfo.CurTabPos then begin        //    -  
          found:=True;
          start:=cnv.DestPos;
          //if Settings.bCopySpaces then begin      // ,    
            setlength(newline,i);
            if i>0 then Move(lnfo.stringtext^,newline[1],i);
          //end;
        end;
        break
      end;
    end;
    if found then Break;
  end;

  if bEmpty then begin //  Backspace   
    // ." " -    
    if Settings.bCopySpaces then begin
      ess.StringNumber:=-1;
      ess.StringText:=PChar(newline);
      ess.StringEOL:=nil;
      ess.StringLength:=Length(newline);
      FARAPI.EditorControl(ECTL_SETSTRING,@ess);
    end
    //,     (, ),  
    else if snfo.StringLength>0 then begin
      ess.StringNumber:=-1;
      ess.StringText:='';
      ess.StringEOL:=nil;
      ess.StringLength:=0;
      FARAPI.EditorControl(ECTL_SETSTRING,@ess);
    end;
  end;

  if bBOL then begin   //  Backspace       1- 
    //   -  ,   ,  -  
    i:=Length(newline);
    SetLength(newline,i+snfo.StringLength-First);
    Move(snfo.StringText[First],newline[i+1],snfo.StringLength-first);
    //  
    ess.StringNumber:=-1;
    ess.StringText:=PChar(newline);
    ess.StringEOL:=nil;
    ess.StringLength:=Length(newline);
    FARAPI.EditorControl(ECTL_SETSTRING,@ess);
  end;

  //    start
  cpos.CurLine:=-1;
  cpos.CurPos:=-1;
  cpos.CurTabPos:=start;
  cpos.TopScreenLine:=-1;
  cpos.LeftPos:=-1;
  cpos.Overtype:=-1;
  FARAPI.EditorControl(ECTL_SETPOSITION,@cpos);
  FARAPI.EditorControl(ECTL_REDRAW,nil);
  Result:=1;
end;

exports
  SetStartupInfo,
  GetPluginInfo,
  Configure,
  ProcessEditorInput;

end.
