/*
  SIS.CPP

  Second-level plugin module for FAR Manager 1.70 and MultiArc plugin
  Based on HA.CPP	Copyright (c) 1996-2000 Eugene Roshal
					Copyrigth (c) 2000-2002 FAR group

  Copyright (c) 2003 Ilya Zverev

  release 1.0  Mar 01, 2003
  
*/

#include <windows.h>
#include "plugin.hpp"
#include "fmt.hpp"
#include "sis.h"

#if defined(__BORLANDC__)
  #pragma option -a1
#elif defined(__GNUC__) || (defined(__WATCOMC__) && (__WATCOMC__ < 1100)) || defined(__LCC__)
  #pragma pack(1)
  #if defined(__LCC__)
    #define _export __declspec(dllexport)
  #endif
#else
  #pragma pack(push,1)
  #if _MSC_VER
    #define _export
  #endif
#endif

static DWORD FileSize;
static HANDLE SisFile;
static DWORD NextPosition;
static WORD wLanguagesCount, wFilesCount;

BOOL WINAPI _export IsArchive(const char *Name,const unsigned char *Data,int DataSize)
{
	if (DataSize < sizeof(SisHeader) ||
		((SisHeader *)Data)->dwUID2 != SIS_UID2 ||
		((SisHeader *)Data)->dwUID3 != SIS_UID3 ||
		((SisHeader *)Data)->wInstallLanguage ||
		((SisHeader *)Data)->wInstallFiles ||
		((SisHeader *)Data)->dwInstallDrive)
		return FALSE;
	return TRUE;
}

BOOL WINAPI _export OpenArchive(const char *Name,int *Type)
{
	SisFile = CreateFile(Name,GENERIC_READ,FILE_SHARE_READ,
						NULL,OPEN_EXISTING,FILE_FLAG_SEQUENTIAL_SCAN,NULL);
	if (!SisFile || SisFile == INVALID_HANDLE_VALUE)
		return FALSE;

	*Type = 0;

	FileSize = GetFileSize(SisFile, NULL);
	if (FileSize < sizeof(struct SisHeader))
		return FALSE;

	DWORD dwBytesRead = 0;

	SetFilePointer(SisFile, 0x12, NULL, FILE_BEGIN);
	ReadFile(SisFile, &wLanguagesCount, sizeof(WORD), &dwBytesRead, NULL);
	ReadFile(SisFile, &wFilesCount, sizeof(WORD), &dwBytesRead, NULL);

	SetFilePointer(SisFile, 0x34, NULL, FILE_BEGIN);
	ReadFile(SisFile, &NextPosition, sizeof(DWORD), &dwBytesRead, NULL);
	if (!dwBytesRead)
		return FALSE;

	return TRUE;
}

int WINAPI _export GetArcItem(struct PluginPanelItem *Item,struct ArcItemInfo *Info)
{
	DWORD ReadSize;
	struct SisFile sFile;

	do {
	
		if (wFilesCount-- == 0)
			return GETARC_EOF;
		
		NextPosition = SetFilePointer(SisFile,NextPosition,NULL,FILE_BEGIN);
		if (NextPosition == INVALID_SET_FILE_POINTER)
			return GETARC_READERROR;
		if (NextPosition > FileSize)
			return GETARC_UNEXPEOF;
		if (!ReadFile(SisFile,&sFile,sizeof(struct SisFile),&ReadSize,NULL))
			return GETARC_READERROR;
		if (ReadSize < sizeof(SisFile))
			return GETARC_EOF;
		NextPosition = SetFilePointer(SisFile, 0, NULL, FILE_CURRENT);

		if (sFile.dwDestNameLength > 0 && sFile.dwType == SIS_FILE_STANDART)
		{
			char *lpszDestFile = new char[sFile.dwDestNameLength + 1];
			if (sFile.dwDestNameLength > 0)
			{
				SetFilePointer(SisFile, sFile.fpDestName, NULL, FILE_BEGIN);
				if (!ReadFile(SisFile,lpszDestFile,sFile.dwDestNameLength,&ReadSize,NULL))
					return GETARC_READERROR;
				if (ReadSize < sFile.dwDestNameLength)
					return GETARC_EOF;
				SetFilePointer(SisFile, NextPosition, NULL, FILE_BEGIN);
			}
			lpszDestFile[sFile.dwDestNameLength] = 0;
			lstrcpy(Info->Description, lpszDestFile);
			lstrcpy(Info->HostOS, "EPOC");
			while (--sFile.dwDestNameLength > 0 && lpszDestFile[sFile.dwDestNameLength] != '\\');
			lstrcpy(Item->FindData.cFileName, &lpszDestFile[sFile.dwDestNameLength + 1]);
			delete [] lpszDestFile;

			if (!ReadFile(SisFile,&Item->FindData.nFileSizeLow,sizeof(DWORD),&ReadSize,NULL))
				return GETARC_READERROR;
			if (ReadSize < sizeof(DWORD))
				return GETARC_EOF;
		}

		NextPosition += (sFile.dwFlags & SIS_MULTILANG ? wLanguagesCount : 1) * sizeof(DWORD) * 2;

	} while (Item->FindData.nFileSizeLow == 0 || sFile.dwType != SIS_FILE_STANDART);

	return GETARC_SUCCESS;
}

BOOL WINAPI _export CloseArchive(struct ArcInfo *Info)
{
	return CloseHandle(SisFile);
}

BOOL WINAPI _export GetFormatName(int Type,char *FormatName,char *DefaultExt)
{
  if (Type==0)
  {
    strcpy(FormatName,"SIS");
    strcpy(DefaultExt,"sis");
    return(TRUE);
  }
  return(FALSE);
}


BOOL WINAPI _export GetDefaultCommands(int Type,int Command,char *Dest)
{
  if (Type==0)
  {
    static char *Commands[]={
    /*Extract               */"",
    /*Extract without paths */"sisread ey %%A %%FMQ",
    /*Test                  */"",
    /*Delete                */"",
    /*Comment archive       */"",
    /*Comment files         */"",
    /*Convert to SFX        */"",
    /*Lock archive          */"",
    /*Protect archive       */"",
    /*Recover archive       */"",
    /*Add files             */"",
    /*Move files            */"",
    /*Add files and folders */"",
    /*Move files and folders*/"",
    /*"All files" mask      */""
    };
    if (Command<sizeof(Commands)/sizeof(Commands[0]))
    {
      strcpy(Dest,Commands[Command]);
      return(TRUE);
    }
  }
  return(FALSE);
}
