        page    66,80
        TITLE   SHELL.Exe 1.3 Shrinks and Spawns a child
;       by Roedy Green
;       works with MASM 5.0 and Optasm

COMMENT 
        This program is copyrighted but may be used freely
        for any purpose except military.

Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com


Version 1.3 1998 November 8
- embed Barker address

Version 1.2 1996 October 25
- embed POB 707 Quathiaski Cove address

version 1.1 1993 June 12
- display new name address

version 1.0 1991 June 25


 SHELL  ۲

SHELL shrinks to 368 bytes, then spawns a child, then restores
itself.  This program has no practical use, as is.  It is just
an EXEC teaching example.  It also acts as a skeleton you can
cannibalize to create your own real-life programs.  This program
has the following advantages over others of its kind in that:
1. it includes full OPTASM/MASM source.
2. It is stripped to minimal features for ease of understanding.
3. It is heavily commented.
4. This version swaps to disk, but it could be trivially be modified
   to swap to EMS, XMS etc.
5. The stub is small  --  and may be configured even smaller.
This program is copyrighted but may be used freely for any
purpose except military.


This program is similar to another teaching program I wrote
called *Spawn* except that *Shell* reduces itself to minimal
size before spawning, by writing itself to disk and then
restoring itself when the child process completes.

You invoke it as:

        SHELL.EXE C:\MYSUB\ANYPROG.COM  ANYARGUMENT

Note the program spawned must have *.COM or *.EXE extension and
the extension must be explicitly stated.  Shell CANNOT directly
handle *.BAT files.  The program spawned must be fully qualified
pathname or in the current directory.  Shell (or rather DOS
spawn) does NOT search the path.  With a little fudging to give
you a more complex command line, you could of course spawn
COMMAND.COM and thereby indirectly spawn a BAT FILE, to search
the path.  Normally you would look at COMSPEC in the environment
in case COMMAND.COM were in an unusual place or 4DOS were the
command processor.

This particular example is overly simplified in that is gets the
name of the child from the command line, and passes the child
JUST ONE space-delimited parameter from the original command
line.  A realistic example would set up these fields in some
more complicated way.

The Method
**********

There is a LINE below which everything will stay in RAM and
above which all will be trampled. The region below the line is
called the STUB.  The region above the line is called the
TRANSIENT REGION.  The STUB does NOT include the PSP.

First we prepare the control blocks for spawning.  We plan so
that all pointers in the control blocks are to data in the stub.

Then we create a temporary file called the Rollout file.   We
write out RAM from the line to the end of RAM used -- including
the entire original stack.

Note that we deliberately DO not save the stub.  If we did and
restored it too, our variables would all be restored to the
way they were before the spawn started.

We close the rollout file.  However we do not close any other
user files.  If the user wants his the child not to see his
handles, he can close them himself or open them with usage bit 7
on, to prevent the child from inheriting the handle.  The child
will be given a full complement of 20 handles even if the parent
leaves some uninheritable files open.

Then we move the stack to overlay the tail end of the PSP.  Then
we free up all the RAM in the transient region.  Jay Vanderbilt
thought up this trick which shrinks the stub by over 200 bytes.

Then we spawn the child.  The child has all of RAM above the
STUB to play in.  We presume that you are using DOS 3.3+ so that
the exec process will preserve registers.

When the child returns, we ask DOS to give us all our RAM back.
We open the rollout file. Then we read it file back into RAM and
delete it.

Finally, we put the stack back the way it was originally, and
return to the caller with success or fail information from the
child.

The two most important routines to follow are SPAWN which calls
CRUCIAL.  I have put both words in upper case to make them easier
to search for with a text editor.

The routines following are in logical order, not the order they
would be in RAM.  Check the segment statements to see which belong
in the STUB and which in the TRANSIENT REGION.  It is crucial to
understanding this program to be very mindful of which code and
data is in the stub and which is in the transient area.

The stub could be made still smaller by:
1. shortening the ChildName field, see MaxChildName.
2. shortening the ChildCmdLine field, see MaxCmdLine.

; =======================================

; R E G I S T E R   C O N V E N T I O N S

Unless otherwise mentioned, routines trash registers except the
segment registers CS:, DS: and SS:.  ES: is treated as a
trashable register.

; 

; =========================================

; C O N F I G U R A T I O N   E Q U A T E S

MaxCmdLine      EQU     50      ; longest command line you will ever
                                ; pass to child, not counting leading
                                ; count byte or trailing Cr.
                                ; Must be in range 1 to 255.

MaxChildName    EQU     30      ; longest name you will give the child
                                ; program, not including the trailing null.
                                ; Must be in the range 1 to 63.

; =======================================

; M A C R O S

Say     macro   Msg             ; display message on screen
        lea     DX,&Msg         ; use LEA rather than
                                ; MOV Offset for more generality
                                ; also avoids needs of seg: overrides.
                                ; Optasm will convert them anyway.
                                ; BETTER HAVE A DECENT DS:assume though!
        mov     ah,09h
        int     21h
        endm

;==============================================================

MCB             SEGMENT word public     'DUMMY'
                                        ; MCB is 16 byte control block
                                        ; ahead of PSP.  MCB is a dummy to
                                        ; use in documenting assumes.
MCBStruct       Struc

MCBMark         db      ?               ; M or Z for DOS designer Mark Zbikowski
                                        ; Z means last block in chain.

MCBOwner        dw      ?               ; PSP of owner

MCBParas        dw      ?               ; size of block in paras,
                                        ; not counting MCB.

                db      11 dup (?)      ; unused

MCBStruct       EndS

MCB             EndS

;==============================================================

PSP             SEGMENT word public     'DUMMY'
                                        ; PSP is 256-byte header ahead of
                                        ; our code.  PSP is a dummy to use
                                        ; in documenting assumes.
PSPStruct   Struc                       ; This structure, compliments
                                        ; gmussar on BIX.

PSPExit     db      2   Dup (?) ; Int 20H code
PSPSegEnd   dw      ?           ; Segment of last allocated block
            db      ?           ; Reserved
PSPCallDOS  db      5   Dup (?) ; Long call to DOS function dispatcher
PSPOldInt22 dd      ?           ; Old contents of Int 22H vector
PSPOldInt23 dd      ?           ; Old contents of Int 23H vector
PSPOldInt24 dd      ?           ; Old contents of Int 24H vector
            db      22  Dup (?) ; Reserved
PSPEnvBlk   dw      ?           ; Segment of environment block
            db      46  Dup (?) ; Reserved
PSPDefFCB1  db      16  Dup (?) ; Default file control block #1
PSPDefFCB2  db      16  Dup (?) ; Default file control block #2
            db      4   Dup (?) ; Reserved
PSPCmdLine  db      128 Dup (?) ; Counted string. Cr Terminated

PSPStruct   Ends

PSP         EndS

;==============================================================

Stubcode        SEGMENT Para public     'STUB'
                                        ; Start with the Stub code
Stubcode        ends                    ; 'STUB' causes all segments of
                                        ; this class to be loaded together.
                                        ; It overrides the even the order we
                                        ; define the segments.  Note that
                                        ; the GROUP has no effect on order.
                                        ; ORDER IS VERY IMPORTANT!

;==============================================================

StubData        SEGMENT word public     'STUB'
                                        ; next comes stub data
StubData        Ends

;==============================================================

EndStub         SEGMENT para public     'STUB'
                                        ; MUST BE PARAGRAPH ALIGNED!

TheLine label   word

; all code below this line is part of the resident stub.
; all code above it is part of the transient area.
; The stub remains resident during a spawn.  The transient area
; is written to disk.  The child uses it's RAM.  When the child
; returns, the transient area is restored.

EndStub         Ends

;==============================================================

TransCode       SEGMENT para public     'TRANS'
                                        ; Then the regular transient code
                                        ; Usually just after STUB, but
                                        ; not necessarily.
TransCode               Ends

; Segment loading order has NOTHING to do with GROUPS.  There is
; no directive to take the assembler by the hand and say -- "put
; the segments in THIS order."  What you must do is MENTION them
; in order in your main routine.  If you use CLASS NAMES (in
; quotes) this overrides the as-mentioned order by promoting
; subsequent segments with a classname matching a segment already
; mentioned to slip in with the rest of the segments in that
; class.  The alphabetical ordering of the segment names or the
; classnames means nothing.

;==============================================================

UserCode        Segment Para Public     'TRANS'
;       This represents code for the user task that uses us to spawn
;       It too is part of the transient region
UserCode        EndS

;==============================================================

UserData        Segment Para Public     'TRANS'
;       This represents data for the user task that uses us to spawn
;       It too is part of the transient region
UserData        EndS

;==============================================================

Stack           SEGMENT para stack      'STACK'

        db      512 dup (?)

Stack           ends

;==============================================================

;  V A R I A B L E S   F O R   S P A W N I N G   T H E   C H I L D

Stubdata        Segment

ChildName       DB      MaxChildName dup (0),0
                                ; e.g. "C:\MySub\Myprog.Exe",0
                                ; Name of the child program to spawn.
                                ; must be fully qualified or
                                ; in the current dir.
                                ; Spawn will not search the path.
                                ; must have explicit .COM or .EXE,
                                ; no .BAT, no leaving extension off.

ChildCmdLine    db      0,MaxCmdLine dup (" "),0dh
                                ; e.g. 2,"/X",0dh
                                ; build command tail here, with length
                                ; byte and trailing Cr, not included in
                                ; length
                                ; This will be the child's command
                                ; parameter line.
                                ; Note ChildCmdLine is what gets passed to the
                                ; child.  DOS copies it into the child's
                                ; PSP at offset 80.

ChildRetCode    DW      0       ; return code the child gave us.
                                ; if +ve came from child.
                                ; if -ve came from DOS exec.

;       The values for the variables above must be provided by the user.
;       The ones below can be computed.

DummyFCB        db      0, 11 dup(" ")
                                ; dummy fcb for the child


ParmBlock       label   Word    ; communication region with child

EnvSeg          DW      0       ; address of child's environment region
                                ; leave zero so child sees our ENV.
                                ; Note 0 offset presumed.

TailOff         DW      0       ; Address of child's command line
Tailseg         DW      0       ; Will point to ChildCmdLine
                                ; must be dynamically ininitialized.

FCB1Off         DW      0       ; address of child's first FCB
FCB1Seg         DW      0       ; will point to DummyFCB
                                ; must be dynamically ininitialized.

FCB2Off         DW      0       ; address of child's second FCB
FCB2Seg         DW      0       ; will point to DummyFCB

Stubdata        EndS

;==============================================================

;  V A R I A B L E S   F O R   H A N D L I N G   T R A N S I E N C E

Stubdata        Segment


TransStopSeg            DW      0
                                ; seg where transient region ends.
                                ; this is actually 1 byte past the end.
                                ; must be provided by the user.

; ----  The variables below can be computed.  The value for TransStopSeg must
;       be provided by the user.


RollOutFileName DB      '\',0, 14 dup (0)
                                ; rollout filename to hold transient region
                                ; while child has control.
                                ; Temporary name generated by DOS.

RollOutHandle           DW      0
                                ; handle of filename to hold transient region.

TransStartSeg           DW      0
                                ; seg where transient region starts.
                                ; right after the stub.

OrigStack               DD      0
                                ; seg:offset where original stack base was
                                ; We have to put it back eventually.
                                ; Addr word after first word pushed to stack,
                                ; at high end of block.  Initial value for SP.
                                ; Note we don't have to move all of the original
                                ; stack -- only the parts we use, since the
                                ; general purpose rollout will restore the rest.
                                ; This is the base of the part we MOVE.
                                ; Usually NOT canonical.
                                ; Usually near the end of the transient region.

PSPStack                DD      0
                                ; seg:offset of PSP stack base
                                ; Addr word after first word pushed to stack,
                                ; at high end of block.  Initial value for SP.
                                ; NOT canonical.
                                ; Overlays PSP

                        org     $-2
PSPSeg                  DW      0
                                ; segment of PSP, overlays PSPStack+2

CurrentStack            DD      0
                                ; seg:offset where base of stack is now.
                                ; Addr word after first word pushed to stack,
                                ; at high end of block.  Initial value for SP.
                                ; Usually NOT canonical.
                                ; Changes as we keep moving the stack from
                                ; origstack to nearstack to farstack back
                                ; to origstack.

OrigRAM                 DW      0
                                ; size in paragraphs of RAM in use when
                                ; we start out.  We will ask for this much
                                ; back after we shrink and grow back again.
                                ; This includes the PSP + Stub + Transient
                                ; region + any other RAM allocated by USER.

ReadWrite               DB 40h  ; 40h if writing to disk, 3Fh if reading
                                ; this way we can save a few bytes by
                                ; using a generic I/O routine instead of
                                ; separate WRITE and READ routines.
Stubdata        Ends
;===========================================================

; M E S S A G E S


Stubdata        Segment
;       IN STUB
;               This error message must always be available
FailMsg         db 13,10
                db 'SHELL failed',13,10
                db '$'
Stubdata        EndS



UserData        Segment

;       IN USER TRANSIENT REGION

BannerMsg       DB 13,10
        DB      ' SHELL 1.3  ۲',13d,10d
        DB      13d,10d
        DB      'Sample program to demonstrate spawning.',13,10
        DB      13,10
        DB      'Copyright (c) 1991,1998 Roedy Green Canadian Mind Products.',13,10
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10
        DB      'May be freely distributed and used for any purpose except military.',13,10,13,10
        db      '$'

UsageMsg        db 13,10
                db 'Try:',13,10
                db 'SHELL.EXE  C:\MYCHILD.EXE  /XXXX',13,10
                db 'when /XXX represents an arbitrary parameter for the child',13,10
                db 'Child must have explicit .COM or .EXE extension.',13,10
                db '$'

DoneMsg         db 13,10
                db ' SHELL 1.3 ۲ Complete',13,10
                db '$'

OopsMsg         db 13,10
                db ' SHELL 1.3 ۲ Child returned an error',13,10
                db '$'

SyntaxErrMsg    db 13,10
                db 'Syntax error in command line',13,10
                db '$'

LastData        Label   Word

Userdata        ends


;==============================================================

StubCode        Segment

StubGroup       group   Stubcode,stubdata

        ASSUME  CS:StubGroup,DS:StubGroup,ES:nothing,SS:nothing

;==============================================================

UserCode        Segment

        ASSUME  CS:UserCode,DS:Nothing,ES:nothing,SS:nothing

UserTask        Proc    Near

; IN TRANSIENT USER REGION
;
;       This represents the sample code you would write that uses SPAWN.
;
;       It has the following duties:
;
;       1.  Build the ASCIIZ string ChildName -- name of program to
;           spawn, fully qualified with extension.
;
;       2.  Build the counted CR-terminated command line for the child
;           in ChildCmdLine
;
;       3.  Calculate TransStopSeg, the place above which in RAM it
;           it not necessary to preserve.
;
;       4.  Ensure no interrupts that will be triggered are pointing into
;           the transient region.
;
;       5.  CALL SPAWN
;
;       6.  Examine the ChildRetCode on return to see if all worked.

Beginning:
                                ; This is an EXE file, and this is the
                                ; first instruction of program executed.
                                ; CS:IP points to Beginning
                                ; SS:SP points to stack
                                ; DS: ES: point to PSP

        mov     ax,SEG UserData
        mov     DS,ax

        ASSUME  CS:UserCode,DS:UserData,ES:PSP,SS:nothing

        Say     BannerMsg       ; display the copyright banner

        Call    GetChildName    ; parse command line
                                ; gets ChildName, 1st parm.
                                ; In real life these would be generated
                                ; some other way.

        Call    GetChildCmdLine ; parse command line
                                ; gets ChildCmdLine, 2nd parm
                                ; In real life this would be generated
                                ; some other way.

        Call    GetTransStopSeg ; Get segment where transient area ends.
                                ; How much of self you want preserved.

        Call    FAR PTR SPAWN   ; handle whole transience and shell.
        mov     ax,SEG StubGroup
        mov     ES,ax
        ASSUME  ES:StubGroup
        test    ChildRetCode,-1
        jz      ChildHappy

ChildSad:
        Say     OopsMsg         ; child returned some sort of error
        mov     ah,4ch
        mov     al,byte ptr ChildRetCode
        int     21h             ; EXIT to DOS

ChildHappy:
        Say     DoneMsg
        mov     ax,4c00h        ; EXIT with return code 0
        int     21h

        ASSUME  ES:nothing

UserTask        Endp

;=============================

GetTransStopSeg Proc    Near

; IN TRANSIENT USER REGION
;       Sample user routine to set the TransStopSeg.
;       We fudge the TransStopSeg just to exercise the code
;       In a real use of this technique, something grander than
;       this would have to be done.

;       Assume the transient area stops after the stack
        mov     ax,sp                   ; stack not too deep right now
        add     ax,15                   ; Round up to next paragraph
                                        ; to give us base.
        mov     cl,4
        shr     ax,cl                   ; convert to paragraphs
        add     ax,SEG Stack

        mov     bx,SEG StubGroup
        mov     ES,bx
        ASSUME  ES:StubGroup

        mov     TransStopSeg,ax         ; save value

        ASSUME  ES:nothing
        ret

GetTransStopSeg EndP

;=============================

UserCode        EndS

;=============================

TransCode       Segment

        ASSUME  CS:TransCode,DS:StubGroup,ES:nothing,SS:nothing

SPAWN   proc    Far


; IN TRANSIENT REGION.  We put it up here with rest of stub code
; because it is the high level control routine.  Physically it will be
; loaded later as part of the transient area.  It will likely come right
; at the front of the transient area, but that is not necessary.

; This is the general spawn routine.
; It controls everything -- saving the transient,
; invoking the child, restoring the transient.
; On entry only a few variables must be set:
; ChildName, ChildCmdLine, and TransStopSeg.
; This routine is in the transient area, and so
; gets clobbered while CRUCIAL runs the guts of the work.

; P R E P A R E   C H I L D   C O N T R O L   B L O C K

        push    DS
        mov     ax,SEG StubGroup
        mov     DS,ax

        Call    InitChild       ; initialize command blocks

; S A V E   T R A N S I E N T  A R E A   (most of RAM)

        Call    CalcTransAddrs  ; calc various addresses

        Call    CalcOrigRAM     ; calculate how much RAM we are
                                ; using NOW.  Might not be all of
                                ; RAM.

        Call    CreateRollOut   ; Create temporary file to
                                ; hold the transient region

        Call    WriteRollOut    ; Save the transient region on disk

        Call    CloseRollout    ; close the rollout file


        les     di,PSPStack     ; Put stack on top of PSP
        call    MoveStack

        Call    FAR PTR CRUCIAL ; handle the spawning, using only routines
                                ; in the stub.  Restore the transient region.

        les     di,OrigStack    ; Put stack back where it was originally
        call    MoveStack

        Call    CloseRollout    ; Close the rollout file

        Call    DeleteRollout   ; Delete the rollout file used
                                ; to hold the transient region
        pop     DS

        ret

SPAWN   endP

TransCode       endS

;=============================

        ASSUME  CS:StubGroup,DS:StubGroup,ES:nothing,SS:nothing

CRUCIAL         Proc    Far


;       STUB
;       Handle the crucial part of the spawn.
;       Called by SPAWN.
;       During this time the transient portion is damaged, so we
;       may not use any of its routines.  We must use only STUB routines.
;       The transient region has already been saved.

        call    ShrinkRam       ; free up ram for use by Child

; S P A W N   T H E  C H I L D

        ASSUME  DS:StubGroup
        lea     dx,ChildName    ; DS:dx executable

        mov     ax,DS
        mov     ES,ax
        ASSUME  ES:StubGroup
        lea     bx,ParmBlock    ; ES:bx pointers to FCBS and ENV

        mov     ax,4B00h        ; load and execute child process
        int     21h
                                ; Pre-DOS 3.0 trash all registers.
                                ; We run only non DOS 3.3+
        ASSUME  ES:nothing

        Call    CheckRetCode    ; check return code
                                ; carry on no matter what.
                                ; spawn itself could fail -- no such child prog
                                ; or Child could run, and return non-zero
                                ; return code.

; R E S T O R E   T R A N S I E N T  A R E A   (most of RAM)

        Call    GrowRam         ; grow RAM back to full size.

        Call    OpenRollOut     ; Open the RollOut file

        Call    ReadRollOut     ; read the transient region back in.
                                ; now we can start using the
                                ; routines in the transient region again.

; The rest of this need not be part of the stub, that we are trying
; to keep as small as possible.

        ret

CRUCIAL         EndP

;=============================

ShrinkRam       Proc    Near

;       STUB
;       Spawning must be done into free RAM.  We must give back RAM
;       to the pool.
;       Stack has already been moved to PSP.
;
;       There are two common ways you might FREE RAM.  One is the
;       Terminate and stay resident int 21H function 32H, and the other
;       is resize memory block INT 21H function 4AH.

;       Both have a builtin presumption that the PSP lives just ahead of
;       your program -- for both COM and EXE files.  Both require you to
;       consider the size of the PSP when figuring how much RAM you want
;       to keep.

                                ; Size must include PSP (COM or EXE!)
                                ; stub code and data
        mov     bx,TransStartSeg
                                ; start of transient region after the stub
        sub     bx,PSPSeg       ; calc size desired in paragraphs
        mov     ES,PSPSeg       ; PSP is the base of our RAM.
        ASSUME  ES:PSP
        mov     ah,4aH
        int     21h             ; shrink RAM
        JC      RamTrouble      ; some trouble with resize
        ret

RamTrouble:
                                ; GrowRam uses this same jmp
        jmp     Trouble

ShrinkRam       EndP

;=============================

GrowRam Proc    Near

;       STUB
;       Take back as much RAM as we had to start.

        mov     ES,PSPSeg       ; PSP is the base of our RAM.
        ASSUME  ES:PSP
        mov     bx,OrigRAM      ; RAM we had before in paragraphs
        mov     ah,4aH
        int     21h             ; grow RAM
                                ; if fails, will tell biggest in BX
        jc      RAMTrouble
                                ; could try recover -- ask for ffff then
                                ; ask again with what could get,
                                ; but something is seriously wrong if can't
                                ; get exactly the same RAM back.
        ASSUME  ES:Nothing
        ret

GrowRam EndP

;=============================

CheckRetCode    Proc    Near

;       STUB
; check return code from last spawn
; If the spawn itself failed, return a negative retcode of the problem.
;
        jc      SpawnFailed
        mov     ah,4Dh
        int     21h
;                               ; ax is the return code
        mov     ChildRetCode,ax
        ret                     ; save it.
                                ; NO NEED TO PANIC IF IT IS NOT ZERO!
                                ; Non-zero ret code could be completely
                                ; benign.
SpawnFailed:
        neg     ax              ; This means Child program could not be
                                ; found etc.  We still can put RAM and stacks
        mov     ChildRetCode,ax ; back together safely.
        ret                     ; This is serious, but not fatal.

CheckRetCode    EndP

;=============================

IOTrans Proc    Far

;       STUB
;       This code either writes the transient region TO disk, or reads it
;       back FROM disk, depending on how ReadWrite is set.
;       The transient region starts and ends on
;       a paragraph boundary to simplify life.
;       The file is already open.
;       We use 64K (less one paragraph) chunks, for the bulk,
;       and treat the remainder specially.
;       This routine is FAR so that both WriteTrans and ReadTrans can call it.

ChunkParas      equ     (64*(1024/16))-1        ; size of an IO chunk in paragraphs
                                                ; 64K less one paragraph

ChunkBytes      equ     ChunkParas*16           ; size of an IO chunk in bytes
                                                ; 64K less one paragraph
        ASSUME  DS:StubGroup

        mov     di,TransStartSeg                ; start of region to read/write

DoAnotherChunk:
        mov     si,di                           ; si=start of chunk
                                                ; di=just past chunk
        add     di,ChunkParas                   ; end of proposed 64K-1 chunk
                                                ; read/write
        cmp     di,TransStopSeg
        jae     DoLastChunk                     ; jump equal so last chunk
                                                ; always handled specially, even
                                                ; if it is a full chunk.  Otherwise
                                                ; we might do a 0-length write.

        mov     ah,ReadWrite                    ; Read/Write a 64K-1 chunk
                                                ; of the transient region.
                                                ; 3Fh=read 40h=write
        mov     bx,RollOutHandle
        mov     cx,ChunkBytes                   ; byte count

        push    DS
        mov     DS,si
        ASSUME  DS:nothing
        mov     dx,0                            ; buffer offset

        int     21h                             ; DOS read/write file
        cmp     ax,cx
        jne     IOTrouble

        pop     DS
        ASSUME  DS:StubGroup
        jmp     DoAnotherChunk

DoLastChunk:
                                        ; last piece is a partial chunk
                                        ; start of chunk is DS
                                        ; end is TransStopSeg
                                        ; how long is the chunk in bytes?

        mov     di,TransStopSeg
        sub     di,si                   ; compute length of last piece in paras
        mov     cl,4                    ; # paragraphs -- will not be > 64K-1
        shl     di,cl                   ; convert paragraphs to bytes

        mov     cx,di                   ; length of read/write in bytes, poss 0
        mov     ah,ReadWrite            ; read/write last chunk of the transient region.
        mov     bx,RollOutHandle

        push    DS
        mov     DS,si
        ASSUME  DS:nothing
        mov     dx,0

        int     21h                     ; DOS read/write file
        cmp     ax,cx
        jne     IOTrouble

        pop     DS
        ASSUME  DS:StubGroup
        ret

IOTrouble:
        jmp     Trouble

IOTrans EndP

;=============================

OpenRollOut Proc        Near

;       STUB
;       Open the RollOut file ready to read back the transient region.
;       on return handle is saved in TransientHandle.
;       TransientFilename contains unique filename created previously.

        mov     ax,3D90h        ; ordinary OPEN = 3D
                                ; 1 001 0 000  = 90h
                                ;         === read access
                                ;   === deny all
                                ; = child-does-not-inherit handle
                                ; DS:dx points to filename
        lea     dx,RollOutFileName
        int     21h
        mov     RollOutHandle,ax
        ret

OpenRollOut EndP

;=============================

ReadRollOut     Proc    Near

;       STUB
;       Restore the transient region from disk.  The region starts and ends
;       on a paragraph boundary to simplify life.
;       The file is already open.

        mov     ReadWrite,3fh   ; code for read
        call    IOTrans
        ret

ReadRollOut     EndP

;=============================

Trouble:

;       STUB
;       Some sort of BIG trouble -- we cannot continue.
;       Can only jump here from within the StubCode segment.
;       If can't find child program or child
;       returns non-zero ret code, we can
;       carry on -- no problem.  No need to come here.

        mov     ax,CS
        mov     DS,ax           ; Say needs a valid DS:
                                ; DS could be wrecked by caller.
        ASSUME  DS:StubGroup
        Say     FailMsg
        mov     ax,4c04h        ; ABORT TO DOS with return code 4
        int     21h
                                ; NO RETURN

;=============================

StubCode        EndS

; FROM HERE ON IN IS THE TRANSIENT REGION
; NOT PART OF THE RESIDENT STUB

TransCode               Segment

;=============================

        ASSUME  CS:TransCode,DS:StubGroup,ES:nothing,SS:nothing

MoveStack       Proc    Near

; IN TRANSIENT REGION
;       moves the stack -- including all its entries from its current
;       position to a new one.
;       The current stack base is given in CurrentStack.
;       The new stack base is given in ES:di
;       By stack base, address of word after first word pushed to the stack,
;       at the high end of the block reserved for the stack.
;       I.e. initial value for SP.
;       Preserves DS, but not other registers, not even ES:.  Changes SS:SP
;       During routine DS and ES cannot be trusted.


        mov     si,word ptr CurrentStack
                                ; SS:si is where stack base is now

        mov     word ptr CurrentStack+2,ES
        mov     word ptr CurrentStack,di
                                ; Save pointer to new stack base.
                                ; There is no Store equivalent to LES.

        push    DS
        mov     ax,SS
        ASSUME  DS:nothing
        mov     DS,ax
        mov     cx,si           ; move stack contents first
        sub     cx,sp           ; size of stack in bytes
        shr     cx,1            ; cx in words
        std
        cmpsw                   ; our pointers DS:si and ES:di are one word
                                ; too high.  This will decrement both di and
                                ; si by 2.  We are not REALLY comparing
                                ; anything.  Happily, it leaves CX untouched!

                                ; work backwards, copying stack words
        rep     movsw           ; mov DS:si -> ES:di, cx words
        cld
        add     di,2            ; back up di to point to last word moved.
                                ; this will become the new stack pointer.
        mov     ax,ES           ; move SS:SP to point to new TOS
        mov     SS,ax
        mov     sp,di

        pop     DS
        ASSUME  DS:StubGroup
        ret

        MoveStack       EndP

;=============================

InitChild       Proc    Near

; IN TRANSIENT REGION
;       Init child's command blocks.
;       Cannot do this at assembly time as seg unknown.

        lea     SI,ChildCmdLine
        mov     TailSeg,DS
        mov     TailOff,SI

        lea     SI,DummyFCB
        mov     FCB1Seg,DS
        mov     FCB1Off,SI
        mov     FCB2Seg,DS
        mov     FCB2Off,SI
        ret

InitChild       EndP

;=============================

CalcTransAddrs          Proc    Near

; IN TRANSIENT REGION
;       On entry we presume TransStopSeg is given.
;       We will calculate OrigStack TransStartSeg
;       PSPStack and CurrentStack

;       Calculate OrigStack
;       Assume we must preserve the FAR return to SPAWN, but no further.
;       The rollout mechanism will handle getting up back from SPAWN to
;       its USERTASK caller.
;       In other words the effective stack base is 2 words higher up than SP.
;       Note the stack is actually bigger.  We are are only concerned with
;       the part that needs special preservation during the spawn.

        mov     word ptr origStack+2,SS ; save current stack position
                                        ; in both OrigStack and CurrentStack
        mov     word ptr CurrentStack+2,SS
        mov     ax,SP
        add     ax,4                    ; 2 word = 4 bytes
        mov     word ptr origStack,AX
        mov     word ptr CurrentStack,ax

;       Calculate TransStartSeg
;       Assume the Transient area starts at TheLine.
        mov     TransStartSeg,SEG TheLine
                                        ; NOTE WE WANT SEG TheLine
                                        ; NOT SEG StubGroup:TheLine


        mov     ah,62h                  ; get PSP address in bx
        int     21h
        mov     word ptr PSPStack+2,bx  ; use entire PSP as temp stack.
                                        ; This also sets alias PSPSeg.
        mov     word ptr PSPStack,256   ; normally only last few bytes used.

        ret

CalcTransAddrs          Endp

;=============================

CalcOrigRAM     Proc    Near

; IN TRANSIENT REGION
;
;       Calculate how much RAM we are using now, so that when we
;       give it all up, we will ask for the right amount back.  We
;       Don't want to necessarily ask for ALL the RAM back
;       and confuse the user.
;
;       To do this, WE HAVE TO CHEAT a little bit.  We peek in the MCB
;       just ahead of the PSP to find out.  The PSP is always just ahead
;       of the program, both for COM and EXE files.
;
;       MCB has format:
;       "M" or "Z" - last MCB in chain marker
;       2 bytes - PSP of owner
;       2 bytes - size of block in paras, not counting MCB.
;
;       We cannot use the RAM size in the PSP since DOS does not keep that
;       updated as the user program allocates and frees RAM.
;
;       There is no thread of MCBS in the ordinary sense.  DOS just
;       expects to find another MCB right smack dab after the block
;       controlled by the previous one ends.
;
;       If ever this use of undocumented DOS should fail, you could
;       replace this routine with one that simply asked for ALL of RAM, then
;       failed, and recorded what it COULD have gotten.  This would have
;       the nasty side effect of possibly returning to the user with
;       more RAM allocated that the user had originally.

        mov     bx,PSPSeg       ; get address of PSP
        sub     bx,1            ; get address of MCB
        mov     ES,bx
        ASSUME  ES:MCB

        mov     bx,MCB:[MCBParas]
                                ; get size of block in paragraphs
                                ; it includes the PSP+program
        mov     OrigRAM,bx
        ASSUME  ES:Nothing
        ret

CalcOrigRAM     EndP

;=============================

CreateRollout Proc      Near

; IN TRANSIENT REGION
;       Creates a temporary file to store the transient region.
;       on return handle is saved in TransientHandle.
;       TransientFilename contains unique filename created.

        mov     ah,5Ah          ; create unique file
        mov     cx,0            ; nothing special attribute, not read only etc.
        lea     dx,RollOutFileName
                                ; DS:dx points to filename
        mov     bx,dx
        mov     byte ptr DS:[bx],'\'
        mov     byte ptr DS:[bx+1],0
        int     21h
        mov     RollOutHandle,ax
        ret

CreateRollout EndP

;=============================

WriteRollOut    Proc    Near

; IN TRANSIENT REGION
;       Save transient region on disk.  The region starts and ends
;       on a paragraph boundary to simplify life.
;       The file is already open.

        mov     ReadWrite,40h   ; code for write
        call    IOTrans
        ret

WriteRollOut    EndP

;=============================

CloseRollOut Proc       Near

; IN TRANSIENT REGION
;       Close the temporary file used to read back the transient region.

        mov     ah,3Eh                  ; ordinary Close
        mov     bx,RollOutHandle        ; close
        int     21h
        ret

CloseRollout EndP

;=============================

DeleteRollout   Proc    Near

; IN TRANSIENT REGION
;       Delete the Rollout file

        lea     dx,RollOutFileName      ; DS:dx points to filename
        mov     ah,41H                  ; delete
        int     21h
        ret

DeleteRollout EndP

;=============================
UserCode Segment

        ASSUME  CS:UserCode,DS:UserData,ES:nothing,SS:nothing

GetChildName    Proc    Near
; IN USER TRANSIENT REGION

;       Sample routine to set up the name of the child program to spawn.
        ASSUME  DS:userdata
        Call    CommandLine             ; in ES:DI
        mov     bx,1
        Call    NthParm                 ; get first parm off command line
                                        ; ES:si points to string, cx is len
        cmp     cx,1
        jl      SyntaxErr
        cmp     cx,MaxChildName
        jg      SyntaxErr
        push    DS
        mov     ax,ES
        mov     DS,ax                   ; point DS: to PSP
        ASSUME  DS:PSP

        mov     ax,seg StubGroup        ; point ES: to StubGroup
        mov     ES,ax
        ASSUME  ES:StubGroup

        lea     di,ChildName
                                        ; DS:si points to parm
                                        ; ES:di points to ChildName field for exec
        rep movsb                       ; save parm in ChildName ASCIIZ variable
        sub     al,al
        stosb                           ; store trailing null.
                                        ; not really necessary as string init to null.
        pop     DS
        ASSUME  DS:Userdata,ES:nothing
        ret

GetChildName    EndP

;=============================

GetChildCmdLine Proc    Near
; IN USER TRANSIENT REGION

;       Sample routine to set up the a command line for the child.
        ASSUME  DS:userdata
        Call    CommandLine             ; command line in ES:DI
        ASSUME  ES:PSP
        mov     bx,2                    ; get the 2nd parm off command line.
        Call    NthParm
                                        ; ES:si points to string, cx is len
        cmp     cx,1                    ; insist on at least one byte.
        jl      SyntaxErr
        cmp     cx,MaxCmdLine
        jg      SyntaxErr

        push    DS
        mov     ax,ES
        mov     DS,ax
        ASSUME  DS:PSP

        mov     ax,seg StubGroup        ; point ES: to StubGroup
        mov     ES,ax
        ASSUME  ES:StubGroup

        lea     di,ChildCmdLine
        mov     al,cl
        stosb                           ; store leading count byte
                                        ; CX unaffected
        rep movsb                       ; store string
        mov     al,0dh
        stosb                           ; store trailing Cr
        pop     DS
        ASSUME  DS:userdata,ES:nothing
        ret

GetChildCmdLine EndP

;=============================

; IN USER TRANSIENT REGION

NthParm Proc    Near
;       Parses string for Nth Parameter delimited by blanks
;       e.g.  "  bright blue" with BX=1 would give string "bright"
;       ES:DI - string to be parsed for parameters
;       CX - length of string
;       BX - which parm wanted 1=parm1 2=parm2 etc.
;       NthParm only finds one parm per call.
;       On exit ES:SI points to string and CX is its length.
;       If there is no parm, the length will be 0.
;       It also handles multiple leading/trailing blanks on parms.
;       Usually the string is the command line

        mov     al,20h          ; AL = blank  -- the search char
ParmLoop:
;       Remove leading blanks on parm
        jcxz    NullParm        ; jump if null string
        repe    scasb           ; scan ES:DI forwards till hit non blank
                                ; DI points just after it
                                ; CX is one too small, or 0 if none found
        je      NullParm        ; jump if entire string was blank
        inc     cx              ; CX is length of remainder of string
        dec     di              ; DI points to non-blank
        mov     si,di           ; remember start of string
;       Search for terminating blank on parm
        jcxz    NullParm        ; jump if null string
        repne   scasb           ; scan ES:DI forwards till hit blank
                                ; DI points just after it
                                ; CX is one too small, or 0 if none found
        jne     NoBlank         ; jump if entire string was non blank
        inc     cx              ; CX is length of remainder of string
        dec     di              ; backup DI to point to blank at string end
NoBlank:
                                ; DI=addr tail end of command string,
                                ; CX=len tail end of command string
                                ; SI=addr parm just parsed
;       Major loop for each parm
        dec     bx
        jnz     ParmLoop        ; loop once for each parm

        mov     cx,di
        sub     cx,si           ; CX is length of parameter.
        ret

NullParm:                       ; was no nth parameter
        mov     cx,0
        ret

NthParm EndP

;=============================

; IN USER TRANSIENT REGION

CommandLine Proc        Near
;       Gets command line string into ES:DI
;       Command line does not include the program name.
        mov     ah,62h          ; get PSP address in bx
        int     21h
        mov     ES,bx
        ASSUME  ES:PSP
        sub     ch,ch
        mov     cl,PSP:[PSPCmdLine]
                                ; at 80h
                                ; CX contains length of command
                                ; counted string at HEX 80
                                ; contains command line.
                                ; It has no trailing null, but a trailing Cr

        mov     di,offset PSP:[PSPCmdLine+1]
                                ; 81h, addr of line.
        ASSUME  ES:Nothing
        ret

CommandLine EndP

;=============================

; E R R O R S
; IN USER TRANSIENT REGION

SyntaxErr:
        Say     SyntaxErrMsg            ; syntax error
        Say     UsageMsg
        mov     ax,4c04h                ; Abort with errorlevel 4
        int     21h

usercode        EndS

;=============================
LastCode Label  word                    ; last byte of RAM in transient region
;=============================

;==========================
TransCode       ends                    ; end of code segment
        end     Beginning
