{ About box }
unit SetFD2;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, Dialogs, ShellAPI;

type
  TAboutBox = class(TForm)
    Panel: TPanel;
    ProgTitle: TLabel;
    ProgIdn: TLabel;
    ProgComment: TLabel;
    Copyright: TLabel;
    AuthorEmail: TLabel;
    OKButton: TButton;
    AuthorURL: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure AuthorEmailClick(Sender: TObject);
    procedure AuthorURLClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AboutBox: TAboutBox;

implementation

Uses SetFD0;

{$R *.DFM}

procedure TAboutBox.FormCreate(Sender: TObject);
begin
  ProgIdn.Caption       := GC_ProgIdn+' '+GC_ProgVers+' - '+GC_ProgDate;
  ProgTitle.Caption     := GC_ProgTitle;
  ProgComment.Caption   := GC_ProgComment;
  ProgComment.Caption   := GC_ProgComment;
  Copyright.Caption     := GC_Copyright;
  AuthorEmail.Caption   := GC_AuthorEmail;
  AuthorURL.Caption     := GC_AuthorURL;
end;


procedure TAboutBox.AuthorEmailClick(Sender: TObject);
var cmd: string;
begin
  cmd:= 'mailto:'   + GC_AuthorEmail +
        '?subject=' + 'About '+GC_ProgIdn+' '+GC_ProgVers;
  if ShellExecute(GetDesktopWindow,nil,PChar(cmd),nil,nil,SW_NORMAL) <= 32
  then ShowMessage('failed to create e-mail');
end;

procedure TAboutBox.AuthorURLClick(Sender: TObject);
var cmd: string;
begin
  cmd:= GC_AuthorURL;
  if ShellExecute(GetDesktopWindow,nil,PChar(cmd),nil,nil,SW_NORMAL) <= 32
  then ShowMessage('failed to launch web browser');
end;

end.

