{ Main Window }
unit SetFD1;

interface

uses
  SetFD0,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, FileCtrl, Buttons, Menus;

const
{ GrpSetTo ItemIndex values }
  st_NoChange   = 0;
  st_Specified  = 1;
  st_Lowest     = 2;
  st_Highest    = 3;
  st_Now        = 4;

type
  T_DateTimeSetting = st_NoChange..st_Specified;

  TMainWindow = class(TForm)
    Panel: TPanel;
    LblFiles1: TLabel;
    LblTime0: TLabel;
    FontDlgDateTime: TFontDialog;
    FontDlgFileInfo: TFontDialog;
    Timer: TTimer;
    MainMenu: TMainMenu;
    MnuFile: TMenuItem;
    MnuFileSelectAll: TMenuItem;
    MnuFileDeselectAll: TMenuItem;
    MnuFileRefresh: TMenuItem;
    MnuFileSep1: TMenuItem;
    MnuFileChange: TMenuItem;
    MnuFileSep2: TMenuItem;
    MnuFileExit: TMenuItem;
    MnuOptions: TMenuItem;
    MnuOptCalendar: TMenuItem;
    MnuOptFont: TMenuItem;
    MnuOptFontFileInfo: TMenuItem;
    MnuOptFontDateTime: TMenuItem;
    MnuHelp: TMenuItem;
    MnuHlpAbout: TMenuItem;
    PopFileInfo: TPopupMenu;
    PopFileInfoFont: TMenuItem;
    PopFiles: TPopupMenu;
    PopFilesSelectAll: TMenuItem;
    PopFilesDeselectAll: TMenuItem;
    PopFilesRefresh: TMenuItem;
    PopFilesSep1: TMenuItem;
    PopFilesChange: TMenuItem;
    PopFilesSep2: TMenuItem;
    PopFilesFont: TMenuItem;
    PopDate: TPopupMenu;
    PopDateCalendar: TMenuItem;
    PopDateFont: TMenuItem;
    PopTime: TPopupMenu;
    PopTimeFont: TMenuItem;
    PnlRight: TPanel;
    LblDate: TLabel;
    DatePicker: TDateTimePicker;
    LblTime: TLabel;
    TimePicker: TDateTimePicker;
    GrpSetTo: TRadioGroup;
    BtnChange: TBitBtn;
    BtnClose: TBitBtn;
    PnlLeft: TPanel;
    GrpDir: TGroupBox;
    GrpFile: TGroupBox;
    DirectoryListBox: TDirectoryListBox;
    FileListBox: TFileListBox;
    PnlBottom: TPanel;
    DirLabel: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    PnlDrive: TPanel;
    PnlMask: TPanel;
    LblDrive: TLabel;
    DriveComboBox: TDriveComboBox;
    LblMask: TLabel;
    FileMask: TEdit;
    Splitter: TSplitter;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure TimerTimer(Sender: TObject);
    procedure DirectoryListBoxChange(Sender: TObject);
    procedure DriveComboBox0Change(Sender: TObject);
    procedure FileListBoxChange(Sender: TObject);
    procedure FileMaskKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FileMaskExit(Sender: TObject);
    procedure GrpSetToClick(Sender: TObject);
    procedure MnuFileClick(Sender: TObject);
    procedure MnuFileSelectAllClick(Sender: TObject);
    procedure MnuFileDeselectAllClick(Sender: TObject);
    procedure MnuFileRefreshClick(Sender: TObject);
    procedure MnuFileChangeClick(Sender: TObject);
    procedure MnuFileExitClick(Sender: TObject);
    procedure MnuOptionsClick(Sender: TObject);
    procedure MnuOptFontFileInfoClick(Sender: TObject);
    procedure MnuOptFontDateTimeClick(Sender: TObject);
    procedure MnuOptCalendarClick(Sender: TObject);
    procedure MnuHlpAboutClick(Sender: TObject);
    procedure PopDatePopup(Sender: TObject);
    procedure PopFilesPopup(Sender: TObject);
    procedure FontDlgFileInfoApply(Sender: TObject; Wnd: Integer);
    procedure FontDlgDateTimeApply(Sender: TObject; Wnd: Integer);
    procedure SplitterMoved(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    procedure WMGetMinMaxInfo(var V_Msg: Tmessage); message WM_GetMinMaxInfo;
    procedure AdjustPaneWidth;
  public
    procedure OnException(Sender: TObject; E: Exception);
    procedure ApplyMask;
    procedure AdjustControls;
    procedure GetDateTime;
    procedure SelectAll(V_Select: boolean);
    function  SetFileDate(V_FileName: String; V_TimeStamp: integer): boolean;
    procedure ApplyFontFileInfo;
    procedure ApplyFontDateTime;
 end;

var
  MainWindow: TMainWindow;

implementation
Uses SetFD2;

{$R *.DFM}


{ --- private --- }

procedure TMainWindow.WMGetMinMaxInfo(var V_Msg: Tmessage);
begin
  with PMinMaxInfo(V_Msg.lparam)^.ptMinTrackSize do begin
    x:= GC_MinWinWidth;
    y:= GC_MinWinHeight;
  end;
  AdjustPaneWidth;
end;

procedure TMainWindow.AdjustPaneWidth;
begin if GV_FormReady then begin
  if GrpDir.Width  < GC_MinDirWidth then
     GrpDir.Width  := GC_MinDirWidth;
  if PnlLeft.Width - GrpDir.Width < GC_MinFilWidth then
     GrpDir.Width := PnlLeft.Width - GC_MinFilWidth;
end end;

{ --- public --- }

procedure TMainWindow.OnException(Sender: TObject; E: Exception);
begin
  if (E.Message = 'I/O error 21') then begin
    MessageDlg('Drive not ready',mtError,[mbOK],0);
    DriveComboBox.Drive:= DirLabel.Caption[1];
  end
  else
    Application.ShowException(E);
end;

procedure TMainWindow.ApplyMask;
begin with FileMask do begin
  if Text = '' then Text:= '*.*';
  FileListBox.Mask:= Text;
  GetDateTime;
  AdjustControls;
end end;

procedure TMainWindow.AdjustControls;
begin
  BtnChange.Enabled  := (GrpSetTo.Itemindex <> st_NoChange) and
                        (FileListBox.Items.Count > 0);
  DatePicker.Enabled := GrpSetTo.Itemindex = st_Specified;
  TimePicker.Enabled := GrpSetTo.Itemindex = st_Specified;
  Timer.Enabled      := GrpSetTo.Itemindex = st_Now;
  with DatePicker do if GV_OptCalendar then DateMode:= dmComboBox
                                       else DateMode:= dmUpDown;
end;

procedure TMainWindow.GetDateTime;
var i: integer; DateTime, FileDate: TDateTime;
  function GetNextFileDate: boolean;
  var found: boolean;
  begin with FileListBox do begin
    found:= false;
    while (i<Items.Count) and (not found) do begin
      if (SelCount < 1) or Selected[i] then begin
         FileDate:= FileDateToDateTime(FileAge(Items[i]));
         found:= true;
      end;
      inc(i);
    end;
    Result:= found;
  end; end;
begin if GrpSetTo.ItemIndex <> st_Specified then begin
  DateTime:= Now;
  if GrpSetTo.ItemIndex = st_Now then {ok}
  else if GrpSetTo.ItemIndex = st_NoChange then with FileListBox do begin
    if (Items.Count > 0) and (ItemIndex >= 0) then
      DateTime:= FileDateToDateTime(FileAge(Items[ItemIndex]));
  end
  else begin
    i:= 0;
    if GetNextFileDate then DateTime:= FileDate else DateTime:= Now;
    while GetNextFileDate do case GrpSetTo.ItemIndex of
      st_Lowest : if FileDate < DateTime then DateTime:= FileDate;
      st_Highest: if FileDate > DateTime then DateTime:= FileDate;
    end;
  end;
  TimePicker.Time:= DateTime;
  DatePicker.Date:= DateTime;
end; end;

procedure TMainWindow.SelectAll(V_Select: boolean);
var i: integer;
begin with FileListBox do begin
  Hide;
  for i:= Items.Count-1 downto 0 do
    Selected[i]:= V_Select;
  Show; SetFocus;
end; end;

function TMainWindow.SetFileDate
           (V_FileName: String; V_TimeStamp: integer): boolean;
var Handle: integer;
begin
  Handle:= FileOpen(DirLabel.Caption+'\'+V_FileName,fmOpenWrite);
  try
    if Handle > 0 then Result:= FileSetDate(Handle,V_TimeStamp) = 0
                  else Result:= false;
  finally FileClose(Handle) end;
end;

procedure TMainWindow.ApplyFontFileinfo;
begin
  DirectoryListBox.Font := FontDlgFileInfo.Font;
  FileListBox.Font      := FontDlgFileInfo.Font;
  DriveComboBox.Font    := FontDlgFileInfo.Font;
  FileMask.Font         := FontDlgFileInfo.Font;
  DirLabel.Font         := FontDlgFileInfo.Font;
end;

procedure TMainWindow.ApplyFontDateTime;
begin
  DatePicker.Font:= FontDlgdateTime.Font;
  TimePicker.Font:= FontDlgdateTime.Font;
end;


{ --- generated --- }

procedure TMainWindow.FormCreate(Sender: TObject);
begin
  Application.OnException:= OnException;
  Icon:= Application.Icon;
  ApplyFontFileInfo;
  ApplyFontDateTime;
end;

procedure TMainWindow.FormShow(Sender: TObject);
begin
  Application.Title  := GC_ProgTitle;
  MainWindow.Caption := GC_ProgTitle;
  GV_SettingFnm      := ChangeFileExt(Application.ExeName,GC_SettingExt);
  ReadOptions;
  GetDateTime;
  AdjustControls;
  GV_FormReady:= true;
end;

procedure TMainWindow.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  CanClose:= WriteOptions;
end;

procedure TMainWindow.TimerTimer(Sender: TObject);
begin
  GetDateTime;
end;

procedure TMainWindow.DirectoryListBoxChange(Sender: TObject);
begin
  AdjustControls;
end;

procedure TMainWindow.DriveComboBox0Change(Sender: TObject);
begin
  AdjustControls;
end;

procedure TMainWindow.FileListBoxChange(Sender: TObject);
begin
  GetDateTime;
end;

procedure TMainWindow.FileMaskKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Shift = []) and (Key = 13) then
    ApplyMask;
end;

procedure TMainWindow.FileMaskExit(Sender: TObject);
begin
  ApplyMask;
end;

procedure TMainWindow.GrpSetToClick(Sender: TObject);
begin
  GetDateTime;
  AdjustControls;
end;

procedure TMainWindow.MnuFileClick(Sender: TObject);
begin
  MnuFileChange.Enabled:= BtnChange.Enabled;
end;

procedure TMainWindow.MnuFileSelectAllClick(Sender: TObject);
begin
  SelectAll(true);
end;

procedure TMainWindow.MnuFileDeselectAllClick(Sender: TObject);
begin
  SelectAll(false);
end;

procedure TMainWindow.MnuFileRefreshClick(Sender: TObject);
begin
  FileListBox.Update;
end;

procedure TMainWindow.MnuFileChangeClick(Sender: TObject);
var fm: String; i: integer; TimeStamp: integer; ok: boolean;
begin with FileListBox do begin
  if (Items.Count>0) and (GrpSetTo.ItemIndex<>st_NoChange) then begin
    if SelCount < 1 then fm:= 'all files' else
    if SelCount = 1 then fm:= 'selected file'
                    else fm:= 'selected files';
    if MessageDlg(
      'Change date/time for '+fm+#13+'to: '+
      DateToStr(DatePicker.Date)+' '+TimeToStr(TimePicker.Time),
      mtConfirmation,mbOkCancel,0) = mrOK then begin
        TimeStamp:= DateTimeToFileDate(
          Trunc(DatePicker.Date)+
          TimePicker.Time-Trunc(TimePicker.Time));
        ok:= true; i:= 0;
        while ok and (i < Items.Count) do begin
          if (SelCount < 1) or Selected[i] then
            if not SetFileDate(Items[i],TimeStamp) then
              ok:= MessageDlg(
                'Unable to change date/time for'#13+
                'file '+Items[i],
                mtError,[mbOK,mbAbort],0) = mrOK;
          inc(i);
        end;
    end;
    GrpSetTo.ItemIndex:= st_NoChange
  end;
end end;

procedure TMainWindow.MnuFileExitClick(Sender: TObject);
begin
  Close;
end;

procedure TMainWindow.MnuOptionsClick(Sender: TObject);
begin
  MnuOptCalendar.Checked:= GV_OptCalendar;
end;

procedure TMainWindow.MnuOptFontFileInfoClick(Sender: TObject);
begin
  if FontDlgFileInfo.Execute then ApplyFontFileInfo;
end;

procedure TMainWindow.MnuOptFontDateTimeClick(Sender: TObject);
begin
  if FontDlgDateTime.Execute then ApplyFontDateTime;
end;

procedure TMainWindow.MnuOptCalendarClick(Sender: TObject);
begin
  GV_OptCalendar:= not GV_OptCalendar;
  AdjustControls;
end;

procedure TMainWindow.MnuHlpAboutClick(Sender: TObject);
begin
  Aboutbox.ShowModal;
end;

procedure TMainWindow.PopFilesPopup(Sender: TObject);
begin
  PopFilesChange.Enabled:= BtnChange.Enabled;
end;

procedure TMainWindow.PopDatePopup(Sender: TObject);
begin
  PopDateCalendar.Checked:= GV_OptCalendar;
end;

procedure TMainWindow.FontDlgFileInfoApply(Sender: TObject; Wnd: Integer);
begin
  ApplyFontFileInfo;
end;

procedure TMainWindow.FontDlgDateTimeApply(Sender: TObject; Wnd: Integer);
begin
  ApplyFontDateTime;
end;

procedure TMainWindow.SplitterMoved(Sender: TObject);
begin
  AdjustPaneWidth;
end;

procedure TMainWindow.FormResize(Sender: TObject);
begin
  AdjustPaneWidth;
end;

end.

