{ General }
unit SetFD0;

interface
uses
  SysUtils, WinProcs, Classes, Controls, Graphics, Forms, Dialogs,
  IniFiles;

const
{ global constants : general }
  GC_ProgIdn     = 'SetFDate';
  GC_ProgVers    = 'v1.2';
  GC_ProgDate    = 'Feb 14, 2000';
  GC_ProgTitle   = 'Set File Date';
  GC_Copyright   = 'Copyright  1998-2000, J.R. Ferguson';
  GC_AuthorEmail = 'j.r.ferguson@iname.com';
  GC_AuthorURL   = 'http://hello.to/ferguson';
  GC_ProgComment = 'Freeware - Windows 95/NT';
  GC_SettingExt  = '.ini';
  GC_DflCalendar = false;
  GC_MinDirWidth = 220;
  GC_MinFilWidth = 170;
  GC_MinWinWidth = 520;
  GC_MinWinHeight= 360;

var
  GV_SettingFnm  : String;
  GV_OptCalendar : boolean;

const
  GV_FormReady   : boolean = false;

procedure SetCursor(V_NewCursor: TCursor);
procedure RestoreCursor;
procedure ReadOptions;
function  WriteOptions: boolean;


implementation
uses SetFD1;

var
  OldCursor: TCursor;

procedure SetCursor(V_NewCursor: TCursor);
begin OldCursor:= Screen.Cursor; Screen.Cursor:= V_NewCursor; end;

procedure RestoreCursor;
begin Screen.Cursor:= OldCursor; end;

procedure ReadOptions;
var Bold, Italic: boolean; IniFile: TIniFile;
begin
  SetCursor(crHourglass); IniFile:= TIniFile.Create(GV_SettingFnm);
  if IniFile <> nil then with IniFile, MainWindow do try
    Left   := ReadInteger('Position','Left'  ,Left);
    Top    := ReadInteger('Position','Top'   ,Top);
    Width  := ReadInteger('Position','Width' ,Width);
    Height := ReadInteger('Position','Height',Height);
    with GrpDir do
      Width:= ReadInteger('Position','DirWidth',Width);
    with FontDlgFileInfo.Font do begin
      Name    := ReadString ('FileInfoFont' ,'Name'  ,Name);
      Size    := ReadInteger('FileInfoFont' ,'Size'  ,Size);
      Color   := ReadInteger('FileInfoFont' ,'Color' ,Color);
      Bold    := ReadBool   ('FileInfoFont' ,'Bold'  ,fsBold   in Style);
      Italic  := ReadBool   ('FileInfoFont' ,'Italic',fsItalic in Style);
      Style   := [];
      if Bold   then Style := Style + [fsBold];
      if Italic then Style := Style + [fsItalic];
      ApplyFontFileInfo;
    end;
    with FontDlgDateTime.Font do begin
      Name    := ReadString ('DateTimeFont' ,'Name'  ,Name);
      Size    := ReadInteger('DateTimeFont' ,'Size'  ,Size);
      Bold    := ReadBool   ('DateTimeFont' ,'Bold'  ,fsBold   in Style);
      Italic  := ReadBool   ('DateTimeFont' ,'Italic',fsItalic in Style);
      Style   := [];
      if Bold   then Style := Style + [fsBold];
      if Italic then Style := Style + [fsItalic];
      ApplyFontDateTime;
    end;
    GV_OptCalendar:= ReadBool('Options','Calendar',GC_DflCalendar);
  finally IniFile.Free; RestoreCursor; end;
end;

function  WriteOptions: boolean;
var IniFile: TIniFile;
begin
  Result:= true;
  SetCursor(crHourglass); IniFile:= TIniFile.Create(GV_SettingFnm);
  if IniFile <> nil then with IniFile, MainWindow do try try
    WriteInteger('Position','Left'  ,Left);
    WriteInteger('Position','Top'   ,Top);
    WriteInteger('Position','Width' ,Width);
    WriteInteger('Position','Height',Height);
    with GrpDir do
      WriteInteger('Position','DirWidth',Width);
    with FontDlgFileInfo.Font do begin
      WriteString ('FileInfoFont','Name'  ,Name);
      WriteInteger('FileInfoFont','Size'  ,Size);
      WriteInteger('FileInfoFont','Color' ,Color);
      WriteBool   ('FileInfoFont','Bold'  ,fsBold   in Style);
      WriteBool   ('FileInfoFont','Italic',fsItalic in Style);
    end;
    with FontDlgDateTime.Font do begin
      WriteString ('DateTimeFont','Name'  ,Name);
      WriteInteger('DateTimeFont','Size'  ,Size);
      WriteBool   ('DateTimeFont','Bold'  ,fsBold   in Style);
      WriteBool   ('DateTimeFont','Italic',fsItalic in Style);
    end;
    WriteBool('Options','Calendar',GV_OptCalendar);
  finally IniFile.Free; RestoreCursor; end;
  except on E: Exception do
    Result:= MessageDlg(E.Message,mtError,mbOKCancel,0) = mrOk;
  end;
end;

end.

