library SendFile;

uses
  Windows,
  SysUtils,
  MAPI,
  ShellAPI,
  FARIntf in 'FARIntf.pas',
  FARLang in 'FARLang.pas';

type PPluginStartupInfo = ^TPluginStartupInfo;

function OpenPlugin(OpenFrom: OPEN; Item: Integer): THandle; stdcall export;
var PInfo : TPanelInfo;
    i     : integer;
    S, S1 : String;
    S2	  : string;
    si    : TShellExecuteInfo;
    StartInfo: TStartupInfo;
    ProcInfo : TProcessInformation;

begin
  Result := INVALID_HANDLE_VALUE;

  Info.Control(INVALID_HANDLE_VALUE,FCTL_GETPANELINFO,@PInfo);

  S1 := StrPas(PInfo.CurDir) + '\';

  if PInfo.PanelType <> PTYPE_FILEPANEL then exit;

  S := '';

  for I:= 0 to PInfo.SelectedItemsNumber - 1 do
  begin
    if S <> '' then S := S + #13#10;
    S := S + StrPas(PInfo.SelectedItems[i].FindData.cFileName);
  end;
  S2 := ExtractFilePath(Info.ModuleName);

  FillMemory(@si, sizeof(TShellExecuteInfo), 0);
  si.cbSize := SizeOf(TShellExecuteInfo);
  si.fMask  := SEE_MASK_NOCLOSEPROCESS or SEE_MASK_FLAG_DDEWAIT;
  si.lpFile := PChar(S2 + 'SendFileEx.exe');
  si.lpParameters := PChar('"' + S1 + '"' +#32 + '"' + S + '"');
  si.lpDirectory := PChar(S1);
  si.nShow := SW_SHOWNORMAL;
  ShellExecuteEx(@si);
end;

var PluginStrings: array[0..0] of PChar;

procedure GetPluginInfo(
  var Info: TPluginInfo);
  stdcall export;
begin
  with Info do
  begin
    StructSize := SizeOf(Info);
    Flags := PF_0;

    DiskMenuStringsNumber := 0;

    PluginStrings[0]:=GetMsg(MPluginMenuString);
    PluginMenuStrings:=@PluginStrings;
    PluginMenuStringsNumber:=1;
    PluginConfigStringsNumber:=0;

    CommandPrefix:=nil;
  end;
end;

exports
  OpenPlugin,
  GetPluginInfo;

begin
end.
