#include "stdafx.h"

#include "ruler.hpp"
#include "dlgruler.hpp"
#include "actions.hpp"

#ifdef __cplusplus
extern "C"{
#endif
  BOOL WINAPI DllMainCRTStartup(HANDLE hDll,DWORD dwReason,LPVOID lpReserved);
#ifdef __cplusplus
};
#endif

BOOL WINAPI DllMainCRTStartup(HANDLE hDll,DWORD dwReason,LPVOID lpReserved)
{
  (void) hDll;
  (void) dwReason;
  (void) lpReserved;
  return TRUE;
}

void WINAPI _export GetPluginInfo(struct PluginInfo *Info)
{
  Info->StructSize = sizeof(struct PluginInfo);

  Info->Flags = PF_EDITOR | PF_VIEWER; // | PF_PRELOAD;

  static char *PluginMenuStrings[1];
  PluginMenuStrings[0] = (char*)GetMsg(MName);
  Info->PluginMenuStrings = PluginMenuStrings;
  Info->PluginMenuStringsNumber = sizeof(PluginMenuStrings) / sizeof(PluginMenuStrings[0]);

  Info->CommandPrefix = "ruler";
}

void WINAPI _export SetStartupInfo(const struct PluginStartupInfo *pInfo)
{
  ::FarInfo = *pInfo;
  FSF = *pInfo->FSF;
  wsprintf(PluginRootKey,"%s\\Ruler", FarInfo.RootKey);
}

HANDLE WINAPI _export OpenPlugin(int OpenFrom, int Item)
{
  UINT i;
  int WhatDo = DoNothing;
  char **CmdParams;
  int CmdParamsCount;
  RECT Region;

  G_FarWnd = (HWND)FarInfo.AdvControl(FarInfo.ModuleNumber, ACTL_GETFARHWND, 0);
  OnChangeConsoleSize();

  if (OpenFrom == OPEN_COMMANDLINE)
  {
    parse_cmdline((char*)Item, NULL, NULL, (UINT*)&CmdParamsCount, &i);
    if (CmdParamsCount > 0)
    {
      CmdParams = (char**)malloc(CmdParamsCount * sizeof(char*) + i * sizeof(char) + 1);
      parse_cmdline((char*)Item, CmdParams,
        ((char*)CmdParams) + sizeof(char*) * CmdParamsCount,
        (UINT*)&CmdParamsCount, &i);
      static const char ActionsList[DoLast - DoFirst + 1][16] = {"", "CopyAsText", "CopyAsBitmap"};
      for (i = DoFirst; i <= DoLast; i++)
        if (lstrcmpi(CmdParams[0], ActionsList[i]) == 0)
          WhatDo = i;

      if (WhatDo == DoCopyAsText || WhatDo == DoCopyAsBitmap)
      {
        if (CmdParamsCount == 1)
          SetRect(&Region, 0, 0, G_FarBufInfo.dwSize.X - 1, G_FarBufInfo.dwSize.Y - 1);
        else
        {
          if (CmdParamsCount >= 5)
          {
            int left, top, right, bottom;
            if (Val(CmdParams[1], &left) && Val(CmdParams[2], &top) &&
                Val(CmdParams[3], &right) && Val(CmdParams[4], &bottom))
            {
              left   = Add(left,   0, 0, G_FarBufInfo.dwSize.X - 1);
              top    = Add(top,    0, 0, G_FarBufInfo.dwSize.Y - 1);

              right  = Add(right,  0, 0, G_FarBufInfo.dwSize.X - 1);
              bottom = Add(bottom, 0, 0, G_FarBufInfo.dwSize.Y - 1);

              SetRect(&Region, left, top, right, bottom);
            }
            else
              WhatDo = DoNothing;
          }
        }
      }
      free(CmdParams);
    }
  }

  switch (WhatDo)
  {
    case DoNothing:
      ShowDialog();
      break;

    case DoCopyAsText:
      CopyAsText(&Region);
      break;

    case DoCopyAsBitmap:
      CopyAsBitmap(SavedHDC, &Region);
      break;
  }

  return INVALID_HANDLE_VALUE;
}
