#include "stdafx.h"

#include "global.hpp"

struct PluginStartupInfo FarInfo;
FARSTANDARDFUNCTIONS FSF;
char PluginRootKey[100];

CONSOLE_SCREEN_BUFFER_INFO G_FarBufInfo;
CHAR_INFO *SavedScreenBuffer = NULL;
HDC SavedHDC;
RECT RulerRegion;
HWND G_FarWnd;
COORD lastMousePos;

const char *GetMsg(int MsgId)
{
  return (MsgId == -1 ? "" : FarInfo.GetMsg(FarInfo.ModuleNumber, MsgId));
}

int Add(int summand1, int summand2, int minValue, int maxValue)
{
  int sum = summand1 + summand2;

  if (sum < minValue) sum = minValue;
  if (sum > maxValue) sum = maxValue;

  return sum;
}

BOOL MyPtInRect(CONST RECT *pRect, int x, int y)
{
  return (x >= min(pRect->left, pRect->right) &&
          x <= max(pRect->left, pRect->right) &&
          y >= min(pRect->top, pRect->bottom) &&
          y <= max(pRect->top, pRect->bottom));
}

#pragma warning( disable : 4706)
char * __cdecl strncat (char * front, const char * back, size_t count)
{
  char *start = front;

  while (*front++)
    ;
  front--;

  while (count--)
    if (!(*front++ = *back++))
       return(start);

  *front = '\0';
  return(start);
}
#pragma warning( default : 4706)

int IsSpace(int c)
{
  return ((c) == 0x20 || ((c) >= 0x09 && (c) <= 0x0D));
}

void parse_cmdline(char *cmdstart, char **argv, char *args, UINT *numargs, UINT *numchars)
{
  char *p;
  int inquote;                    /* 1 = inside quotes */
  int copychar;                   /* 1 = copy char to *args */
  unsigned numslash;              /* num of backslashes seen */

  *numchars = 0;
  *numargs = 0;

  p = cmdstart;

  inquote = 0;

  /* loop on each argument */
  for(;;) {

    while (IsSpace((int)*p)) ++p;

    if (*p == '\0')break;   /* end of args */

    /* scan an argument */
    if (argv) *argv++ = args;     /* store ptr to arg */
    ++*numargs;

    /* loop through scanning one argument */
    for (;;) {
      copychar = 1;
      /* Rules: 2N backslashes + " ==> N backslashes and begin/end quote
         2N+1 backslashes + " ==> N backslashes + literal "
         N backslashes ==> N backslashes */
      numslash = 0;
      while (*p == '\\') { /* count number of backslashes for use below */
        ++p;
        ++numslash;
      }
      if (*p == '\"') {
      /* if 2N backslashes before, start/end quote, otherwise
        copy literally */
        if ((numslash & 1) == 0) {
          if (inquote) {
            if (p[1] == '\"')
              p++;    /* Double quote inside quoted string */
            else        /* skip first quote char and copy second */
              copychar = 0;
          } else copychar = 0;       /* don't copy quote */
          inquote = !inquote;
        }
        numslash >>= 1;             /* divide numslash by two */
      }

      /* copy slashes */
      while (numslash--) {
        if (args) *args++ = '\\';
        ++*numchars;
      }

      /* if at end of arg, break loop */
      if (*p == '\0' || (!inquote && IsSpace((int)*p))) break;

      /* copy character into argument */
      if (copychar) {
        if (args) *args++ = *p;
        ++*numchars;
      }
      ++p;
    }

    /* null-terminate the argument */

    if (args) *args++ = '\0';          /* terminate string */
    ++*numchars;
  }
}

void OnChangeConsoleSize(void)
{
  HANDLE hStdout = GetStdHandle(STD_OUTPUT_HANDLE);

  if (hStdout != INVALID_HANDLE_VALUE)
  {
    if (GetConsoleScreenBufferInfo(hStdout, &G_FarBufInfo))
    {
      COORD dwBufferSize = {G_FarBufInfo.dwSize.X, G_FarBufInfo.dwSize.Y};
      COORD dwBufferCoord = {0, 0};
      SMALL_RECT ReadRegion = {0, 0, G_FarBufInfo.dwSize.X - 1, G_FarBufInfo.dwSize.Y - 1};

      if (SavedScreenBuffer)
        free(SavedScreenBuffer);

      SavedScreenBuffer = (CHAR_INFO*)malloc(sizeof(CHAR_INFO) * G_FarBufInfo.dwSize.X * G_FarBufInfo.dwSize.Y);

      ReadConsoleOutput(hStdout, SavedScreenBuffer, dwBufferSize, dwBufferCoord, &ReadRegion);
    }
  }

  HGDIOBJ hbm;
  RECT rc;

  GetClientRect(G_FarWnd, &rc);
  HDC hdcScr = GetDC(G_FarWnd);
  if (SavedHDC)
    DeleteDC(SavedHDC);
  SavedHDC = CreateCompatibleDC(hdcScr);
  hbm = CreateCompatibleBitmap(hdcScr, rc.right, rc.bottom);
  SelectObject(SavedHDC, hbm);
  BitBlt(SavedHDC, 0, 0, rc.right, rc.bottom, hdcScr, rc.left, rc.top, SRCCOPY);
}

BOOL Val(LPCTSTR lpSrc, int *Result)
{
#define ISDIGIT(c)  ((c) >= TEXT('0') && (c) <= TEXT('9'))

  BOOL bRes = FALSE;

  int n = 0;
  BOOL bNeg = FALSE;

  if (*lpSrc == TEXT('-'))
  {
    bNeg = TRUE;
    lpSrc++;
  }

  while (ISDIGIT(*lpSrc))
  {
    bRes = TRUE;
    n *= 10;
    n += *lpSrc - TEXT('0');
    lpSrc++;
  }

  if (bRes)
  {
    *Result = (bNeg ? -n : n);
    return TRUE;
  }
  else
  {
    return FALSE;
  }
}

int CopyAsText(RECT *Region)
{
  OSVERSIONINFO WinVer;
  WinVer.dwOSVersionInfoSize = sizeof (OSVERSIONINFO);
  GetVersionEx (&WinVer);

  long DataSize;
  CHAR *Data = (CHAR*)malloc((G_FarBufInfo.dwSize.Y * (G_FarBufInfo.dwSize.X + 2) + 1) * sizeof(WCHAR));

  lstrcpy(Data, "");
  for (int j = Region->top; j <= Region->bottom; j++)
  {
    for (int i = Region->left; i <= Region->right; i++)
    {
      strncat((CHAR*)Data, &SavedScreenBuffer[j * G_FarBufInfo.dwSize.X + i].Char.AsciiChar, 1);
    }
    strncat((CHAR*)Data, "\r\n", 2);
  }

  if (Data != NULL && (DataSize = lstrlen(Data)) != 0)
  {
    HGLOBAL hData;
    void *GData;
    if (!OpenClipboard(NULL))
      return (FALSE);
    EmptyClipboard();
    int BufferSize = DataSize + 1;
    if ((hData = GlobalAlloc(GMEM_MOVEABLE | GMEM_DDESHARE, BufferSize)) != NULL)
      if ((GData = GlobalLock(hData))!=NULL)
      {
        CopyMemory(GData, Data, DataSize+1);
        GlobalUnlock(hData);
        SetClipboardData(CF_OEMTEXT, (HANDLE)hData);
      }
    if ((hData = GlobalAlloc(GMEM_MOVEABLE | GMEM_DDESHARE, BufferSize)) != NULL)
      if ((GData = GlobalLock(hData)) != NULL)
      {
        CopyMemory(GData, Data, DataSize + 1);
        OemToChar((LPCSTR)GData, (LPTSTR)GData);
        GlobalUnlock(hData);
        SetClipboardData(CF_TEXT, (HANDLE)hData);
      }
    if (WinVer.dwPlatformId == VER_PLATFORM_WIN32_NT)
      if ((hData=GlobalAlloc(GMEM_MOVEABLE | GMEM_DDESHARE, BufferSize * 2)) != NULL)
        if ((GData=GlobalLock(hData)) != NULL)
        {
          MultiByteToWideChar(CP_OEMCP, 0, Data, -1, (LPWSTR)GData, BufferSize);
          GlobalUnlock(hData);
          SetClipboardData(CF_UNICODETEXT, (HANDLE)hData);
        }
    CloseClipboard();
  }

  free(Data);

  return TRUE;
}

int CopyAsBitmap(HDC dc, RECT *Region)
{
  HDC hdcMem = NULL;
  HGDIOBJ hbmOld;

  RECT FarRect;
  HGDIOBJ hbm;

  GetClientRect(G_FarWnd, &FarRect);
  int dx = (FarRect.right - FarRect.left) / G_FarBufInfo.dwSize.X;
  int dy = (FarRect.bottom - FarRect.top) / G_FarBufInfo.dwSize.Y;
  RECT rc;
  SetRect(&rc, Region->left * dx, Region->top * dy,
    (Region->right - Region->left + 1) * dx,
    (Region->bottom - Region->top + 1) * dy);

  hdcMem = CreateCompatibleDC(dc);
  hbm = CreateCompatibleBitmap(dc, rc.right, rc.bottom);
  hbmOld = SelectObject(hdcMem, hbm);
  BitBlt(hdcMem, 0, 0, rc.right, rc.bottom, dc, rc.left, rc.top, SRCCOPY);
  SelectObject(hdcMem, hbmOld);

  OpenClipboard(NULL);
  EmptyClipboard();
  SetClipboardData(CF_BITMAP, hbm);
  CloseClipboard();

  DeleteDC(hdcMem);

  return TRUE;
}
