#include "stdafx.h"

#include "dlgruler.hpp"
#include "actions.hpp"

static BOOL ResizeHack;

long WINAPI DlgProc(HANDLE hDlg, int Msg, int Param1, long Param2)
{
  long result;

  switch (Msg)
  {
  case DN_INITDIALOG:
    if (dlgMainOnInitDialog(hDlg, Msg, Param1, Param2, &result))
      return result;
    break;

  case DN_KEY:
    if (dlgMainOnKey(hDlg, Msg, Param1, Param2, &result))
      return result;
    break;

  case DN_MOUSEEVENT:
    if (dlgMainOnMouseEvent(hDlg, Msg, Param1, Param2, &result))
      return result;
    break;

  case DN_DRAWDLGITEM:
    if (dlgMainOnDrawDlgItem(hDlg, Msg, Param1, Param2, &result))
      return result;
    break;

  case DN_RESIZECONSOLE:
    if (dlgMainOnResizeConsole(hDlg, Msg, Param1, Param2, &result))
      return result;
    break;

  case DN_CLOSE:
    if (dlgMainOnClose(hDlg, Msg, Param1, Param2, &result))
      return result;
    break;
  }

  return FarInfo.DefDlgProc(hDlg, Msg, Param1, Param2);
}

BOOL dlgMainOnInitDialog(HANDLE hDlg, int Msg, int Param1, long Param2, long *Result)
{
  (void) Msg;
  (void) Param1;
  (void) Param2;

  ResizeHack = TRUE;

  lastMousePos.X = 0;
  lastMousePos.Y = 0;

  //稬 ࠡ稪 DN_MOUSEEVENT
  FarInfo.SendDlgMessage(hDlg, DM_SETMOUSEEVENTNOTIFY , 1, 0);

  *Result = FALSE;
  return TRUE;
}

BOOL dlgMainOnResizeConsole(HANDLE hDlg, int Msg, int Param1, long Param2, long *Result)
{
  (void) Msg;
  (void) Param1;
  (void) Param2;
  (void) Result;

  if (!ResizeHack)
    FarInfo.SendDlgMessage(hDlg, DM_CLOSE, -10, 0);

  ResizeHack = !ResizeHack;

  *Result = TRUE;
  return TRUE;
}

BOOL dlgMainOnClose(HANDLE hDlg, int Msg, int Param1, long Param2, long *Result)
{
  (void) hDlg;
  (void) Msg;
  (void) Param1;
  (void) Param2;

  *Result = TRUE;
  return TRUE;
}

BOOL dlgMainOnKey(HANDLE hDlg, int Msg, int Param1, long Param2, long *Result)
{
  (void) Msg;
  (void) Param1;

  *Result = TRUE;

  int movements[23][5] = {
    KEY_LEFT,                         -1,  0, -1,  0,
    KEY_RIGHT,                         1,  0,  1,  0,
    KEY_UP,                            0, -1,  0, -1,
    KEY_DOWN,                          0,  1,  0,  1,

    KEY_LEFT  | KEY_CTRL,             -8,  0, -8,  0,
    KEY_RIGHT | KEY_CTRL,              8,  0,  8,  0,
    KEY_UP    | KEY_CTRL,              0, -8,  0, -8,
    KEY_DOWN  | KEY_CTRL,              0,  8,  0,  8,

    KEY_LEFT  | KEY_SHIFT,             0,  0, -1,  0,
    KEY_RIGHT | KEY_SHIFT,             0,  0,  1,  0,
    KEY_UP    | KEY_SHIFT,             0,  0,  0, -1,
    KEY_DOWN  | KEY_SHIFT,             0,  0,  0,  1,

    KEY_LEFT  | KEY_SHIFT | KEY_CTRL,  0,  0, -8,  0,
    KEY_RIGHT | KEY_SHIFT | KEY_CTRL,  0,  0,  8,  0,
    KEY_UP    | KEY_SHIFT | KEY_CTRL,  0,  0,  0, -8,
    KEY_DOWN  | KEY_SHIFT | KEY_CTRL,  0,  0,  0,  8,

    KEY_HOME,                          -RulerRegion.left,  0,  -RulerRegion.left,  0,
    KEY_END,                           G_FarBufInfo.dwSize.X - RulerRegion.right - 1,
                                       0, G_FarBufInfo.dwSize.X - RulerRegion.right - 1, 0,
    KEY_PGUP,                          0, -RulerRegion.top, 0, -RulerRegion.top,
    KEY_PGDN,                          0, G_FarBufInfo.dwSize.Y - RulerRegion.bottom - 1,
                                       0, G_FarBufInfo.dwSize.Y - RulerRegion.bottom - 1,

    KEY_CTRL+'A',                      -1024, -1024, 1024, 1024,

    KEY_TAB,                           8,  0,  8,  0,
    KEY_TAB   | KEY_SHIFT,            -8,  0, -8,  0,
  };

  for (int i = 0; i < 23; i++)
  {
    if (Param2 == movements[i][0])
    {
      RulerRegion.left = Add(RulerRegion.left, movements[i][1], 0, G_FarBufInfo.dwSize.X - 1);
      RulerRegion.top = Add(RulerRegion.top, movements[i][2], 0, G_FarBufInfo.dwSize.Y - 1);

      RulerRegion.right = Add(RulerRegion.right, movements[i][3], 0, G_FarBufInfo.dwSize.X - 1);
      RulerRegion.bottom = Add(RulerRegion.bottom, movements[i][4], 0, G_FarBufInfo.dwSize.Y - 1);

      FarInfo.SendDlgMessage(hDlg, DM_REDRAW, 0, 0);

      *Result = TRUE;
      return TRUE;
    }
  }

  switch (Param2)
  {
  case KEY_ALT | KEY_SHIFT | KEY_F9:
    *Result = TRUE;
    return TRUE;

  case KEY_ENTER:
  case KEY_APPS:
    ShowActionsMenu(RulerRegion.right, RulerRegion.bottom);
    *Result = TRUE;
    return TRUE;
  }

  *Result = FALSE;
  return TRUE;
}

BOOL dlgMainOnMouseEvent(HANDLE hDlg, int Msg, int Param1, long Param2, long *Result)
{
  (void) Msg;
  (void) Param1;
  (void) Result;

  SMALL_RECT DlgRect;
  MOUSE_EVENT_RECORD m_record = *(MOUSE_EVENT_RECORD*)Param2;

  int mx = m_record.dwMousePosition.X;
  int my = m_record.dwMousePosition.Y;

  BOOL Selected = (RulerRegion.left != RulerRegion.right) ||
                  (RulerRegion.top != RulerRegion.bottom);

  FarInfo.SendDlgMessage(hDlg, DM_GETDLGRECT, 0, (long)&DlgRect);

  if (m_record.dwButtonState == RIGHTMOST_BUTTON_PRESSED)
  {
    if (Selected)
    {
      ShowActionsMenu(mx, my);

      *Result = FALSE;
      return TRUE;
    }
  }

  if (lastMousePos.X != mx || lastMousePos.Y != my)
  {
    if (m_record.dwButtonState == FROM_LEFT_1ST_BUTTON_PRESSED)
    {
      RulerRegion.right = mx;
      RulerRegion.bottom = my;
    }
    else
    {
      if (!Selected)
      {
        RulerRegion.left = mx;
        RulerRegion.top = my;

        RulerRegion.right = mx;
        RulerRegion.bottom = my;
      }
      else
      {
        if (!MyPtInRect(&RulerRegion, mx, my))
        {
          RulerRegion.left = mx;
          RulerRegion.top = my;

          RulerRegion.right = mx;
          RulerRegion.bottom = my;
        }
      }
    }
    lastMousePos = m_record.dwMousePosition;
    FarInfo.SendDlgMessage(hDlg, DM_REDRAW, 0, 0);
  }

  //*Result = FALSE;
  return FALSE;
}

void DrawLine(CHAR_INFO *VBuf, int x, int y, int len, int direction, WORD attr1, WORD attr2)
{
  int delta[4] = {1, G_FarBufInfo.dwSize.X, -1, -G_FarBufInfo.dwSize.X};

  VBuf = &VBuf[y * G_FarBufInfo.dwSize.X + x];

  for(int i = x; i < x + len; i++, VBuf += delta[direction])
  {
    int k = (i - x  + 1) % 10;
    if (k == 0)
    {
      VBuf->Attributes = attr2;
      VBuf->Char.AsciiChar = (char)((i - x + 1) / 10) % 10 + '0';
    }
    else
    {
      VBuf->Attributes = attr1;
      VBuf->Char.AsciiChar = (char)k + '0';
    }
  }
}

void DrawStr(CHAR_INFO *VBuf, int x, int y, const char *str, WORD color)
{
  VBuf = &VBuf[y * G_FarBufInfo.dwSize.X + x];

  for (int i = 0; i < lstrlen(str); i++, VBuf++)
  {
    VBuf->Attributes = color;
    VBuf->Char.AsciiChar = str[i];
  }
}

BOOL dlgMainOnDrawDlgItem(HANDLE hDlg, int Msg, int Param1, long Param2, long *Result)
{
  (void) hDlg;
  (void) Msg;
  (void) Param2;
  (void) Result;

  struct FarDialogItem *DialogItem;
  WORD attr1, attr2, attr3, attr4;
  CHAR_INFO *VBuf, *VBufTmp;

  switch (Param1)
  {
    case dlgMain_ucRuler:
      DialogItem = (FarDialogItem*)Param2;

      attr1 = (WORD)FarInfo.AdvControl(FarInfo.ModuleNumber, ACTL_GETCOLOR, (void *)COL_HELPTEXT);
      attr2 = (WORD)FarInfo.AdvControl(FarInfo.ModuleNumber, ACTL_GETCOLOR, (void *)COL_HELPHIGHLIGHTTEXT);

      attr3 = (WORD)FarInfo.AdvControl(FarInfo.ModuleNumber, ACTL_GETCOLOR, (void *)COL_EDITORSELECTEDTEXT);
      attr4 = (WORD)FarInfo.AdvControl(FarInfo.ModuleNumber, ACTL_GETCOLOR, (void *)COL_HELPTOPIC);

      VBuf = &DialogItem->VBuf[0];

      CopyMemory(VBuf, SavedScreenBuffer, sizeof(CHAR_INFO) * G_FarBufInfo.dwSize.X * G_FarBufInfo.dwSize.Y);

      int x1, x2, y1, y2, xSign, ySign;

      x1 = min(RulerRegion.left, RulerRegion.right);
      x2 = max(RulerRegion.left, RulerRegion.right);

      y1 = min(RulerRegion.top, RulerRegion.bottom);
      y2 = max(RulerRegion.top, RulerRegion.bottom);

      xSign = (RulerRegion.left < RulerRegion.right ? 0 : 1);
      ySign = (RulerRegion.top < RulerRegion.bottom ? 0 : 1);

      DrawLine(VBuf, RulerRegion.left, RulerRegion.bottom, x2 - x1, (xSign == 0 ? 0 : 2), attr1, attr2);
      DrawLine(VBuf, RulerRegion.right, RulerRegion.top, y2 - y1, (ySign == 0 ? 1 : 3), attr1, attr2);

      DrawLine(VBuf, RulerRegion.left, RulerRegion.top,
        G_FarBufInfo.dwSize.X - RulerRegion.left, 0, attr1, attr2);
      DrawLine(VBuf, RulerRegion.left, RulerRegion.top,
        G_FarBufInfo.dwSize.Y - RulerRegion.top, 1, attr1, attr2);

      DrawLine(VBuf, RulerRegion.left, RulerRegion.top,
        RulerRegion.left + 1, 2, attr1, attr2);
      DrawLine(VBuf, RulerRegion.left, RulerRegion.top,
        RulerRegion.top + 1, 3, attr1, attr2);

      VBufTmp = &VBuf[RulerRegion.bottom * G_FarBufInfo.dwSize.X + RulerRegion.right];
      VBufTmp->Attributes = attr1;
      VBufTmp->Char.AsciiChar = ''; //

      // 뤥 
      VBufTmp = &VBuf[(y1 + 1) * G_FarBufInfo.dwSize.X + x1 + 1];
      for (int j = y1 + 1; j < y2; j++, VBufTmp += (G_FarBufInfo.dwSize.X - (x2 - x1 - 1)))
      {
        for (int i = x1 + 1; i < x2; i++, VBufTmp++)
        {
          switch (1)
          {
            //default
            case 0:
              if ((VBufTmp->Attributes & 0x70) == 0x70)
                VBufTmp->Attributes = 0x87;
              else
                VBufTmp->Attributes = 0x07;
              break;

            //invert
            case 1:
              VBufTmp->Attributes = ~VBufTmp->Attributes;
              break;

            //like DN
            case 2:
              VBufTmp->Attributes = (VBufTmp->Attributes ^ 0x7f) & 0x7f;
              if (VBuf->Attributes == 0)
                VBufTmp->Attributes = 0x07;
              break;
          }
        }
      }

      //⮡ࠦ ࠧ 뤥 
      char buf[128];
      wsprintf(buf, "%d:%d", x2 - x1 + 1, y2 - y1 + 1);
      int len = lstrlen(buf);
      if (x2 - x1 > lstrlen(buf) && y2 - y1 > 1)
      {
        int StartX = RulerRegion.left + 1 - xSign * (len + 1);
        int StartY = RulerRegion.top + 1 - ySign * 2;
        VBufTmp = &VBuf[StartY * G_FarBufInfo.dwSize.X + StartX];
        WORD attr = 0xff - VBufTmp->Attributes;

        DrawStr(VBuf, StartX, StartY, buf, attr);
      }

      break;
  }

  //*Result = TRUE;
  return FALSE;
}

void ShowDialog(void)
{
  int ExitCode;
  struct FarDialogItem DialogItems[2];

  do
  {
    RulerRegion.left   = G_FarBufInfo.dwCursorPosition.X;
    RulerRegion.top    = G_FarBufInfo.dwCursorPosition.Y;
    RulerRegion.right  = G_FarBufInfo.dwCursorPosition.X;
    RulerRegion.bottom = G_FarBufInfo.dwCursorPosition.Y;

    ZeroMemory(&DialogItems[0], sizeof(DialogItems));
    DialogItems[dlgMain_sbBox].Type = DI_SINGLEBOX;
    DialogItems[dlgMain_sbBox].X2 = G_FarBufInfo.dwSize.X;
    DialogItems[dlgMain_sbBox].Y2 = G_FarBufInfo.dwSize.Y;
    lstrcpy(DialogItems[dlgMain_sbBox].Data, GetMsg(MName));

    DialogItems[dlgMain_ucRuler].Type = DI_USERCONTROL;
    DialogItems[dlgMain_ucRuler].X2 = G_FarBufInfo.dwSize.X;
    DialogItems[dlgMain_ucRuler].Y2 = G_FarBufInfo.dwSize.Y;

    DialogItems[dlgMain_ucRuler].VBuf = (CHAR_INFO*)malloc(
      sizeof(CHAR_INFO) * G_FarBufInfo.dwSize.X * G_FarBufInfo.dwSize.Y);

    ExitCode = FarInfo.DialogEx(FarInfo.ModuleNumber,
      0, 0,
      G_FarBufInfo.dwSize.X - 1, G_FarBufInfo.dwSize.Y - 1,
      "Contents",
      DialogItems, sizeof(DialogItems) / sizeof(DialogItems[0]),
      0, FDLG_NODRAWPANEL | FDLG_NODRAWSHADOW, DlgProc, 0
    );

    free(DialogItems[dlgMain_ucRuler].VBuf);

    if (ExitCode == -10)
      OnChangeConsoleSize();
  }
  while (ExitCode == -10);
}
