#include "stdafx.h"
#include "ruler.hpp"
#include "getmsg.hpp"

#ifdef __cplusplus
extern "C"{
#endif
  BOOL WINAPI DllMainCRTStartup(HANDLE hDll,DWORD dwReason,LPVOID lpReserved);
#ifdef __cplusplus
};
#endif

BOOL WINAPI DllMainCRTStartup(HANDLE hDll,DWORD dwReason,LPVOID lpReserved)
{
  (void) hDll;
  (void) dwReason;
  (void) lpReserved;
  return TRUE;
}

PluginStartupInfo FarInfo;
FARSTANDARDFUNCTIONS FSF;
DialogPluginStartupInfo DialogInfo;
char PluginRootKey[100];
char RulerPath[MAX_PATH] = "";

PluginStartupInfo RulerInfo;
SetStartupInfoProc SetStartupInfoRuler = NULL;
OpenPluginProc OpenPluginRuler = NULL;

const char* WINAPI RulerGetMsg(int PluginNumber,int MsgId)
{
  (void)PluginNumber;

  UpdateLanguage(RulerPath);

  if (MsgId >= 0 && MsgId < MessagesCount)
    return Messages[MsgId];
  else
    return "";
}

char *GetMsg(int MsgNum,char *Str)
{
  DialogInfo.GetMsg(DialogInfo.MessageName, MsgNum, Str);
  return Str;
}

HINSTANCE TryLoadLibrary(const char* FileName)
{
  char LibraryPath[MAX_PATH];
  FSF.ExpandEnvironmentStr(FileName, LibraryPath, sizeof(LibraryPath));
  HINSTANCE result = LoadLibrary(LibraryPath);
  if (!result)
  {
    int error = GetLastError();

    char Title[128];
    GetMsg(mName, Title);

    char Msg[1024];
    wsprintf(Msg, "%s\n%s", Title, LibraryPath);

    SetLastError(error);
    FarInfo.Message(FarInfo.ModuleNumber,
      FMSG_ALLINONE | FMSG_WARNING | FMSG_ERRORTYPE | FMSG_MB_OK,
      NULL,
      (const char * const *) Msg,
      0, 0);
  }

  return result;
}

int WINAPI _export Start(const struct PluginStartupInfo *FarInfo,const struct DialogPluginStartupInfo *DialogInfo)
{
  ::FarInfo = *FarInfo;
  FSF=*FarInfo->FSF;
  ::DialogInfo = *DialogInfo;
  wsprintf(PluginRootKey, "%s\\Ruler", ::DialogInfo.RootKey);
  lstrcpy(RulerPath, "C:\\Program Files\\Far\\Plugins\\Ruler\\ruler.dll");

  HKEY hKey;
  if(RegOpenKeyEx(HKEY_CURRENT_USER, PluginRootKey, 0, KEY_READ, &hKey) == ERROR_SUCCESS)
  {
    DWORD Type = REG_SZ;
    DWORD DataSize = sizeof(RulerPath);
    RegQueryValueEx(hKey, "RulerPath", 0, &Type, (BYTE *)RulerPath, &DataSize);
    RegCloseKey(hKey);
  }
  return 0;
}

void WINAPI _export Exit(void)
{
  SetStartupInfoRuler = NULL;
  OpenPluginRuler = NULL;
}

int WINAPI _export Message(unsigned long Msg,void *InData,void *OutData)
{
  (void)InData;
  (void)OutData;

  switch(Msg)
  {
    case FMMSG_GETINFO:
      {
        GetInfoOutData *data = (GetInfoOutData *)OutData;
        GetMsg(mName, data->MenuString);
        strcpy(data->HotkeyID, "e6y_ruler");
        data->Flags = FMMSG_MENU;
      }
      return TRUE;
    case FMMSG_MENU:
      {
        BOOL wasLoaded = TRUE;
        HMODULE hRuler;
        hRuler = GetModuleHandle("ruler.dll");
        if (!hRuler)
        {
          wasLoaded = FALSE;
          hRuler = TryLoadLibrary(RulerPath);
        }

        if (!hRuler)
        {
          char GetRulerPathTitle[512];
          char GetRulerPathPrompt[512];
          GetMsg(mGetRulerPathTitle, GetRulerPathTitle);
          GetMsg(mGetRulerPathPrompt, GetRulerPathPrompt);

          int ExitCode;
          do
          {
            ExitCode = FarInfo.InputBox(GetRulerPathTitle, GetRulerPathPrompt,
              NULL, RulerPath, RulerPath, sizeof(RulerPath), NULL, FIB_BUTTONS);

            if (ExitCode)
            {
              HKEY hKey;
              DWORD Disposition;
              if(RegCreateKeyEx(HKEY_CURRENT_USER, PluginRootKey, 0, NULL, 0, KEY_WRITE, NULL, &hKey, &Disposition) == ERROR_SUCCESS)
              {
                RegSetValueEx(hKey, "RulerPath", 0, REG_SZ, (BYTE *)&RulerPath, lstrlen(RulerPath) + 1);
                RegCloseKey(hKey);
              }
              hRuler = TryLoadLibrary(RulerPath);
            }
          }
          while(ExitCode && !hRuler);
        }
        if (hRuler)
        {
          SetStartupInfoRuler = (SetStartupInfoProc)GetProcAddress(hRuler, "SetStartupInfo");
          OpenPluginRuler = (OpenPluginProc)GetProcAddress(hRuler, "OpenPlugin");

          if (SetStartupInfoRuler && OpenPluginRuler)
          {
            if (!wasLoaded)
            {
              RulerInfo = FarInfo;
              RulerInfo.GetMsg = &RulerGetMsg;
              lstrcpy(RulerInfo.ModuleName, RulerPath);
              RulerInfo.RootKey = FarInfo.RootKey;
              SetStartupInfoRuler(&RulerInfo);
            }
            OpenPluginRuler(255, NULL);
          }
        }
      }
      return TRUE;
  }
  return FALSE;
}
