#include "stdafx.h"
#include "memory.hpp"

void * __cdecl malloc(size_t size)
{
  return HeapAlloc(hHeap, HEAP_ZERO_MEMORY, size);
}

void * __cdecl realloc(void *block, size_t size)
{
  HANDLE hhh = GetProcessHeap();
  if (block)
    return HeapReAlloc(hhh, HEAP_ZERO_MEMORY, block, size);
  else
    return HeapAlloc(hHeap, HEAP_ZERO_MEMORY, size);
}

void __cdecl free(void *block)
{
  HeapFree(hHeap, 0, block);
}


#ifdef __cplusplus
void * __cdecl operator new(size_t size)
{
  return malloc(size);
}

void __cdecl operator delete(void *block)
{
  free(block);
}
#endif

void _pure_error_ () {};
