#include "stdafx.h"
#include "getmsg.hpp"

char Language[MAX_LANGUAGE_LINE_LENGTH];
char **Messages = NULL;
int MessagesCount = 0;

void UpdateLanguage(const char *ModulePath)
{
  char new_language[MAX_LANGUAGE_LINE_LENGTH];
  DWORD res = GetEnvironmentVariable("FARLANG",new_language,sizeof(new_language));
  if (!(res && res<sizeof(new_language)))
    lstrcpy(new_language,"English");
  if (!lstrcmp(Language,new_language))
    return;
  lstrcpy(Language,new_language);
  ClearMsgs();
  char path[NM];
  lstrcpy(path,ModulePath);
  lstrcpy(FSF.PointToName(path),"*.lng");
  char EnglishFile[NM], LastFile[NM], LastFileLanguage[MAX_LANGUAGE_LINE_LENGTH];
  *EnglishFile = 0;
  *LastFile = 0;
  WIN32_FIND_DATA fd;
  HANDLE lfh = INVALID_HANDLE_VALUE;
  HANDLE fh = FindFirstFile(path,&fd);
  if (fh!=INVALID_HANDLE_VALUE)
  {
    do
    {
      if (fd.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)
        continue;

      char lngpath[NM];
      lstrcpy(lngpath,ModulePath);
      lstrcpy(FSF.PointToName(lngpath),fd.cFileName);

      lfh = CreateFile(lngpath,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL|FILE_FLAG_SEQUENTIAL_SCAN,NULL);
      if (lfh==INVALID_HANDLE_VALUE)
        continue;
      char buf[MAX_LANGUAGE_LINE_LENGTH];
      if (!ReadLine(lfh,buf,sizeof(buf)))
      {
        CloseHandle(lfh);
        lfh=INVALID_HANDLE_VALUE;
        continue;
      }
      char *ptr=buf;
      int res=0;
      for (int i=0; i<3; i++)
      {
        while (*ptr==0x20 || *ptr=='\t')
          ptr++;
        switch (i)
        {
          case 0:
            res = lstrlen(ptr)>10; //.Language=
            res = res && !FSF.LStrnicmp(ptr,".Language",9);
            ptr += 9;
            break;
          case 1:
            res = lstrlen(ptr)>2; //=
            res = res && *ptr=='=';
            ptr++;
            break;
          case 2:
          {
            char *ptr_s = ptr;
            while (*ptr && *ptr!=0x20 && *ptr!='\t' && *ptr!=',')
            {
              LastFileLanguage[ptr-ptr_s] = *ptr;
              ptr++;
            }
            LastFileLanguage[ptr-ptr_s] = 0;
            break;
          }
        }
        if (!res)
          break;
      }
      if (res && *LastFileLanguage)
      {
        if (!lstrcmpi(LastFileLanguage,Language))
          break;
        if (!lstrcmpi(LastFileLanguage,"English"))
          lstrcpy(EnglishFile,lngpath);
        else
          lstrcpy(LastFile,lngpath);
      }
      CloseHandle(lfh);
      lfh=INVALID_HANDLE_VALUE;
    } while (FindNextFile(fh,&fd));
    FindClose(fh);
    if (lfh==INVALID_HANDLE_VALUE && (*EnglishFile || *LastFile))
    {
      lfh = CreateFile(*EnglishFile?EnglishFile:LastFile,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL|FILE_FLAG_SEQUENTIAL_SCAN,NULL);
    }
    if (fh!=INVALID_HANDLE_VALUE)
    {
      char buf[MAX_LANGUAGE_LINE_LENGTH];
      while (ReadLine(lfh,buf,sizeof(buf)))
      {
        char *ptr = buf;
        while (*ptr==0x20 || *ptr=='\t')
          ptr++;
        if (*ptr!='"')
          continue;
        ptr++;
        char *ptr_e = buf+lstrlen(buf)-1;
        while (ptr_e>ptr && (*ptr_e==0x20 || *ptr_e=='\t'))
          ptr_e--;
        //if (ptr_e==ptr)
          //continue;
        *ptr_e = 0;
        if (!AddMsg(ptr))
          break;
      }
      CloseHandle(lfh);
      /*lfh=OpenLog("G:\\Program Files\\Far\\pm\\PluginManager_lang");
      for (int i=0; i<MessagesCount; i++)
      {
        WriteLog(lfh,Messages[i]);
        WriteLog(lfh,"\n");
      }
      CloseLog(&lfh);*/
    }
  }
}

bool AddMsg(const char *str)
{
  char **NewMessages = (char **) realloc(Messages,(MessagesCount+1)*sizeof(char *));
  if (!NewMessages)
    return false;
  Messages = NewMessages;
  Messages[MessagesCount] = (char *) malloc((lstrlen(str)+1)*sizeof(char));
  if (Messages[MessagesCount])
  {
    lstrcpy(Messages[MessagesCount++],str);
    return true;
  }
  return false;
}

void ClearMsgs()
{
  if (Messages)
  {
    for (int i=0; i<MessagesCount; i++)
    {
      if (Messages[i])
        free(Messages[i]);
    }
    free(Messages);
    MessagesCount = 0;
    Messages = NULL;
  }
}

bool ReadLine(HANDLE file,char *buffer,DWORD len)
{
  DWORD CurrPos = SetFilePointer(file,0,NULL,FILE_CURRENT), transferred;
  bool res = true;
  if (ReadFile(file,buffer,len-1,&transferred,NULL) && transferred)
  {
    buffer[len-1] = 0;
    DWORD len = 0;
    char *ptr = buffer;
    for (size_t i=0; i<transferred; i++,len++,ptr++)
    {
      if (buffer[i]=='\n' || buffer[i]=='\r')
      {
        if ((buffer[i+1]=='\n' || buffer[i+1]=='\r') && buffer[i]!=buffer[i+1])
          len++;
        break;
      }
    }
    *ptr = 0;
    SetFilePointer(file,CurrPos+len+1,NULL,FILE_BEGIN);
  }
  else
  {
    buffer[0] = 0;
    res = false;
  }
  return res;
}
