#define _export
#include <windows.h>
#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <winbase.h>
#include "riolng.hpp"
#include "plugin.hpp"
#include "riopanel.hpp"
#include "std.h"
#include "rio.h"

#define         PORT_BASE_DEFAULT               0x378


static struct PluginStartupInfo Info;

void (WINAPI * Text)(int X,  int Y,  int Color,  char *Str) = NULL;
int (WINAPI * Message)(
  int PluginNumber,
  unsigned int Flags,
  char *HelpTopic,
  char **Items,
  int ItemsNumber,
  int ButtonsNumber
);
int (WINAPI * Control)(
  HANDLE hPlugin,
  int Command,
  void *Param
);
int (WINAPI * Dialog)(
  int PluginNumber,
  int X1,
  int Y1,
  int X2,
  int Y2,
  char *HelpTopic,
  struct FarDialogItem *Item,
  int ItemsNumber
);
HANDLE (WINAPI * SaveScreen)(
  int X1,
  int Y1,
  int X2,
  int Y2
);
void (WINAPI * RestoreScreen)(
  HANDLE hScreen
);
int BreakPressed = FALSE;
int MyNumber = -1;
#define INFO_LINE_NUM 5

#define VLEN 40
void * CurVisual=NULL;
class Visual {
  private:
    char VisualFile[30];
    char VisualHeader[30];
    HANDLE ScrSaved;    
  public:
    Visual(char * iHeader,char * iFile);
    ~Visual();
    void DrawVisual(int Cur,int Max);
    void DrawFrame();
};
    Visual::Visual(char * iHeader,char * iFile)
    {
      ScrSaved = SaveScreen(3,5,3+VLEN,9);
	  int l;
      if ((l=strlen(iHeader)+1) >= sizeof(VisualHeader))
         iHeader+=l-sizeof(VisualHeader);
      if ((l=strlen(iFile)+1) >= sizeof(VisualFile))
         iFile+=l-sizeof(VisualFile);
      strncpy(VisualFile,iFile,sizeof(VisualFile));
      strncpy(VisualHeader,iHeader,sizeof(VisualHeader));
      DrawFrame();
      DrawVisual(0,1);
      CurVisual = this;
    };
    Visual::~Visual() 
    {
      CurVisual=NULL;
      RestoreScreen(ScrSaved);
    };
    void Visual::DrawVisual(int Cur,int Max)
    {
      char MyLine[VLEN-2];
      MyLine[sizeof(MyLine)-1]=0;
      int PercentMark = Max?(long)(sizeof(MyLine)-3) * Cur / Max:0;
      for (int i=0;i<sizeof(MyLine)-1;i<=PercentMark?MyLine[i++]='':MyLine[i++]=' ');
      Text(4,7,112,MyLine);
      Text(1,1,1,NULL); //Flush a buffer
    };
    void Visual::DrawFrame()
    {
      char MyLine[VLEN];
      MyLine[sizeof(MyLine)-1]=0;
      MyLine[0]='';
      MyLine[sizeof(MyLine)-2]='';
      for (int i=1;i<sizeof(MyLine)-2;MyLine[i++]='');
      Text(3,5,112,MyLine);         
      MyLine[0]='';
      MyLine[sizeof(MyLine)-2]='';
      for (i=1;i<sizeof(MyLine)-2;MyLine[i++]=' ');
      memcpy(&MyLine[2],VisualHeader,strlen(VisualHeader));
      Text(3,6,112,MyLine);
      for (i=1;i<sizeof(MyLine)-2;MyLine[i++]=' ');
      Text(3,7,112,MyLine);
      memcpy(&MyLine[2],VisualFile,strlen(VisualFile));
      Text(3,8,112,MyLine);
      MyLine[0]='';
      MyLine[sizeof(MyLine)-2]='';
      for (i=1;i<sizeof(MyLine)-2;MyLine[i++]='');
      Text(3,9,112,MyLine);
    };

int Flags = rfUseInternal+rfUseExternal+rfBestFit;; // they should be global to be accessible from configuration dialog
class RioPanel {
  private:
    void AllocDirItems( int ItemsNum );
    void FillDirItem( int ItemNum );
  public:
    RioPanel();
    ~RioPanel();
    void RioDir2FarDir(CDirBlock& cDirBlock,UINT uiCountEntry,UINT uiFirstEntryNum,char ** SpColumn);
    BOOL SwitchFlash(BOOL InternalFlash);
    void RioNotFoundDir();
	void RioErrorMessage(char * iMessage); // display error message in case of error
    BOOL UpdateRioDir();
    BOOL FlushDir();            /* Upload directory changes into RIO player*/
    BOOL GetDir(BOOL External); /* download external or internal flash directory into cRio */
    BOOL ArrangeItems(struct PluginPanelItem *PanelItem,int ItemsNumber,
					  struct PluginPanelItem ** OrderedItems, 
					  int * LastInternalItem, int * LastExternalItem); 
					  /* PanelItem - in OrderedItems - out LastInternalItem - last item to put into internal flash*/
					  /* LastExternalItem - last item in OrderedItems (it can be less than ItemsNumber if not enough mem) */
					  /* arranges items according to current flags settings. Function returns TRUE if all items fits*/
	BOOL DeleteFile( char* pszFile ); /* removes file pszFile from directory, contains code to move through last file deletion bug*/
	PluginPanelItem *RioPanelItem;
    int RioItemsNumber;
    CRio* cRio;
    InfoPanelLine *InfoLines;
    char Title[4];
	int IntMemFree,IntMemTotal,IntMemUsed,IntMemBad,ExtMemFree,ExtMemTotal,ExtMemUsed,ExtMemBad;
};

RioPanel::RioPanel()
{
    cRio = new CRio;
    RioItemsNumber = 0;
	RioPanelItem = 0;
	IntMemFree = 0;
	IntMemTotal = 0;
	IntMemUsed = 0;
	IntMemBad = 0;
	ExtMemFree = 0;
	ExtMemTotal = 0;
	ExtMemUsed = 0;
	ExtMemBad = 0;
    InfoLines=(struct InfoPanelLine *)malloc(sizeof(*InfoLines)*INFO_LINE_NUM);
    strcpy(InfoLines[0].Text,"RIO INFO");
    strcpy(InfoLines[0].Data,"");
    InfoLines[0].Separator=TRUE;
    strcpy(InfoLines[1].Text,"TOTAL");
    strcpy(InfoLines[1].Data,"");
    InfoLines[1].Separator=FALSE;
    strcpy(InfoLines[2].Text,"USED");
    strcpy(InfoLines[2].Data,"");
    InfoLines[2].Separator=FALSE;
    strcpy(InfoLines[3].Text,"FREE");
    strcpy(InfoLines[3].Data,"");
    InfoLines[3].Separator=FALSE;
    strcpy(InfoLines[4].Text,"BAD");
    strcpy(InfoLines[4].Data,"");
    InfoLines[4].Separator=FALSE;
    strcpy(Title,"RIO");
}

RioPanel::~RioPanel()
{
    delete cRio;
    free(RioPanelItem);
    free(InfoLines);
}

BOOL RioPanel::DeleteFile( char* pszFile )
{
	if (cRio->GetDirectoryBlock().m_cDirHeader.m_usCountEntry>1)
		return(cRio->RemoveFile(pszFile));
	else
		if (cRio->FindFile(pszFile))
			return(cRio->RemoveAllFiles());
		else
			return(FALSE);
}

void RioPanel::RioErrorMessage(char * iMessage)
{
	char *MsgItems[]={"","","Oops"};
	MsgItems[0]=iMessage;
    MsgItems[1]=cRio->GetErrorStr();
    Message(MyNumber,0,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),1);
}

BOOL RioPanel::FlushDir()
{
  if(!(cRio->TxDirectory()))
    {
	  RioErrorMessage("Updating directory failed");
      return(FALSE);
    }
  return(TRUE);
}

BOOL RioPanel::GetDir(BOOL External)
{
	if (cRio->GetUseExternalFlashStatus()!=External)
  	    cRio->UseExternalFlash(External);
    if (!(cRio->RxDirectory()))
    {
		RioErrorMessage("Reading RIO directory failed");
        return(FALSE);
    };
	return(TRUE);
}

void RioPanel::AllocDirItems( int ItemsNum )
{
    RioItemsNumber = ItemsNum;
    RioPanelItem=(struct PluginPanelItem *)realloc(RioPanelItem,sizeof(*RioPanelItem)*(RioItemsNumber+1));
}

void RioPanel::FillDirItem( int ItemNum )
{
    if (ItemNum >= RioItemsNumber)
    {
       char *MsgItems[]={"Internal error","ItemNum>=RioItemsNumber","OK"};
       Message(MyNumber,0,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),1);
       return;
    }
    RioPanelItem[ItemNum].FindData.dwFileAttributes = 0;
    RioPanelItem[ItemNum].FindData.ftCreationTime.dwLowDateTime = 0;
    RioPanelItem[ItemNum].FindData.ftCreationTime.dwHighDateTime = 0;
    RioPanelItem[ItemNum].FindData.ftLastAccessTime.dwLowDateTime = 0;
    RioPanelItem[ItemNum].FindData.ftLastAccessTime.dwHighDateTime = 0;
    RioPanelItem[ItemNum].FindData.ftLastWriteTime.dwLowDateTime = 0;
    RioPanelItem[ItemNum].FindData.ftLastWriteTime.dwHighDateTime = 0;
    RioPanelItem[ItemNum].FindData.nFileSizeHigh = 0;
    RioPanelItem[ItemNum].FindData.nFileSizeLow = 0;
    RioPanelItem[ItemNum].FindData.dwReserved0 = 0;
    RioPanelItem[ItemNum].FindData.dwReserved1 = 0;
    RioPanelItem[ItemNum].PackSizeHigh=0;
    RioPanelItem[ItemNum].PackSize=0;
    RioPanelItem[ItemNum].Flags=0;
    RioPanelItem[ItemNum].NumberOfLinks=0;
    RioPanelItem[ItemNum].Description=NULL;
    RioPanelItem[ItemNum].Owner=NULL;
    RioPanelItem[ItemNum].CustomColumnData=NULL;
    RioPanelItem[ItemNum].CustomColumnNumber=0;
//    strcpy(RioPanelItem[ItemNum].FindData.cFileName,"!");
//    strcpy(RioPanelItem[ItemNum].FindData.cAlternateFileName,"!");
}

void RioPanel::RioNotFoundDir()
{
    AllocDirItems(1);
    FillDirItem(0);
    strcpy(RioPanelItem[0].FindData.cFileName,"!!!RIO player not found!!!");
    strcpy(RioPanelItem[0].FindData.cAlternateFileName,"!NO_RIO!");
}

void Num2Line( char * Line, int Num )
{
  char TmpLine[80];
/*
  strcpy(Line,"");
  int C = (long) Num / 1000000;
  if (C)
  {
     sprintf(TmpLine,"%i",C);
     strcat(Line,TmpLine);
     strcat(Line,"'");
     Num = (long) (Num-C*1000000);
  }
  C = (long) Num / 1000;
  if (C)
  {
     sprintf(TmpLine,"%i",C);
     strcat(Line,TmpLine);
     strcat(Line,"'");
     Num = (long) (Num-C*1000);
  }
  sprintf(TmpLine,"%i",Num);
  strcat(Line,TmpLine);
*/
  sprintf(TmpLine,"%i",Num);
  strcpy(Line,TmpLine);
}

void RioPanel::RioDir2FarDir(CDirBlock& cDirBlock,UINT uiCountEntry,UINT uiFirstEntryNum,char ** SpColumn)
{
    if ( uiCountEntry )
    {
		CDirEntry* pDirEntry = cDirBlock.m_acDirEntry;
        if ( uiCountEntry > CRIO_MAX_DIRENTRY )
            uiCountEntry = CRIO_MAX_DIRENTRY; //Why this?
        for( UINT uiA=0; uiA<uiCountEntry; ++uiA, ++pDirEntry )
            {
                FillDirItem(uiA+uiFirstEntryNum);
                RioPanelItem[uiA+uiFirstEntryNum].FindData.nFileSizeLow=pDirEntry->m_lSize;
				RioPanelItem[uiA+uiFirstEntryNum].PackSize=pDirEntry->m_usCount32KBlock;
				RioPanelItem[uiA+uiFirstEntryNum].CustomColumnData=SpColumn;
                RioPanelItem[uiA+uiFirstEntryNum].CustomColumnNumber=1;
//              RioPanelItem[uiA+uiFirstEntryNum].FindData.ftCreationTime=pDirEntry->m_lTimeUpload;
                strcpy(RioPanelItem[uiA+uiFirstEntryNum].FindData.cFileName,pDirEntry->m_szName);
                for (int i = 0; i < 13; i++)
                  RioPanelItem[uiA+uiFirstEntryNum].FindData.cAlternateFileName[i]=
                  pDirEntry->m_szName[i];
                RioPanelItem[uiA+uiFirstEntryNum].FindData.cAlternateFileName[13]=0;
            }
    }
}
char * ExFlash = "E";
char * InFlash = "I";

BOOL RioPanel::UpdateRioDir()
{
	if (!cRio->CheckPresent()||!GetDir(FALSE))
		return(FALSE);
	CDirBlock& cDirBlock = cRio->GetDirectoryBlock();
    CDirHeader& cDirHeader = cDirBlock.m_cDirHeader;
	UINT MainFlashEntry = cDirHeader.m_usCountEntry;
	IntMemTotal = cDirHeader.m_usCount32KBlockAvailable;
	IntMemUsed = cDirHeader.m_usCount32KBlockUsed;
	IntMemFree = cDirHeader.m_usCount32KBlockRemaining;
	IntMemBad = cDirHeader.m_usCount32KBlockBad;
    AllocDirItems(cDirHeader.m_usCountEntry);
    RioDir2FarDir(cDirBlock,MainFlashEntry,0,&InFlash);
	if (GetDir(TRUE))
    {
      cDirBlock = cRio->GetDirectoryBlock();
      cDirHeader = cDirBlock.m_cDirHeader;
      ExtMemTotal = cDirHeader.m_usCount32KBlockAvailable;
	  ExtMemUsed = cDirHeader.m_usCount32KBlockUsed;
	  ExtMemFree = cDirHeader.m_usCount32KBlockRemaining;
	  ExtMemBad = cDirHeader.m_usCount32KBlockBad;
      AllocDirItems(cDirHeader.m_usCountEntry+MainFlashEntry);
	  RioDir2FarDir(cDirBlock,cDirHeader.m_usCountEntry,MainFlashEntry,&ExFlash);
    } else
	{
      ExtMemTotal = 0;
	  ExtMemUsed = 0;
	  ExtMemFree = 0;
	  ExtMemBad = 0;
	};
    _snprintf(InfoLines[1].Data,80,"%i+%i=%i",IntMemTotal*CRIO_SIZE_32KBLOCK,
		                       ExtMemTotal*CRIO_SIZE_32KBLOCK,
							  (IntMemTotal+ExtMemTotal)*CRIO_SIZE_32KBLOCK);
    _snprintf(InfoLines[2].Data,80,"%i+%i=%i",IntMemUsed*CRIO_SIZE_32KBLOCK,
		                       ExtMemUsed*CRIO_SIZE_32KBLOCK,
							  (IntMemUsed+ExtMemUsed)*CRIO_SIZE_32KBLOCK);
    _snprintf(InfoLines[3].Data,80,"%i+%i=%i",IntMemFree*CRIO_SIZE_32KBLOCK,
		                       ExtMemFree*CRIO_SIZE_32KBLOCK,
							  (IntMemFree+ExtMemFree)*CRIO_SIZE_32KBLOCK);
    _snprintf(InfoLines[4].Data,80,"%i+%i=%i * 32k",IntMemBad,
		                       ExtMemBad,
							   IntMemBad+ExtMemBad);
	return(TRUE);
}

BOOL RioPanel::SwitchFlash(BOOL InternalFlash)
{
	if ( ( InternalFlash && cRio->GetUseExternalFlashStatus()) | 
         ( !InternalFlash && !cRio->GetUseExternalFlashStatus()) )
	{
		return(GetDir(!InternalFlash));
	}	
    return(TRUE);
}

int BlockNum( int iFileSize )
{
	int Result = iFileSize / CRIO_SIZE_32KBLOCK;
	if (Result * CRIO_SIZE_32KBLOCK!=iFileSize)
		Result++;
	return(Result);
}

int GetBestAlternative(int* SizesInBlock,int* Sizes,int ItemsNum,int MemFree)
{
		int MaxAlternative=(1 << ItemsNum)-1;
		int BestAlternative = 0,BestFill = 0;
		for (int CurAlt = 1; CurAlt <= MaxAlternative; CurAlt++ )
		{
			int CurFill = 0,CurBlocks = 0;
			for (int CurBit = 0; CurBit < ItemsNum; CurBit++)
				if (CurAlt & (1 << CurBit))
					CurBlocks+=SizesInBlock[CurBit],CurFill+=Sizes[CurBit];
			if ((CurFill > BestFill)&&(CurBlocks<=MemFree))
			{
				BestFill = CurFill;
				BestAlternative = CurAlt;
				if (CurBlocks==MemFree)
					break;
			}
		}
	return(BestAlternative);
}

BOOL RioPanel::ArrangeItems(struct PluginPanelItem *PanelItem,int ItemsNumber,
							struct PluginPanelItem ** OrderedItems, 
							int * LastInternalItem, int * LastExternalItem)
{
	*LastInternalItem = -1;
	int IntBlocksLeft = IntMemFree==IntMemTotal-IntMemBad?IntMemFree-1:IntMemFree; // one block for Directory
	int ExtBlocksLeft = ExtMemFree==ExtMemTotal-ExtMemBad?ExtMemFree-1:ExtMemFree; // one block for Directory
	if ((Flags & rfBestFit) == 0) 
	{
		int FileBlockNum;
		struct PluginPanelItem * curPI = PanelItem;
		if (Flags & rfUseInternal)
		{
			while (((curPI-PanelItem)<ItemsNumber) && 
				   (curPI->FindData.nFileSizeHigh==0) &&
				   ((FileBlockNum=BlockNum(curPI->FindData.nFileSizeLow))<=IntBlocksLeft))
			{
				IntBlocksLeft-=FileBlockNum;
				OrderedItems[++(*LastInternalItem)]=curPI++;
            }
		}
		*LastExternalItem = *LastInternalItem;
		if (Flags & rfUseExternal)
		{
			while (((curPI-PanelItem)<ItemsNumber) && 
				   (curPI->FindData.nFileSizeHigh==0) && 
				   ((FileBlockNum=BlockNum(curPI->FindData.nFileSizeLow))<=ExtBlocksLeft))
			{
				ExtBlocksLeft-=FileBlockNum;
				OrderedItems[++(*LastExternalItem)]=curPI++;
			}
		}
	}
	else
	{
		const MaxBit = 27;
		if (ItemsNumber>MaxBit)
			return(FALSE);
		int BestAlternative=0; // Best result
		int Sizes[MaxBit],SizesInBlock[MaxBit];
		{for (int i = 0; i < MaxBit; SizesInBlock[i]=BlockNum(PanelItem[i].FindData.nFileSizeLow),
			Sizes[i]=PanelItem[i].FindData.nFileSizeLow,i++);}
		BestAlternative = GetBestAlternative(SizesInBlock,Sizes,ItemsNumber,IntBlocksLeft);
		struct PluginPanelItem * RemainingItems[MaxBit];
		int ItemsRemained = 0;
		{for (int i = 0; i < ItemsNumber; i++)
		{
			if ((BestAlternative & (1 << i))==0)
			{
				RemainingItems[ItemsRemained]=PanelItem+i;
				SizesInBlock[ItemsRemained]=BlockNum(PanelItem[i].FindData.nFileSizeLow);
				Sizes[ItemsRemained++]=PanelItem[i].FindData.nFileSizeLow;
			}
			else
				OrderedItems[++(*LastInternalItem)]=PanelItem+i;
		}}
		*LastExternalItem=*LastInternalItem;
		BestAlternative = GetBestAlternative(SizesInBlock,Sizes,ItemsRemained,ExtBlocksLeft);
		{for (int i = 0; i < ItemsRemained; i++)
		{
			if ((BestAlternative & (1 << i))!=0)
				OrderedItems[++(*LastExternalItem)]=RemainingItems[i];
		}}
	}
	return((*LastExternalItem)+1>=ItemsNumber);
}

void WINAPI _export SetStartupInfo(struct PluginStartupInfo *Info)
{
  Text = Info->Text;
  Message = Info->Message;
  Control = Info->Control;
  Dialog = Info->Dialog;
  MyNumber = Info->ModuleNumber;
  SaveScreen = Info->SaveScreen;
  RestoreScreen = Info->RestoreScreen;
}


HANDLE WINAPI _export OpenPlugin(int OpenFrom,int Item)
{
  HANDLE hPlugin = new RioPanel;
  ((RioPanel*)hPlugin)->cRio->Set(PORT_BASE_DEFAULT);
  return(hPlugin);
}


void WINAPI _export ClosePlugin(HANDLE hPlugin)
{
  delete (CRio*)hPlugin;
}


void WINAPI _export ExitFAR()
{
}


int WINAPI _export GetFindData(HANDLE hPlugin,struct PluginPanelItem **pPanelItem,int *pItemsNumber,int OpMode)
{
 BOOL fresult = ((RioPanel*)hPlugin)->UpdateRioDir();
 *pPanelItem = ((RioPanel*)hPlugin)->RioPanelItem;
 *pItemsNumber = ((RioPanel*)hPlugin)->RioItemsNumber;
 return(fresult);
}


void WINAPI _export GetPluginInfo(struct PluginInfo *Info)
{
  Info->StructSize=sizeof(*Info);
  Info->Flags=0;
  static char *DiskMenuStrings[1];
  DiskMenuStrings[0]="RIO-PMP300";
  static int DiskMenuNumbers[1];
  Info->DiskMenuStrings=DiskMenuStrings;
  DiskMenuNumbers[0]=9;
  Info->DiskMenuNumbers=DiskMenuNumbers;
  Info->DiskMenuStringsNumber=1;
  static char *PluginMenuStrings[1];
  PluginMenuStrings[0]="RIO directory";
  Info->PluginMenuStrings=PluginMenuStrings;
  Info->PluginMenuStringsNumber=sizeof(PluginMenuStrings)/sizeof(PluginMenuStrings[0]);
  static char *PluginCfgStrings[1];
  PluginCfgStrings[0]="Configure RIO plugin (n/a)";
  Info->PluginConfigStrings=PluginCfgStrings;
  Info->PluginConfigStringsNumber=sizeof(PluginCfgStrings)/sizeof(PluginCfgStrings[0]);
  Info->CommandPrefix="RIO";
}

struct PanelMode RioPanelModes[2]={"N,C0,S","30,1,5",NULL,0,0,0,0,NULL,NULL,0,0,"N,C0,S","27,1,7",NULL,0,0,0,0,NULL,NULL,0,0};

void WINAPI _export GetOpenPluginInfo(HANDLE hPlugin,struct OpenPluginInfo *Info)
{
//  char *MsgItems[]={"FuncStart","","OK"};
//  Message(MyNumber,0,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),1);

  Info->InfoLines = ((RioPanel*)hPlugin)->InfoLines;
  Info->InfoLinesNumber = INFO_LINE_NUM;
  Info->PanelTitle = &(((RioPanel*)hPlugin)->Title[0]);
  Info->PanelModesArray = RioPanelModes;
  Info->PanelModesNumber = 2;
  Info->StartPanelMode = '1';
  Info->StartSortMode = SM_UNSORTED;
  Info->StartSortOrder = 0;
//  char *MsgItems1[]={"FuncEnd","","OK"};
//  Message(MyNumber,0,NULL,MsgItems1,sizeof(MsgItems1)/sizeof(MsgItems1[0]),1);
}


int WINAPI _export SetDirectory(HANDLE hPlugin,char *Dir,int OpMode)
{
  return(FALSE);
}

BOOL MyCallback(int iPos, int iCount)
{
  if (CurVisual)
    ((Visual*)CurVisual)->DrawVisual(iPos,iCount);
  return(!BreakPressed);
}

int WINAPI DeleteFiles(HANDLE hPlugin, struct PluginPanelItem *PanelItem,
           int ItemsNumber,int OpMode)
{
	struct PluginPanelItem * curPI=&PanelItem[0];
	const dfFromInternal   = 1;
	const dfFromExternal   = 2;
	const dfNothingDeleted = 3;
	int DeletedFrom = dfNothingDeleted;
	char *MsgItems[]={"Are you sure you want to delete",NULL,"Yes","No"};
	char MsgItem1[40];
	MsgItems[1]=MsgItem1;
	if (ItemsNumber==1)
		_snprintf(MsgItem1,sizeof(MsgItem1),"file %s ?",PanelItem[0].FindData.cFileName);
	else
		_snprintf(MsgItem1,sizeof(MsgItem1),"%d files?",ItemsNumber);
	if (Message(MyNumber,0,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),2))
		return(FALSE);
	for(int CurItem=0;
      CurItem<ItemsNumber;CurItem++,
      curPI++)
	{
		char* aFile=curPI->FindData.cFileName;
		BOOL ExternalFlash = curPI->CustomColumnData[0][0]=='E';
		if (((DeletedFrom == dfFromInternal) & ExternalFlash) |
			((DeletedFrom == dfFromExternal) & !ExternalFlash))
			if (!((RioPanel*)hPlugin)->FlushDir())
				return(FALSE);
		if(!((RioPanel*)hPlugin)->SwitchFlash(!ExternalFlash))
			return(FALSE);
		if (ExternalFlash)
			DeletedFrom = dfFromExternal;
		else
			DeletedFrom = dfFromInternal;
		Visual CurVisual("Deleting a file",aFile);
		if(!(((RioPanel*)hPlugin)->DeleteFile(aFile)))
		{
			((RioPanel*)hPlugin)->RioErrorMessage("Delete failed");
      		return(FALSE);
		}
		CurVisual.DrawVisual(1,1);
	}
	return(((RioPanel*)hPlugin)->FlushDir());
}

BOOL DisplaySelection(struct PluginPanelItem ** OrderedItems,int LastInternalItem,int LastExternalItem)
{
  const MaxFiles = 22;
  struct InitDialogItem InitItems[]={
    DI_DOUBLEBOX,0,0,76,23,0,0,0,0,"Internal <-Files-> External",
    DI_BUTTON,0,23,0,0,0,0,DIF_CENTERGROUP,1,"OK",
    DI_BUTTON,0,23,0,0,0,0,DIF_CENTERGROUP,0,"Cancel"
  };
  int DialogHeight = 23;
  const DialogHeaderSize = sizeof(InitItems)/sizeof(InitItems[0]);
  struct FarDialogItem DialogItems[DialogHeaderSize+MaxFiles];
  int FilesNumToDisplay = LastInternalItem>LastExternalItem-LastInternalItem-1?LastInternalItem:LastExternalItem-LastInternalItem-1,
	  ItemsNumToDisplay;
  struct FarDialogItem * CurItem;
  if (FilesNumToDisplay >= MaxFiles) 
	{
		FilesNumToDisplay = MaxFiles-2;
		ItemsNumToDisplay = MaxFiles + DialogHeaderSize;
		CurItem = &DialogItems[DialogHeaderSize+MaxFiles-1];
		CurItem->Y1=MaxFiles;
		CurItem->X1=37;
		CurItem->Type=DI_TEXT;
		CurItem->X2=0;
		CurItem->Y2=0;
		CurItem->Focus=FALSE;
		CurItem->Selected=0;
		CurItem->Flags=0;
		CurItem->DefaultButton=FALSE;
		strcpy(CurItem->Data,"...");
	}
  else 
  {
    ItemsNumToDisplay = FilesNumToDisplay + DialogHeaderSize + 1;
	DialogHeight = FilesNumToDisplay + 2;
	InitItems[0].Y2 = DialogHeight;
	InitItems[1].Y1 = DialogHeight;
	InitItems[2].Y1 = DialogHeight;
  }
  InitDialogItems(InitItems,DialogItems,DialogHeaderSize);
  char *LeftFile,*RightFile;
  char EmptyString = 0;
  for (int i = 0; i <= FilesNumToDisplay; i++)
	{
		CurItem = &DialogItems[DialogHeaderSize+i];
		CurItem->Y1=i+1;
		CurItem->X1=1;
		CurItem->Type=DI_TEXT;
		CurItem->X2=0;
		CurItem->Y2=0;
		CurItem->Focus=FALSE;
		CurItem->Selected=0;
		CurItem->Flags=DIF_BOXCOLOR;
		CurItem->DefaultButton=FALSE;
		if (i <= LastInternalItem)

			LeftFile = GetFile(OrderedItems[i]->FindData.cFileName);
		else
		    LeftFile = &EmptyString;
		if ((LastInternalItem+i)<LastExternalItem)
			RightFile = GetFile(OrderedItems[LastInternalItem+i+1]->FindData.cFileName);
		else
			RightFile = &EmptyString;
		_snprintf(CurItem->Data,sizeof(CurItem->Data),"%-37.37s|%-37.37s",LeftFile,RightFile);
	}
  int ExitCode=Dialog(Info.ModuleNumber,-1,-1,76,DialogHeight+1,"Upload configuration",DialogItems,ItemsNumToDisplay);
  return(ExitCode==1);
}

int WINAPI _export PutFiles(HANDLE hPlugin,struct PluginPanelItem *PanelItem,
                   int ItemsNumber,int Move,int OpMode)
{
  BOOL SomeErrors = FALSE;
  struct PluginPanelItem ** OrderedItems = (PluginPanelItem**)malloc(sizeof(PluginPanelItem*)*ItemsNumber);
  int LastInternalItem;
  int LastExternalItem;
  BOOL ShouldReturn=((RioPanel*)hPlugin)->ArrangeItems(PanelItem,ItemsNumber,OrderedItems,&LastInternalItem,&LastExternalItem);
  if (DisplaySelection(OrderedItems,LastInternalItem,LastExternalItem))
  {
	((RioPanel*)hPlugin)->SwitchFlash(LastInternalItem>=0);
	for(int CurItem=0;
		CurItem<=LastExternalItem;CurItem++)
	{
		char* aFile=OrderedItems[CurItem]->FindData.cFileName;
		if (CurItem==(LastInternalItem+1))
			{
				if (!((RioPanel*)hPlugin)->FlushDir())
				{
					SomeErrors=TRUE;
					break;
				}
				((RioPanel*)hPlugin)->SwitchFlash(FALSE);
			}
		BreakPressed = FALSE;
		Visual CurVisual("Uploading a file",GetFile(aFile));
		if(!(((RioPanel*)hPlugin)->cRio->TxFile(aFile,&MyCallback)))
		{
			char *MsgItems[]={"Uploading failed:","","update directory?","Yes","No"};
			MsgItems[1]=((RioPanel*)hPlugin)->cRio->GetErrorStr();
			if (!Message(MyNumber,0,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),2))
			{
				((RioPanel*)hPlugin)->cRio->RemoveFile(GetFile(aFile));
				((RioPanel*)hPlugin)->FlushDir();
			};
			SomeErrors = TRUE;
			break;
		} else
			OrderedItems[CurItem]->Flags = OrderedItems[CurItem]->Flags & !PPIF_SELECTED;
		CurVisual.DrawVisual(1,1);
	}
  }
  free(OrderedItems);
  if (SomeErrors)
	  return(FALSE);
  else 
  {
	  if (!((RioPanel*)hPlugin)->FlushDir())
		  ShouldReturn = FALSE;
      return(ShouldReturn);
  }
}

BOOL ExistFile( char * FileName )
{
  BOOL a_result;
  _finddata_t FindData;
  long SearchHandle = _findfirst(FileName,&FindData);
  if ((void*)SearchHandle!=INVALID_HANDLE_VALUE)
  { 
     a_result = TRUE;
     _findclose(SearchHandle);
  }
  else
     a_result = FALSE;
  return(a_result);
}

int WINAPI _export GetFiles(HANDLE hPlugin,struct PluginPanelItem *PanelItem,
                   int ItemsNumber,int Move,char* DestPath,int OpMode)
{
  struct PluginPanelItem * curPI=&PanelItem[0];
  for(int CurItem=0;
      CurItem<ItemsNumber;CurItem++,
      curPI++)
  {
    char aFile[MAX_PATH];
    if (strlen(DestPath)+strlen(curPI->FindData.cFileName)>MAX_PATH-2)
    {
       char *MsgItems[]={"Error","File name too long","Cancel"};
       Message(MyNumber,0,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),1);
       return(FALSE);
    }
    strcpy(aFile,DestPath);
    strcat(aFile,"\\");
    strcat(aFile,curPI->FindData.cFileName);
    BreakPressed = FALSE;
    Visual CurVisual("Receiving a file",aFile);
    if (ExistFile(aFile)) 
    {
      char *MsgItems[]={"File","","already exist! replace?","Yes","No"};
      MsgItems[1]=aFile;
      if(Message(MyNumber,0,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),2))
        continue;
    }       
    if(!((RioPanel*)hPlugin)->SwitchFlash(curPI->CustomColumnData[0][0]=='I'))
	   return(FALSE);
    if(!(((RioPanel*)hPlugin)->cRio->RxFile(aFile,&MyCallback)))
    {
		((RioPanel*)hPlugin)->RioErrorMessage("Downloading failed");
      	return(FALSE);
    }
    else
      if(Move)
      {
        if ( !(((RioPanel*)hPlugin)->cRio->RemoveFile(curPI->FindData.cFileName)) )
            {
				((RioPanel*)hPlugin)->RioErrorMessage("Delete failed");
            }
      }
    CurVisual.DrawVisual(1,1);
  }
  return(Move?((RioPanel*)hPlugin)->FlushDir():TRUE);
}


int WINAPI _export SetFindList(HANDLE hPlugin,struct PluginPanelItem *PanelItem,int ItemsNumber)
{
  return(FALSE);
}


int WINAPI _export ProcessEvent(HANDLE hPlugin,int Event,void *Param)
{
  if (Event==FE_BREAK)
    BreakPressed = TRUE;
  return(FALSE);
}

const	imInitializeInternal = 0x01,
		imInitializeExternal = 0x02,
		imInternalBlockCheck = 0x04,
		imExternalBlockCheck = 0x08;
		
unsigned int InitializeModeDialog()
{
	unsigned int InitializeMode=0;
   struct InitDialogItem InitItems[]={
    DI_DOUBLEBOX,0,0,75,8,0,0,0,0,"Initialize mode",
	DI_CHECKBOX,2,2,0,0,0,1,0,0,"Initialize internal memory",
	DI_CHECKBOX,2,3,0,0,0,1,0,0,"Initialize external memory",
	DI_CHECKBOX,35,2,0,0,0,0,0,0,"Internal memory block check",
	DI_CHECKBOX,35,3,0,0,0,1,0,0,"External memory block check",
    DI_BUTTON,0,9,0,0,0,0,DIF_CENTERGROUP,0,"OK",
    DI_BUTTON,0,9,0,0,1,0,DIF_CENTERGROUP,1,"Cancel",
	DI_TEXT,0,5,0,0,0,0,DIF_CENTERGROUP,0,"*WARNING* initialization with block check ",
	DI_TEXT,0,6,0,0,0,0,DIF_CENTERGROUP,0,"will take ~20min for each flash card, but is strongly recomended",
	DI_TEXT,0,7,0,0,0,0,DIF_CENTERGROUP,0,"because that d#mned samsung flash cards are full of defects :-("
  };
   const DialogHeaderSize = sizeof(InitItems)/sizeof(InitItems[0]);
   struct FarDialogItem DialogItems[DialogHeaderSize];
   InitDialogItems(InitItems,DialogItems,DialogHeaderSize);
   DialogItems[1].Selected = 1;
   DialogItems[2].Selected = 1;
   DialogItems[3].Selected = 0;
   DialogItems[4].Selected = 1;
   int ExitCode=Dialog(Info.ModuleNumber,-1,-1,76,11,"Initialize mode",DialogItems,DialogHeaderSize);
   if (ExitCode==5)
   {
	   	if (DialogItems[1].Selected) 
			InitializeMode = imInitializeInternal;
		else
			InitializeMode = 0;
		if (DialogItems[2].Selected)
			InitializeMode|= imInitializeExternal;
		else
			InitializeMode&= ~imInitializeExternal;
		if (DialogItems[3].Selected)
			InitializeMode|= imInternalBlockCheck;
		else
			InitializeMode&= ~imInternalBlockCheck;
		if (DialogItems[4].Selected)
			InitializeMode|= imExternalBlockCheck;
		else
			InitializeMode&= ~imExternalBlockCheck;
   }
  return(InitializeMode);	
}

int WINAPI _export ProcessKey(HANDLE hPlugin,int Key,unsigned int ControlState)
{
  if ((ControlState&PKF_CONTROL)&&(Key==VK_F8))
  {
	unsigned int InitializeMode = InitializeModeDialog();
	
	if(InitializeMode&imInitializeInternal)
    {
      { // Visual should be visible only here
        Visual aVisual("Initializing...","internal flash memory");
		((RioPanel*)hPlugin)->cRio->UseExternalFlash(FALSE);
        if (!((RioPanel*)hPlugin)->cRio->Initialize(InitializeMode&imInternalBlockCheck,&MyCallback))
			((RioPanel*)hPlugin)->RioErrorMessage("Initialization of internal flash memory failed");
		else
			((RioPanel*)hPlugin)->FlushDir();
        Control(hPlugin,FCTL_UPDATEPANEL,NULL);
        aVisual.DrawVisual(1,1);
      } // and should be destroyed here (i hope)
    }
	if(InitializeMode&imInitializeExternal)
    {
      { // Visual should be visible only here
        Visual aVisual("Initializing...","external flash memory");
		((RioPanel*)hPlugin)->cRio->UseExternalFlash(TRUE);
        if (!((RioPanel*)hPlugin)->cRio->Initialize(InitializeMode&imExternalBlockCheck,&MyCallback))
			((RioPanel*)hPlugin)->RioErrorMessage("Initialization of external flash memory failed");
		else
			((RioPanel*)hPlugin)->FlushDir();
        Control(hPlugin,FCTL_UPDATEPANEL,NULL);
        aVisual.DrawVisual(1,1);
      } // and should be destroyed here (i hope)
    }
    if (InitializeMode)
		Control(hPlugin,FCTL_REDRAWPANEL,NULL);
	return(TRUE);
  }
  return(FALSE);
}


int WINAPI _export Configure(int ItemNumber)
{
   struct InitDialogItem InitItems[]={
    DI_DOUBLEBOX,0,0,75,8,0,0,0,0,"RIO plugin configuration",
	DI_CHECKBOX,2,2,0,0,0,1,0,0,"Use internal memory",
	DI_CHECKBOX,2,3,0,0,0,1,0,0,"Use external memory",
	DI_RADIOBUTTON,35,2,0,0,0,0,DIF_GROUP,0,"Copy tracks in the selection order",
	DI_RADIOBUTTON,35,3,0,0,0,1,0,0,"Shuffle tracks to use maximum memory",
    DI_BUTTON,0,9,0,0,1,0,DIF_CENTERGROUP,1,"OK",
    DI_BUTTON,0,9,0,0,0,0,DIF_CENTERGROUP,0,"Cancel",
	DI_TEXT,0,5,0,0,0,0,DIF_CENTERGROUP,0,"*WARNING* finding best track order might take several minutes",
	DI_TEXT,0,6,0,0,0,0,DIF_CENTERGROUP,0,"if you select more than 20 tracks. You can not select more",
	DI_TEXT,0,7,0,0,0,0,DIF_CENTERGROUP,0,"than 27 tracks in the second mode"
  };
   const DialogHeaderSize = sizeof(InitItems)/sizeof(InitItems[0]);
   struct FarDialogItem DialogItems[DialogHeaderSize];
   InitDialogItems(InitItems,DialogItems,DialogHeaderSize);
   DialogItems[1].Selected = ((Flags&rfUseInternal)!=0);
   DialogItems[2].Selected = ((Flags&rfUseExternal)!=0);
   DialogItems[4].Selected = !(DialogItems[3].Selected = ((Flags&rfBestFit)==0));
   int ExitCode=Dialog(Info.ModuleNumber,-1,-1,76,11,"Upload configuration",DialogItems,DialogHeaderSize);
   if (ExitCode==5)
   {
		if (DialogItems[1].Selected) 
			Flags|=rfUseInternal;
		else
			Flags&=~rfUseInternal;
		if (DialogItems[2].Selected)
			Flags|=rfUseExternal;
		else
			Flags&=~rfUseExternal;
		if (DialogItems[3].Selected)
			Flags&=~rfBestFit;
		else
			Flags|=rfBestFit;
		return(TRUE);
   }
   else
	  return(FALSE);
}