{*************************************************************************}
{*                                                                       *}
{* ROSE FILE WEEDER, RFW     - see RFW.DOC                               *}
{*                                                                       *}
{* Based on RHBVS.PAS and K-TaiPan....                                   *}
{*                                                                       *}
{* Due to the fact that this is an ultra fast hack this program can not  *}
{* win a price in best design or structural programming. But how cares?  *}
{*                                                                       *}
{* The hash functions are not worth to be named "hash" functions, but    *}
{* it will work for the first 120.000 files in the database very well.   *}
{*                                                                       *}
{* For testing I suggest the use of ROSEGOAT!                            *}
{*                                                                       *}
{*************************************************************************}
{*           ----------------------------------                          *}
{*            ROSE Softwareentwicklung                                *}
{*            Dipl.-Ing. Ralph Roth                                   *}
{*            Finkenweg 24                                            *}
{*                                                                    *}
{*            D 78658 Zimmern o. R.                                   *}
{*                                                                    *}
{*           ----------------------------------                         *}
{*             #################################                         *}
{*                                                                       *}
{*                                                                       *}
{*************************************************************************}


{**********************************************************************}
{*                                                                    *}
{* Source code is included for finding bugs and better                *}
{* enhancements requests. Feel free to send back modified source      *}
{* code. Please comments changes clearly.                             *}
{*                                                                    *}
{* Currently I am searching an 32 bit Pascal compiler that can        *}
{* compile RFW into a 32 bit application, using 4 GB for hash tables! *}
{* FPC looks very good and I have written/ported some of the programs *}
{* so far, but RFW uses some inline/asm (CRC, SeekEP) routines, so I  *}
{* need additional manpower for the proting to FPC/32 - maybe you? :) *}
{*                                                                    *}
{* Anyone interested in continue the work on RFW? Contact me via      *}
{* email: RalphRoth@gmx.de, http://come.to/rose_swe                   *}
{*                                                                    *}
{**********************************************************************}

{

$Header: C:/TP/VIR/RCS/rfw.pas 1.10 2001/05/08 17:50:03 rar_ulm Exp $
$Log: rfw.pas $
Revision 1.10  2001/05/08 17:50:03  rar_ulm
RFW 2.00 - released

Revision 1.9  2001/03/24 22:24:24  rose300
RFW/32 - Beta 2

Revision 1.8  2001/03/19 08:22:53  rar
RFW 2.00 beta 1 - runs now under Linux too

Revision 1.7  2001/03/19 08:21:45  rar
rfw 2.00 beta - before porting to Linux

Revision 1.6  2001/03/18 12:39:57  rar
1.07.2, before porting to TMT Pascal, DOS32

Revision 1.5  2001/02/18 12:58:05  rar
1.07 - consolidated to r_utils, chdir does not cause an halt anymore

Revision 1.4  2001/01/19 23:05:58  rar
RFW 1.06 - massive changes in the units due to win32/linux porting

Revision 1.3  2000/12/24 13:01:44  rose_swe.p300
rfw 1.05.3 with enhanced -info switch

Revision 1.2  2000/12/24 12:14:24  rose_swe.p300
RFW 1.05.2 (option exclude= changed to exdir=).
Changed the layout of the option -??

Revision 1.1  2000/12/24 12:02:08  rose_swe.p300
Initial revision


}

{$I COMP.PAS}
{$IFNDEF FPC}
{$N+,E+}                { for double }
{$ENDIF}

{$IFNDEF __TMT__}
{$M 42000,80000,$9fff0}
{$ENDIF}

{$IFDEF SHARE}
{$D+,L+}
{$I+,V+,R+,S+}
{$ENDIF}
{&R c:\tp\icons\danger.res}

program RFW;  { RFW -> Read the Fucking Warning :), 15.02.98 }

uses
      crt,
      dos,
{$IFNDEF FPC}
      syserr,
      netzwerk,
{$ENDIF}

      r_utils,
      rstrings,

      ansi_crc,
      avrvbs,

      kommando,
      rfwunit;

const PATHLEN     = 41;         { cut filelength to this value }
      {$IFDEF FPC}
      MAXBUFSIZE    = $7FFFF;   { FPC }
      {$ELSE}
      MAXBUFSIZE    = $7FFF;
      {$ENDIF}

{$IFDEF SHARE}
      MAXCRCSIZE    = $0fff;    { IDE! }
      MAXFILELOOKUP = $07FF;
{$ELSE}
  {$IFDEF SMALLMEM}
      MAXFILELOOKUP = $0FFF;    { 1fff }
  {$ELSE}
      {$IFDEF FPC}              { maxfilelookup: pointer to record in rfw.dat }
      MAXFILELOOKUP = $7FFFF;   { FPC, 3ffff=262143 }
      {$ELSE}
      MAXFILELOOKUP = $1FFF;    { 1fff }
      {$ENDIF}
  {$ENDIF}

{$IFDEF SMALLMEM}
      MAXCRCSIZE    = $1FFF;    { if not enough memory availiable! }
{$ELSE}
      {$IFDEF FPC}
      MAXCRCSIZE    = $3FFFF;   { FPC }
      {$ELSE}
      MAXCRCSIZE    = $7FFF;
      {$ENDIF}
{$ENDIF}
{$ENDIF}


type
     LengthBuffer    = Array [0..MAXBUFSIZE] of Byte;  { changed 14.03.98, 31.03.2001 }
     LengthBufferPtr = ^LengthBuffer;
     CrcBuffer       = Array [0..MAXCRCSIZE] of Byte;  { changed 15.03.98 }
     CrcBufferPtr    = ^CrcBuffer;
     DB_Record       = Record
                             lSize, lCrc, lCrc32 : LongInt; { lCrc32 = SmartCRC }
                       end;
     DB_File         = File of DB_Record;
     FileLookup      = Array [0..MAXFILELOOKUP] of LongInt; { 19.07.98 }
     FileLookupPtr   = ^FileLookup;


var     { wegen Stack! }
    szSearch    : String;
    szName      : String;
    szHome      : String;
    szParam     : String;
    szTmp       : String;
    szExt       : ExtStr;
    szDir       : DirStr;
    szExDir     : DirStr;
    szBName     : NameStr;

    nParam      : Integer;
    nExitCode   : Integer;
    rTime       : Real;         { for timing }

    lFound      : LongInt;
    lAdded      : LongInt;      { files added }
    lremoved    : LongInt;
    lChk        : LongInt;
    lChkReal    : LongInt;
    lDBEntry    : LongInt;
{$IFNDEF FPC}
    lMem        : LongInt;
{$ENDIF}
    dSizeFiles  : Double;       { size of all files together }

    bDelete     : Boolean;
    bAllFiles   : Boolean;
    bAddFiles   : Boolean;
    bStdOut     : Boolean;
    bReNumber   : Boolean;
    bReName     : Boolean;
    bRenMarx    : Boolean;      { COM -> CO$, EXE -> EX$ }
    bUserBreak  : Boolean;
    bShowFileName: Boolean;     { prints full file name }
    bUseErrCode : Boolean;
    bFileShort  : Boolean;
    bRmDir      : Boolean;
    bFileComp   : Boolean;      { file compare... for Andreas Marx }
    brenPE      : Boolean;
    bJPG        : Boolean;      { -JPG switch, 26.11.2000 }

    kz          : PKommandoZeile;

    hLog        : Text;

    aDBLen      : LengthBufferPtr;
    aHashCrc    : Array[0..3] of CrcBufferPtr;  { 16.02.98, 03.03.98, 15.03.98 }
    aHashCrc32  : Array[0..4] of CrcBufferPtr;  { 25.04.98, 15.05.99 }
    aFile       : FileLookupPtr;

{$I seekep.pas}

{ --=[ Writeln1 ]=------------------------------------------------------ }

procedure writeln1(szWhat: String);

var t, v : Byte;

begin

    if bStdOut then writeln(szWhat)
   else
    begin
     for t := 1 to length(szWhat) do
     begin
          v := byte(szWhat[t]);
          textcolor(7);
          if v < 48 then textcolor(3);
          if v in [91..96] then textcolor(3+8);
          if v > 122 then textcolor(1+8);
          if v = 254 then textcolor(White);
          write(szWhat[t]);
     end;
     textcolor(7);
     writeln;
    end;

    if kz^.isOption('log') then writeln(hLog, szWhat);

end; { writeln1 }

{-----------------------------------------------------------------------}
{ 1:1 file compare - for Andi Marx }
{-----------------------------------------------------------------------}

Function CheckIfFilesAreEqual( sF1, sF2 : String) : Boolean;

{ rar, 09.09.98 - check if file sF1 is equal to file sF2 }
{ WARNING: Make sure file access is garanted!            }

var hF1, hF2       : File;
    res1, res2, nT : Word;
    bEqual         : Boolean;

    abRB1, abRB2   : Array[1..1024] of byte;   { requires huge stack! }

begin

     CheckIfFilesAreEqual := FALSE;

     assign(hF1, sF1);
     if ioresult <> 0 then exit;        { q'n'd bail out }
     assign(hF2, sF2);
     if ioresult <> 0 then exit;
     reset(hF1, 1);
     if ioresult <> 0 then exit;
     reset(hF2, 1);
     if ioresult <> 0 then exit;

     repeat
        blockread(hF1, abRB1, sizeof(abRB1), res1);
        blockread(hF2, abRB2, sizeof(abRB2), res2);

        bEqual := (res1 = res2) AND (res1>0);

        if bEqual then
           for nT := 1 to res1 do
             if abRB1[nT] <> abRB2[nT] then bEqual := FALSE;

     until eof(hF1) or eof(hF2) or (bEqual = FALSE);

     if (not eof(hF1)) AND (not eof(hF2)) then bEqual := FALSE;

     close(hF1);
     close(hF2);

     CheckIfFilesAreEqual := bEqual;

end; { CheckIfFilesAreEqual }


{ --=[ simplyfied hash functions ]=------------------------------------- }

Procedure SetLength(lIn : LongInt);  { 14.03.98 }
{ based on an idea from Andreas Marx }

var  bRest : Byte;
     wDiv  : Word;

begin
     wDiv := (lIn shr 4) AND MAXBUFSIZE;         { gets index }
     { normaly, files are bigger than 7 bytes, so this is a good workaround }
     { 'cos DOS Segements sucks }
     { if wDiv >= MAXBUFSIZE then wDiv := 0; }
     bRest:= lIn Mod 8;
     { v := 1; for t := 1 to bRest do v := v shl 1; }
     aDBLen^[wDiv] := aDBLen^[wDiv] OR (1 shl bRest);   { set bit }
end;

{ ---=[ IsLength ]=------------------------------------------------------ }

Function IsLength(lIn : LongInt) :Boolean;  { 14.03.98 }
{ based on an idea from Andreas Marx }

var  bRest : Byte;
     wDiv  : Word;
     v     : Byte;

begin
     wDiv := (lIn shr 4) AND MAXBUFSIZE;         { gets index }
     { if wDiv >= MAXBUFSIZE then wDiv := 0; }
     { 'cos DOS Segements sucks }
     bRest:= lIn Mod 8;                          { 0...7 }
     { v := 1; for t := 1 to bRest do v := v shl 1; }
     v := 1 shl bRest;
     ISLength := (aDBLen^[wDiv] and v) = v;     { is bit set? }
end;

{ ----- IsHash ----------------------------------------------------------- }

Procedure SetHash(lIn : LongInt);  { 14/15.03.98 }
{ based on an idea from Andreas Marx }

var  bRest : Byte;
     wDiv  : Word;
     wInd  : Byte;

begin
     wInd := lIn AND 3; { Array Index }
     lIn  := lIn shr 2;
     wDiv := (lIn shr 4) AND MAXCRCSIZE;         { gets index }
     bRest:= lIn Mod 8;
     { v := 1; for t := 1 to bRest do v := v shl 1; }
     aHashCrc[wInd]^[wDiv] := aHashCrc[wInd]^[wDiv] Or (1 shl bRest);
end;


Procedure SetHash32(lIn : LongInt);  { 14/15.03.98 }
{ based on an idea from Andreas Marx }

var  bRest : Byte;
     wDiv  : Word;
     wInd  : Byte;

begin
     wInd := lIn AND 3; { Array Index }
     lIn  := lIn shr 2;
     wDiv := (lIn shr 4) AND MAXCRCSIZE;         { gets index }
     bRest:= lIn Mod 8;
     { v := 1; for t := 1 to bRest do v := v shl 1; }
     lIn  := lIn shr 7;
     inc(wInd, lIn and 1);
     aHashCrc32[wInd]^[wDiv] := aHashCrc32[wInd]^[wDiv] Or (1 shl bRest);
end;

{ ----- Sethash ---------------------------------------------------------- }

Function IsHash(lIn : LongInt) : Boolean;  { 14/15.03.98 }
{ based on an idea from Andreas Marx }

var  bRest : Byte;
     wDiv  : Word;
     wInd  : Byte;
     v     : Byte;

begin
     wInd := lIn AND 3; { Array Index }
     lIn  := lIn shr 2;
     wDiv := (lIn shr 4) AND MAXCRCSIZE;         { gets index }
     bRest:= lIn Mod 8;
     { v := 1; for t := 1 to bRest do v := v shl 1; }
     v := 1 shl bRest;
     IsHash := (aHashCrc[wInd]^[wDiv] and v) = v;
end;


Function IsHash32(lIn : LongInt) : Boolean;  { 14/15.03.98 }
{ based on an idea from Andreas Marx }

var  bRest : Byte;
     wDiv  : Word;
     wInd  : Byte;
     v     : Byte;

begin
     wInd := lIn AND 3; { Array Index }
     lIn  := lIn shr 2;
     wDiv := (lIn shr 4) AND MAXCRCSIZE;         { gets index }
     bRest:= lIn Mod 8;
     { v := 1; for t := 1 to bRest do v := v shl 1; }
     v := 1 shl bRest;
     lIn  := lIn shr 7;
     inc(wInd, lIn and 1);
     IsHash32 := (aHashCrc32[wInd]^[wDiv] and v) = v;
end;

{ .... FOpenHashTable ............................................. }

Function FOpenHashTab(var hIn : DB_File) : Boolean;

var nOldMode, io : Byte;

begin { FOpenBin, refixed 02.03.98 }

      FOpenHashtab := FALSE;
      nOldMode     := FileMode;

      if ioresult <> 0 then { old error! };

      FileMode := 0;
      assign(hIn, szDataBase);
      if IoResult <> 0
         then exit; { TP! };

      reset(hIn);                        { read, compatible }
      io := ioresult;
      if io <> 0 then
      begin
          FileMode := $A0 {64};          { read, shared, win95 }
          reset(hIn);
          clreol;
          writeln('WARNING (FOPEN1): Sharing violation = ',io);
          io := ioresult;
          if io <> 0 then
             writeln('WARNING (FOPEN2): Sharing violation = ',io);
      end;

      FOpenHashTab := Io = 0;
      FileMode := nOldMode;
      if ioresult <> 0 then writeln1(' DATABASE FOPEN ERROR!'); { old error! };

end;  { FOpenBin }


{ ... CreateHashTable ................................................. }


Procedure CreateHashTable;

{ creates internal hash table, if needed the database too! }

var t    : LongInt;
    hIn  : DB_File;
    work : DB_Record;
    hTxt : Text;
    lT1, lT2 : LongInt;

begin

  new(aFile);
  for t := 0 to MAXFILELOOKUP do aFile^[t] := MAXLONGINT;

  if (not exists(szDataBase)) AND (bAddFiles) then
  begin
       writeln1(' Database does not exists: Creating an empty database for adding new files!');
       assign(hIn, szDatabase);
       rewrite(hIn);
       work.lCrc   := 0;     { files with zero size == REAL VIRUSES! :-) }
       work.lSize  := 0;
       work.lCrc32 := 0;
       aFile^[0]   := FilePos(hIn);

       write(hIn,work);
       close(hIn);

       assign(hTxt, szDataFiles);
       rewrite(hTxt);
       writeln(hTxt,'Empty file with filesize = zero bytes! (AUTO ADDED) '+date);
       close(hTxt);
  end;

  write(' Reading database & creating the hash tables',#13);
  lDBEntry := 0;

  new(aDBLen);
  new(aHashCrc[0]);
  new(aHashCrc[1]);
  new(aHashCrc[2]);
  new(aHashCrc[3]);
  new(aHashCrc32[0]);
  new(aHashCrc32[1]);
  new(aHashCrc32[2]);
  new(aHashCrc32[3]);
  new(aHashCrc32[4]);

  { index=0 -> file with zero size }
  for t := 1 to MAXBUFSIZE do aDBLen^[t] := 0;
  for t := 1 to MAXCRCSIZE do   { fillchar? }
  begin
       aHashCrc[0]^[t] := 0;
       aHashCrc[1]^[t] := 0;
       aHashCrc[2]^[t] := 0;
       aHashCrc[3]^[t] := 0;
       aHashCrc32[0]^[t] := 0;
       aHashCrc32[1]^[t] := 0;
       aHashCrc32[2]^[t] := 0;
       aHashCrc32[3]^[t] := 0;
       aHashCrc32[4]^[t] := 0;
  end;

  if FOpenHashTab(hIn) then
  begin
       while not eof(hIn) do
       begin
             lT2 := FilePos(hIn);       { current pos }

             read(hIn, work);
             inc(lDBEntry);
             SetLength(work.lSize);
             SetHash(work.lcrc);
             SetHash32(work.lCrc32);

             lT1 := work.lSize;
             t   := lT1 and MAXFILELOOKUP;

             if aFile^[t] > lT2 then
                aFile^[t] := lT2;
       end;
       close(hIn);
  end;
  clreol;

end;

{ --=[ the working horse ]=--------------------------------------------- }


Function WeedFile(szIn : String; lSize : LongInt) : String;

var lCrc, lCrc32 : LongInt;
    work : DB_Record;
    hIn  : DB_File;
    crc  : PCrc;

Procedure Add2DataBase(bReScan: Boolean); { 16.02.98 }

var hIn       : File of DB_Record;
    bOldFMode : Byte;
    hTxt      : Text;
    t         : Word;
    lT1       : LongInt;

begin

  if bReScan then
  begin
     NEW(CRC, Init( CRCPOLY_ChkSum ));     { Build Up Objekt }
     lCrc := Crc^.CheckSumme(szIn);
     lCrc32 := crc^.Checksumme32(SzIn);
     Dispose(crc, Done);                   { Speicher wieder freigeben }
  end;

  work.lSize := lSize;
  work.lCrc  := lCrc;
  work.lCrc32:= lCrc32;
  bOldFMode  := FileMode;               { 02.03.98! }
  FileMode   := 2;                      { set write perms }

  assign(hIn, szDataBase);
  reset(hIn);
  seek(hIn,filesize(hIn));

  t := lSize and MAXFILELOOKUP;
  lT1 := FilePos(hIn);
  if aFile^[t] > lT1 then
     aFile^[t] := lT1;

  write(hIn, work);
  close(hIn);
  assign(hTxt, szDataFiles);
  append(hTxt);
  writeln(hTxt, szIn+', '+format(lSize)+', CRC='+hex(lCrc,8)+'/'+hex(lCrc32,8));
  close(hTxt);

  FileMode   := bOldFMode;              { network compatible perms }

  SetLength(lSize);                     { insert into hash table }
  Sethash(lCrc);
  SetHash32(lCrc32);
  inc(lAdded);

end;

{ ---------------------------------------------------------------------- }

var hTxt   : Text;
    lLine  : LongInt;
    szLine : String;
    szWeed : String;    { temp result }
    i      : Byte;
    szTmp  : String;
    t      : Word;
    lFPos  : LongInt;

Begin { 15.02.98 }

   WeedFile := '';
   szTmp := Upper(szIn);        { 18.03.2001 }

   if (szTmp = Upper(szLogFile)) or (szTmp = Upper(szDataBase))
      or (szTmp = Upper(szDataFiles)) then exit; { 06.03.98, 21.04.98 }

   { dups in the current scan will not be deleted, if you don't use /ADD! }
   if (not IsLength(lSize))
   or (aFile^[lSize AND MAXFILELOOKUP] = MAXLONGINT)
   then begin
      if bAddFiles then
         add2DataBase(TRUE);
      exit;
   end;

   { szIn := SourceFile }

   NEW(CRC, Init( CRCPOLY_ChkSum ));     { Build Up Objekt }
   lCrc32 := Crc^.CheckSumme32(szIn);
   if not IsHash32(lCrc32) then          { Major Speedup, 25.04.98 }
   begin
        Dispose(Crc, Done);              { will be recreated }
        if bAddFiles then
           add2DataBase(TRUE);
        exit;
   end;

   lCrc   := Crc^.CheckSumme(szIn);      { CRC32 ber die ganze Datei! }
   Dispose(crc, Done);                   { Speicher wieder freigeben }

   { --- lCrc = CRC32 of the original file }
   if IsHash(lCrc) then
   { so we need to scan the whole database! }
   begin
      if not FOpenHashTab(hIn) then
       begin
         clreol;
         writeln;
         writeln1('FATAL: Can not read/open the database! Program halted!');
         writeln1('Stopped on file: '+szIn);
         writeln;
         chdir(szHome);
         halt(3);
       end;

      { --- So try to find the crc }
      t := lSize and MAXFILELOOKUP;   { MAXFILELOOKUP files are cached }
      lFPos := aFile^[t];
      if lFPos = MAXLONGINT then lFPos := 0;
      seek(hIn, lFPos);
      if ioresult <> 0 then writeln1(' WARNING: FILEPOS SEEK ERROR!');

      lDBEntry := FilePos(hIn); { never used anymore }

     if not eof(hIn) then
      repeat
            read(hIn, work);
            inc(lDBEntry);
      until eof(hIn) OR ((lCrc = work.lCrc) AND (lSize = work.lSize) AND (lCrc32 = work.lCrc32));
      close(hIn);
   end
   else
      work.lCrc := lCrc - 1;     { means add anyway }

   if (lCrc = work.lCrc) AND (lSize = work.lSize) AND (lCrc32 = work.lCrc32) then
   begin
        szWeed := Triml(format(lSize))+', CRC='+hex(Work.lCrc,8);
        if not bShowFilename then
           szWeed := 'DUP:'+format(lDBEntry)+', ' + szWeed
        else
           szWeed := szWeed + ', DUP:'+format(lDBEntry);

        if bShowFileName or bFileComp then      { NOT case sensitive! }
        begin
             lLine := 0;
             assign(hTxt, szDataFiles);
             reset(htxt);
             repeat
                 readln(hTxt, szLine);
                 inc(lLine);
             until (eof(hTxt) or (ioresult<>0) or (lLine=lDBEntry));
             close(hTxt);
             szWeed := szWeed + #13#10 +' ->  ';
             if lLine = lDBEntry
                then
                  begin
                    i := Pos(', ',szLine);
                    if lLine = 1 then i := 255;
                    szTmp := Copy(szLine,1,i-1);

                    if bFileShort then szWeed := szWeed + szTmp
                                  else szWeed := szWeed + copy(PathFit(szTmp,PATHLEN)+
                                  '                                  ',1,PATHLEN)+triml(copy(szLine,i+1,255));

                    if bFileComp then { 1:1 Filecompare, aber mit welcher Datei? }
                    begin
                        if not CheckIfFilesAreEqual(szIn, szTmp)
                           then szWeed := ''  { BUG: /FC: NOT EQUAL!!! }
                           else szWeed := szWeed + '(1:1)';
                    end;
                  end
                else szWeed := szWeed + 'File Access Error! Line:'+format(lLine);
        end;
        if bDelete then
        begin
             if NOT (bShowFileName AND (Pos(copy(szIn,3,255),szLine)>0)) then
             begin
                  unlink(szIn);     { kills da file 4ever! }
                  inc(lRemoved);    { benefits, from /FILE Param }
             end;
        end;

        if bShowFileName AND (Pos(Copy(szIn,3,255),SzLine)>0) then szWeed := '';
        WeedFile := szWeed;
   end
   else
        if bAddFiles then Add2DataBase(FALSE);

end; { WeedFile }

{ -------- rekursiv ------------------------------------------ }

procedure Bearbeite(pfad: string);

var sr        : SearchRec;
    szHomeDir : PathStr;
    nIO       : Byte;

begin { Bearbeite }

 if length(Pfad) > sizeof(DIRSTR) then
 begin
      Writeln1('ERROR! Path is longer than internal DIR structure, skipping!');
      Writeln1('Path = '+Pfad);
      exit;
 end;

 if (length(szExDir)>3) AND (Upper(Pfad)=Upper(szExDir))
    then exit;

 if bRename then
           SmartFileRename(bRenumber, bRenMarx, bRenPe);

 FindFirst(pfad+SLASH+FILEMASKALL, anyfile-VolumeId, sr);
 while (DosError=0) do
    begin
      if ((sr.attr AND directory) = Directory) AND (sr.name <> '.')
         AND (sr.name <> '..')
      then
      begin
          szName := pfad+SLASH+sr.name;
          chdir(szName);
          nIO := ioResult;

          if nIO = 0
          then
             bearbeite(szName)
          else
             begin
                Writeln1(' Folder '+szName+': Access denied! Code='+klformat(nIO));
                { halt(nIO); }  { 18.02.2001, rar }
             end; { 1.00.02, rar4am }
      end
    else
      if (sr.name <> '.') AND (sr.name <> '..') then
      begin
        szName := pfad+SLASH+sr.name;
        write(pathfit(szname,PATHLEN));
        clreol;
        write(#13);
        szSearch := '';

        if not ((sr.attr AND directory) = Directory)
           then inc(lChk);
        dSizeFiles := dSizeFiles + sr.size;

        { targets }
        if (IsSrcExtension(sr.name) OR
            IsExeExtension(sr.name) OR
            IsDocExtension(sr.name) OR
            IsJPGExtension(sr.name) OR
            IsHTMLExtension(sr.name) OR
            { or allways true, if all files specified }
            bAllFiles) then
        begin
             if not ((sr.attr AND directory) = Directory)
                then inc(lChkReal);

             if not (bJPG and not IsJPGExtension(sr.name))   { 26.11.2000 }
             then
                 szSearch := WeedFile(szName, sr.size);
        end;

        if szSearch <> '' then
        begin
          inc(lFound);
          textcolor(white);
          write(copy(pathfit(szName,PATHLEN)+
                '                                           ',1,PATHLEN+5));
          textcolor(yellow);
             if kz^.IsOption('log') then
             begin
              writeln(szSearch);
              writeln(hLog,szName+'  '+szSearch);
             end
          else
              writeln1(szSearch);
          textcolor(7);
        end;
      end;

      FindNext(sr);
      if keypressed then bUserBreak := ReadKey = #27;
      if bUserBreak then exit;
    end;

 GetDir(0, szHomeDir);
 if length(szHomeDir)>3 then
 begin
       chdir('..');
       if ioresult <> 0 then { at root! };
 end;
 if bRmDir then
 begin
       clreol;
       RmDir(szHomeDir);
       if ioresult = 0 then Writeln1(' DIR '+szHomeDir+' removed!');
 end;

 if ioresult <> 0 then {-???-};

end; { Bearbeite }

{$IFNDEF FPC}
{ ----[ AutoGetParams ]------------------------------------------- }

PROCEDURE AutoGetParams;

VAR  T    : Byte;
     szLw : string[3];
     io   : Word;

BEGIN

  WITH Kz^ DO
  BEGIN

   T:=3;
   REPEAT                          { Diese Routine ermittelt alle gltigen
                                     Laufwerke }
     IF Disksize(t)>1 THEN
     begin
        io := IOCtlDevLocal(t);
        szLw := CHR(64+t)+':\';

        If (not IsItem(copy(szLw, 1, 2))) and (io and $8000 = 0)
            then AddItem(szLw);
     end;
     Inc(t);

   UNTIL (t>numberofdrives);
  END;

END;

{$ENDIF}

{ --- [Statistik] --------------------------------------------------------- }

Procedure Statistik;  { 08.01.97 }

var s : String;
    lMB : LongInt;

 Function sFormat(l : LongInt) : String;
 var s : String;

 begin { format }
    s := Format(l);
    while length(s) < 10 do s := ' '+s;
    sFormat := s;
 end; { format }

 begin { Statistik }
  clreol;
  writeln;
  writeln1(GuruHeadLine('Statistics'));
  writeln;

  lMB := Trunc(dSizeFiles / (1024.0 * 1024.0))+1;
  writeln1(' Files total .............................. '+sformat(lChk)+ '  '+format(lMB)+' MB');
  if lChk>0 then str(lFound/lChk*100:3:1,s)
            else s := '0.0';
  writeln1(' Files checked ............................ '+sformat(lChkReal));
  if lChkReal>0 then str(lFound/lChkReal*100:3:1,s)
            else s := '0.0';
  writeln1(' Duplicate files .......................... '+sformat(lFound)+'         ('+s+'%)');
  if lChk>0 then str(lRenamed/lChk*100:3:1,s)
            else s := '0.0';
  if lAdded > 0 then
  writeln1(' Files added to the database .............. '+sformat(ladded));
  if lRenamed > 0 then
  writeln1(' Renamed files ............................ '+sformat(lRenamed)+'         ('+s+'%)');

  if lFound > 0 then str(lRemoved/lFound*100:3:1,s)
                else s := '0.0';
  writeln1(' Files deleted ............................ '+sformat(lRemoved)+'         ('+s+'%)');
{$IFDEF STACK}
  writeln1(' Stack used/total ......................... '+sformat(UsedStack)+'/'+Format(HighSP));
{$ENDIF}
  writeln1(' Weeding time needed ......................   '+Wandle_Zeit(rTime));
  writeln;
  writeln1(GuruHeadLine('Weeding finished! Have a virus free time!'));

 end; { Statistik }

 { ----------------------- CleanUp ----------------------------- }

Procedure CleanUP;

{ var hO : File; }

begin

{ comment out for debugging purposes }

(*
assign(hO,'rfw!.dmp');
rewrite(hO,1);
blockwrite(hO,aFile^,sizeof(aFile^));
close(hO);
*)

  if kz^.IsOption('log') then close(hLog);

  if kz^.IsOption('Quick') or kz^.IsOption('uniq') then
  begin
       if not kz^.IsOption('Keep') then
       begin
          unlink(szDataBase);
          unlink(szDataFiles);
       end;
  end;

  dispose(aDBLen);
  dispose(aHashCrc[0]);
  dispose(aHashCrc[1]);
  dispose(aHashCrc[2]);
  dispose(aHashCrc[3]);
  dispose(aHashCrc32[0]);
  dispose(aHashCrc32[1]);
  dispose(aHashCrc32[2]);
  dispose(aHashCrc32[3]);
  dispose(aHashCrc32[4]);
  dispose(aFile);
  dispose(kz, done);

  ChDir(szHome);

end;


{ ------[MAIN]--------------------------------------------------------- }

begin

  bStdOut := FALSE;
  rTime   := 0.0;

  new(kz, init);
  writeln;

  if kz^.IsOption('Log') then
  begin
    szTmp := kz^.GetString('Log');
    if szTmp = '' then szTmp := '.'+SLASH+'RFW.LOG';
    szLogFile := FExpand(szTmp);
    if ioresult <> 0 then sirene; { win95 bug }
    assign(hLog, szLogFile);
    if ioresult <> 0 then
    begin
       writeln1('ERROR: Can not create/open LOG file: '+szLogFile);
       halt(5);
    end;
    rewrite(hLog);
    if ioresult <> 0 then
    begin
       writeln1('ERROR: Can not write to LOG file: '+szLogFile);
       halt(5);
    end;
  end;

  { Versionsnummer }
  writeln1(GuruHeadLine('RFW'+ {$IFDEF FPC} '/32'+ {$ENDIF}
           ' - ROSE''s File Weeder - Version 2.00'
           {$IFDEF SMALLMEM} +'/Small' {$ENDIF}
           {$IFDEF STACK} + '/Stack' {$ENDIF}
           {$ifdef lfn} + '/LFN' {$ENDIF}
           +'' { beta etc. }
           ));
  writeln1('(c) 1989-2001 by ROSE SWE - Dipl.-Ing. Ralph Roth - See ROSEBBS.TXT for address');

  bStdOut := kz^.IsOption('STDOUT');
  if bStdOut then Crt2Con;

  if (kz^.ParamCounter < 1) or (kz^.IsOption('?') or kz^.IsOption('help')) then
  begin
    writeln;
    if not kz^.IsOption('??') then
    begin
     writeln1(GuruHeadLine('Usage'));
     writeln('usage:             RFW  [-/options]  [drive:[\path]]  [-/options] [-??]');
     writeln;
     writeln('Drive:  Drive:\    Scans recursivly the drive from the root directory.');
     writeln('Drive:\Path        Scans recursivly the drive from the given directory.');
     writeln('.                  Scans recursivly the current directory.');
     writeln;
     writeln1(GuruHeadLine('Basic Options'));
     writeln('-? -help     This help screen! -?? for help on the guru options!');
     writeln('-Add         Add new files to the current database');
     writeln('-All         Scans all files (*.*), default: Binaries, MS-Office, source code');
     {$IFNDEF FPC}
     writeln('-Auto        Scans all drives (local and remote), except diskette drives');
     {$ENDIF}
     writeln('-Base=File   Add files to the database "File[.dat]", default = rfw.dat/rfw.lst');
     writeln('-Del         Deletes duplicate files! No query is made!');
     writeln('-FC          File Compare. Tries an 1:1 file compare - old files must exist!');
     writeln('-File        Show file name of original file. Don''t kill dups with same path.');
     writeln('-FileShort   Same as /File, but only the file name is printed');
     writeln('-Log[=File]  Write a report to the log file "FILE", default is RFW.LOG');
    end
     else
    begin
     writeln1(GuruHeadLine('Guru switches'));
     writeln('-Dir         Remove empty directories. Does not work with NT4<->win32 version');
     writeln('-Err[=xx]    Sets DOS Errorlevel to zero (or xx), useful for REARJ or batches');
     writeln('-Exdir=xx    Exclude the directory "xx" and its subfolders from being processed');
     writeln('-ExFile=list Exclude files (* future *)');
     writeln('-Info        Show startup informations and terminate without doing anything.');
     writeln('-JPG         DB=rfw_jpg.dat, adds only .JPG, .GIF, .AVI, .MPG, .TIF etc.');
     writeln('-Keep        Does not remove RFW.DAT (only valid with /UNIQ or /QUICK)');
     writeln('-Quick       Cur. dir,/ALL /RANDOM /DEL /ADD /BASE=%tmp%\RFW.DAT /DIR;del rfw.*');
     writeln('-Random      /Renumber=[Random Integer between 0 and 750000], useful for batch');
     writeln('-Rename      Smart renaming, depending on the entry point, e.g. MZ/ZM gets .EXE');
     writeln('-RenMarx     Smart renaming, using extension .??$ (used by Andreas Marx :))');
     writeln('-Renumber[=x]/Rename & create unique filename, based on a counter. Default x=0');
     writeln('-RenPE       Win/OS2 files will be renamed to .NE/.PE/.LX/.LE instead of .EXE');
     writeln('-StdOut      No colors and stdout instead of BIOS is used. Useful for pipes.');
     writeln('-Uniq        current dir, /ALL /DEL /ADD /BASE=%tmp%\RFW.DAT /DIR; del rfw.*');
    end;
    halt(2);
  end;

{$IFNDEF FPC}
  lMem := LongInt((MAXCRCSIZE*9+MAXBUFSIZE+MAXFILELOOKUP*4)+20000);
  if memavail <  lMem then
  begin
       writeln1(GuruHeadLine('Error'));
       writeln('Not enough memory free, ',Format(lMem-Memavail),
               ' additionally bytes required!');
       writeln('Free = ',format(memavail),' largest block = ',format(maxavail));
       writeln1(GuruHeadLine('Program aborted!'));
       halt(8); { memory }
  end;
{$ENDIF}

  Randomize;
  lFound        := 0;
  lChk          := 0;
  lChkReal      := 0;
  lRemoved      := 0;
  lRenamed      := 0;
  lAdded        := 0;
  lRenameDelta  := kz^.GetValue('Renumber');  { or 0 if not used }
  dSizeFiles    := 1024.0;                    { div 0 bug }

  GetDir(0, szHome);

  if (kz^.IsOption('Quick') Or kz^.IsOption('Uniq')) then
  with kz^ do
  begin
       if ParamStrCounter > 0 then
       begin
            writeln1(GuruHeadLine('Error'));
            writeln('Option /QUICK and /UNIQ can not be mixed with paths/directories!');
            halt(9);
       end;
       AddItem('.'); { local }
       AddOption('All');
       if IsOption('Quick') then
          AddOption('Random');
       AddOption('Del');
       AddOption('Add');

       repeat
             szTmp := getenv('tmp')+SLASH+'rfw_'+hex(random(65000),4)+'.dat';
       until not exists(szTmp);

       AddOption('Base='+szTmp);
       AddOption('Dir');
  end;

  if kz^.IsOption('Random') then lRenameDelta := longint(Random(65000))+Longint(LongInt(Random(65000))*31);

{$IFNDEF FPC}
  if kz^.IsOption('Auto') then AutoGetParams;
{$ENDIF}

  writeln;
  writeln1(' Commandline: ' + kz^.ParamS^);

  bUserBreak    := FALSE;
  bDelete       := kz^.IsOption('dEl');
  bReNumber     := kz^.IsOption('ReNumber') or kz^.IsOption('Random');
  bRenMarx      := kz^.IsOption('RenMarx');
  bRenPe        := kz^.IsOption('RenPE');
  bReName       := kz^.IsOption('Rename') or bRenumber or bRenMarx or bRenPE;
  bAllFiles     := kz^.IsOption('All') or bReNumber or bRename;
  bAddFiles     := kz^.IsOption('Add');
  bShowFileName := kz^.IsOption('File');  { andi marx }
  nExitCode     := kz^.GetValue('ERR');
  bUseErrCode   := kz^.IsOption('ERR');
  bFileShort    := kz^.IsOption('FILESHORT');
  bRmdir        := kz^.IsOption('Dir');
  bFileComp     := kz^.IsOption('FC');    { andi marx, 0.92 }
  bJPG          := kz^.IsOption('JPG');

  szExDir       := Upper(kz^.GetString('exdir'));
  szDataBase    := kz^.GetString('base');
  if bJPG then szDataBase := 'RFW_JPG.DAT';

  if szDataBase = '' then
    if not existonpath('rfw.dat',szDataBase) then
      writeln1(' Database not found using PATH statement!');

  if pos('.', szDataBase) < 1 then
     szDataBase := szDataBase+'.DAT';

  szDataBase := fexpand(szDataBase);  { BUG/FATAL: Expand to full path! };

  fsplit(szDataBase, szDir, szBName, szExt);
  szDataFiles := szDir+szBName+'.lst';

  Writeln1(' Creating hash tables using '+format(MAXCRCSIZE*9+13+MAXBUFSIZE+MAXFILELOOKUP*4)+' bytes memory for '
              +format((MAXCRCSIZE*9+9+MAXFILELOOKUP+MAXBUFSIZE)*8)+' entries!');

  CreateHashTable;  { malloc }

{$IFNDEF FPC}
  Writeln1(' Free memory left       = '+format(memavail)+' bytes');
{$ENDIF}
  Writeln1(' Checksum database used = '+szDataBase+', '+format(lDBEntry)+' entries');
  Writeln1(' Filename database used = '+szDataFiles);

  if bUseErrCode then
     writeln1(' Switch /ERR: Setting ERRORLEVEL='+klformat(nExitCode));

  if bAllFiles then szTmp := '(All files)'
               else szTmp := '(Executables, Images, MS-Office, Sources)';
  writeln;

  if kz^.IsOption('INFO') then
  begin
        writeln1(GuruHeadLine('RCS Internal Information'));
        writeln('RFW Main:');
        writeln('$Header: C:/TP/VIR/RCS/rfw.pas 1.10 2001/05/08 17:50:03 rar_ulm Exp $');
        writeln('RFW Unit:');
        writeln(RCS_ID_RFWUNIT);
        cleanup;
        halt(0);
  end;

  clearkeys;
  rTime := Timer;

  for nParam := 1 to kz^.ParamStrCounter do
  begin
    szParam := kz^.ParamString(nParam);
{$IFNDEF FPC}
    szParam := Upper(DirAdust(szParam));
    if length(szParam) = 2
       then szParam := szParam+'\';
{$ENDIF}
    ChDir(szParam);
    if ioresult = 0 then
    begin
         GetDir(0, szParam);
         if length(szParam) = 3
            then szParam := copy(szParam, 1, 2);

         writeln1(GuruHeadLine(PathFit(szParam,22)+'  '+szTmp));
         writeln1(' Scan started at '+datum+'  ['+time+']');

         Bearbeite(szParam);

         clreol;
         writeln;
    end
    else
        writeln1('ERROR: Path '+szParam+' not found!'^m^j);
  end;

  rTime := Timer - rTime;
  if bUserBreak then writeln1(' Weeding process aborted due to user break!');
  Statistik;

  CleanUP;

  if bUseErrCode
     then halt(nExitCode);

  if lFound <> 0 then halt(10) else halt(0)
end.

{ /* end /* }
