{******************************************************}
{*                                                    *}
{*    RFWUNIT - common functions shared with RHBVS    *}
{*              and RFW                               *}
{*                                                    *}
{*   (c) by RalphRoth@gmx.de, http://come.to/rose_swe *}
{*                                                    *}
{******************************************************}

{**********************************************************************}
{*                                                                    *}
{* Source code is included for finding bugs and better                *}
{* enhancements requests. Feel free to send back modified source      *}
{* code. Please comments changes clearly.                             *}
{*                                                                    *}
{* Currently I am searching an 32 bit Pascal compiler that can        *}
{* compile RFW into a 32 bit application, using 4 GB for hash tables! *}
{* FPC looks very good and I have written/ported some of the programs *}
{* so far, but RFW uses some inline/asm (CRC, SeekEP) routines, so I  *}
{* need additional manpower for the proting to FPC/32 - maybe you? :) *}
{*                                                                    *}
{* Anyone interested in continue the work on RFW? Contact me via      *}
{* email: RalphRoth@gmx.de, http://come.to/rose_swe                   *}
{*                                                                    *}
{*                                                                    *}
{**********************************************************************}

{ ---------------------------------------------------------------------

$Header: C:/TP/VIR/RCS/rfwunit.pas 1.3 2001/03/24 22:24:57 rose300 Exp $

$Log: rfwunit.pas $
Revision 1.3  2001/03/24 22:24:57  rose300
RFW/32 - beta 2

Revision 1.2  2001/02/18 13:00:01  rar
consolidated units for RFW 1.07

Revision 1.1  2000/12/24 12:23:40  rose_swe.p300
Initial revision

----------------------------------------------------------------------- }

{$I COMP.pas}
Unit RFWUNIT; { 08.08.98 }

INTERFACE

VAR

    { need here, because we don't want to rename our own log files! }

    szDataBase  : String;       { path to database }
    szDataFiles : String;       { path to database with filenames }
    szLogFile   : String;       { path to logfile }

    lRenamed    : LongInt;
    lRenameDelta: LongInt;

    Procedure SmartFileRename(bRenumber: Boolean;
                              bRenmarx : Boolean;
                              bRenPE   : Boolean
                             );  { 05.02.98 }

const RCS_ID_RFWUNIT = '$Header: C:/TP/VIR/RCS/rfwunit.pas 1.3 2001/03/24 22:24:57 rose300 Exp $';

IMPLEMENTATION

uses crt, dos, constant, r_utils, rstrings;

{$i seekep.pas}

{ ---------------------------------------------------------------------- }

Procedure SmartFileRename;  { 05.02.98 }

{ renames the files in the current directory }

const szForbidden = '.ZIP.ARC.LHA.RAR.ARJ.ZOO.PAK.PAC.ACE.UC2.SIT.LHZ';

var sr   : SearchRec;
    hIn  : File;
    aBuf : array[1..$411] of byte;
    aPBuf: EinKilo absolute aBuf;
    szE,szNew  : ExtStr;
    szD  : DirStr;
    szN  : NameStr;
    res, wPE  : Word;
    lCount    : LongInt;
    bForce    : Boolean;
    t         : Byte;
    szTmp     : String[20];
    szPE      : String[3];

begin { 27.01.98 }

      lCount := 0;

      FindFirst('*.*',AnyFile-VolumeId-Directory, sr);

      while DosError = 0 do
      begin
           clreol;
           write('Rename=',sr.name,#13);
           fsplit(sr.name, szD, szN, szE);

           bForce := bReNumber;
           szNew  := '';
           szE    := Upper(szE);   { win32, linux! }

           if szE = '' then szE := '.rfw';

           if (pos(sr.name, szDataBase) = 0) AND { don't trash with logs }
              (pos(sr.name, szLogFile) = 0) AND
              (pos(sr.name, szDataFiles) = 0) AND
              FOpenBin(hIn, sr.name) then
           begin
                blockread(hIn, aBuf[1], SizeOf(aBuf)-1, res);
                close(hIn);

                szTmp := '';
                for t:=1 to sizeof(szTmp)
                    do szTmp := szTmp+UpCase(char(aBuf[t]));
                if pos('VIRUS',szTmp) in [1..4] then szNew := '.TXT';
                if pos('MACRO',szTmp)>0 then szNew := '.MAC';
                if pos('SUB MAIN',szTmp)>0 then szNew := '.MAC';

                if SeekEP(aPBuf) > 1     { VSP's entry point engine!!! }
                   then szNew := '.COM';  { COM or EXE! }
                if ((aBuf[1] in [$e8,$e9,$eb,$b8..$bf])
                    or FindCodeFraq(@aPBuf,'E80000',$e8,sizeof(aBuf),res)
                    or FindCodeFraq(@aPBuf,'cd21',$cd,sizeof(aBuf),res)
                    or FindCodeFraq(@aPBuf,'558bec83',$55,sizeof(aBuf),res)
                    or FindCodeFraq(@aPBuf,'90909090909090',$90,sizeof(aBuf),res)
                    or FindCodeFraq(@aPBuf,'00000000000000',$00,sizeof(aBuf),res)
                   ) and (sr.size < $fd00) then
                     szNew := '.COM';

                if (char(aBuf[1]) in ['M','Z']) AND   { enhanced July 2000 by rar }
                   (char(aBuf[2]) in ['M','Z']) AND
                   (aBuf[1] <> aBuf[2]) then
                   begin
                      szNew := '.EXE';

                      wPE := aBuf[$20]*256+aBuf[$19];
                      if bRenPe and (wPE >= $40) then
                      begin
                        wPE := aBuf[$3c+2]*256+aBuf[$3c+1];
                        inc(wPE); { we start with index 1 }

                        if wPE >= sizeof(aBuf) then  { real guessing }
                        begin
                            if FindCodeFraq(@aPBuf,'0000004E45',$0, sizeof(aBuf), res)
                               then szNew := '.NE';
                            if FindCodeFraq(@aPBuf,'50450000',$50, sizeof(aBuf), res)
                               then szNew := '.PE';
                        end
                       else
                        begin
                             szPE  := chr(aBuf[wPE])+chr(aBuf[wPE+1]);
                             if pos(szPE,'PE NE LE LX') > 0 then
                                szNew := '.'+szPE;
                        end; { if > buffer }
                      end; { >= $40 }
                   end; { .EXE }

                if (aBuf[1] = $ff) AND (aBuf[2] = aBuf[3]) and (aBuf[4]=$ff)
                   and (Abuf[2]=$ff) then szNew := '.SYS';
                if (aBuf[1] in [$ea,$eb]) OR
                (
                    FindCodeFraq(@aPBuf,'fa33c0',$fa,sizeof(aBuf),res) or
                    FindCodeFraq(@aPBuf,'55aa',$55,sizeof(aBuf),res) or
                    FindCodeFraq(@aPBuf,'a11304',$a1,sizeof(aBuf),res) or
                    FindCodeFraq(@aPBuf,'a31304',$a3,sizeof(aBuf),res) or
                    FindCodeFraq(@aPBuf,'b106d3e0',$b1,sizeof(aBuf),res) or
                    FindCodeFraq(@aPBuf,'8ed0bc007c',$8e,sizeof(aBuf),res)
                ) then
                begin
                   if (sr.size=512) then szNew := '.BIN';
                   if (sr.size=1024) then szNew := '.IMG';  { 2 sectors }
                   if (sr.size=1026) then szNew := '.IMG';  { scobp-image }
                   if (sr.size=8704) then szNew := '.IMG';  { scobp-image }
                   if (sr.size>$ffff) then szNew := '.IMG';
                end;

                if (aBuf[$1ff]=$55) AND (aBuf[$200]=$AA) then
                   szNew := '.BIN';

                if (aBuf[1]=$D0) and (aBuf[2]=$cf) and
                   (aBuf[3]=$11) and (aBuf[4]=$e0)
                     and ((pos('DO',szE)=0)
                     and (pos('XL',szE)=0)
                     and (pos('SHS', szE)=0)
                    or (szNew<>'')
                    or (szNew ='.COM'))
                   then szNew := '.DOC';

                if (aBuf[1]=$80) and (aBuf[3]=$0) and (pos('.ASM',szTmp)>4)
                   then sznew := '.OBJ';
                if (aBuf[1]=$80) and (aBuf[2]=$09) and
                   (aBuf[3]=$00) and (aBuf[4]=$07)
                   then szNew := '.OBJ';

                if pos('ECHO OFF',szTmp)>0 then szNew := '.BAT';
                if pos('@ECHO ',szTmp)=1 then szNew := '.BAT';
                if pos('@ECHO ',szTmp)>0 then szNew := '.BAT';
                if pos('GIF8', szTmp)>0 then szNew := '.GIF';
                if pos('JFIF', szTmp)=7 then szNew := '.JPG';
                if pos(#127+'ELF', szTmp)=1 then szNew := '.ELF';
                if pos('TD'#0, szTmp)=1 then szNew := '.TD0';           { fixed: 21.11.99, rar }
                if pos('RAR!'#$1a, szTmp)=1 then szNew := '.RAR';
                if pos('THIS IS A', szTmp)=1 then szNew := '.TXT';
                if pos('INFECTOR WHICH INFECTS FILES', szTmp)=1 then szNew := '.TXT';
                if pos('AN OVERWRITING VIRUS', szTmp)=1 then szNew := '.TXT';
                if pos('INFECTOR THAT INFECT', szTmp)=1 then szNew := '.TXT';
                if pos('[SCRIPT]', szTmp)=1 then szNew := '.INI';
                if pos(#0'STANDARD JET DB'#0, szTmp)>1 then szNew := '.MDB';
                if pos('%PDF-', szTmp)=1 then szNew := '.PDF';
                if (pos('<HTML>', szTmp)>0) AND (Pos('<HEAD>', szTmp)>4) then szNew := '.HTM';
                if pos('-LH5-',szTmp) >1 then szNew := '.LZH';
                if (aBuf[1] = $60) and (aBuf[2] = $ea) then szNew := '.ARJ';
                if pos('PK'#3#4,szTmp)=1 then szNew := '.ZIP'; { 29.07.2000 }
                if pos('WAVEFMT',szTmp)>5 then szNew := '.WAV';
                if pos('**ACE**',szTmp)>1 then szNew := '.ACE';
                if pos('?_'#3#0,szTmp)=1 then szNew := '.HLP';
                if pos('ITSF'#3#0,szTmp)=1 then szNew := '.CHM';
                if pos('TFMR'#$A#0,szTmp)=1 then szNew := '.FTS';
                if pos('AVI LIST',szTmp)>4 then szNew := '.AVI';
                if pos(':BASE ',szTmp)=1 then szNew := '.CNT';
                if pos('MSFT',szTmp)=1 then szNew := '.TXT';
                if pos('MSCF'#0#0,szTmp)=1 then szNew := '.CAB'; { 29.07.2000 }

                if bRenMarx then
                   if szNew <> '' then szNew := copy(szNew,1,3)+'$'
                                  else szNew := copy(szE,1,3)+'$';

                if (bForce OR ((szNew <> szE) AND (szNew <> '')))
                   AND (pos(szE, szForbidden)=0) then
                begin
                   if bForce and (szNew='') then szNew := szE;
                   while exists(szN+szNew) or (bForce) do
                   begin
                        bForce := FALSE;
                        szN := hex(lCount+lRenamed+lRenameDelta,6);
                        if exists(szN+szNew) then inc(lCount);
                   end;
                   {writeln(sr.name,' -> ',szN+szNew);}
                   doserror := 0;
                   SetFAttr (hIn, 0);
                   rename(hIn, szN+szNew);
                   if ioresult = 0 then inc(lRenamed);
                   if doserror <> 0 then writeln('Error: File ',sr.name,' access denied!');
                end;
           end;
           FindNext(sr);
      end;

end; { 27.01.98 }

end. { rfwunit }
