program k_goat_files;
{$I comp.pas}
{&R c:\tp\icons\danger.res}

uses
  dos, crt,

  {$IFnDEF FPC}
  syserr,
  netzwerk,
  {$ENDIF}

{$IFNDEF FPC} avr_poly, {$ENDIF}
  constant,     { fpc portable }
  rStrings,
  r_utils;      { fpc portable }


{********************************************************}
{*                                                      *}
{* (C)opyright 1987-2001 (ALL RIGHTS RESERVED!)         *}
{*                                                      *}
{*            Ŀ     *}
{*             ROSE SWE                              *}
{*             Dipl.-Ing. Ralph Roth                 *}
{*                                                   *}
{*             Vollstndige Adresse, inkl.           *}
{*             Email, FAX, Telefon & PGP key         *}
{*             siehe Datei:   ROSEBBS.TXT            *}
{*                                                   *}
{*                     RalphRoth@gmx.de              *}
{*                 http://come.to/rose_swe           *}
{*                *}
{*                  *}
{*                                                      *}
{********************************************************}

{$IFDEF FPC}
{$I seekep.pas}
{$ENDIF}

const VirusMinLen = 1;        { Darunter infiziert er nicht! }
      PATHLEN     = 50;       { Auf soviel wird Pfad gekrzt! }


var
    search      : String;
    szSearch    : String;
    szName      : String;
    szHome      : String;
    szParam     : String;
    szTmp       : String;
    lFound      : LongInt;
    lremoved    : LongInt;
    lChk, lSize : LongInt;
    bDelete     : Boolean;
    bLog        : Boolean;
    bGreater    : Boolean;
    cCmd        : String;
    hLog        : Text;


{ --- [Writeln1 ] ------------------------------------------------------- }

procedure writeln1(szWhat: String);

var t, v : Byte;

begin
     for t := 1 to length(szWhat) do
     begin
          v := byte(szWhat[t]);
          textcolor(7);
          if v < 48 then textcolor(3);
          if v in [91..96] then textcolor(3+8);
          if v > 122 then textcolor(1+8);
          if v = 254 then textcolor(white);
          (* if (chr(v) in ['A'..'Z']) then textcolor(11); *)
          write(szWhat[t]);
          end;
     writeln;
     textcolor(7);


end; { writeln1 }

{ ---------------------------------------------------------------------- }

Function AVR_goats(filename: String) : String;
{ 02.01.96, 01.09.96, 22.02.99, rar }

var
    hIn                    : File;
    wAttr, wVLen, nT, wDLen: Word;
    szAVR                  : String;
    szLen, szPE            : String[10];
    Buffer                 : pEinKilo;
    bMode, i               : Byte;
    XorByte                : Byte;
    w, wOldNT              : Word;
    lDatum                 : LongInt;
    dt                     : DateTime;
    wEP, wEP_PE            : LongInt;
    bEXE                   : Boolean;


label exit_here;

begin
     AVR_goats := '';
     szAVR     := '';
     bMode     := FileMode;
     FileMode  := FileMode or 2;        { read/write }

     new(buffer);

     Assign(hIn, Filename);
     reset(hIn, 1);
     blockread(hIn, buffer^, $80);      { head }

     wEP := SeekEP(buffer^);

     if wEP > fileSize(hIn) then
     begin
        szAVR := 'Corrupted (Head)'; 
	{ '('+format(wEP)+'/'+format(FileSize(hIn))+')'; }
        szLen := '';
        goto exit_here;
     end;

     bExe := (Char(Buffer^[0]) in ['M','Z']) AND
             (Char(Buffer^[1]) in ['M','Z']) AND
             (Buffer^[0] <> Buffer^[1]);

     w := Buffer^[$18]+Buffer^[$19]*256;
     if bEXE AND (w >= $40) then
     begin  { maybe PE }

            w := Buffer^[$3C]+Buffer^[$3D]*256;
            if w > fileSize(hIn) then
            begin
                 szAVR := 'Corrupted (PE:Head)';
                 szLen := '';
                 goto exit_here;
            end;

            Seek(hIn, w);
            blockread(hIn, buffer^, $20);      { head }

            szPE := Chr(Buffer^[0])+Chr(Buffer^[1]);

            if Pos(szPE, 'NE PE LX LE') > 0 then
            begin
                 { szAVR := 'Ext_EXE.'+szPE; }
                 szLen := '';
                 goto exit_here;
            end;
     end;

     seek(hIn, wEP);
     blockread(hIn, buffer^, sizeof(buffer^), wVLen); { e8000005d... }

     str(wVLen, szLen);

     if (wVlen = 0) then
     begin
        szAVR := 'Corrupted (Jump)';
        szLen := '';
        goto exit_here;
     end;

     nT := 0;

     while (nT < wVLen) and (Buffer^[nT] in [$0,$4,$90])
           do inc(nT);

     if (nT = wVlen) then
        szAVR := 'Trash (Zeros)';

     (*
     nT := 0;

     while (nT < wVLen) and (Buffer^[nT] = $90)
           do inc(nT);

     if (nT = wVlen) then
        szAVR := 'NOPs';
     *)

     if (Buffer^[nT] = $CD) and (Buffer^[nT+1] = $20) then
        szAVR := 'Goat (Int20h)';

     if (Buffer^[nT] = $b8) and (Buffer^[nT+1] = $0) and (Buffer^[nT+2] =$4c)
        and (Buffer^[nT+3] = $cd) and (Buffer^[nT+4] = $21) then
        szAVR := 'Goat (NoMercy)';

     wOldNT := nT;
     i      := nT;

for nT := i to i+2 do
begin
     if (Buffer^[nT] = $b4) and (Buffer^[nT+1] = $09) and (Buffer^[nT+2] =$ba)
        and (Buffer^[nT+5] = $cd) and (Buffer^[nT+6] = $21)
        and (Buffer^[nT+7] = $b8) and (Buffer^[nT+9] = $4c)
        and (Buffer^[nT+10] = $cd) and (Buffer^[nT+11] = $21)
     then
        szAVR := 'Goat (PrintText-1)';

     if (Buffer^[nT] = $b4) and (Buffer^[nT+1] = $09) and (Buffer^[nT+2] =$ba)
        and (Buffer^[nT+5] = $cd) and (Buffer^[nT+6] = $21)
        and (Buffer^[nT+7] = $cd) and (Buffer^[nT+8] = $20)
     then
        szAVR := 'Goat (PrintText-2)';

     if (Buffer^[nT] = $ba) and (Buffer^[nT+3] = $b4) and (Buffer^[nT+4] =$09)
        and (Buffer^[nT+5] = $cd) and (Buffer^[nT+6] = $21)
        and (Buffer^[nT+7] = $30) and (Buffer^[nT+8] = $c0)
        and (Buffer^[nT+9] = $b4) and (Buffer^[nT+10] = $4c)
        and (Buffer^[nT+11] = $cd) and (Buffer^[nT+12] = $21)
     then
        szAVR := 'Goat (PrintText-3)';

     if (Buffer^[nT] = $ba) and (Buffer^[nT+3] = $b4) and (Buffer^[nT+4] =$09)
        and (Buffer^[nT+5] = $cd) and (Buffer^[nT+6] = $21)
        and (Buffer^[nT+7] = $b8) and (Buffer^[nT+9] = $4c)
        and (Buffer^[nT+10] = $cd) and (Buffer^[nT+11] = $21)
     then
        szAVR := 'Goat (PrintText-4)';

     if (Buffer^[nT] = $8c) and (Buffer^[nT+1] = $c8) and (Buffer^[nT+2] =$8e)
        and (Buffer^[nT+3] = $d8) and (Buffer^[nT+4] = $ba)
        and (Buffer^[nT+7] = $b4) and (Buffer^[nT+8] = $09)
        and (Buffer^[nT+9] = $cd) and (Buffer^[nT+10] = $21)
        and (Buffer^[nT+11] = $b4) and (Buffer^[nT+12] = $4c)
        and (Buffer^[nT+13] = $cd) and (Buffer^[nT+14] = $21)
     then
        szAVR := 'Goat (PrintText-5)';
end;

    nT := wOldNT;

     if (Buffer^[0] = $c3) and (wEP < 2) then
        szAVR := 'Goat (COM-Ret)';

if (wEP > 3) AND (Buffer^[0] <> $E8) {and (wVLen <> sizeof(Buffer^))} then
begin
     if (FindCodeFraq(@Buffer^[0], 'b8014ccd21', $b8, 8, nT))
       then
          szAVR := 'Exit_1';
     if (FindCodeFraq(@Buffer^[0], 'b8004ccd21', $b8, 8, nT))
       then
          szAVR := 'Exit_0';

     if (FindCodeFraq(@Buffer^[0], 'e90000e84100', $e9, 2, nT))
       then
          szAVR := 'Goat40';

     if (FindCodeFraq(@Buffer^[0], 'ba0301b409cd21b44ccd21', $ba, 3, nT))
       then
          szAVR := 'Sophos';

     if (FindCodeFraq(@Buffer^[0], 'b40fcd10bb00b83c0274', $b4, 3, nT))
       then
          szAVR := 'TheDraw';

     if (FindCodeFraq(@Buffer^[0], '8edab409ba3700cd21', $8e, 10, nT))
       then
          szAVR := 'RHRG-Goat';


end;

     if (FindCodeFraq(@Buffer^[0], 'b40ebb0000be1601ac0ac07404cd10', $b4, 10, nT))
       then
          szAVR := 'Sacrifice-Goat';

     if (FindCodeFraq(@Buffer^[0], 'b80300cd10b80006b90000b24fb618', $b8, 10, nT))
       then
          szAVR := 'InfectMe';

     if (FindCodeFraq(@Buffer^[0], '0e1fba1601b409cd21b8004ccd21', $0e, 5, nT))
       then
          szAVR := 'JH-Goat';

     if (FindCodeFraq(@Buffer^[0], 'b409ba1601cd21cd202424', $b4, 8, nT))
       then
          szAVR := 'LiveGoat';

     if (FindCodeFraq(@Buffer^[0], '3a7370202073733a737020207373', $3a, 8, nT))
       then
          szAVR := 'ROSE-Goat SS:SP';

     if (FindCodeFraq(@Buffer^[0], '8cca8edaba8501b409cd21b8070ecd10b8004ccd21', $8c, 8, nT))
       then
          szAVR := 'Activ-Goat';

     if (Buffer^[0] = $e8) and (Buffer^[1] = $44)
     and (FindCodeFraq(@Buffer^[0], '5afcb409cd21facd20', $5a, 128, nT))
       then
          szAVR := 'Funky_Bait';

if wEP = 0 then
begin
     if (FindCodeFraq(@Buffer^[0], 'bb1401b010b402ba', $bb, 8, nT)) and
        (FindCodeFraq(@Buffer^[0], 'b90100cd13b8004ccd21', $b9, 18, nT))
       then
          szAVR := 'ReadSector';

end; { wEP = 0 }

     if szAVR <> '' then
        szAVR := szAVR + '.' + szLen;

Exit_Here:
     close(hIn);
     dispose(buffer);
     FileMode := bMode;

     AVR_goats := szAVR;

end; { goats }

{ ---------------------------------------------------------------------- }

procedure Bearbeite(pfad: string);

var sr: SearchRec;

begin { Bearbeite }

 if length(Pfad) > SizeOf(DIRSTR) then   { 1.11, 07.02.99, rar }
 begin
      Writeln1('ERROR! Path is longer than internal MS-DOS structure, skipping!');
      Writeln1('Path='+Pfad);
      exit;
 end;

 FindFirst('*.*', anyfile-VolumeId, sr);
 while (DosError=0) do
    begin
      if ((sr.attr AND directory) = Directory) AND (sr.name[1] <> '.')
      then
      begin
          szName := pfad+'\'+sr.name;
          chdir(szName);
          bearbeite(szName);
      end
    else
      if sr.name[1] <> '.' then
      begin
        szName := pfad+'\'+sr.name;
        write(pathfit(szname,PATHLEN));
        clreol;
        write(#13);
        szSearch := '';

        inc(lChk);
        inc(lSize, sr.size);

        { targets }
        if bGreater then
        begin
           if sr.size > $0ff00 then szSearch := 'BigFile';
        end
          else
        szSearch := AVR_goats(szName);

        if szSearch <> '' then
        begin
          inc(lFound);
          if ioresult <> 0 then {} ;
          textcolor(white);
          write(copy(pathfit(szName,PATHLEN)+
                '                                           ',1,PATHLEN+5));
          textcolor(yellow);
          writeln(szSearch);
          textcolor(7);

          if bDelete then
          begin
             unlink(szName);
             inc(lRemoved);
          end;
          if ioresult <> 0 then { --- ARGGLLLLL!!!! --- };
          if bLog then writeln(hLog, szName+' Infection: '+szSearch);
        end;
      end;

      FindNext(sr);

      if keypressed then exit;
    end;
 chdir('..');
 if ioresult <> 0 then {-???-};

end; { Bearbeite }


{ ------[MAIN]--------------------------------------------------------- }

begin

  writeln;
  writeln1(GuruHeadLine('Goats Detector and Remover - Version 2.05' 
	   {$IFDEF FPC} + '/32' {$ENDIF}));;
  writeln('(c) 1994-2001 by ROSE SWE, Dipl.-Ing. Ralph Roth, RalphRoth@gmx.de');

  if (paramcount < 1) or (Copy(paramstr(1),2,1) = '?') then
  begin
    writeln1('- Home page: http://come.to/rose_swe - see also ROSEBBS.TXT');
    writeln;
    writeln1('- Detects standard goat/bait files as well as corrupted files!');
    writeln1('- Use RZooSort to sort out trash and goats from your "unknown" collection');
    writeln;
    writeln1(GuruHeadLine('Usage and parameters'));
    writeln;
    writeln1('usage: K_Goat drive:[\path] [/-options] [-?|/?]');
    writeln;
    writeln('-? /?              Show this short help.');
    writeln('Drive:  Drive:\    Scans recursivly the drive from the root directory.');
    writeln('Drive:\Path        Scans recursivly the drive from the given directory.');
    writeln('.                  Scans recursivly the current directory.');
    writeln('-d /d              Deletes found files. No query is made!');
    writeln('-g /g              Prints files greater than 64 KB');
    writeln('-l /l              Create a LOG file for ZooSort & VirSort');
    writeln;
    writeln1(GuruHeadLine('FREEWARE! ALL RIGHTS RESERVED! USE AT YOUR OWN RISK!'));
    write('  ');
    close(OutPut);
    halt;
  end;

  writeln;
  lFound        := 0;
  lChk          := 0;
  lRemoved      := 0;
  lSize         := 0;

  GetDir(0, szHome);
  szParam := ParamStr(1);
  szParam := Upper(DirAdust(szParam));

  cCmd :=  copy(Upper(ParamStr(2)), 2, 1)+copy(Upper(ParamStr(3)),2,1);

  bDelete  := (cCmd[1] = 'D') OR (cCmd[2] = 'D');
  bLog     := (cCmd[1] = 'L') OR (cCmd[2] = 'L');
  bGreater := (cCmd[1] = 'G') OR (cCmd[2] = 'G');

  if bLog then
  begin
       FileMode := 2;
       assign(hLog, 'K_Goat.Log');
       rewrite(hLog);
       writeln(hLog,GuruheadLine('K_GOAT Log File'));
  end;

  if length(szParam) = 2
     then szParam := szParam+'\';

  ChDir(szParam);
  GetDir(0, szParam);
  if length(szParam) = 3
     then szParam := copy(szParam, 1, 2);


  writeln1(GuruHeadLine(copy(szParam,1,2)));

  ClearKeys;
  Bearbeite(szParam);
  ClearKeys;

  if bLog then
     close(hLog);

  clreol;
  writeln;
  writeln1(GuruHeadLine('Statistics'));
  writeln(format(lChk),' files checked. ',
          format(lSize div (1024 * 1024)+1),' MB scanned. ',
          format(lFound),' suspicious, ',format(lRemoved),' deleted!');
  writeln1(GuruHeadLine('Scanning finished! Have a virus free time!'));
  ChDir(szHome);
  TextColor(7);
  NormVideo;
  write('   ');
  close(OutPut);
end.
