/*
 * K_Goat Signature Extractor, 20.04.2001, initial creation (Ralph)
 * Extracts from K_GOAT.PAS all used signatures, result see K-Goat.Txt
 * Must be compiled with makeflex.bat, has own yywrap()!!!
 *
 */

%{
#include <stdio.h>
#include <string.h>

int	nFound = 0;

%}

/* white space (space/tabs) */
WS      [ \t]

%s      Normal Trigger

%%
^{WS}+                          /* ignore leading space */;
{WS}+$                          /* skip ws at end of line */;
<Normal>szAVR{WS}*":="{WS}*     BEGIN Trigger;
<Trigger>"'".+"'"               {
				yytext[yyleng-1] = 0;
				if (strlen(yytext)>5)
				{
					puts(&yytext[1]); 
					nFound++;
				}
				BEGIN Normal; 
				}
.
\n				BEGIN Normal;
%%

yywrap() {  printf("Total = %d\n", nFound); return 1;  }
