//////////////////////////////////////////////////////////////////////////
//
// rez.h
//
// Copyright (c) 2002 Dennis Trachuk <dennis.trachuk@nm.ru>||<dennis.trachuk@bk.ru>
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
// PARTICULAR PURPOSE.
//

#ifndef ___rez_h___
#define ___rez_h___

#include <plugin.hpp>

struct FData
{
	DWORD Offset;
	DWORD Length;
};

#pragma pack(push,1)
struct TRezHeader
{
	char  Signature[ 0x7F ];
	DWORD Mark0;                   // 0x01
	FData Root;
	DWORD Reserved0;               // 0x00
	DWORD Index_Offset;
	DWORD Date;
	DWORD Reserved1;               // 0x00
	DWORD Max_Foldername;
	DWORD Max_Filename;
	DWORD Reserved2;               // 0x00
	BYTE  Mark1;                   // 0x01
};
#pragma pack(pop)

typedef TRezHeader * PRezHeader;

struct TRezIndex
{
	DWORD Attr;                    // 0x0 - file, 0x1 - directory
	FData Data;
	DWORD Date;
};

struct TRezFile : public TRezIndex
{
	DWORD ID;
	char  Type[ 4 ];               // it's in REVERSE! So DLL would be: LLD
	DWORD Reserved;                // 0x0
	//LPSTR Name;                    // 2 trailing '\0's!
	LPCSTR GetName() const
	{
		return (LPCSTR)this + sizeof( TRezFile );
	}
};

struct TRezDirectory : public TRezIndex
{
	//LPSTR Name;                    // 1 Trailing '\0'
	LPCSTR GetName() const
	{
		return (LPCSTR)this + sizeof( TRezDirectory );
	}
};

struct TData : public FData
{
	LPSTR Name;
};

class CRez
{
public:
	struct TItem
	{
		TItem * Parent;
		TItem * Next;
		TItem * Prev;
		TItem * SubDir;
		DWORD   Offset;
		DWORD   Length;
		FAR_FIND_DATA FindData;
	};

private:
	HANDLE      m_hFile;
	CRez::TItem m_Root;

	TRezIndex * m_Index;
	int         m_MaxIndexSize;

	CRez();

	int EnumItems( CRez::TItem * Parent );

	TItem * GetNext( TItem * Prev, TItem * Root );

	bool Extract( TItem * Item, LPCSTR Name );

public:
	~CRez();

	int EnumItems()
	{
		return EnumItems( &m_Root );
	}

	TItem * GetFirst() const
	{
		return m_Root.SubDir;
	}
	TItem * GetNext( TItem * Prev )
	{
		return GetNext( Prev, &m_Root );
	}

	bool Extract( LPCSTR Name, bool bUsePath );

	static CRez * Create( LPCSTR FileName );
	static BOOL IsRez( const unsigned char * Data, int DataSize );
};

#endif //!defined(___rez_h___)