//////////////////////////////////////////////////////////////////////////
//
// mem.cpp
//
// Copyright (c) 2002 Dennis Trachuk <dennis.trachuk@nm.ru>||<dennis.trachuk@bk.ru>
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
// PARTICULAR PURPOSE.
//

#include <windows.h>

#ifndef _DEBUG

void * malloc( size_t size )
{
	HANDLE heap = GetProcessHeap();
	return HeapAlloc( heap, HEAP_ZERO_MEMORY, size );
}

void * realloc( void * block, size_t size )
{
	HANDLE heap = GetProcessHeap();
	return block == NULL ?
		HeapAlloc( heap, HEAP_ZERO_MEMORY, size ) :
	HeapReAlloc( heap, HEAP_ZERO_MEMORY, block, size );
}

void free( void * block )
{
	if ( block != NULL )
	{
		HANDLE heap = GetProcessHeap();
		HeapFree( heap, 0, block );
	}
}

void * operator new( size_t size )
{
	return malloc( size );
}

void * operator new( size_t, void * p )
{
	return p;
}

void * operator new[]( size_t size )
{
	return malloc( size );
}

void operator delete( void * p )
{
	free( p );
}

void operator delete[]( void * p )
{
	free( p );
}

#endif // _DEBUG
