        PAGE    60,132
NAME    RESIZE
        TITLE   RESIZE version 1.3
COMMENT 


Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com

This program may be freely copied and used for any purpose
except military.

Usage:

RESIZE C:\MySub\MyFile.Ext  9999999

The size of the resultant file is 9999999 bytes

Uses for RESIZE:
1.  Shortening files.
2.  Lengthening files.
3.  preallocating space to save the time you would otherwise
    spend allocating disk space as you write records.

Note that when you lengthen a file the new parts will contain
garbage since RESIZE does not intialize that area.  This was
done on purpose for speed since your application program will
generally re-initialize the new space anyway to some complex pattern.

Note the file you RESIZE must exist already.  RESIZE will not
create it for you.  The companion program EMPTY will create an
empty file for you.


Version 1.3 1998 November 8
- embed Barker address

Version 1.2 1996 October 25
- embed POB 707 Quathiaski Cove address

Version 1.1 1993 June 7
- embed the new address and phone number.

 ;

CODE    SEGMENT PARA

        ASSUME  CS:CODE,DS:CODE
        ORG     100H

;==============================================================
SAY     MACRO   Msg
;       display message on screen
        LEA     DX,&Msg         ; use LEA rather than
                                ; MOV Offset for more generality
        MOV     AH,09h
        INT     21h
        ENDM
;==============================================================

RESIZE   PROC    FAR

START:
;==============================================================
; GET THE FILENAME AND THE NEW DESIRED SIZE FROM COMMAND LINE
        Call    ParseFileName
        Call    ParseFileSize
;==============================================================
; HOW LONG SHOULD THE NEW FILE BE?

        MOV     CX,Numberlen
        MOV     SI,NumberAd
        CALL    ASCIItoBin      ; desired size = DX:AX
        MOV     FileSize,AX     ; save in FileSize
        MOV     FileSize+2,DX
;==============================================================
; OPEN THE FILE
        MOV     DX,FileNameAd
        XOR     CX,CX           ; CX=0 is attribute
        MOV     AL,2h           ; read/write access
        MOV     AH,3Dh          ; DOS open
        INT     21h
        JC      NoSuchFile
        MOV     BX,AX           ; save handle in BX
;==============================================================
; HOW LONG IS FILE RIGHT NOW?
        XOR     DX,DX           ; CX:DX is 0 offset from end
        MOV     CX,DX
        MOV     AL,2            ; relative to end style seek
        MOV     AH,42h
        INT     21h             ; DOS seek
        JC      Trouble
                                ; DX:AX is current length of file in bytes
;==============================================================
; ARE WE SHRINKING OR GROWING THE FILE?
                                ; current size = DX:AX
                                ; desired size = FileSize
        SUB     AX,FileSize
        SBB     DX,FileSize+2
;       Note we cannot distinguish all 3 cases at this point
;       so we just treat equal as Shrinking.
;       BE CAREFUL, JL works after 32 bit compare, JG JE will not.
        JL      Growing         ; grow the file
        Call    Shrink
        JMP     Done
Growing:
        Call    Grow
Done:

;==============================================================
; CLOSE THE FILE
CLOSE:
        MOV     AH,3Eh
        INT     21h             ; DOS close
        JC      Trouble

;==============================================================
; ALL DONE
QUIT:   MOV     AX,4C00H        ; EXIT back to DOS
        INT     21H

;==============================================================
; ERROR HANDLERS

NoSuchFile:
;       Could not open file
        Say     NoSuchFileMsg
        JMP     QUIT

Trouble:
;       Some problem, give standard Error message.
;       More detail would probably just confuse
        Say     TroubleMsg
        JMP     QUIT


;==============================================================
; PARSE FILENAME
ParseFileName   PROC
                                ; counted string at HEX 80
                                ; contains command line.
                                ; It has no trailing null.
                                ; Name of file we want is
                                ; preceded and followed by
                                ; unwanted spaces.
        XOR     CH,CH
        MOV     CL,DS:80h       ; CX contains length of command
        MOV     BX,CX
        MOV     AL,20h
        MOV     [BX+81h],AL     ; store trailing blank on command
        INC     CX              ; and increase string length.
                                ; to simplify parsing
        MOV     DI,81h
        JCXZ    Trouble
        REPE    SCASB           ; scan for start file name
                                ; DI points one past it.
        MOV     DX,DI           ; DS:DX point to file
        DEC     DX
        MOV     FilenameAd,DX   ; Save pointer for future ref.
        JCXZ    Trouble
        REPNE   SCASB           ; scan to end of file name
                                ; DI points one past trail blank
        MOV     BYTE PTR [DI-1],0
                                ; patch in trail null after filename
        RET
ParseFileName   ENDP
;==============================================================

; PARSE FILESIZE

ParseFileSize   PROC
                                ; DS:SI points to blanks before
                                ; number.  CX is command len.
        JCXZ    Trouble
        REPE    SCASB           ; scan for first digit of number
        MOV     DX,DI           ; point to number start
        DEC     DX
        MOV     NumberAd,DX     ; Save location start number for
                                ; future ref.
        JCXZ    Trouble
        REPNE   SCASB           ; scan for blank at end of number
        SUB     DI,DX           ; calculate length of number string
        DEC     DI
        JLE     Trouble         ; had better be positive
        MOV     NumberLen,DI    ; save length for future ref.
        RET

ParseFileSize   ENDP

;==============================================================
Shrink  PROC
; SHRINK THE FILE
; SEEK TO THE CHOPPING PLACE
        MOV     DX,FileSize     ; CX:DX is new file length
        MOV     CX,FileSize+2
        XOR     AL,AL           ; relative to start style seek
        MOV     AH,42h
        INT     21h             ; DOS seek
        JC      Trouble

; WRITE 0 BYTES
        XOR     CX,CX           ; Write 0 bytes
        MOV     DX,CX           ; dummy location
        MOV     AH,40h
        INT     21h             ; DOS write
        JC      Trouble
        RET
Shrink  ENDP
;==============================================================
Grow    PROC
; GROW THE FILE
; SEEK TO THE 1 BYTE BEFORE THE END
        MOV     DX,FileSize     ; CX:DX is new file length
        MOV     CX,FileSize+2
        SUB     DX,1
        SBB     CX,0
        XOR     AL,AL           ; relative to start style seek
        MOV     AH,42h
        INT     21h             ; DOS seek
        JC      Trouble

; WRITE 1 BYTE
        MOV     CX,1            ; Write 1 byte
                                ; We have to write at least 1 byte
                                ; or we cannot tell if WRITE failed
                                ; from lack of disk space.
        XOR     DX,DX           ; dummy location
        MOV     AH,40h
        INT     21h             ; DOS write
        JC      DiskFull
        CMP     AX,1
        JNE     DiskFull
        RET

Diskfull:
;       not enough room to expand file
        Say     DiskFullMsg
        JMP     QUIT

Grow    ENDP
;==============================================================

ASCIIToBin      PROC
;       on entry DS:SI points to start of decimal ASCII string of digits.
;       String should contain only the decimal digits 0..9.
;       CX contains length of string > 0
;       On exit DX:AX contains binary equivalent of string.
        PUSH    BX              ; save regs we will trash
        PUSH    CX
        PUSH    SI
        PUSH    DI
        XOR     AX,AX
        MOV     DX,AX           ; accumulate in DX:AX

OneDigitLoop:

; multiply accumulated number by 10
                                ; Works because 10*X = 2*X + 8*X
                                ; use DI:BX as working register
        SHL     AX,1
        RCL     DX,1            ; DX:AX = x*2
        MOV     BX,AX
        MOV     DI,DX
        SHL     BX,1
        RCL     DI,1
        SHL     BX,1
        RCL     DI,1            ; DI:BX = x*8
        ADD     BX,AX
        ADC     DI,DX           ; DI:BX = x*2 + x*8

; add on the next digit
        XOR     DX,DX
        MOV     AH,DH
        LODSB                   ; get next digit in AL
        SUB     AL,"0"          ; convert 1 digit ASCII to bin
        JL      NumTrouble      ; ensure 0..9
        CMP     AL,9
        JG      NumTrouble
        ADD     AX,BX           ; add it onto accumulated product
        ADC     DX,DI

        LOOP    OneDigitLoop    ; loop once for each digit

                                ; restore regs
        POP     DI
        POP     SI
        POP     CX
        POP     BX              ; save regs we will trash

        RET
NumTrouble:
;       Some problem, give standard Error message.
        Say     TroubleMsg
        JMP     QUIT

;
ASCIIToBin      ENDP

;==============================================================
; VARIABLES
FileSize        DW      0,0     ; new size of file in bytes 32 bits
FileNameAd      DW      0       ; address first char of filename
NumberAd        DW      0       ; address of number string
NumberLen       DW      0       ; length of number string
;==============================================================

; MESSAGES

NoSuchFileMsg   LABEL BYTE
        DB      'No such file',13,10,'$'

DiskFullMsg     LABEL BYTE
        DB      'Not enough room on disk to expand the file',13,10,'$'

TroubleMsg      LABEL BYTE
        DB      'Usage is:',13,10
        DB      'RESIZE C:\MySub\MyFile.Ext 9999999',13,10
        DB      'to chop or expand a file to size 9999999 bytes',13,10
        DB      13,10
        DB      ' Resize 1.3 ۲ Copyright (c) 1989,1998 Roedy Green',13,10
        DB      'Canadian Mind Products',13,10
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10
        DB      'This program may be freely copied and used for any purpose except military.',13,10,'$'
;==============================================================

RESIZE  ENDP

CODE    ENDS
        END     START
