set echo off
set verify off
set term on
set serveroutput on

prompt *********************************************************
prompt * Deallocating unused space in tables ...               *
prompt *********************************************************

declare
	v_cursor  integer default null;
	v_result  integer;
	v_SQL     varchar2 (1024) default null;
	all_count integer default 0;
begin
	v_cursor := dbms_sql.open_cursor;

	for i in (select table_name from dba_tables where owner = '&&schema') loop
		begin
			v_SQL := 'ALTER TABLE ' || '&&schema' || '."' || i.table_name || '" DEALLOCATE UNUSED';
			dbms_sql.parse (v_cursor, v_SQL, dbms_sql.NATIVE);
			v_result := dbms_sql.execute (v_cursor);
			dbms_repair.rebuild_freelists (
				schema_name => '&&schema',
				object_name => i.table_name,
				partition_name => null,
				object_type => dbms_repair.table_object
			);
			all_count := all_count + 1;

		exception when others then
			-- ORA-14451: unsupported feature with temporary table
			-- ORA-01771: illegal option for a clustered table
			-- ORA-00701: object necessary for warmstarting database cannot be altered
			if (SQLCODE != -14451) and (SQLCODE != -1771) and (SQLCODE != -701)
			then
				dbms_output.put_line ('Statement [' || v_SQL || ']');
				raise;
			end if;
		end;
	end loop;

    if dbms_sql.is_open (v_cursor) then dbms_sql.close_cursor (v_cursor); end if;
    dbms_output.put_line ('Tables processed: ' || all_count);
end;
/
