#define _WIN32_WINNT 0x0400
#ifdef _DEBUG
	#include <stdio.h>
#endif

#include <windows.h>
#include "plugin.hpp"
#include "mswellng.hpp"
#include "mswheel.hpp"
#define WH_MOUSE_LL  14
#ifndef MOUSE_WHEELED
#define MOUSE_WHEELED 0x0004
#endif
bool InEditor(CONSOLE_SCREEN_BUFFER_INFO & sbi);
static int os = 1;
extern "C" __declspec(dllexport) LRESULT CALLBACK MouseProc(int code, WPARAM wParam, LPARAM lParam);
// uncomment this if you use VC 5.0
/*
typedef struct tagMSLLHOOKSTRUCT {
    DWORD pt;
    DWORD mouseData;
    DWORD flags;
    DWORD time;
    DWORD dwExtraInfo;
} MSLLHOOKSTRUCT;
*/
/*global variables */
char PluginRootKey[512] = "";
short zDelta;
HANDLE hi;
HANDLE ho;
SHORT  lines_to_scroll = 3;
SHORT  lines_to_scroll_v = 3;
SHORT  lines_to_scroll_e = 3;
SHORT  lines_to_scroll_p = 3;
SHORT  double_click = 1;
SHORT  exclude_from_list = 0;
DWORD d;
DWORD pluginTid = -1;
int i;
INPUT_RECORD ir;
HANDLE hThread = NULL;
HINSTANCE hDll = 0;
DWORD hFarThread;
HWND  hFarWnd=NULL;
HWND hWnd;
DWORD WINAPI ThreadProc(LPVOID lpParameter);
LONG APIENTRY MainWndProc(HWND hWnd, UINT message, UINT wParam, LONG lParam);
void WriteKey(short ctrl);
void WriteDoubleClick(POINT & pt);

HHOOK hook = 0;

HKEY CreateRegKey(HKEY hRoot,char *Key)
{
  HKEY hKey;
  DWORD Disposition;
  char FullKeyName[512];
  strcpy(FullKeyName,PluginRootKey);
  if (*Key)
  {
    strcat(FullKeyName,"\\");
    strcat(FullKeyName,Key);
  }
  RegCreateKeyEx(hRoot,FullKeyName,0,NULL,0,KEY_WRITE,NULL,
                 &hKey,&Disposition);
  return(hKey);
}


HKEY OpenRegKey(HKEY hRoot,char *Key)
{
  HKEY hKey;
  char FullKeyName[512];
  strcpy(FullKeyName,PluginRootKey);
  if (*Key)
  {
    strcat(FullKeyName,"\\");
    strcat(FullKeyName,Key);
  }
  if (RegOpenKeyEx(hRoot,FullKeyName,0,KEY_QUERY_VALUE,&hKey)!=ERROR_SUCCESS)
    return(NULL);
  return(hKey);
}
void SetRegKey(HKEY hRoot,char *Key,char *ValueName,DWORD ValueData)
{
  HKEY hKey=CreateRegKey(hRoot,Key);
  RegSetValueEx(hKey,ValueName,0,REG_DWORD,(BYTE *)&ValueData,sizeof(ValueData));
  RegCloseKey(hKey);
}

int GetRegKey(HKEY hRoot,char *Key,char *ValueName,int &ValueData,DWORD Default)
{
  HKEY hKey=OpenRegKey(hRoot,Key);
  DWORD Type,Size=sizeof(ValueData);
  int ExitCode=RegQueryValueEx(hKey,ValueName,0,&Type,(BYTE *)&ValueData,&Size);
  RegCloseKey(hKey);
  if (hKey==NULL || ExitCode!=ERROR_SUCCESS)
  {
    ValueData=Default;
    return(FALSE);
  }
  return(TRUE);
}
int GetRegKey(HKEY hRoot,char *Key,char *ValueName,DWORD Default)
{
  int ValueData;
  GetRegKey(hRoot,Key,ValueName,ValueData,Default);
  return(ValueData);
}

void InitDialogItems(struct InitDialogItem *Init,struct FarDialogItem *Item,
                    int ItemsNumber)
{
  for (int I=0;I<ItemsNumber;I++)
  {
    Item[I].Type=Init[I].Type;
    Item[I].X1=Init[I].X1;
    Item[I].Y1=Init[I].Y1;
    Item[I].X2=Init[I].X2;
    Item[I].Y2=Init[I].Y2;
    Item[I].Focus=Init[I].Focus;
    Item[I].Selected=Init[I].Selected;
    Item[I].Flags=Init[I].Flags;
    Item[I].DefaultButton=Init[I].DefaultButton;
    if ((unsigned int)Init[I].Data<2000)
      strcpy(Item[I].Data,GetMsg((unsigned int)Init[I].Data));
    else
      strcpy(Item[I].Data,Init[I].Data);
  }
}


void WriteKey(short ctrl)
{
	if (zDelta > 0)
	{
		memset(&ir, 0, sizeof(ir));
		ir.EventType = KEY_EVENT;
		ir.Event.KeyEvent.wRepeatCount = 1;
		ir.Event.KeyEvent.bKeyDown = TRUE;
		ir.Event.KeyEvent.wVirtualKeyCode = VK_UP;
		ir.Event.KeyEvent.wVirtualScanCode = MapVirtualKey(VK_UP, 0);
		ir.Event.KeyEvent.uChar.AsciiChar= 0;//VK_UP;
		if (ctrl != 0)
			ir.Event.KeyEvent.dwControlKeyState = LEFT_CTRL_PRESSED;
		else
			ir.Event.KeyEvent.dwControlKeyState = 0;
		WriteConsoleInput(hi, &ir, 1, &d);
		memset(&ir, 0, sizeof(ir));
		ir.EventType = KEY_EVENT;
		ir.Event.KeyEvent.wRepeatCount = 1;
		ir.Event.KeyEvent.wVirtualKeyCode = VK_UP;
		ir.Event.KeyEvent.wVirtualScanCode = MapVirtualKey(VK_UP, 0);
		ir.Event.KeyEvent.uChar.AsciiChar= 0;//VK_UP;
		ir.Event.KeyEvent.bKeyDown = FALSE;
		ir.Event.KeyEvent.dwControlKeyState = 0;
		ir.Event.KeyEvent.wRepeatCount = 1;
		WriteConsoleInput(hi, &ir, 1, &d);
	}
	else
	{
		memset(&ir, 0, sizeof(ir));
		ir.EventType = KEY_EVENT;
		ir.Event.KeyEvent.wRepeatCount = 1;
		ir.Event.KeyEvent.bKeyDown = TRUE;
		ir.Event.KeyEvent.wVirtualKeyCode = VK_DOWN;
		ir.Event.KeyEvent.wVirtualScanCode = MapVirtualKey(VK_DOWN, 0);
		ir.Event.KeyEvent.uChar.AsciiChar = 0;//VK_DOWN;
		if (ctrl != 0)
			ir.Event.KeyEvent.dwControlKeyState = LEFT_CTRL_PRESSED;
		else
			ir.Event.KeyEvent.dwControlKeyState = 0;
		WriteConsoleInput(hi, &ir, 1, &d);
		memset(&ir, 0, sizeof(ir));
		ir.EventType = KEY_EVENT;
		ir.Event.KeyEvent.wRepeatCount = 1;
		ir.Event.KeyEvent.wVirtualKeyCode = VK_DOWN;
		ir.Event.KeyEvent.wVirtualScanCode = MapVirtualKey(VK_DOWN, 0);
		ir.Event.KeyEvent.uChar.AsciiChar = 0;//VK_DOWN;
		ir.Event.KeyEvent.bKeyDown = FALSE;
		ir.Event.KeyEvent.dwControlKeyState = 0;
		ir.Event.KeyEvent.wRepeatCount = 1;
		WriteConsoleInput(hi, &ir, 1, &d);
	}
}

BOOL WINAPI MyDllMain(HINSTANCE hinstDLL, DWORD dwReason, LPVOID lpvReserved);
extern "C" __declspec(dllexport) LRESULT CALLBACK GetMsgProc(int code, WPARAM wParam, LPARAM lParam);

void WINAPI _export SetStartupInfo(struct PluginStartupInfo *Info)
{
  ::Info=*Info;
  strcpy(PluginRootKey,Info->RootKey);
  strcat(PluginRootKey,"\\MouseWheel");
  hThread = CreateThread(NULL, 0, &ThreadProc, NULL, 0, &pluginTid);
  hFarThread = GetCurrentThreadId();
  lines_to_scroll=GetRegKey(HKEY_CURRENT_USER,"","ScrollingSpeed", 3);
  lines_to_scroll_v=GetRegKey(HKEY_CURRENT_USER,"","ScrollingSpeed_in_viewer", 3);
  lines_to_scroll_p=GetRegKey(HKEY_CURRENT_USER,"","ScrollingSpeed_in_file_panels", 3);
  lines_to_scroll_e=GetRegKey(HKEY_CURRENT_USER,"","ScrollingSpeed_in_editor", 3);
  double_click=GetRegKey(HKEY_CURRENT_USER,"","EmulateDoubleClick", 1);
  exclude_from_list=GetRegKey(HKEY_CURRENT_USER,"","ExcludeFromF11List", 0);

}
HANDLE WINAPI _export OpenPlugin(int OpenFrom, int Item)
{
  struct InitDialogItem InitItems[]={
    DI_DOUBLEBOX,3,1,66,12,0,0,0,0,(char *)MMouseWheelInfo,

    //DI_TEXT,5,2,0,0,0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,"",
    DI_TEXT,9,2,0,0,0,0,DIF_CENTERGROUP,0,(char *)MMouseLinesPerWheel,

    DI_FIXEDIT,7,3,7,3,1,0,0,0,"",
    DI_TEXT,9,3,0,0,0,0,0,0,(char *)MViewer,

    DI_FIXEDIT,7,4,7,3,0,0,0,0,"",
    DI_TEXT,9,4,0,0,0,0,0,0,(char *)MEditor,

    DI_FIXEDIT,7,5,7,3,0,0,0,0,"",
    DI_TEXT,9,5,0,0,0,0,0,0,(char *)MFilePanels,

    DI_TEXT,5,6,0,0,0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,"",

	DI_TEXT,5,7,0,0,0,0,DIF_CENTERGROUP,0,(char *)MDoubleClick,

	DI_RADIOBUTTON, 5,8,0,0,0,1,DIF_GROUP,0,(char *)MGenerateOneClk,
	DI_RADIOBUTTON,25,8,0,0,0,0,0,0,(char *)MGenerateDblClk,
	DI_RADIOBUTTON,50,8,0,0,0,0,0,0,(char *)MGenerateNo,

	DI_CHECKBOX,5,9,0,0,0,0,0,0,(char *)MExcludePlugin,
    DI_TEXT,5,10,0,0,0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,"",

    DI_BUTTON,0,11,0,0,0,0,DIF_CENTERGROUP,1,(char *)MMouseOk,
    DI_BUTTON,0,11,0,0,0,0,DIF_CENTERGROUP,0,(char *)MMouseCancel
  };

  struct FarDialogItem DialogItems[sizeof(InitItems)/sizeof(InitItems[0])];
  InitDialogItems(InitItems,DialogItems,sizeof(InitItems)/sizeof(InitItems[0]));
  int lts_p;
  int lts_v;
  int lts_e;
  lts_v=GetRegKey(HKEY_CURRENT_USER,"","ScrollingSpeed_in_viewer",3);
  lts_e=GetRegKey(HKEY_CURRENT_USER,"","ScrollingSpeed_in_editor",3);
  lts_p=GetRegKey(HKEY_CURRENT_USER,"","ScrollingSpeed_in_file_panels",3);
  int Selected_click = GetRegKey(HKEY_CURRENT_USER,"","EmulateDoubleClick",1);
  int Selected_exclude = GetRegKey(HKEY_CURRENT_USER,"","ExcludeFromF11List",0);

  while (1)
  {
	DialogItems[2].Data[0] = char(lts_v+0x30);
	DialogItems[2].Data[1] = '\0';
	DialogItems[4].Data[0] = char(lts_e+0x30);
	DialogItems[4].Data[1] = '\0';
	DialogItems[6].Data[0] = char(lts_p+0x30);
	DialogItems[6].Data[1] = '\0';
	DialogItems[10].Selected = 0;
	DialogItems[11].Selected = 0;
	DialogItems[12].Selected = 0;
	if (Selected_click == 0)
		DialogItems[12].Selected = 1;
	else if (Selected_click == 1)
		DialogItems[10].Selected = 1;
	else if (Selected_click == 2)
		DialogItems[11].Selected = 1;
	DialogItems[13].Selected = Selected_exclude;

	int ExitCode=Info.Dialog(Info.ModuleNumber,-1,-1,70,14,NULL,DialogItems,sizeof(DialogItems)/sizeof(DialogItems[0]));
	if (ExitCode!=2 && ExitCode != 4 && ExitCode!= 6 && ExitCode!= 10
		&& ExitCode!=11 && ExitCode!=12 && ExitCode!=14 && ExitCode!=15)
		return(INVALID_HANDLE_VALUE);
	if ((DialogItems[2].Data[0] <= 0x30 || DialogItems[2].Data[0] > 0x39) &&
		(DialogItems[4].Data[0] <= 0x30 || DialogItems[4].Data[0] > 0x39) &&
		(DialogItems[6].Data[0] <= 0x30 || DialogItems[6].Data[0] > 0x39))
	{
		char *MsgItems[]={"",GetMsg(MMouseError), "OK"};
		Info.Message(Info.ModuleNumber,0,NULL,MsgItems,
                     sizeof(MsgItems)/sizeof(MsgItems[0]),1);
		continue;
	}
	else
	{
		lines_to_scroll_v = (int)(DialogItems[2].Data[0] - 0x30);
		lines_to_scroll_e = (int)(DialogItems[4].Data[0] - 0x30);
		lines_to_scroll_p = (int)(DialogItems[6].Data[0] - 0x30);
		exclude_from_list = DialogItems[13].Selected;
		double_click = 0;
		if (DialogItems[10].Selected != 0)
			double_click = 1;
		else if (DialogItems[11].Selected != 0)
			double_click = 2;
		else if (DialogItems[12].Selected != 0)
			double_click = 0;

		SetRegKey(HKEY_CURRENT_USER,"","ScrollingSpeed_in_viewer",lines_to_scroll_v);
		SetRegKey(HKEY_CURRENT_USER,"","ScrollingSpeed_in_editor",lines_to_scroll_e);
		SetRegKey(HKEY_CURRENT_USER,"","ScrollingSpeed_in_file_panels",lines_to_scroll_p);
		SetRegKey(HKEY_CURRENT_USER,"","EmulateDoubleClick",double_click);
		SetRegKey(HKEY_CURRENT_USER,"","ExcludeFromF11List",exclude_from_list);
		break;
	}
  }
	return INVALID_HANDLE_VALUE;
}
void WINAPI _export ExitFAR(void)
{
	if (hWnd != 0)
		DestroyWindow(hWnd);
	if (hook != NULL)
	{
		UnhookWindowsHookEx(hook);
		hook = NULL;
	}
	CloseHandle(hThread);
}

void WINAPI _export GetPluginInfo(struct PluginInfo *Info)
{
  Info->StructSize=sizeof(*Info);
  Info->Flags = PF_PRELOAD|PF_VIEWER|PF_EDITOR;
  Info->DiskMenuStringsNumber=0;
  if (exclude_from_list == 0)
  {
    static char *PluginMenuStrings[1];
    PluginMenuStrings[0]=GetMsg(MMouseWheel);
    Info->PluginMenuStrings=PluginMenuStrings;
    Info->PluginMenuStringsNumber=sizeof(PluginMenuStrings)/sizeof(PluginMenuStrings[0]);
    Info->PluginConfigStringsNumber=0;
  }
  else
    Info->PluginMenuStringsNumber = 0;
  static char *PluginCfgStrings[1];
  PluginCfgStrings[0]=GetMsg(MMouseWheel);
  Info->PluginConfigStrings=PluginCfgStrings;
  Info->PluginConfigStringsNumber=sizeof(PluginCfgStrings)/sizeof(PluginCfgStrings[0]);

}
char *GetMsg(int MsgId)
{
  return(Info.GetMsg(Info.ModuleNumber,MsgId));
}


BOOL WINAPI MyDllMain(HINSTANCE hinstDLL, DWORD dwReason, LPVOID lpvReserved)
{
	switch (dwReason)
	{
		case DLL_PROCESS_ATTACH:
			{
				hDll = hinstDLL;
				OSVERSIONINFO vi;
				hFarWnd = GetForegroundWindow();
				vi.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
				BOOL rc = GetVersionEx(&vi);
				if (rc != 0)
				{
					if (vi.dwPlatformId == VER_PLATFORM_WIN32_NT)
					{
						if ((vi.dwMajorVersion < 4) ||
						((vi.dwMajorVersion == 4) &&
						(strcmp(vi.szCSDVersion, "Service Pack 3") < 0)))
							os = 0;
						else
							os = 1;
					}
					else if (vi.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS)
					{
						os = -1;
						return FALSE;
					}
					else
						return FALSE;
					//### for debug only!!!
					//os = 0;
				}
				break;
			}
		case DLL_PROCESS_DETACH:
			break;
		default:
			break;
	}
	return TRUE;
}

DWORD WINAPI ThreadProc(LPVOID lpParameter)
{
  WNDCLASS  wc;
  wc.style = 0;
  wc.lpfnWndProc = (WNDPROC)MainWndProc;
  wc.cbClsExtra = 0;
  wc.cbWndExtra = 0;
  wc.hInstance = GetModuleHandle(NULL);
  wc.hIcon = NULL;
  wc.hCursor = LoadCursor(NULL, IDC_ARROW);
  wc.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
  wc.lpszMenuName = NULL;
  wc.lpszClassName = "WM_MOUSEWHEEL 4 FAR Plugin";
  if (RegisterClass(&wc) == 0)
	  return FALSE;

    DWORD dwFlags = WS_OVERLAPPED | WS_CAPTION | WS_MINIMIZEBOX | WS_SYSMENU ;
    /* Create the main window */
    hWnd = CreateWindow("WM_MOUSEWHEEL 4 FAR Plugin",
						/*"MSWHEEL PLUGIN HIDED WINDOW"*/"", dwFlags,
                       0, 0, 0, 0, NULL, NULL,
						GetModuleHandle(NULL), NULL) ;
    if (!hWnd)
        return (FALSE);
	ShowWindow(hWnd, SW_HIDE);
    UpdateWindow(hWnd);

	if (os == 1)
	{
		hook = SetWindowsHookEx(WH_MOUSE_LL, (HOOKPROC)GetMsgProc, GetModuleHandle(NULL), 0);
		if (hook == NULL)
		{
			MessageBox(0, "Failed to set hook (NT4 SP3 required)", "Error", MB_OK);
			return FALSE;
		}
	}

	MSG	msg;
	while (GetMessage(&msg, 0, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return TRUE;
}

LONG APIENTRY MainWndProc(HWND hWnd, UINT message, UINT wParam, LONG lParam)
{
	BOOL rc = 0;
	static int t;
	static bool first = true;
    switch (message)
    {
		case WM_DESTROY:
			if (os == 0)
				KillTimer(hWnd, t);
			PostQuitMessage(0);
			break;
		case WM_SHOWWINDOW:
			if (wParam == TRUE)
				break;
			if (first)
			if (os == 0)
			{
				t = SetTimer(hWnd, 0x423, 20000, NULL);
			}
		case WM_TIMER:
			if (first){ first=false;
			if (os == 0)				
			{	if (hook!= NULL)
				{
					UnhookWindowsHookEx(hook);
					hook = NULL;
				}
				//MessageBox(0, "", "Preparing to set hook", MB_OK);
				hook = SetWindowsHookEx(WH_MOUSE,
					(HOOKPROC)MouseProc,
					//GetProcAddress(hDll, "MouseProc"),
					/*hDll*/GetModuleHandle(NULL),	0);
				//MessageBox(0, "", "Hook was set", MB_OK);
			}}	
		default:
			return (DefWindowProc(hWnd, message, wParam, lParam));
			break ;
    }
    return (0L);
}


extern "C" __declspec(dllexport) LRESULT CALLBACK GetMsgProc(int code, WPARAM wParam, LPARAM lParam)
{
	HWND hWnd = GetForegroundWindow();
    if (code >= 0 && (wParam == WM_MOUSEWHEEL || wParam == WM_MBUTTONDOWN))
    {
		WORD fwKeys = 0;
		if (wParam == WM_MOUSEWHEEL)
			fwKeys = HIWORD(((MSLLHOOKSTRUCT *)(lParam))->flags);
		if (fwKeys == 0 &&
			((GetWindowThreadProcessId(hWnd, NULL) == hFarThread) ||
			(hFarWnd == hWnd)))
		{
			hi = GetStdHandle(STD_INPUT_HANDLE);
			ho = GetStdHandle(STD_OUTPUT_HANDLE);
			ir.EventType = KEY_EVENT;
			ir.Event.KeyEvent.wRepeatCount = 1;
			if (wParam == WM_MOUSEWHEEL)
				zDelta = (short) HIWORD(((MSLLHOOKSTRUCT *)(lParam))->mouseData);

			if (ho != INVALID_HANDLE_VALUE || hi != INVALID_HANDLE_VALUE)
			{
				CONSOLE_CURSOR_INFO ci;
				if (GetConsoleCursorInfo(ho, &ci) != 0)
				{
					if (ci.bVisible == FALSE) /* We're not in editor */
					{ // we are in the viewer
						//MessageBox(NULL,  "View",  "View",  MB_OK);
						if (wParam == WM_MBUTTONDOWN)
						{
						    return CallNextHookEx(NULL, code, wParam, lParam);
						}
						for (i=0;i<lines_to_scroll_v;i++)
							WriteKey(0);
					}
					else /* may be we are in editor */
					{
						CONSOLE_SCREEN_BUFFER_INFO sbi;
						GetConsoleScreenBufferInfo(ho, &sbi);
						bool isInEditor = InEditor(sbi);
						if (wParam == WM_MBUTTONDOWN)
						{
							if (isInEditor == true)
							    return CallNextHookEx(NULL, code, wParam, lParam);
							
							WriteDoubleClick(((MSLLHOOKSTRUCT *)(lParam))->pt);
						    return CallNextHookEx(NULL, code, wParam, lParam);
						}

						//char buf[100];
						//sprintf(buf,  "%c; %d",  ci.Char.AsciiChar,  ci.Attributes);
						//MessageBox(NULL,  buf,  buf,  MB_OK);
						// get offset;
						SHORT offset = sbi.dwSize.Y - sbi.dwCursorPosition.Y;
						if (offset <= 2 || offset >= sbi.dwSize.Y - 1)
						{
							if (isInEditor == false)
							{
								//MessageBox(NULL,  "Panel",  "Panel",  MB_OK);
								for (i=0;i<lines_to_scroll_p;i++)
									WriteKey(0);
							}
							else
							{
								//MessageBox(NULL,  "Edit",  "Edit",  MB_OK);
								for (i=0;i<lines_to_scroll_e;i++)
									WriteKey(0);
							}
						}
						else
						{
							//MessageBox(NULL,  "Edit",  "Edit",  MB_OK);
							for (i=0;i<lines_to_scroll_e;i++)
								WriteKey(1);
						}
					}
				}
			}
		}
    }
    return CallNextHookEx(NULL, code, wParam, lParam);
}

extern "C" __declspec(dllexport) LRESULT CALLBACK MouseProc(int code, WPARAM wParam, LPARAM lParam)
{
	HWND hWnd = GetForegroundWindow();
	bool processed = false;
    if (code >= 0 && wParam == WM_MOUSEWHEEL && lParam != NULL)
    {
		MOUSEHOOKSTRUCT * m = (MOUSEHOOKSTRUCT *)lParam;
		if (GetWindowThreadProcessId(m->hwnd, NULL) == hFarThread
			&& m->wHitTestCode == 0)
		{
			hi = GetStdHandle(STD_INPUT_HANDLE);
			ho = GetStdHandle(STD_OUTPUT_HANDLE);
			ir.EventType = KEY_EVENT;
			ir.Event.KeyEvent.wRepeatCount = 1;
			zDelta = (short)m->dwExtraInfo;

			if (ho != INVALID_HANDLE_VALUE || hi != INVALID_HANDLE_VALUE)
			{
				CONSOLE_CURSOR_INFO ci;
				if (GetConsoleCursorInfo(ho, &ci) != 0)
				{
					processed = true;
					if (ci.bVisible == FALSE) /* We're not in editor */
					{
						for (i=0;i<lines_to_scroll_v;i++)
							WriteKey(0);
					}
					else /* may be we are in editor */
					{
						CONSOLE_SCREEN_BUFFER_INFO sbi;
						GetConsoleScreenBufferInfo(ho, &sbi);
						bool isInEditor = InEditor(sbi);

						// get offset;
						SHORT offset = sbi.dwSize.Y - sbi.dwCursorPosition.Y;
						if (offset <= 2 || offset >= sbi.dwSize.Y - 1)
						{
							if (isInEditor == false)
							{
								//MessageBox(NULL,  "Panel",  "Panel",  MB_OK);
								for (i=0;i<lines_to_scroll_p;i++)
									WriteKey(0);
							}
							else
							{
								//MessageBox(NULL,  "Edit",  "Edit",  MB_OK);
								for (i=0;i<lines_to_scroll_e;i++)
									WriteKey(0);
							}
						}
						else
						{
							//MessageBox(NULL,  "Edit",  "Edit",  MB_OK);
							for (i=0;i<lines_to_scroll_e;i++)
								WriteKey(1);
						}
					}
				}
			}
		}
    }
	return CallNextHookEx(NULL, code, wParam, lParam);
}
int WINAPI _export Configure(int ItemNumber)
{
  switch(ItemNumber)
  {
    case 0:
      return((int)OpenPlugin(0,0));
  }
  return(FALSE);
}
bool InEditor(CONSOLE_SCREEN_BUFFER_INFO & sbi)
{
	//DebugBreak();
	//
	// check the first suggestion: command line is black and previous
	// symbol before cursor is '>'. It's not sufficient condition.
	//
	CHAR_INFO ci;
	COORD coord;
	coord.X = 1;
	coord.Y = 1;
	COORD coord1;
	coord1.X = 0;
	coord1.Y = 0;
	SMALL_RECT sr;
	sr.Left =   0;
	sr.Top =   sbi.dwCursorPosition.Y;
	sr.Right =   0;
	sr.Bottom =   sbi.dwCursorPosition.Y;
	ReadConsoleOutput(ho,  &ci,  coord,  coord1,  &sr);
	if ( (ci.Attributes & (0x000F))== 7 &&
		 (ci.Attributes & (0x00F0)) == 0)	
	{
		coord.X = 1;
		coord.Y = 1;
		coord1.X = 0;
		coord1.Y = 0;
		if (sbi.dwCursorPosition.X >=1)
		{
			sr.Left =   sbi.dwCursorPosition.X-1;
			sr.Top =   sbi.dwCursorPosition.Y;
			sr.Right =   sbi.dwCursorPosition.X-1;
			sr.Bottom =   sbi.dwCursorPosition.Y;
			ReadConsoleOutput(ho,  &ci,  coord,  coord1,  &sr);
			//char buf[100];
			//sprintf(buf,  "%c",  ci.Char.AsciiChar);
			//MessageBox(NULL,  buf,  buf,  MB_OK);
			if (ci.Char.AsciiChar == '>')
				return false;
		}
	}
	//
	// check the second suggestion: in FAR editor fields for F3, F4, F5, F9
	// are usually empty. And on the contrary, in File Panels they
	// are filled with View, Edit, Copy, ConfMn.
	//
	char console_last_line[512];
	memset(console_last_line,  0,  512);
	DWORD cells_read = 0;
	coord.X = 0;
	coord.Y = sbi.dwSize.Y-1;
	ReadConsoleOutputCharacter(ho, console_last_line, 512, coord, &cells_read);
	if (cells_read > 511)
		return false;
	int i;
	bool is_space_block = true;
	if (cells_read >22)
	{
		for(i=17;i<=22;i++)
		{
			if (console_last_line[i] != ' ')
			{
				is_space_block = false;
				break;
			}				
		}
		if (is_space_block == true)
		{
			//MessageBox(NULL,  console_last_line,  console_last_line,  MB_OK);
			return true;
		}
	}

	is_space_block = true;
	if (cells_read >30)
	{
		for(i=25;i<=30;i++)
		{
			if (console_last_line[i] != ' ')
			{
				is_space_block = false;
				break;
			}				
		}
		if (is_space_block == true)
			return true;
	}


	is_space_block = true;
	if (cells_read >38)
	{
		for(i=33;i<=38;i++)
		{
			if (console_last_line[i] != ' ')
			{
				is_space_block = false;
				break;
			}				
		}
		if (is_space_block == true)
			return true;
	}


	is_space_block = true;
	if (cells_read >70)
	{
		for(i=65;i<=70;i++)
		{
			if (console_last_line[i] != ' ')
			{
				is_space_block = false;
				break;
			}				
		}
		if (is_space_block == true)
			return true;
	}
	return false;
}

void WriteDoubleClick(POINT & pt)
{
		/*
		memset(&ir, 0, sizeof(ir));
		ir.EventType = MOUSE_EVENT;
		ir.Event.MouseEvent.dwMousePosition.X = 0;
		ir.Event.MouseEvent.dwMousePosition.Y = 0;
		ir.Event.MouseEvent.dwButtonState = FROM_LEFT_1ST_BUTTON_PRESSED;
		ir.Event.MouseEvent.dwControlKeyState = 0;
		ir.Event.MouseEvent.dwEventFlags = 0;
		WriteConsoleInput(hi, &ir, 1, &d);
		*/
		if (double_click == 2)
		{
			ScreenToClient(hFarWnd, &pt);
			SendMessage(hFarWnd, WM_LBUTTONDBLCLK, 0, MAKELPARAM(pt.x, pt.y));
		}
		else if (double_click == 1)
		{
			static POINT p = {0, 0};
			static DWORD prev_time = GetTickCount();
			bool moved;
			moved = false;
			if (memcmp(&p, &pt, sizeof(POINT)) == 0)
			{
				if (GetTickCount() - prev_time < 1000)
				{
					//char buf[100];
					//sprintf(buf, "%d %d %d %d", pt.x, pt.y, p.x, p.y);
					//MessageBox(NULL, buf, buf, MB_OK);
					moved = true;
					ScreenToClient(hFarWnd, &pt);
					SendMessage(hFarWnd, WM_LBUTTONDBLCLK, 0, MAKELPARAM(pt.x, pt.y));
					return;
				}
			}
			memcpy(&p, &pt, sizeof(POINT));
			prev_time = GetTickCount();
			if (moved == false)
			{
				ScreenToClient(hFarWnd, &pt);
				SendMessage(hFarWnd, WM_LBUTTONDOWN, 0, MAKELPARAM(pt.x, pt.y));
			}
		}
}
